/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportDialog;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getFileToConvert", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "intellij.markdown"})
@ApiStatus.Experimental
public final class MarkdownExportAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"event.project ?: return");
        Project project2 = project;
        VirtualFile virtualFile = this.getFileToConvert(event);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.path");
        new MarkdownExportDialog(virtualFile2, string, project2).show();
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setEnabled(this.getFileToConvert(event) != null);
    }

    private final VirtualFile getFileToConvert(AnActionEvent event) {
        MarkdownEditorWithPreview markdownEditorWithPreview;
        MarkdownEditorWithPreview editor2 = MarkdownActionUtil.findSplitEditor(event);
        MarkdownEditorWithPreview markdownEditorWithPreview2 = editor2;
        if (markdownEditorWithPreview2 != null && (markdownEditorWithPreview2 = markdownEditorWithPreview2.getFile()) != null) {
            MarkdownEditorWithPreview markdownEditorWithPreview3 = markdownEditorWithPreview2;
            boolean bl = false;
            boolean bl2 = false;
            MarkdownEditorWithPreview it = markdownEditorWithPreview3;
            boolean bl3 = false;
            MarkdownEditorWithPreview markdownEditorWithPreview4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownEditorWithPreview4), (String)"it");
            markdownEditorWithPreview = markdownEditorWithPreview4.getFileType() instanceof MarkdownFileType ? markdownEditorWithPreview3 : null;
        } else {
            markdownEditorWithPreview = null;
        }
        return markdownEditorWithPreview;
    }
}

