/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/fileActions/utils/GoogleDocsImportUtils;", "", "()V", "docsRegEx", "Lkotlin/text/Regex;", "getDocsRegEx", "()Lkotlin/text/Regex;", "docsUrlPrefix", "", "docsUrlSuffix", "extractDocsId", "link", "isLinkToDocumentCorrect", "", "intellij.markdown"})
public final class GoogleDocsImportUtils {
    private static final String docsUrlPrefix = "https://docs.google.com/document/d/";
    private static final String docsUrlSuffix = "/edit";
    @NotNull
    public static final GoogleDocsImportUtils INSTANCE;

    private final Regex getDocsRegEx() {
        String string = "https://docs.google.com/document/d/(\\S*)/edit";
        boolean bl = false;
        return new Regex(string);
    }

    public final boolean isLinkToDocumentCorrect(@NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return this.getDocsRegEx().containsMatchIn((CharSequence)link);
    }

    @NotNull
    public final String extractDocsId(@NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)link, (CharSequence)docsUrlPrefix), (CharSequence)docsUrlSuffix);
    }

    private GoogleDocsImportUtils() {
    }

    static {
        GoogleDocsImportUtils googleDocsImportUtils;
        INSTANCE = googleDocsImportUtils = new GoogleDocsImportUtils();
    }
}

