/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.utils;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ModalityUiUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownNotifier;
import org.intellij.plugins.markdown.fileActions.export.MarkdownDocxExportProvider;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.settings.pandoc.PandocApplicationSettings;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.JCEFHtmlPanelProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J$\u0010!\u001a\u00020\u0006*\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010%*\u00020&2\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/intellij/plugins/markdown/fileActions/utils/MarkdownImportExportUtils;", "", "()V", "TARGET_FORMAT_NAME", "", "copyAndConvertToMd", "", "project", "Lcom/intellij/openapi/project/Project;", "vFileToImport", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectedFileUrl", "getConvertDocxToMdCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "file", "mediaSrc", "targetFile", "getPreviewEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "fileType", "isJCEFPanelOpen", "", "editor", "notifyAndRefreshIfExportSuccess", "Ljava/io/File;", "refreshProjectDirectory", "refreshPath", "suggestFileNameToCreate", "fileToImport", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "copySelectedFile", "dirToImport", "newFileName", "validateTargetDir", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "field", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "intellij.markdown"})
public final class MarkdownImportExportUtils {
    private static final String TARGET_FORMAT_NAME = "markdown";
    @NotNull
    public static final MarkdownImportExportUtils INSTANCE;

    @Nullable
    public final MarkdownPreviewFileEditor getPreviewEditor(@NotNull AnActionEvent event, @NotNull String fileType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"event.project ?: return null");
        Project project2 = project;
        MarkdownPreviewFileEditor previewEditor = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        if (previewEditor == null) {
            String string = MarkdownBundle.message("markdown.export.validation.failure.msg", fileType);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026n.failure.msg\", fileType)");
            MarkdownNotifier.INSTANCE.notifyIfConvertFailed(project2, string);
            return null;
        }
        return previewEditor;
    }

    public final void refreshProjectDirectory(@NotNull Project project, @NotNull String refreshPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)refreshPath, (String)"refreshPath");
        ModalityUiUtil.invokeLaterIfNeeded((Runnable)new Runnable(refreshPath){
            final /* synthetic */ String $refreshPath;

            public final void run() {
                block0: {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.$refreshPath));
                    if (virtualFile == null) break block0;
                    virtualFile.refresh(true, true);
                }
            }
            {
                this.$refreshPath = string;
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    @NotNull
    public final String suggestFileNameToCreate(@NotNull Project project, @NotNull VirtualFile fileToImport, @NotNull DataContext dataContext) {
        File file;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileToImport, (String)"fileToImport");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        String string = fileToImport.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileToImport.nameWithoutExtension");
        String defaultFileName = string;
        VirtualFile selectedVirtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (selectedVirtualFile == null) {
            String string2 = project.getBasePath();
            Intrinsics.checkNotNull((Object)string2);
            file = new File(string2);
        } else if (selectedVirtualFile instanceof VirtualFileImpl) {
            VirtualDirectoryImpl virtualDirectoryImpl = ((VirtualFileImpl)selectedVirtualFile).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualDirectoryImpl, (String)"selectedVirtualFile.parent");
            file = new File(virtualDirectoryImpl.getPath());
        } else {
            file = new File(selectedVirtualFile.getPath());
        }
        File dirToImport = file;
        MarkdownFileType markdownFileType = MarkdownFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownFileType), (String)"MarkdownFileType.INSTANCE");
        String string3 = FileUtil.createSequentFileName((File)dirToImport, (String)defaultFileName, (String)markdownFileType.getDefaultExtension());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtil.createSequentFi\u2026NSTANCE.defaultExtension)");
        String suggestMdFile = string3;
        String suggestFileName = FilesKt.getNameWithoutExtension((File)new File(suggestMdFile));
        String string4 = FileUtil.createSequentFileName((File)dirToImport, (String)suggestFileName, (String)MarkdownDocxExportProvider.Companion.getFormat().getExtension());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FileUtil.createSequentFi\u2026rovider.format.extension)");
        String suggestDocxFile = string4;
        String string5 = FileUtil.join((String[])new String[]{dirToImport.getPath(), suggestDocxFile});
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"FileUtil.join(dirToImport.path, suggestDocxFile)");
        return string5;
    }

    public final void copyAndConvertToMd(@NotNull Project project, @NotNull VirtualFile vFileToImport, @NotNull String selectedFileUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vFileToImport, (String)"vFileToImport");
        Intrinsics.checkNotNullParameter((Object)selectedFileUrl, (String)"selectedFileUrl");
        new Task.Modal(vFileToImport, project, selectedFileUrl, project, MarkdownBundle.message("markdown.import.docx.convert", new Object[0]), true){
            private String createdFilePath;
            private ProcessOutput output;
            private final String dirToImport;
            private final String newFileName;
            private final String resourcesDir;
            final /* synthetic */ VirtualFile $vFileToImport;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $selectedFileUrl;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String[] stringArray = new String[2];
                stringArray[0] = this.dirToImport;
                StringBuilder stringBuilder = new StringBuilder().append(this.newFileName).append('.');
                MarkdownFileType markdownFileType = MarkdownFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownFileType), (String)"MarkdownFileType.INSTANCE");
                stringArray[1] = stringBuilder.append(markdownFileType.getDefaultExtension()).toString();
                String string = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.join(dirToImpor\u2026TANCE.defaultExtension}\")");
                String filePath = string;
                GeneralCommandLine cmd = MarkdownImportExportUtils.access$getConvertDocxToMdCommandLine(MarkdownImportExportUtils.INSTANCE, this.$vFileToImport, this.resourcesDir, filePath);
                this.output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
                this.createdFilePath = filePath;
            }

            public void onCancel() {
                File mdFile;
                String string = this.createdFilePath;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"createdFilePath");
                }
                if ((mdFile = new File(string)).exists()) {
                    FileUtil.delete((File)mdFile);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                MarkdownNotifier.INSTANCE.notifyIfConvertFailed(this.$project, '[' + this.$vFileToImport.getName() + "] " + error.getLocalizedMessage());
            }

            public void onSuccess() {
                ProcessOutput processOutput = this.output;
                if (processOutput == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                }
                if (processOutput.getStderrLines().isEmpty()) {
                    String string = this.dirToImport;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dirToImport");
                    MarkdownImportExportUtils.access$copySelectedFile(MarkdownImportExportUtils.INSTANCE, this.$vFileToImport, this.$project, string, this.newFileName);
                    String string2 = this.createdFilePath;
                    if (string2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"createdFilePath");
                    }
                    OpenFileAction.openFile((String)string2, (Project)this.$project);
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append('[').append(this.$vFileToImport.getName()).append("] ");
                    ProcessOutput processOutput2 = this.output;
                    if (processOutput2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    }
                    List list = processOutput2.getStderrLines();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"output.stderrLines");
                    MarkdownNotifier.INSTANCE.notifyIfConvertFailed(this.$project, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
                }
            }
            {
                this.$vFileToImport = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$selectedFileUrl = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                this.dirToImport = new File($captured_local_variable$2).getParent();
                this.newFileName = FilesKt.getNameWithoutExtension((File)new File($captured_local_variable$2));
                String string = PandocApplicationSettings.Companion.getInstance().getState().getMyPathToImages$intellij_markdown();
                if (string == null) {
                    String string2 = $captured_local_variable$1.getBasePath();
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.basePath!!");
                }
                this.resourcesDir = string;
            }
        }.queue();
    }

    private final void copySelectedFile(VirtualFile $this$copySelectedFile, Project project, String dirToImport, String newFileName) {
        String fileNameWithExtension = newFileName + '.' + MarkdownDocxExportProvider.Companion.getFormat().getExtension();
        try {
            LocalFileSystem localFS = LocalFileSystem.getInstance();
            VirtualFile virtualFile = localFS.findFileByPath(dirToImport);
            if (virtualFile == null) {
                String string = project.getBasePath();
                Intrinsics.checkNotNull((Object)string);
                VirtualFile virtualFile2 = localFS.findFileByPath(string);
                virtualFile = virtualFile2;
                Intrinsics.checkNotNull((Object)virtualFile2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"localFS.findFileByPath(d\u2026ath(project.basePath!!)!!");
            VirtualFile dirToImportVF = virtualFile;
            boolean $i$f$runWriteAction = false;
            Intrinsics.checkNotNullExpressionValue((Object)ApplicationManager.getApplication().runWriteAction(new Computable($this$copySelectedFile, project, dirToImportVF, fileNameWithExtension){
                final /* synthetic */ VirtualFile $this_copySelectedFile$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ VirtualFile $dirToImportVF$inlined;
                final /* synthetic */ String $fileNameWithExtension$inlined;
                {
                    this.$this_copySelectedFile$inlined = virtualFile;
                    this.$project$inlined = project;
                    this.$dirToImportVF$inlined = virtualFile2;
                    this.$fileNameWithExtension$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.$project$inlined).findDirectory(this.$dirToImportVF$inlined);
                    Intrinsics.checkNotNull((Object)psiDirectory);
                    Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"PsiManager.getInstance(p\u2026irectory(dirToImportVF)!!");
                    PsiDirectory directory = psiDirectory;
                    PsiFile psiFile = PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$this_copySelectedFile$inlined);
                    Intrinsics.checkNotNull((Object)psiFile);
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(project).findFile(this)!!");
                    PsiFile file = psiFile;
                    return (T)directory.copyFileFrom(this.$fileNameWithExtension$inlined, file);
                }
            }), (String)"runWriteAction {\n       \u2026hExtension, file)\n      }");
        }
        catch (Throwable exception) {
            MarkdownNotifier.INSTANCE.notifyIfConvertFailed(project, '[' + fileNameWithExtension + "] " + exception.getLocalizedMessage());
        }
    }

    private final GeneralCommandLine getConvertDocxToMdCommandLine(VirtualFile file, String mediaSrc, String targetFile) {
        return new GeneralCommandLine(new String[]{"pandoc", "--extract-media=" + mediaSrc, file.getPath(), "-f", MarkdownDocxExportProvider.Companion.getFormat().getExtension(), "-t", TARGET_FORMAT_NAME, "-s", "-o", targetFile});
    }

    public final boolean isJCEFPanelOpen(@NotNull MarkdownPreviewFileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)((Object)editor2), (String)"editor");
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo = editor2.getLastPanelProviderInfo();
        return Intrinsics.areEqual((Object)(providerInfo != null ? providerInfo.getClassName() : null), (Object)JCEFHtmlPanelProvider.class.getName());
    }

    @Nullable
    public final ValidationInfo validateTargetDir(@NotNull ValidationInfoBuilder $this$validateTargetDir, @NotNull TextFieldWithHistoryWithBrowseButton field) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validateTargetDir, (String)"$this$validateTargetDir");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)field.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithHistory, (String)"field.childComponent");
        CharSequence charSequence = textFieldWithHistory.getText();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string = RefactoringBundle.message((String)"no.target.directory.specified");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RefactoringBundle.messag\u2026get.directory.specified\")");
            validationInfo = $this$validateTargetDir.error(string);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public final void notifyAndRefreshIfExportSuccess(@NotNull File file, @NotNull Project project) {
        String dirToExport;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = MarkdownBundle.message("markdown.export.success.msg", file.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026.success.msg\", file.name)");
        MarkdownNotifier.INSTANCE.notifyOfSuccessfulExport(project, string);
        String string2 = dirToExport = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dirToExport");
        this.refreshProjectDirectory(project, string2);
    }

    private MarkdownImportExportUtils() {
    }

    static {
        MarkdownImportExportUtils markdownImportExportUtils;
        INSTANCE = markdownImportExportUtils = new MarkdownImportExportUtils();
    }

    public static final /* synthetic */ GeneralCommandLine access$getConvertDocxToMdCommandLine(MarkdownImportExportUtils $this, VirtualFile file, String mediaSrc, String targetFile) {
        return $this.getConvertDocxToMdCommandLine(file, mediaSrc, targetFile);
    }

    public static final /* synthetic */ void access$copySelectedFile(MarkdownImportExportUtils $this, VirtualFile $this$access_u24copySelectedFile, Project project, String dirToImport, String newFileName) {
        $this.copySelectedFile($this$access_u24copySelectedFile, project, dirToImport, newFileName);
    }
}

