/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceWrapper;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestinationImpl;
import org.intellij.plugins.markdown.lang.references.ContentRootRelatedMissingExtensionFileReference;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorPathReferenceProvider;
import org.jetbrains.annotations.NotNull;

public class MarkdownReferenceProvider
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            MarkdownReferenceProvider.$$$reportNull$$$0(0);
        }
        PsiElementPattern.Capture linkDestinationCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(MarkdownLinkDestinationImpl.class).inFile((ElementPattern)PlatformPatterns.psiFile(MarkdownFile.class));
        registrar.registerReferenceProvider((ElementPattern)linkDestinationCapture, (PsiReferenceProvider)new CommonLinkDestinationReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)linkDestinationCapture, (PsiReferenceProvider)new GithubWikiLocalFileReferenceProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider", "registerReferenceProviders"));
    }

    static class GithubWikiLocalFileReferenceProvider
    extends PsiReferenceProvider {
        private static final Pattern LINK_PATTERN = Pattern.compile("^https://github.com/[^/]*/[^/]*/wiki/");
        private static final boolean ARE_REFERENCES_SOFT = false;
        private final MarkdownAnchorPathReferenceProvider myAnchorPathReferenceProvider = new MarkdownAnchorPathReferenceProvider();

        GithubWikiLocalFileReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            String text;
            Matcher matcher;
            if (element == null) {
                GithubWikiLocalFileReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GithubWikiLocalFileReferenceProvider.$$$reportNull$$$0(1);
            }
            if ((matcher = LINK_PATTERN.matcher(text = element.getText())).find()) {
                ArrayList<PsiReference> references = new ArrayList<PsiReference>();
                int offsetInElement = matcher.end();
                int lastPos = PathReferenceProviderBase.getLastPosOfURL((int)offsetInElement, (String)text);
                String path = lastPos == -1 ? text.substring(offsetInElement) : text.substring(offsetInElement, lastPos);
                StaticPathReferenceProvider staticProvider = new StaticPathReferenceProvider(null);
                staticProvider.setEndingSlashNotAllowed(true);
                staticProvider.setRelativePathsAllowed(false);
                staticProvider.createReferences(element, offsetInElement, path, references, false);
                ContentRootRelatedMissingExtensionFileReference.Companion.createReference(element, references, false);
                this.myAnchorPathReferenceProvider.createReferences(element, references, false);
                PsiReference[] psiReferenceArray = ContainerUtil.map(references, x$0 -> new GithubWikiLocalFileReferenceWrapper((PsiReference)x$0)).toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    GithubWikiLocalFileReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                GithubWikiLocalFileReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider$GithubWikiLocalFileReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider$GithubWikiLocalFileReferenceProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class GithubWikiLocalFileReferenceWrapper
        extends PsiReferenceWrapper {
            private GithubWikiLocalFileReferenceWrapper(PsiReference originalPsiReference) {
                super(originalPsiReference);
            }
        }
    }

    private static class CommonLinkDestinationReferenceProvider
    extends PsiReferenceProvider {
        private CommonLinkDestinationReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                CommonLinkDestinationReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CommonLinkDestinationReferenceProvider.$$$reportNull$$$0(1);
            }
            PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(element, false, true, true, new PathReferenceProvider[0]);
            if (psiReferenceArray == null) {
                CommonLinkDestinationReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider$CommonLinkDestinationReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/markdown/lang/references/MarkdownReferenceProvider$CommonLinkDestinationReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

