/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.util.Key;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownEditorWithPreview
extends TextEditorWithPreview {
    public static final Key<MarkdownEditorWithPreview> PARENT_SPLIT_EDITOR_KEY = Key.create((String)"parentSplit");
    private boolean myAutoScrollPreview;

    public MarkdownEditorWithPreview(@NotNull TextEditor editor2, @NotNull MarkdownPreviewFileEditor preview) {
        if (editor2 == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(1);
        }
        super(editor2, (FileEditor)preview, MarkdownBundle.message("markdown.editor.name", new Object[0]), TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW, !MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isVerticalSplit());
        this.myAutoScrollPreview = MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isAutoScrollPreview();
        editor2.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.setMainEditor(editor2.getEditor());
        MarkdownApplicationSettings.SettingsChangedListener settingsChangedListener = new MarkdownApplicationSettings.SettingsChangedListener(){

            @Override
            public void settingsChanged(@NotNull MarkdownApplicationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                MarkdownEditorWithPreview.this.setAutoScrollPreview(settings.getMarkdownPreviewSettings().isAutoScrollPreview());
                MarkdownEditorWithPreview.this.handleLayoutChange(!settings.getMarkdownPreviewSettings().isVerticalSplit());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$1", "settingsChanged"));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
        this.getTextEditor().getEditor().getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener());
    }

    public boolean isAutoScrollPreview() {
        return this.myAutoScrollPreview;
    }

    public void setAutoScrollPreview(boolean autoScrollPreview) {
        this.myAutoScrollPreview = autoScrollPreview;
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("Markdown.Toolbar.Left");
    }

    @Nullable
    protected ActionGroup createRightToolbarActionGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("Markdown.Toolbar.Right");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "preview";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int previousLine = 0;

        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent event) {
            if (event == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            if (!MarkdownEditorWithPreview.this.isAutoScrollPreview()) {
                return;
            }
            Editor editor2 = event.getEditor();
            int currentLine = EditorUtil.yPositionToLogicalLine((Editor)editor2, (int)editor2.getScrollingModel().getVerticalScrollOffset());
            if (currentLine == this.previousLine) {
                return;
            }
            this.previousLine = currentLine;
            ((MarkdownPreviewFileEditor)MarkdownEditorWithPreview.this.getPreviewEditor()).scrollToSrcOffset(EditorUtil.getVisualLineEndOffset((Editor)editor2, (int)currentLine));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$MyVisibleAreaListener", "visibleAreaChanged"));
        }
    }
}

