/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownSplitEditorProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final long PARSING_CALL_TIMEOUT_MS = 50L;
    private static final long RENDERING_DELAY_MS = 20L;
    public static final Key<MarkdownHtmlPanel> PREVIEW_BROWSER = Key.create((String)"PREVIEW_BROWSER");
    @Nullable
    private static Boolean ourIsDefaultMarkdownPreviewSettings = null;
    private final Project myProject;
    private final VirtualFile myFile;
    @Nullable
    private final Document myDocument;
    private final JPanel myHtmlPanelWrapper;
    @Nullable
    private MarkdownHtmlPanel myPanel;
    @Nullable
    private MarkdownHtmlPanelProvider.ProviderInfo myLastPanelProviderInfo;
    private final Alarm myPooledAlarm;
    private final Alarm mySwingAlarm;
    private final Object REQUESTS_LOCK;
    @Nullable
    private Runnable myLastScrollRequest;
    @Nullable
    private Runnable myLastHtmlOrRefreshRequest;
    private volatile int myLastScrollOffset;
    @NotNull
    private String myLastRenderedHtml;
    private Editor mainEditor;

    public MarkdownPreviewFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(1);
        }
        this.myLastPanelProviderInfo = null;
        this.myPooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySwingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.REQUESTS_LOCK = new Object();
        this.myLastScrollRequest = null;
        this.myLastHtmlOrRefreshRequest = null;
        this.myLastRenderedHtml = "";
        this.myProject = project;
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (this.myDocument != null) {
            this.myDocument.addDocumentListener(new DocumentListener(){

                public void beforeDocumentChange(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MarkdownPreviewFileEditor.this.myPooledAlarm.cancelAllRequests();
                }

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MarkdownPreviewFileEditor.this.myPooledAlarm.addRequest(() -> MarkdownPreviewFileEditor.this.updateHtml(), 50L);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeDocumentChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "documentChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this);
        }
        this.myHtmlPanelWrapper = new JPanel(new BorderLayout());
        this.myHtmlPanelWrapper.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                    if (MarkdownPreviewFileEditor.this.myPanel == null) {
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    }
                }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                    if (MarkdownPreviewFileEditor.this.myPanel != null) {
                        MarkdownPreviewFileEditor.this.detachHtmlPanel();
                    }
                }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
            }
        });
        if (MarkdownPreviewFileEditor.isPreviewShown(project, file)) {
            this.attachHtmlPanel();
        }
        MessageBusConnection settingsConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        MyUpdatePanelOnSettingsChangedListener settingsChangedListener = new MyUpdatePanelOnSettingsChangedListener();
        settingsConnection.subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
        settingsConnection.subscribe(MarkdownApplicationSettings.FontChangedListener.TOPIC, (Object)this.createFontChangedListener());
    }

    @NotNull
    private MarkdownApplicationSettings.FontChangedListener createFontChangedListener() {
        return new MarkdownApplicationSettings.FontChangedListener(){

            @Override
            public void fontChanged() {
                if (MarkdownPreviewFileEditor.this.myPanel != null && MarkdownPreviewFileEditor.this.mainEditor != null) {
                    MarkdownPreviewFileEditor.this.myPanel.reloadWithOffset(MarkdownPreviewFileEditor.this.mainEditor.getCaretModel().getOffset());
                }
            }
        };
    }

    public void setMainEditor(Editor editor2) {
        this.mainEditor = editor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToSrcOffset(int offset) {
        if (this.myPanel == null) {
            return;
        }
        if (!this.myPooledAlarm.isEmpty()) {
            this.myLastScrollOffset = offset;
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastScrollRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastScrollRequest);
            }
            this.myLastScrollRequest = () -> {
                if (this.myPanel != null) {
                    this.myLastScrollOffset = offset;
                    this.myPanel.scrollToMarkdownSrcOffset(this.myLastScrollOffset);
                    Object object = this.REQUESTS_LOCK;
                    synchronized (object) {
                        this.myLastScrollRequest = null;
                    }
                }
            };
            this.mySwingAlarm.addRequest(this.myLastScrollRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myHtmlPanelWrapper;
        if (jPanel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel != null ? this.myPanel.getComponent() : null;
    }

    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.editor.preview.name", new Object[0]);
        if (string == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (this.myPanel != null) {
            this.updateHtmlPooled();
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
    }

    @Nullable
    public MarkdownHtmlPanelProvider.ProviderInfo getLastPanelProviderInfo() {
        return this.myLastPanelProviderInfo;
    }

    @NotNull
    private MarkdownHtmlPanelProvider retrievePanelProvider(@NotNull MarkdownApplicationSettings settings) {
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo;
        MarkdownHtmlPanelProvider provider;
        if (settings == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(7);
        }
        if ((provider = MarkdownHtmlPanelProvider.createFromInfo(providerInfo = settings.getMarkdownPreviewSettings().getHtmlPanelProviderInfo())).isAvailable() != MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE) {
            if (ourIsDefaultMarkdownPreviewSettings == null) {
                ourIsDefaultMarkdownPreviewSettings = settings.getMarkdownPreviewSettings() == MarkdownPreviewSettings.DEFAULT;
            }
            settings.setMarkdownPreviewSettings(new MarkdownPreviewSettings(settings.getMarkdownPreviewSettings().getSplitEditorLayout(), MarkdownPreviewSettings.DEFAULT.getHtmlPanelProviderInfo(), settings.getMarkdownPreviewSettings().isAutoScrollPreview(), settings.getMarkdownPreviewSettings().isVerticalSplit()));
            if (!ourIsDefaultMarkdownPreviewSettings.booleanValue()) {
                Messages.showMessageDialog((Component)this.myHtmlPanelWrapper, (String)MarkdownBundle.message("dialog.message.tried.to.use.preview.panel.provider", providerInfo.getName()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
            provider = Objects.requireNonNull((MarkdownHtmlPanelProvider)ContainerUtil.find((Object[])MarkdownHtmlPanelProvider.getProviders(), p -> p.isAvailable() == MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE));
        }
        this.myLastPanelProviderInfo = settings.getMarkdownPreviewSettings().getHtmlPanelProviderInfo();
        MarkdownHtmlPanelProvider markdownHtmlPanelProvider = provider;
        if (markdownHtmlPanelProvider == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(8);
        }
        return markdownHtmlPanelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtml() {
        if (this.myPanel == null || this.myDocument == null || !this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        String html = MarkdownUtil.INSTANCE.generateMarkdownHtml(this.myFile, this.myDocument.getText(), this.myProject);
        if (!this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastHtmlOrRefreshRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastHtmlOrRefreshRequest);
            }
            this.myLastHtmlOrRefreshRequest = () -> {
                if (this.myPanel == null) {
                    return;
                }
                String currentHtml = "<html><head></head>" + html + "</html>";
                if (!currentHtml.equals(this.myLastRenderedHtml)) {
                    this.myLastRenderedHtml = currentHtml;
                    this.myPanel.setHtml(this.myLastRenderedHtml, this.mainEditor.getCaretModel().getOffset());
                }
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastHtmlOrRefreshRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastHtmlOrRefreshRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    private void detachHtmlPanel() {
        if (this.myPanel != null) {
            this.myHtmlPanelWrapper.remove(this.myPanel.getComponent());
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
            this.putUserData(PREVIEW_BROWSER, null);
        }
    }

    private void attachHtmlPanel() {
        MarkdownApplicationSettings settings = MarkdownApplicationSettings.getInstance();
        this.myPanel = this.retrievePanelProvider(settings).createHtmlPanel();
        this.myHtmlPanelWrapper.add((Component)this.myPanel.getComponent(), "Center");
        if (this.myHtmlPanelWrapper.isShowing()) {
            this.myHtmlPanelWrapper.validate();
        }
        this.myHtmlPanelWrapper.repaint();
        this.myLastRenderedHtml = "";
        this.putUserData(PREVIEW_BROWSER, this.myPanel);
        this.updateHtmlPooled();
    }

    private void updateHtmlPooled() {
        this.myPooledAlarm.cancelAllRequests();
        this.myPooledAlarm.addRequest(() -> this.updateHtml(), 0);
    }

    private static boolean isPreviewShown(@NotNull Project project, @NotNull VirtualFile file) {
        MarkdownSplitEditorProvider provider;
        if (project == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(9);
        }
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(10);
        }
        if ((provider = (MarkdownSplitEditorProvider)FileEditorProvider.EP_FILE_EDITOR_PROVIDER.findExtension(MarkdownSplitEditorProvider.class)) == null) {
            return true;
        }
        FileEditorState state = EditorHistoryManager.getInstance((Project)project).getState(file, (FileEditorProvider)provider);
        if (!(state instanceof SplitFileEditor.MyFileEditorState)) {
            return true;
        }
        String layout = ((SplitFileEditor.MyFileEditorState)state).getSplitLayout();
        return layout == null || !layout.equals("FIRST");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "retrievePanelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "retrievePanelProvider";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewShown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyUpdatePanelOnSettingsChangedListener
    implements MarkdownApplicationSettings.SettingsChangedListener {
        private MyUpdatePanelOnSettingsChangedListener() {
        }

        @Override
        public void settingsChanged(@NotNull MarkdownApplicationSettings settings) {
            if (settings == null) {
                MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(0);
            }
            MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                if (settings.getMarkdownPreviewSettings().getSplitEditorLayout() != TextEditorWithPreview.Layout.SHOW_EDITOR) {
                    if (MarkdownPreviewFileEditor.this.myPanel == null) {
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    } else if (MarkdownPreviewFileEditor.this.myLastPanelProviderInfo == null || MarkdownHtmlPanelProvider.createFromInfo(MarkdownPreviewFileEditor.this.myLastPanelProviderInfo).equals(MarkdownPreviewFileEditor.this.retrievePanelProvider(settings))) {
                        MarkdownPreviewFileEditor.this.detachHtmlPanel();
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    }
                    MarkdownPreviewFileEditor.this.myPanel.reloadWithOffset(MarkdownPreviewFileEditor.this.mainEditor.getCaretModel().getOffset());
                }
            }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$MyUpdatePanelOnSettingsChangedListener", "settingsChanged"));
        }
    }
}

