/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestConstants;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestElements;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestFramework
extends CidrTestWithScopeElementsAndGeneratorFramework {
    public static CidrBoostTestFramework getInstance() {
        return (CidrBoostTestFramework)CidrBoostTestFramework.getInstance(CidrBoostTestFramework.class);
    }

    public CidrBoostTestFramework() {
        super("Boost Test", new Class[]{OCMacroCall.class, OCCppNamespace.class, OCFunctionDefinition.class});
    }

    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(0);
        }
        CidrTestFrameworkVersion cidrTestFrameworkVersion = CidrBoostTestFramework.getFrameworkVersionUsingImportedMacro((PsiFile)file, (String)"BOOST_AUTO_TEST_CASE");
        if (cidrTestFrameworkVersion == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(1);
        }
        return cidrTestFrameworkVersion;
    }

    @NonNls
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return ":";
    }

    @NonNls
    @NotNull
    public String getProtocolPrefix() {
        return "boost://";
    }

    @Nullable
    protected CidrTestScopeElement extractTest(@NotNull PsiElement element) {
        if (element == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(2);
        }
        return this.getTestObjectFromTestHolder(element, CidrBoostTestConstants.BOOST_TEST_MACRO_NAMES);
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(3);
        }
        return this.standardProbe(symbol, element, OCFunctionDefinition.class, project, new OCSymbolKind[]{OCSymbolKind.FUNCTION_DECLARATION});
    }

    @Contract(value="null, null, _ -> false")
    public boolean isTestNamespace(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(4);
        }
        return this.standardProbe(symbol, element, OCCppNamespace.class, project, new OCSymbolKind[]{OCSymbolKind.NAMESPACE});
    }

    @Nullable
    public String generateTestPath(String suitePath, String testPath, @NotNull String testSource) {
        if (testSource == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(5);
        }
        return "boost".equals(testSource) ? CidrBoostTestElements.createTestScopeElementForSuiteAndTest(suitePath, testPath).getTestPath() : null;
    }

    @NotNull
    protected Map<String, CidrTestScopeElement> createTestObjectsDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(6);
        }
        Map<String, CidrTestScopeElement> map = CidrBoostTestUtil.createTestLinks(file);
        if (map == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    protected Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
        Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> function = CidrBoostTestElements.getGenerator();
        if (function == null) {
            CidrBoostTestFramework.$$$reportNull$$$0(8);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestFramework";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestFramework";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameworkVersionDirectly";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestObjectsDirectly";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFrameworkVersionDirectly";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractTest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodOrFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestNamespace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateTestPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTestObjectsDirectly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

