/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.editor;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssSelectioner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.psi.LESSFile;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LessStatement;
import org.jetbrains.plugins.less.psi.impl.LESSGuardImpl;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.impl.LESSOperationImpl;
import org.jetbrains.plugins.less.psi.impl.LessParameterList;

public class LessExtendWordSelectionHandler
extends AbstractWordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            LessExtendWordSelectionHandler.$$$reportNull$$$0(0);
        }
        return e.getContainingFile() instanceof LESSFile;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        LessStatement statement;
        PsiElement parent;
        PsiElement fullNameIdentifier;
        if (e == null) {
            LessExtendWordSelectionHandler.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            LessExtendWordSelectionHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LessExtendWordSelectionHandler.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        LESSOperationImpl operation = (LESSOperationImpl)PsiTreeUtil.getParentOfType((PsiElement)e, LESSOperationImpl.class);
        while (operation != null) {
            result.add(operation.getTextRange());
            operation = (LESSOperationImpl)PsiTreeUtil.getParentOfType((PsiElement)operation, LESSOperationImpl.class);
        }
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)e, (Class[])new Class[]{LESSMixin.class, CssBlock.class});
        if (psiElement instanceof LESSMixin && (fullNameIdentifier = ((LESSMixin)psiElement).getFullNameIdentifier()) != null) {
            Object nextVisibleLeaf;
            result.add(fullNameIdentifier.getTextRange());
            PsiElement lParen = nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)fullNameIdentifier);
            if (lParen != null && lParen.getNode().getElementType() == CssElementTypes.CSS_LPAREN) {
                PsiElement rParen;
                LessParameterList argumentList = (LessParameterList)PsiTreeUtil.getNextSiblingOfType((PsiElement)lParen, LessParameterList.class);
                if (argumentList != null) {
                    result.add(argumentList.getTextRange());
                    nextVisibleLeaf = argumentList;
                }
                if ((rParen = PsiTreeUtil.nextVisibleLeaf((PsiElement)nextVisibleLeaf)) != null && rParen.getNode().getElementType() == CssElementTypes.CSS_RPAREN) {
                    result.add(TextRange.create((int)fullNameIdentifier.getTextRange().getStartOffset(), (int)rParen.getTextRange().getEndOffset()));
                    result.add(TextRange.create((int)lParen.getTextRange().getStartOffset(), (int)rParen.getTextRange().getEndOffset()));
                    nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)rParen);
                }
            }
            if (nextVisibleLeaf != null && nextVisibleLeaf.getNode().getElementType() == LESSTokenTypes.WHEN_KEYWORD) {
                PsiElement guard = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextVisibleLeaf);
                PsiElement lastGuard = null;
                while (guard != null && (guard instanceof LESSGuardImpl || StringUtil.isEmptyOrSpaces((String)guard.getText()) || guard instanceof PsiComment || guard instanceof LESSOperationImpl || guard.getNode().getElementType() == CssElementTypes.CSS_COMMA)) {
                    lastGuard = guard;
                    result.add(guard.getTextRange());
                    guard = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)guard);
                }
                if (lastGuard != null) {
                    result.add(TextRange.create((int)nextVisibleLeaf.getTextRange().getStartOffset(), (int)lastGuard.getTextRange().getEndOffset()));
                    result.add(TextRange.create((int)fullNameIdentifier.getTextRange().getStartOffset(), (int)lastGuard.getTextRange().getEndOffset()));
                }
            }
        }
        if ((parent = e.getParent()) instanceof LESSMixinName) {
            result.add(parent.getTextRange());
            PsiElement mixinInvocation = parent.getParent();
            if (mixinInvocation instanceof LESSMixinInvocation) {
                result.add(mixinInvocation.getTextRange());
                List<LESSNamespace> namespaces = ((LESSMixinInvocation)mixinInvocation).getNamespacesElements();
                for (LESSNamespace namespace : namespaces) {
                    result.add(TextRange.create((int)namespace.getTextRange().getStartOffset(), (int)mixinInvocation.getTextRange().getEndOffset()));
                }
            }
        }
        if ((statement = (LessStatement)PsiTreeUtil.getParentOfType((PsiElement)e, LessStatement.class)) != null) {
            result.add(statement.getTextRange());
            ContainerUtil.addIfNotNull(result, (Object)CssSelectioner.getStatementWithSemicolonRange((PsiElement)statement));
        }
        return !result.isEmpty() ? result : null;
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text, int cursorOffset) {
        if (element == null) {
            LessExtendWordSelectionHandler.$$$reportNull$$$0(4);
        }
        if (text == null) {
            LessExtendWordSelectionHandler.$$$reportNull$$$0(5);
        }
        if (WebEditorOptions.getInstance().isSelectWholeCssIdentifierOnDoubleClick()) {
            IElementType type = element.getNode().getElementType();
            PsiElement parent = element.getParent();
            if (parent instanceof LESSMixinName) {
                return type == CssElementTypes.CSS_HASH ? element.getTextLength() - 1 : element.getTextLength();
            }
        }
        return element.getNode().getElementType() == LESSTokenTypes.VARIABLE ? element.getTextLength() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/less/editor/LessExtendWordSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinimalTextRangeLength";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

