/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.css.impl.parsing.CssParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.parser.LESSParser;

final class LessMathParser
extends CssMathParser {
    @NotNull
    private final LESSParser myParser;

    public LessMathParser(@NotNull LESSParser parser) {
        if (parser == null) {
            LessMathParser.$$$reportNull$$$0(0);
        }
        super((CssParser)parser);
        this.myParser = parser;
    }

    public boolean parse() {
        boolean ok = this.parseEscapeStringsAsTerms();
        if (ok && this.getTokenType() == CssElementTypes.CSS_RPAREN) {
            return true;
        }
        if (super.parse()) {
            ok = true;
            this.parseEscapeStringsAsTerms();
        }
        return ok;
    }

    protected boolean parseTerm(IElementType prevOperation) {
        boolean result = this.parseTermInner(prevOperation);
        if (this.myParser.parseEscapeString()) {
            while (this.myParser.parseEscapeString()) {
            }
            this.parseTerm(prevOperation);
            return true;
        }
        return result;
    }

    private boolean parseTermInner(IElementType prevOperation) {
        if (this.getTokenType() == LESSTokenTypes.VARIABLE) {
            this.myParser.parseVariable();
            return true;
        }
        return super.parseTerm(prevOperation);
    }

    private boolean parseEscapeStringsAsTerms() {
        if (this.parseEscapeStringAsTerm()) {
            while (this.parseEscapeStringAsTerm()) {
            }
            return true;
        }
        return false;
    }

    private boolean parseEscapeStringAsTerm() {
        PsiBuilder.Marker m = this.mark();
        if (this.myParser.parseEscapeString()) {
            m.done(CssElementTypes.CSS_TERM);
            return true;
        }
        m.rollbackTo();
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/less/parser/LessMathParser", "<init>"));
    }
}

