/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;

public class LESSNamespaceReference
extends PsiPolyVariantReferenceBase<LESSNamespace> {
    public LESSNamespaceReference(LESSNamespace element) {
        super((PsiElement)element);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)this.myElement);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)((LESSNamespace)this.myElement).getContainingFile(), (PsiElement)this.myElement, (boolean)false);
        String parentNamespace = ((LESSNamespace)this.myElement).getNamespace();
        LinkedList result = new LinkedList();
        LinkedList resultResolvedByNameOnly = new LinkedList();
        LessMixinIndex.process(((LESSNamespace)this.myElement).getFullName(), ((LESSNamespace)this.myElement).getProject(), scope, (Processor<? super LESSMixin>)((Processor)mixin -> {
            if (!mixin.hasParameters() && LESSUtil.isMixinMatchesWithInvocation(mixin, this.myElement, parentNamespace)) {
                boolean validResult = importedFiles.contains(mixin.getContainingFile().getVirtualFile());
                PsiElementResolveResult resolveResult = new PsiElementResolveResult(mixin.getTargetForReference(), validResult);
                if (validResult) {
                    result.add(resolveResult);
                } else {
                    resultResolvedByNameOnly.add(resolveResult);
                }
            }
            return true;
        }));
        result.addAll(resultResolvedByNameOnly);
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            LESSNamespaceReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return ((LESSNamespace)this.myElement).getText().length() > 0 ? TextRange.from((int)1, (int)(((LESSNamespace)this.myElement).getTextLength() - 1)) : TextRange.EMPTY_RANGE;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            LESSNamespaceReference.$$$reportNull$$$0(1);
        }
        return ((LESSNamespace)this.myElement).setName(newElementName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/references/LESSNamespaceReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/references/LESSNamespaceReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

