/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.testing.CidrMetaParam;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverterBase;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLinker;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CidrCatchOutputToGeneralTestEventsConverter
extends CidrOutputToGeneralTestEventsConverterBase {
    @NonNls
    private static final String CATCH_TAG = "Catch";
    @NonNls
    private static final String STDOUT_TAG = "StdOut";
    @NonNls
    private static final String STDERR_TAG = "StdErr";
    @NonNls
    private static final String ORIGINAL_TAG = "Original";
    @NonNls
    private static final String EXPANDED_TAG = "Expanded";
    @NonNls
    private static final String GROUP_TAG = "Group";
    @NonNls
    private static final String TEST_CASE_TAG = "TestCase";
    @NonNls
    private static final String SECTION_TAG = "Section";
    @NonNls
    private static final String OVERALL_RESULT_TAG = "OverallResult";
    @NonNls
    private static final String OVERALL_RESULTS_TAG = "OverallResults";
    @NonNls
    private static final String EXPRESSION_TAG = "Expression";
    @NonNls
    private static final String INFO_TAG = "Info";
    @NonNls
    private static final String WARNING_TAG = "Warning";
    @NonNls
    private static final String FAILURE_TAG = "Failure";
    @NonNls
    private static final String FATAL_ERROR_CONDITION_TAG = "FatalErrorCondition";
    @NonNls
    private static final String EXCEPTION_TAG = "Exception";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final String TAGS_ATTR = "tags";
    @NonNls
    private static final String DURATION_IN_SECONDS_ATTR = "durationInSeconds";
    @NonNls
    private static final String SUCCESS_ATTR = "success";
    @NonNls
    private static final String SUCCESSES_ATTR = "successes";
    @NonNls
    private static final String FAILURES_ATTR = "failures";
    @NonNls
    private static final String DESCRIPTION_ATTR = "description";
    @NonNls
    private static final String EXPECTED_FAILURES_ATTR = "expectedFailures";
    @NonNls
    private static final String FILE_NAME_ATTR = "filename";
    @NonNls
    private static final String LINE_ATTR = "line";
    @NonNls
    private static final String TYPE_ATTR = "type";
    @NonNls
    private static final String OUT_INDENT = "  ";
    private static final String[] ALL_TAGS = new String[]{"Catch", "StdOut", "StdErr", "Original", "Expanded", "Group", "TestCase", "Section", "OverallResult", "OverallResults", "Expression", "Info", "Warning", "Failure", "FatalErrorCondition", "Exception"};
    private static final String[] ALL_ATTRS = new String[]{"name", "description", "tags", "durationInSeconds", "success", "successes", "failures", "expectedFailures", "filename", "line", "type"};
    private volatile Future<Boolean> myXMLParser;
    private volatile PipedOutputStream myPipedOutStream;
    private volatile ServiceMessageVisitor myVisitor;
    private final CidrTestEventProcessor myEventProcessor;
    private volatile boolean myXMLStarted;
    private volatile boolean myXMLParserInAction;
    private volatile String myProcessFinishedMessage;
    private final ExecutionConsole myConsole;
    private final String myTargetName;
    private final List<CidrCatchTestLinker> myInfos;
    private static final String TAGS = StringUtil.join((String[])ALL_TAGS, (String)"|");
    private static final Pattern OPEN_TAG = Pattern.compile(String.format("([^\\n]*)(\\s*<(%s)(?: (?:%s)\\=\"[^\"]*\")*\\/?>\\n)", TAGS, StringUtil.join((String[])ALL_ATTRS, (String)"|")));
    private static final Pattern CLOSE_TAG = Pattern.compile(String.format("([^\\n]*)(\\s*</(%s)>\\n)", TAGS));
    private final BooleanStack myPrintfHolderStack;

    public CidrCatchOutputToGeneralTestEventsConverter(@NotNull @NonNls String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console, @Nullable List<CidrCatchTestLinker> infos, @Nullable @NonNls String targetName) {
        if (testFrameworkName == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (console == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties);
        this.myXMLStarted = false;
        this.myXMLParserInAction = true;
        this.myPrintfHolderStack = new BooleanStack();
        this.myConsole = console;
        this.myEventProcessor = new CidrTestEventProcessor("catch");
        this.myInfos = infos;
        this.myTargetName = targetName;
    }

    protected synchronized void setupTestTree(@NotNull GeneralTestEventsProcessor processor) {
        if (processor == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        if (this.myInfos == null || this.myInfos.isEmpty()) {
            return;
        }
        CatchXMLOutputHandler handler = this.createHandler();
        for (CidrCatchTestLinker linker : this.myInfos) {
            handler.startTest(processor, linker.getFindPath(), null, false);
            handler.endTest(processor, false);
        }
        processor.onBuildTreeEnded();
    }

    protected void process(@NotNull List<ServiceMessageBuilder> messages) {
        if (messages == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        try {
            for (ServiceMessageBuilder each : messages) {
                super.processServiceMessages(each.toString(), ProcessOutputTypes.STDOUT, this.myVisitor);
            }
        }
        catch (Exception e) {
            CidrTestLog.LOG.error(e.getMessage());
        }
    }

    protected boolean processServiceMessages(@NotNull String text, @NotNull Key outputType, @NotNull ServiceMessageVisitor visitor) {
        if (text == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        if (visitor == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(7);
        }
        CidrOutputToGeneralTestEventsConverter.logOutput((String)text, (Key)outputType);
        this.myVisitor = visitor;
        if (!this.myXMLStarted && CidrCatchOutputToGeneralTestEventsConverter.isXMLHeader(text)) {
            this.myXMLStarted = true;
        }
        if (ProcessOutputType.isStdout((Key)outputType) && this.myXMLStarted && this.myXMLParserInAction) {
            try {
                if (this.myXMLParser == null) {
                    this.myPipedOutStream = new PipedOutputStream();
                    PipedInputStream pipedInStream = new PipedInputStream(this.myPipedOutStream);
                    this.myXMLParser = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        boolean success = false;
                        try {
                            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)pipedInStream, (DefaultHandler)this.createHandler());
                            success = true;
                        }
                        catch (SAXParseException sax) {
                            CidrTestLog.LOG.debug((Throwable)sax);
                        }
                        catch (IOException | ParserConfigurationException e) {
                            if ("Pipe broken".equals(e.getMessage())) {
                                CidrTestLog.LOG.debug((Throwable)e);
                            } else {
                                CidrTestLog.LOG.error((Throwable)e);
                            }
                        }
                        finally {
                            try {
                                pipedInStream.close();
                            }
                            catch (IOException e) {
                                CidrTestLog.LOG.debug((Throwable)e);
                            }
                            this.myXMLParserInAction = false;
                        }
                        return success;
                    });
                }
                this.processLine(text);
                return true;
            }
            catch (IOException e) {
                this.myXMLParserInAction = false;
                CidrTestLog.LOG.error((Throwable)e);
            }
        } else if (outputType == ProcessOutputTypes.SYSTEM) {
            if (CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN.matcher(text).matches()) {
                this.myProcessFinishedMessage = text;
                return true;
            }
            if (text.equals("\n")) {
                return true;
            }
        }
        return false;
    }

    private void processLine(String text) throws IOException {
        if (CidrCatchOutputToGeneralTestEventsConverter.isXMLHeader(text)) {
            this.passToParser(text);
        } else {
            boolean isInPrintfTag = !this.myPrintfHolderStack.isEmpty() && this.myPrintfHolderStack.peek();
            Matcher m = OPEN_TAG.matcher(text);
            if (m.matches()) {
                this.processTag(isInPrintfTag, true, m);
            } else {
                m = CLOSE_TAG.matcher(text);
                if (m.matches()) {
                    this.processTag(isInPrintfTag, false, m);
                } else {
                    this.processFreeText(isInPrintfTag, text);
                }
            }
        }
        this.myPipedOutStream.flush();
    }

    @Contract(pure=true)
    private static boolean isXMLHeader(@Nullable String text) {
        return text != null && text.startsWith("<?xml version=");
    }

    private void processTag(boolean isInPrinfTag, boolean isOpenTag, @NotNull Matcher m) throws IOException {
        if (m == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(8);
        }
        String freeText = m.group(1);
        String tagContext = m.group(2);
        String tagName = m.group(3);
        this.processFreeText(isInPrinfTag, freeText.trim());
        if (isOpenTag) {
            this.myPrintfHolderStack.push(CidrCatchOutputToGeneralTestEventsConverter.isPrintfHolder(tagName));
        } else {
            this.myPrintfHolderStack.pop();
        }
        this.passToParser(tagContext);
    }

    private void processFreeText(boolean isInPrintfTag, @NotNull String freeText) throws IOException {
        if (freeText == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(9);
        }
        if (freeText.length() == 0) {
            return;
        }
        this.passToParser(isInPrintfTag ? String.format("<%s>%s</%s>", STDOUT_TAG, StringUtil.escapeXmlEntities((String)freeText), STDOUT_TAG) : freeText);
    }

    private static boolean isPrintfHolder(@NotNull String tag) {
        if (tag == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(10);
        }
        return TEST_CASE_TAG.equals(tag) || SECTION_TAG.equals(tag);
    }

    private void passToParser(@NotNull String openTagContext) throws IOException {
        if (openTagContext == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(11);
        }
        this.myPipedOutStream.write(openTagContext.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBufferOnProcessTermination(int exitCode) {
        CidrTestLog.LOG.debug("flushBufferOnProcessTermination");
        if (this.myPipedOutStream != null) {
            try {
                this.myPipedOutStream.close();
            }
            catch (IOException e) {
                CidrTestLog.LOG.debug((Throwable)e);
            }
            finally {
                this.myPipedOutStream = null;
            }
        }
        if (this.myXMLParser != null) {
            try {
                GeneralTestEventsProcessor processor;
                Boolean isSuccessXMLParsing = this.myXMLParser.get();
                if (CidrTestLog.LOG.isDebugEnabled()) {
                    CidrTestLog.LOG.debug("parsing finished:" + isSuccessXMLParsing.toString());
                }
                if ((processor = this.getProcessor()) != null && this.myProcessFinishedMessage != null) {
                    processor.onUncapturedOutput(this.myProcessFinishedMessage, ProcessOutputTypes.SYSTEM);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                CidrTestLog.LOG.error((Throwable)e);
            }
            finally {
                this.myXMLParser = null;
                this.myXMLParserInAction = false;
            }
        }
        this.transferTextToConsoleViewInTest();
        super.flushBufferOnProcessTermination(exitCode);
    }

    private void transferTextToConsoleViewInTest() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ((ConsoleViewImpl)((SMTRunnerConsoleView)this.myConsole).getConsole()).waitAllRequests());
        }
    }

    @NotNull
    @Contract(pure=true)
    private CatchXMLOutputHandler createHandler() {
        return new CatchXMLOutputHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freeText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openTagContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setupTestTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processServiceMessages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processTag";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processFreeText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrintfHolder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "passToParser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CatchXMLOutputHandler
    extends DefaultHandler {
        static final String ROOT_NODE_ID = "0";
        final Stack<String> myTestNameStack = new Stack();
        final HashMap<String, TestEnd> myTestResults = new HashMap();
        final StringBuilder myInfoMessageWithNewLineAndIndent = new StringBuilder();
        String myExpressionPrefix;
        boolean myInErrorExpression = false;
        final StringBuilder myText = new StringBuilder();
        boolean mySuccess;
        int myDuration;
        final Stack<String> mySectionsEndIdStack = new Stack();

        private CatchXMLOutputHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            GeneralTestEventsProcessor processor = CidrCatchOutputToGeneralTestEventsConverter.this.getProcessor();
            if (processor == null) {
                CidrTestLog.LOG.debug("startElement: processor was disposed");
                return;
            }
            this.myText.setLength(0);
            if (CidrTestLog.LOG.isDebugEnabled()) {
                CidrTestLog.LOG.debug("{startElement" + qName);
            }
            if (CidrCatchOutputToGeneralTestEventsConverter.GROUP_TAG.equals(qName)) {
                processor.onTestsReporterAttached();
            } else if (CidrCatchOutputToGeneralTestEventsConverter.TEST_CASE_TAG.equals(qName) || CidrCatchOutputToGeneralTestEventsConverter.SECTION_TAG.equals(qName)) {
                String testName = StringUtil.notNullize((String)attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.NAME_ATTR), (String)"Anonymous test case *");
                this.startTest(processor, testName, attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.LINE_ATTR), true);
            } else if (CidrCatchOutputToGeneralTestEventsConverter.OVERALL_RESULT_TAG.equals(qName)) {
                String seconds = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.DURATION_IN_SECONDS_ATTR);
                if (seconds != null) {
                    this.myDuration = (int)Math.round(Double.parseDouble(seconds) * 1000.0);
                }
                this.mySuccess = "true".equals(attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.SUCCESS_ATTR));
            } else if (CidrCatchOutputToGeneralTestEventsConverter.OVERALL_RESULTS_TAG.equals(qName)) {
                String seconds = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.DURATION_IN_SECONDS_ATTR);
                if (seconds != null) {
                    this.myDuration = (int)Math.round(Double.parseDouble(seconds) * 1000.0);
                }
                this.mySuccess = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.FAILURES_ATTR) != null && attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.EXPECTED_FAILURES_ATTR) != null && attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.FAILURES_ATTR).equals(attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.EXPECTED_FAILURES_ATTR));
            } else if (CidrCatchOutputToGeneralTestEventsConverter.EXPRESSION_TAG.equals(qName) && !"true".equals(attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.SUCCESS_ATTR))) {
                this.reportError(processor, attributes, "");
                this.myExpressionPrefix = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.TYPE_ATTR);
                this.myInErrorExpression = true;
            } else if (CidrCatchOutputToGeneralTestEventsConverter.EXCEPTION_TAG.equals(qName) && !this.myInErrorExpression) {
                this.reportError(processor, attributes, "");
            } else if (CidrCatchOutputToGeneralTestEventsConverter.FATAL_ERROR_CONDITION_TAG.equals(qName)) {
                this.reportError(processor, attributes, "\nfatal error");
            } else if (CidrCatchOutputToGeneralTestEventsConverter.FAILURE_TAG.equals(qName)) {
                this.reportError(processor, attributes, "");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.myText.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            GeneralTestEventsProcessor processor = CidrCatchOutputToGeneralTestEventsConverter.this.getProcessor();
            if (processor == null) {
                CidrTestLog.LOG.debug("endElement: processor was disposed");
                return;
            }
            if (CidrTestLog.LOG.isDebugEnabled()) {
                CidrTestLog.LOG.debug("}endElement " + qName);
            }
            if (!CidrCatchOutputToGeneralTestEventsConverter.GROUP_TAG.equals(qName)) {
                if (CidrCatchOutputToGeneralTestEventsConverter.TEST_CASE_TAG.equals(qName) || CidrCatchOutputToGeneralTestEventsConverter.SECTION_TAG.equals(qName)) {
                    this.endTest(processor, true);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.INFO_TAG.equals(qName)) {
                    this.addInfo(this.myText.toString());
                } else if (CidrCatchOutputToGeneralTestEventsConverter.ORIGINAL_TAG.equals(qName)) {
                    this.outMessage(processor, CidrCatchOutputToGeneralTestEventsConverter.OUT_INDENT + StringUtil.notNullize((String)this.myExpressionPrefix) + "(" + this.myText.toString().trim() + ")", false);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.EXPRESSION_TAG.equals(qName)) {
                    this.myExpressionPrefix = null;
                    this.myInErrorExpression = false;
                } else if (CidrCatchOutputToGeneralTestEventsConverter.EXCEPTION_TAG.equals(qName)) {
                    this.outMessageWithInfoHeader(processor, "due to unexpected exception with message:", false);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.WARNING_TAG.equals(qName)) {
                    this.outMessageWithInfoHeader(processor, "\nwarning:", true);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.EXPANDED_TAG.equals(qName)) {
                    StringBuilder message = new StringBuilder();
                    String expansion = this.myText.toString().trim();
                    if (expansion.length() != 0) {
                        message.append("\nwith expansion:\n").append(CidrCatchOutputToGeneralTestEventsConverter.OUT_INDENT).append(expansion);
                    }
                    if (this.myInfoMessageWithNewLineAndIndent.length() != 0) {
                        message.append("\nwith message:").append((CharSequence)this.myInfoMessageWithNewLineAndIndent);
                        this.myInfoMessageWithNewLineAndIndent.setLength(0);
                    }
                    message.append('\n');
                    this.outMessage(processor, message.toString(), false);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.FAILURE_TAG.equals(qName)) {
                    this.outMessageWithInfoHeader(processor, "explicitly with messages:", false);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.STDOUT_TAG.equals(qName) || CidrCatchOutputToGeneralTestEventsConverter.STDERR_TAG.equals(qName)) {
                    this.outMessage(processor, this.myText.toString().trim() + "\n", CidrCatchOutputToGeneralTestEventsConverter.STDOUT_TAG.equals(qName));
                }
            }
        }

        private void addInfo(@NotNull String text) {
            if (text == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(0);
            }
            this.myInfoMessageWithNewLineAndIndent.append("\n").append(CidrCatchOutputToGeneralTestEventsConverter.OUT_INDENT).append(text.trim());
        }

        private void outMessageWithInfoHeader(GeneralTestEventsProcessor processor, String header, boolean std) {
            this.addInfo(this.myText.toString());
            String message = header + this.myInfoMessageWithNewLineAndIndent + "\n";
            this.myInfoMessageWithNewLineAndIndent.setLength(0);
            this.outMessage(processor, message, std);
        }

        private void outMessage(GeneralTestEventsProcessor processor, String message, boolean toStd) {
            String testName = this.getCurrentNodeName();
            String nodeId = this.getCurrentNodeId();
            CidrCatchOutputToGeneralTestEventsConverter.this.process(toStd ? CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testStdOut(testName, nodeId, message) : CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testErrOut(testName, nodeId, message));
        }

        private void reportError(@NotNull GeneralTestEventsProcessor processor, @NotNull Attributes attributes, @NotNull String message) {
            if (processor == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(2);
            }
            if (message == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(3);
            }
            assert (processor instanceof GeneralIdBasedToSMTRunnerEventsConvertor);
            String file = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.FILE_NAME_ATTR);
            String line = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.LINE_ATTR);
            String prefix = file == null || line == null ? "Failure:" : String.format("%s:%s: Failure:", file, line);
            ((GeneralIdBasedToSMTRunnerEventsConvertor)processor).onError(this.getCurrentNodeId(), "", prefix + message, false);
        }

        public void startTest(@NotNull GeneralTestEventsProcessor processor, @NotNull String testName, @Nullable String testLineLocation, boolean runState) {
            if (processor == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(4);
            }
            if (testName == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(5);
            }
            String parentId = this.getCurrentNodeId();
            this.myTestNameStack.push((Object)testName);
            String nodeId = this.getCurrentNodeId();
            if (this.mySectionsEndIdStack.size() != 0) {
                if (nodeId.equals(this.mySectionsEndIdStack.peek())) {
                    this.mySectionsEndIdStack.pop();
                    return;
                }
                this.closeAllOpenSections(processor);
            }
            String location = this.getLocationFromId();
            String metainfo = CidrMetaParam.serialize((Pair[])new Pair[]{Pair.pair((Object)"target", (Object)CidrCatchOutputToGeneralTestEventsConverter.this.myTargetName), Pair.pair((Object)CidrCatchOutputToGeneralTestEventsConverter.LINE_ATTR, (Object)testLineLocation)});
            if (runState) {
                CidrCatchOutputToGeneralTestEventsConverter.this.process(CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testStarted(testName, parentId, nodeId, location, metainfo));
            } else {
                processor.onSuiteTreeNodeAdded(false, testName, "catch://" + location, metainfo, nodeId, parentId);
            }
        }

        public void endTest(GeneralTestEventsProcessor processor, boolean runState) {
            String nodeId = this.getCurrentNodeId();
            String testName = (String)this.myTestNameStack.pop();
            TestEnd end = this.myTestResults.get(nodeId);
            if (end == null) {
                this.myTestResults.put(nodeId, new TestEnd(testName, nodeId, this.myDuration, this.mySuccess, runState));
            } else {
                end.update(this.myDuration, this.mySuccess);
            }
            this.mySectionsEndIdStack.push((Object)nodeId);
            String parentId = this.getCurrentNodeId();
            if (ROOT_NODE_ID.equals(parentId) && this.mySectionsEndIdStack.size() != 0) {
                this.closeAllOpenSections(processor);
            }
        }

        private void closeAllOpenSections(GeneralTestEventsProcessor processor) {
            this.mySectionsEndIdStack.forEach(endNodeId -> {
                TestEnd end = this.myTestResults.get(endNodeId);
                assert (end != null);
                end.processEnd(processor);
                this.myTestResults.remove(endNodeId);
            });
            this.mySectionsEndIdStack.clear();
        }

        @NotNull
        private String getLocationFromId() {
            String nodeId = this.getCurrentNodeId();
            String string = nodeId.equals(ROOT_NODE_ID) ? "" : nodeId.substring(ROOT_NODE_ID.length());
            if (string == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(6);
            }
            return string;
        }

        private String getCurrentNodeName() {
            return (String)this.myTestNameStack.peek();
        }

        @NotNull
        private String getCurrentNodeId() {
            StringBuilder path = new StringBuilder();
            path.append(ROOT_NODE_ID);
            this.myTestNameStack.forEach(testName -> path.append('[').append(CidrCatchTestLinker.prepareTestPathForPattern(testName)).append(']'));
            String string = path.toString();
            if (string == null) {
                CatchXMLOutputHandler.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter$CatchXMLOutputHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter$CatchXMLOutputHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocationFromId";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentNodeId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addInfo";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "reportError";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "startTest";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        class TestEnd {
            final String testName;
            final String nodeId;
            int durationInMs;
            boolean success;
            boolean runState;

            @Contract(pure=true)
            TestEnd(@NotNull String testName, String nodeId, int durationInMs, boolean success, boolean runState) {
                if (testName == null) {
                    TestEnd.$$$reportNull$$$0(0);
                }
                if (nodeId == null) {
                    TestEnd.$$$reportNull$$$0(1);
                }
                this.testName = testName;
                this.nodeId = nodeId;
                this.durationInMs = durationInMs;
                this.success = success;
                this.runState = runState;
            }

            void update(int durationInMs, boolean success) {
                this.durationInMs += durationInMs;
                this.success &= success;
            }

            void processEnd(GeneralTestEventsProcessor processor) {
                if (this.runState) {
                    CidrCatchOutputToGeneralTestEventsConverter.this.process(CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testFinished(this.testName, this.nodeId, Integer.toString(this.durationInMs), this.success));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "nodeId";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter$CatchXMLOutputHandler$TestEnd";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

