/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CidrCatchTestLinker {
    List<String> myEscapedPathParts;
    @NonNls
    private static final String SECTION_RUN_START = "section-run(";
    @NonNls
    private static final String SECTION_RUN_END = ")";
    @NonNls
    public static final String PARAM_SEPARATOR = " - ";
    @NonNls
    public static final String TEMPLATE_TEXT_SUFFIX = " - *";
    @NonNls
    private static final String[][][] PREFIX_DECODERS = new String[][][]{{{"Given: ", "   Given: "}, {"When: ", "    When: "}, {"Then: ", "    Then: "}, {"And: ", "     And: "}}, {{"Given: ", "    Given: "}, {"When: ", "     When: "}, {"And when: ", " And when: "}, {"Then: ", "     Then: "}, {"And: ", "      And: "}}, new String[0][]};

    @Contract(pure=true)
    private CidrCatchTestLinker() {
    }

    @NotNull
    public String getPatternForCommandLine() {
        if (this.myEscapedPathParts.size() == 1) {
            String string = this.myEscapedPathParts.get(0);
            if (string == null) {
                CidrCatchTestLinker.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = "section-run([" + StringUtil.join(this.myEscapedPathParts, (String)"][") + "])";
        if (string == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void addCommandLineParams(@NotNull GeneralCommandLine cl, @NotNull String patternForCommandLine) {
        List<String> escapedTestOrSectionNames;
        if (cl == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(2);
        }
        if (patternForCommandLine == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(3);
        }
        if ((escapedTestOrSectionNames = CidrCatchTestLinker.splitPattern(patternForCommandLine)).size() > 0) {
            cl.addParameter(escapedTestOrSectionNames.get(0));
        }
        for (int i = 1; i < escapedTestOrSectionNames.size(); ++i) {
            cl.addParameter("-c");
            Object sectionName = StringUtil.unescapeStringCharacters((String)escapedTestOrSectionNames.get(i));
            for (String[] start2wrap : PREFIX_DECODERS[CidrCatchTestUtil.getInternalCatchVersion()]) {
                if (!((String)sectionName).startsWith(start2wrap[0])) continue;
                sectionName = start2wrap[1] + ((String)sectionName).substring(start2wrap[0].length());
                break;
            }
            cl.addParameter((String)sectionName);
        }
    }

    public static List<String> splitPattern(@NotNull String patternForCommandLine) {
        if (patternForCommandLine == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(4);
        }
        if (CidrCatchTestLinker.isSectionPattern(patternForCommandLine)) {
            return CidrCatchTestLinker.splitLocationPathToEscapedParts(patternForCommandLine.substring(SECTION_RUN_START.length(), patternForCommandLine.length() - SECTION_RUN_END.length()));
        }
        return Collections.singletonList(patternForCommandLine);
    }

    @NotNull
    public String getFindPath() {
        String string = StringUtil.unescapeStringCharacters((String)this.myEscapedPathParts.get(0));
        if (string == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String convertTemplateTestName(@NotNull String testWithParam) {
        int paramStart;
        if (testWithParam == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(6);
        }
        Object object = (paramStart = testWithParam.lastIndexOf(PARAM_SEPARATOR)) >= 0 ? testWithParam.substring(0, paramStart) + TEMPLATE_TEXT_SUFFIX : testWithParam;
        if (object == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(7);
        }
        return object;
    }

    @NotNull
    public String getConfigurationName() {
        String string = StringUtil.unescapeStringCharacters((String)this.myEscapedPathParts.get(this.myEscapedPathParts.size() - 1));
        if (string == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static CidrCatchTestLinker create(@NotNull String locationTestPath) {
        if (locationTestPath == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(9);
        }
        CidrCatchTestLinker linker = new CidrCatchTestLinker();
        linker.myEscapedPathParts = CidrCatchTestLinker.splitLocationPathToEscapedParts(locationTestPath.trim());
        CidrCatchTestLinker cidrCatchTestLinker = linker;
        if (cidrCatchTestLinker == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(10);
        }
        return cidrCatchTestLinker;
    }

    @NotNull
    private static List<String> splitLocationPathToEscapedParts(@NotNull String locationTestPath) {
        if (locationTestPath == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(11);
        }
        if (CidrCatchTestLinker.isWrapped(locationTestPath)) {
            List<String> list = Arrays.asList(locationTestPath.substring(1, locationTestPath.length() - 1).split("(?<!\\\\)]\\["));
            if (list == null) {
                CidrCatchTestLinker.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<String> list = Collections.singletonList(CidrCatchTestLinker.prepareTestPathForPattern(locationTestPath));
        if (list == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static String getLocationWrapperIfNeed(@NotNull String testPath) {
        if (testPath == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(14);
        }
        if (CidrCatchTestLinker.isWrapped(testPath)) {
            String string = testPath;
            if (string == null) {
                CidrCatchTestLinker.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = "[" + CidrCatchTestLinker.prepareTestPathForPattern(testPath) + "]";
        if (string == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String prepareTestPathForPattern(@NotNull String testNameOrLocationPath) {
        if (testNameOrLocationPath == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(17);
        }
        if (CidrCatchTestLinker.isSectionPattern(testNameOrLocationPath)) {
            String string = testNameOrLocationPath;
            if (string == null) {
                CidrCatchTestLinker.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = StringUtil.escapeChars((String)testNameOrLocationPath, (char[])new char[]{'\\', ',', '[', ']'});
        if (string == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static boolean isSectionPattern(@NotNull String patternForCommandLine) {
        if (patternForCommandLine == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(20);
        }
        return patternForCommandLine.startsWith(SECTION_RUN_START) && patternForCommandLine.endsWith(SECTION_RUN_END);
    }

    private static boolean isWrapped(@NotNull String locationTestPath) {
        if (locationTestPath == null) {
            CidrCatchTestLinker.$$$reportNull$$$0(21);
        }
        return locationTestPath.startsWith("[") && locationTestPath.endsWith("]");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 3: 
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternForCommandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testWithParam";
                break;
            }
            case 9: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationTestPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNameOrLocationPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternForCommandLine";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestLinker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTemplateTestName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "splitLocationPathToEscapedParts";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationWrapperIfNeed";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTestPathForPattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCommandLineParams";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitPattern";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertTemplateTestName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "splitLocationPathToEscapedParts";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocationWrapperIfNeed";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestPathForPattern";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSectionPattern";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isWrapped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

