/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import com.intellij.util.xml.NanoXmlUtil;
import icons.XpathIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XsltSupport {
    private static final String XALAN_EXTENSION_PREFIX = "http://xml.apache.org/xalan/";
    public static final String XSLT_NS = "http://www.w3.org/1999/XSL/Transform";
    public static final String PLUGIN_EXTENSIONS_NS = "urn:idea:xslt-plugin#extensions";
    private static final Key<ParameterizedCachedValue<XsltChecker.LanguageLevel, PsiFile>> FORCE_XSLT_KEY = Key.create((String)"FORCE_XSLT");
    public static final TextAttributesKey XSLT_DIRECTIVE = TextAttributesKey.createTextAttributesKey((String)"XSLT_DIRECTIVE", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
    private static final Map<String, String> XPATH_ATTR_MAP = new HashMap<String, String>(10);
    private static final Map<String, Set<String>> XPATH_AVT_MAP = new HashMap<String, Set<String>>(10);

    private XsltSupport() {
    }

    public static PsiFile @NotNull [] getFiles(XmlAttribute attribute) {
        XmlAttributeValue value = attribute.getValueElement();
        if (value != null) {
            SmartList files = new SmartList();
            InjectedLanguageManager.getInstance((Project)value.getProject()).enumerate((PsiElement)value, (arg_0, arg_1) -> XsltSupport.lambda$getFiles$0((List)files, arg_0, arg_1));
            PsiFile[] psiFileArray = files.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray((Collection)files);
            if (psiFileArray == null) {
                XsltSupport.$$$reportNull$$$0(0);
            }
            return psiFileArray;
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            XsltSupport.$$$reportNull$$$0(1);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    public static boolean isXsltAttribute(@NotNull XmlAttribute attribute) {
        XmlTag parent;
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(2);
        }
        return (parent = attribute.getParent()) != null && XsltSupport.isXsltTag(parent);
    }

    public static boolean isXsltTag(@NotNull XmlTag tag) {
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(3);
        }
        if (!tag.isValid()) {
            return false;
        }
        String s = tag.getNamespace();
        return XSLT_NS.equals(s) || s.startsWith(XALAN_EXTENSION_PREFIX);
    }

    private static boolean isXsltCoreTag(@NotNull XmlTag tag) {
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(4);
        }
        return tag.isValid() && XSLT_NS.equals(tag.getNamespace());
    }

    public static boolean isXPathAttribute(@NotNull XmlAttribute attribute) {
        XsltChecker.LanguageLevel level;
        PsiFile file;
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(5);
        }
        if (attribute.getValueElement() == null) {
            return false;
        }
        String name = attribute.getName();
        if (XsltSupport.isXsltAttribute(attribute)) {
            String tagName = attribute.getParent().getLocalName();
            String s = XPATH_ATTR_MAP.get(name);
            if (!(s != null && s.length() <= 0 || tagName.equals(s) || XsltSupport.isAttributeValueTemplate(attribute, true))) {
                return false;
            }
        } else if (!XsltSupport.isAttributeValueTemplate(attribute, false)) {
            return false;
        }
        return (file = attribute.getContainingFile()) != null && (level = XsltSupport.getXsltLanguageLevel(file)) != XsltChecker.LanguageLevel.NONE;
    }

    private static boolean isAttributeValueTemplate(@NotNull XmlAttribute attribute, boolean isXsltAttribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(6);
        }
        return (!isXsltAttribute || XsltSupport.mayBeAVT(attribute)) && XsltSupport.getAVTOffset(attribute.getValue(), 0) != -1;
    }

    public static boolean isVariableOrParamName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(7);
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isVariableOrParam(attribute.getParent());
    }

    public static boolean isVariableOrParam(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(8);
        }
        return ("variable".equals(localName = tag.getLocalName()) || "param".equals(localName)) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isVariable(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(9);
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isVariable(attribute.getParent());
    }

    public static boolean isVariable(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(10);
        }
        return "variable".equals(localName = tag.getLocalName()) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isParam(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(11);
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isParam(attribute.getParent());
    }

    public static boolean isParam(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(12);
        }
        return "param".equals(localName = tag.getLocalName()) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isPatternAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(13);
        }
        if (!XsltSupport.isXsltAttribute(attribute)) {
            return false;
        }
        String name = attribute.getName();
        if ("match".equals(name)) {
            return true;
        }
        if ("count".equals(name) || "from".equals(name)) {
            return "number".equals(attribute.getParent().getLocalName());
        }
        return false;
    }

    public static boolean isTemplateCall(@NotNull XmlTag tag) {
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(14);
        }
        return "call-template".equals(tag.getLocalName()) && XsltSupport.hasNameAttribute(tag) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isFunction(@NotNull XmlTag tag) {
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(15);
        }
        return "function".equals(tag.getLocalName()) && XsltSupport.hasNameAttribute(tag) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isApplyTemplates(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(16);
        }
        return "apply-templates".equals(localName = tag.getLocalName()) && XsltSupport.isXsltCoreTag(tag);
    }

    private static boolean hasNameAttribute(@NotNull XmlTag tag) {
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(17);
        }
        return tag.getAttribute("name", null) != null;
    }

    public static boolean isTemplateCallName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(18);
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isTemplateCall(attribute.getParent());
    }

    private static boolean isXsltNameAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(19);
        }
        return "name".equals(attribute.getName()) && XsltSupport.isXsltAttribute(attribute);
    }

    public static boolean isTemplateName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(20);
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isTemplate(attribute.getParent());
    }

    public static boolean isFunctionName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(21);
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isFunction(attribute.getParent());
    }

    public static boolean isTemplate(@NotNull XmlTag element) {
        if (element == null) {
            XsltSupport.$$$reportNull$$$0(22);
        }
        return XsltSupport.isTemplate(element, true);
    }

    public static boolean isTemplate(@NotNull XmlTag element, boolean requireName) {
        if (element == null) {
            XsltSupport.$$$reportNull$$$0(23);
        }
        return "template".equals(element.getLocalName()) && (!requireName || XsltSupport.hasNameAttribute(element)) && XsltSupport.isXsltCoreTag(element);
    }

    public static boolean isXsltFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            XsltSupport.$$$reportNull$$$0(24);
        }
        if (psiFile.getFileType() != XmlFileType.INSTANCE) {
            return false;
        }
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        XsltChecker.LanguageLevel level = XsltSupport.getXsltLanguageLevel(psiFile);
        return level != XsltChecker.LanguageLevel.NONE;
    }

    public static XsltChecker.LanguageLevel getXsltLanguageLevel(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            XsltSupport.$$$reportNull$$$0(25);
        }
        CachedValuesManager mgr = CachedValuesManager.getManager((Project)psiFile.getProject());
        return (XsltChecker.LanguageLevel)((Object)mgr.getParameterizedCachedValue((UserDataHolder)psiFile, FORCE_XSLT_KEY, XsltSupportProvider.INSTANCE, false, (Object)psiFile));
    }

    public static boolean isXsltRootTag(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            XsltSupport.$$$reportNull$$$0(26);
        }
        return ("stylesheet".equals(localName = tag.getLocalName()) || "transform".equals(localName)) && XsltSupport.isXsltCoreTag(tag);
    }

    public static boolean isTemplateCallParamName(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(27);
        }
        return XsltSupport.isXsltNameAttribute(attribute) && XsltSupport.isTemplateCallParam(attribute.getParent());
    }

    private static boolean isTemplateCallParam(@NotNull XmlTag parent) {
        if (parent == null) {
            XsltSupport.$$$reportNull$$$0(28);
        }
        return "with-param".equals(parent.getLocalName()) && XsltSupport.hasNameAttribute(parent) && XsltSupport.isXsltCoreTag(parent);
    }

    public static boolean isTopLevelElement(XmlTag tag) {
        XmlTag p = tag;
        while ((p = p.getParentTag()) != null) {
            if (!XsltSupport.isXsltTag(p)) continue;
            return XsltSupport.isXsltRootTag(p);
        }
        return false;
    }

    public static boolean isIncludeOrImportHref(XmlAttribute xmlattribute) {
        if (xmlattribute == null || !XsltSupport.isXsltAttribute(xmlattribute)) {
            return false;
        }
        String localName = xmlattribute.getParent().getLocalName();
        return XsltSupport.isIncludeOrImport(localName) && "href".equals(xmlattribute.getName());
    }

    private static boolean isIncludeOrImport(String localName) {
        return "import".equals(localName) || "include".equals(localName);
    }

    public static boolean isIncludeOrImport(XmlTag tag) {
        if (tag == null) {
            return false;
        }
        return XsltSupport.isIncludeOrImport(tag.getLocalName()) && XsltSupport.isXsltCoreTag(tag) && tag.getAttribute("href", null) != null;
    }

    public static boolean isImport(XmlTag tag) {
        if (tag == null) {
            return false;
        }
        return "import".equals(tag.getLocalName()) && XsltSupport.isXsltCoreTag(tag) && tag.getAttribute("href", null) != null;
    }

    @Nullable
    public static PsiElement getAttValueToken(@NotNull XmlAttribute attribute) {
        PsiElement firstChild;
        XmlAttributeValue valueElement;
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(29);
        }
        if ((valueElement = attribute.getValueElement()) != null && (firstChild = valueElement.getFirstChild()) != null) {
            PsiElement nextSibling = firstChild.getNextSibling();
            return nextSibling instanceof XmlToken && ((XmlToken)nextSibling).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN ? nextSibling : null;
        }
        return null;
    }

    public static boolean isMode(XmlAttribute xmlattribute) {
        if ("mode".equals(xmlattribute.getName())) {
            XmlTag parent = xmlattribute.getParent();
            return XsltSupport.isApplyTemplates(parent) || XsltSupport.isTemplate(parent, false);
        }
        return false;
    }

    public static int getAVTOffset(String value, int i) {
        while ((i = value.indexOf(123, i)) != -1 && i == value.indexOf("{{", i) && (i += 2) != -1) {
        }
        return i;
    }

    public static boolean mayBeAVT(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XsltSupport.$$$reportNull$$$0(30);
        }
        if (XsltSupport.isXsltAttribute(attribute)) {
            String tagName = attribute.getParent().getLocalName();
            Set<String> allowedAttrs = XPATH_AVT_MAP.get(tagName);
            if (allowedAttrs == null) {
                return XsltSupport.isExtensionAvtAttribute(attribute);
            }
            return allowedAttrs.contains(attribute.getName());
        }
        return true;
    }

    private static boolean isExtensionAvtAttribute(XmlAttribute attribute) {
        String namespace = attribute.getParent().getNamespace();
        return namespace.startsWith(XALAN_EXTENSION_PREFIX) && "file".equals(attribute.getName());
    }

    public static Icon createXsltIcon(Icon icon) {
        return XpathIcons.XsltFiletypeOverlay;
    }

    private static /* synthetic */ void lambda$getFiles$0(List files, PsiFile injectedPsi, List places) {
        if (injectedPsi instanceof XPathFile) {
            files.add(injectedPsi);
        }
    }

    static {
        XPATH_ATTR_MAP.put("select", "");
        XPATH_ATTR_MAP.put("match", "");
        XPATH_ATTR_MAP.put("test", "");
        XPATH_ATTR_MAP.put("use-when", "");
        XPATH_ATTR_MAP.put("group-by", "");
        XPATH_ATTR_MAP.put("group-adjacent", "");
        XPATH_ATTR_MAP.put("count", "number");
        XPATH_ATTR_MAP.put("from", "number");
        XPATH_ATTR_MAP.put("value", "number");
        XPATH_ATTR_MAP.put("use", "key");
        XPATH_AVT_MAP.put("element", Set.of("name", "namespace"));
        XPATH_AVT_MAP.put("attribute", Set.of("name", "namespace"));
        XPATH_AVT_MAP.put("namespace", Set.of("name"));
        XPATH_AVT_MAP.put("processing-instruction", Set.of("name"));
        XPATH_AVT_MAP.put("number", Set.of("format", "lang", "letter-value", "grouping-separator", "grouping-size", "ordinal"));
        XPATH_AVT_MAP.put("sort", Set.of("lang", "data-type", "order", "case-order", "collation"));
        XPATH_AVT_MAP.put("message", Set.of("terminate"));
        XPATH_AVT_MAP.put("value-of", Set.of("separator"));
        XPATH_AVT_MAP.put("result-document", Set.of("format", "href", "method", "byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "include-content-type", "indent", "media-type", "normalization-form", "omit-xml-declaration", "standalone", "undeclare-prefixes", "output-version"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/XsltSupport";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/XsltSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isXsltAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isXsltTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isXsltCoreTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isXPathAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAttributeValueTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVariableOrParamName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isVariableOrParam";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isVariable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isParam";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPatternAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateCall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isFunction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isApplyTemplates";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasNameAttribute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateCallName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isXsltNameAttribute";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTemplate";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isXsltFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getXsltLanguageLevel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isXsltRootTag";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateCallParamName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateCallParam";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAttValueToken";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "mayBeAVT";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XsltSupportProvider
    implements ParameterizedCachedValueProvider<XsltChecker.LanguageLevel, PsiFile> {
        public static final ParameterizedCachedValueProvider<XsltChecker.LanguageLevel, PsiFile> INSTANCE = new XsltSupportProvider();

        private XsltSupportProvider() {
        }

        public CachedValueProvider.Result<XsltChecker.LanguageLevel> compute(PsiFile psiFile) {
            XmlTag rootTag;
            XmlDocument doc;
            if (!(psiFile instanceof XmlFile)) {
                return CachedValueProvider.Result.create((Object)((Object)XsltChecker.LanguageLevel.NONE), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            XmlFile xmlFile = (XmlFile)psiFile;
            if (psiFile instanceof PsiFileEx && ((PsiFileEx)psiFile).isContentsLoaded() && (doc = xmlFile.getDocument()) != null && (rootTag = doc.getRootTag()) != null) {
                XmlAttribute v;
                XsltChecker.LanguageLevel level = XsltSupport.isXsltRootTag(rootTag) ? ((v = rootTag.getAttribute("version")) != null ? XsltChecker.getLanguageLevel(v.getValue()) : XsltChecker.LanguageLevel.NONE) : ((v = rootTag.getAttribute("version", XsltSupport.XSLT_NS)) != null ? XsltChecker.getLanguageLevel(v.getValue()) : XsltChecker.LanguageLevel.NONE);
                return CachedValueProvider.Result.create((Object)((Object)level), (Object[])new Object[]{rootTag});
            }
            XsltChecker xsltChecker = new XsltChecker();
            NanoXmlUtil.parseFile((PsiFile)psiFile, (IXMLBuilder)xsltChecker);
            return CachedValueProvider.Result.create((Object)((Object)xsltChecker.getLanguageLevel()), (Object[])new Object[]{psiFile});
        }
    }
}

