/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.git.AddLoadedFile;
import org.jetbrains.settingsRepository.git.DeleteDirectory;
import org.jetbrains.settingsRepository.git.DeleteFile;
import org.jetbrains.settingsRepository.git.DirCacheEditor;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.DirCacheTerminator;
import org.jetbrains.settingsRepository.git.PathEdit;
import org.jetbrains.settingsRepository.git.PathEditBase;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a&\u0010\u0010\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0012\u001a\u00020\n*\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014\u001a\u0012\u0010\u0012\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0002\u001a$\u0010\u0015\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"EDIT_CMP", "Ljava/util/Comparator;", "Lorg/jetbrains/settingsRepository/git/PathEdit;", "DeleteFile", "Lorg/jetbrains/settingsRepository/git/DeleteFile;", "path", "", "encodePath", "", "deleteAllFiles", "", "Lorg/eclipse/jgit/lib/Repository;", "deletedSet", "", "fromWorkingTree", "", "deletePath", "isFile", "edit", "edits", "", "writePath", "bytes", "size", "", "intellij.settingsRepository"})
public final class DirCacheEditorKt {
    private static final Comparator<PathEdit> EDIT_CMP = EDIT_CMP.1.INSTANCE;

    /*
     * WARNING - void declaration
     */
    private static final byte[] encodePath(String path) {
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(path);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"Charsets.UTF_8.encode(path)");
        byte[] bytes = IoKt.toByteArray$default((ByteBuffer)byteBuffer, (boolean)false, (int)1, null);
        if (SystemInfo.isWindows) {
            int n = 0;
            int n2 = bytes.length;
            while (n < n2) {
                void i;
                if ((char)bytes[i] == '\\') {
                    bytes[i] = (byte)47;
                }
                ++i;
            }
        }
        return bytes;
    }

    @NotNull
    public static final DeleteFile DeleteFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new DeleteFile(DirCacheEditorKt.encodePath(path));
    }

    public static final void edit(@NotNull Repository $this$edit, @NotNull PathEdit edit2) {
        Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"$this$edit");
        Intrinsics.checkNotNullParameter((Object)edit2, (String)"edit");
        DirCacheEditorKt.edit($this$edit, CollectionsKt.listOf((Object)edit2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void edit(@NotNull Repository $this$edit, @NotNull List<? extends PathEdit> edits) {
        Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"$this$edit");
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        if (edits.isEmpty()) {
            return;
        }
        DirCache dirCache = $this$edit.lockDirCache();
        try {
            DirCache dirCache2 = dirCache;
            Intrinsics.checkNotNullExpressionValue((Object)dirCache2, (String)"dirCache");
            new DirCacheEditor(edits, $this$edit, dirCache2, dirCache.getEntryCount() + 4).commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void deleteAllFiles(@NotNull Repository $this$deleteAllFiles, @Nullable Set<String> deletedSet, boolean fromWorkingTree) {
        File[] files2;
        Intrinsics.checkNotNullParameter((Object)$this$deleteAllFiles, (String)"$this$deleteAllFiles");
        DirCache dirCache = $this$deleteAllFiles.lockDirCache();
        try {
            if (deletedSet != null) {
                int n = 0;
                DirCache dirCache2 = dirCache;
                Intrinsics.checkNotNullExpressionValue((Object)dirCache2, (String)"dirCache");
                int n2 = dirCache2.getEntryCount();
                while (n < n2) {
                    void i;
                    DirCacheEntry entry;
                    DirCacheEntry dirCacheEntry = entry = dirCache.getEntry((int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)dirCacheEntry, (String)"entry");
                    if (Intrinsics.areEqual((Object)dirCacheEntry.getFileMode(), (Object)FileMode.REGULAR_FILE)) {
                        String string = entry.getPathString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.pathString");
                        deletedSet.add(string);
                    }
                    ++i;
                }
            }
            DirCache dirCache3 = dirCache;
            Intrinsics.checkNotNullExpressionValue((Object)dirCache3, (String)"dirCache");
            new DirCacheTerminator(dirCache3).commit();
        }
        finally {
            dirCache.unlock();
        }
        if (fromWorkingTree && (files2 = $this$deleteAllFiles.getWorkTree().listFiles(deleteAllFiles.files.1.INSTANCE)) != null) {
            for (File file : files2) {
                FileUtil.delete((File)file);
            }
        }
    }

    public static /* synthetic */ void deleteAllFiles$default(Repository repository2, Set set, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        DirCacheEditorKt.deleteAllFiles(repository2, set, bl);
    }

    public static final void writePath(@NotNull Repository $this$writePath, @NotNull String path, @NotNull byte[] bytes, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$writePath, (String)"$this$writePath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        DirCacheEditorKt.edit($this$writePath, new AddLoadedFile(path, bytes, size, 0L, 8, null));
        FileUtil.writeToFile((File)new File($this$writePath.getWorkTree(), path), (byte[])bytes, (int)0, (int)size);
    }

    public static /* synthetic */ void writePath$default(Repository repository2, String string, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        DirCacheEditorKt.writePath(repository2, string, byArray, n);
    }

    public static final void deletePath(@NotNull Repository $this$deletePath, @NotNull String path, boolean isFile, boolean fromWorkingTree) {
        Intrinsics.checkNotNullParameter((Object)$this$deletePath, (String)"$this$deletePath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirCacheEditorKt.edit($this$deletePath, isFile ? (PathEditBase)DirCacheEditorKt.DeleteFile(path) : (PathEditBase)new DeleteDirectory(path));
        if (fromWorkingTree) {
            Path ioFile;
            Path workTree = $this$deletePath.getWorkTree().toPath();
            Path path2 = ioFile = workTree.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"ioFile");
            if (PathKt.exists((Path)path2)) {
                Path path3 = workTree;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"workTree");
                PathKt.deleteWithParentsIfEmpty((Path)ioFile, (Path)path3, (boolean)isFile);
            }
        }
    }

    public static /* synthetic */ void deletePath$default(Repository repository2, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        DirCacheEditorKt.deletePath(repository2, string, bl, bl2);
    }

    public static final /* synthetic */ Comparator access$getEDIT_CMP$p() {
        return EDIT_CMP;
    }

    public static final /* synthetic */ byte[] access$encodePath(String path) {
        return DirCacheEditorKt.encodePath(path);
    }
}

