/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.internal.statistic.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/actions/EventsSchemeConfigurationModel;", "", "()V", "currentSettings", "Lcom/intellij/internal/statistic/actions/EventsSchemeConfigurationModel$EventsSchemePathSettings;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "recorderComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "recorderToSettings", "", "getRecorderToSettings", "()Ljava/util/Map;", "useCustomPathCheckBox", "Ljavax/swing/JCheckBox;", "reset", "recorderId", "updatePanel", "", "updatePathField", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "validatePath", "settings", "EventsSchemePathSettings", "intellij.platform.statistics.devkit"})
public final class EventsSchemeConfigurationModel {
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final Map<String, EventsSchemePathSettings> recorderToSettings;
    private final ComboBox<String> recorderComboBox;
    private final TextFieldWithBrowseButton pathField;
    private final JCheckBox useCustomPathCheckBox;
    private EventsSchemePathSettings currentSettings;

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final Map<String, EventsSchemePathSettings> getRecorderToSettings() {
        return this.recorderToSettings;
    }

    private final void updatePathField() {
        boolean useCustomPath = this.useCustomPathCheckBox.isSelected();
        EventsSchemePathSettings settings2 = this.currentSettings;
        if (settings2 == null) {
            return;
        }
        this.pathField.setEditable(useCustomPath);
        this.pathField.setEnabled(useCustomPath);
        this.pathField.setText(settings2.getCurrentPath());
    }

    private final void updatePanel() {
        EventsSchemePathSettings settings2;
        Object object = this.recorderComboBox.getSelectedItem();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String recorderId = (String)object;
        EventsSchemePathSettings eventsSchemePathSettings = this.recorderToSettings.computeIfAbsent(recorderId, new Function(recorderId){
            final /* synthetic */ String $recorderId;

            @NotNull
            public final EventsSchemePathSettings apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new EventsSchemePathSettings(this.$recorderId);
            }
            {
                this.$recorderId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)eventsSchemePathSettings, (String)"recorderToSettings.compu\u2026athSettings(recorderId) }");
        this.currentSettings = settings2 = eventsSchemePathSettings;
        this.useCustomPathCheckBox.setSelected(settings2.getUseCustomPath());
        this.updatePathField();
    }

    @NotNull
    public final EventsSchemeConfigurationModel reset(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.recorderComboBox.setSelectedItem((Object)recorderId);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ValidationInfo validate() {
        EventsSchemePathSettings eventsSchemePathSettings = this.currentSettings;
        if (eventsSchemePathSettings == null) {
            return null;
        }
        EventsSchemePathSettings currentPathSettings = eventsSchemePathSettings;
        ValidationInfo currentValidationInfo = this.validatePath(currentPathSettings);
        if (currentValidationInfo != null) {
            return currentValidationInfo;
        }
        Object object = this.recorderToSettings;
        boolean bl = false;
        Iterator<Map.Entry<String, EventsSchemePathSettings>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void recorder;
            ValidationInfo validationInfo;
            Map.Entry<String, EventsSchemePathSettings> entry;
            Map.Entry<String, EventsSchemePathSettings> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            EventsSchemePathSettings settings2 = entry2.getValue();
            if (Intrinsics.areEqual((Object)settings2, (Object)this.currentSettings) || (validationInfo = this.validatePath(settings2)) == null) continue;
            this.recorderComboBox.setSelectedItem((Object)recorder);
            this.updatePanel();
            return validationInfo;
        }
        return null;
    }

    private final ValidationInfo validatePath(EventsSchemePathSettings settings2) {
        if (!settings2.getUseCustomPath()) {
            return null;
        }
        String customPath = settings2.getCustomPath();
        CharSequence charSequence = customPath;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new ValidationInfo("Specify events scheme path.", (JComponent)this.pathField.getTextField());
        }
        if (!FileUtil.exists((String)customPath)) {
            return new ValidationInfo("File doesn't exist.", (JComponent)this.pathField.getTextField());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public EventsSchemeConfigurationModel() {
        void $this$panel;
        StatisticsEventLoggerProvider provider;
        boolean bl = false;
        this.recorderToSettings = new LinkedHashMap();
        this.recorderComboBox = new ComboBox();
        this.pathField = new TextFieldWithBrowseButton();
        this.useCustomPathCheckBox = new JCheckBox("Use custom path:");
        Iterable $this$forEach$iv = StatisticsDevKitUtil.INSTANCE.getLogProvidersInTestMode();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            provider = (StatisticsEventLoggerProvider)element$iv;
            boolean bl2 = false;
            String recorderId = provider.getRecorderId();
            this.recorderComboBox.addItem((Object)recorderId);
        }
        this.recorderComboBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.updatePanel();
            }
        });
        this.pathField.addBrowseFolderListener("Select Events Scheme Location ", null, null, FileChooserDescriptorFactory.createSingleFileDescriptor());
        JTextField jTextField = this.pathField.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"pathField.textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!useCustomPathCheckBox.isSelected()) break block1;
                    EventsSchemePathSettings eventsSchemePathSettings = currentSettings;
                    if (eventsSchemePathSettings != null) {
                        eventsSchemePathSettings.setCustomPath(pathField.getText());
                    }
                }
            }
        });
        this.useCustomPathCheckBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                EventsSchemePathSettings eventsSchemePathSettings = currentSettings;
                if (eventsSchemePathSettings != null) {
                    eventsSchemePathSettings.setUseCustomPath(useCustomPathCheckBox.isSelected());
                }
                this.updatePathField();
            }
        });
        this.updatePanel();
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder builder$iv = LayoutImplKt.createLayoutBuilder();
        provider = builder$iv;
        EventsSchemeConfigurationModel eventsSchemeConfigurationModel = this;
        boolean bl3 = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ EventsSchemeConfigurationModel this$0;
            {
                this.this$0 = eventsSchemeConfigurationModel;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.label$default((Cell)((Cell)$this$row), (String)"Recorder:", null, null, (boolean)false, (int)14, null);
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)EventsSchemeConfigurationModel.access$getRecorderComboBox$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getGrowX(), $this$row.getPushX()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ EventsSchemeConfigurationModel this$0;
            {
                this.this$0 = eventsSchemeConfigurationModel;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)EventsSchemeConfigurationModel.access$getUseCustomPathCheckBox$p(this.this$0), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)EventsSchemeConfigurationModel.access$getPathField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getGrowX(), $this$row.getPushX()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        Unit unit = Unit.INSTANCE;
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        eventsSchemeConfigurationModel.panel = panel$iv;
    }

    public static final /* synthetic */ void access$setCurrentSettings$p(EventsSchemeConfigurationModel $this, EventsSchemePathSettings eventsSchemePathSettings) {
        $this.currentSettings = eventsSchemePathSettings;
    }

    public static final /* synthetic */ ComboBox access$getRecorderComboBox$p(EventsSchemeConfigurationModel $this) {
        return $this.recorderComboBox;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0004R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/actions/EventsSchemeConfigurationModel$EventsSchemePathSettings;", "", "recorderId", "", "(Ljava/lang/String;)V", "currentPath", "getCurrentPath", "()Ljava/lang/String;", "customPath", "getCustomPath", "setCustomPath", "defaultPath", "useCustomPath", "", "getUseCustomPath", "()Z", "setUseCustomPath", "(Z)V", "intellij.platform.statistics.devkit"})
    public static final class EventsSchemePathSettings {
        private final String defaultPath;
        @Nullable
        private String customPath;
        private boolean useCustomPath;

        @Nullable
        public final String getCustomPath() {
            return this.customPath;
        }

        public final void setCustomPath(@Nullable String string) {
            this.customPath = string;
        }

        public final boolean getUseCustomPath() {
            return this.useCustomPath;
        }

        public final void setUseCustomPath(boolean bl) {
            this.useCustomPath = bl;
        }

        @NotNull
        public final String getCurrentPath() {
            String customEventsSchemePath = this.customPath;
            return this.useCustomPath && customEventsSchemePath != null ? customEventsSchemePath : this.defaultPath;
        }

        public EventsSchemePathSettings(@NotNull String recorderId) {
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            this.defaultPath = ((Object)BaseEventLogMetadataPersistence.getDefaultMetadataFile((String)recorderId, (String)"events-scheme.json", null)).toString();
            com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings pathSettings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(recorderId);
            if (pathSettings != null) {
                this.customPath = pathSettings.getCustomPath();
                this.useCustomPath = pathSettings.isUseCustomPath();
            }
        }
    }
}

