/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.clion.perf.PerfNavigationMap;
import com.intellij.profiler.clion.perf.PerfSourceFileLineData;
import com.intellij.profiler.model.NativeCall;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\u0011\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u00c2\u0003J/\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/clion/perf/NavigatableNativeCall;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "library", "", "methodWithClassOrFunction", "navigationMap", "Lcom/intellij/profiler/clion/perf/PerfNavigationMap;", "navigatableClass", "Ljava/lang/Class;", "Lcom/intellij/psi/NavigatablePsiElement;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/profiler/clion/perf/PerfNavigationMap;Ljava/lang/Class;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "isNavigatable", "", "()Z", "nativeCall", "Lcom/intellij/profiler/model/NativeCall;", "calcNavigatables", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/psi/NavigatablePsiElement;", "component1", "component2", "component3", "copy", "equals", "other", "", "fullName", "getNavigatablePsiElement", "hashCode", "", "toString", "Companion", "intellij.profiler.clion"})
public final class NavigatableNativeCall
extends BaseCallStackElement {
    private final NativeCall nativeCall;
    private PerfNavigationMap navigationMap;
    private final String library;
    private final String methodWithClassOrFunction;
    private final Class<? extends NavigatablePsiElement> navigatableClass;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String fullName() {
        return this.nativeCall.fullName();
    }

    public boolean isNavigatable() {
        return this.navigationMap.hasNavigationData(this.library, this.methodWithClassOrFunction);
    }

    @NotNull
    public NavigatablePsiElement[] calcNavigatables(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NavigatablePsiElement element = this.getNavigatablePsiElement(project);
        if (element == null) {
            return new NavigatablePsiElement[0];
        }
        return new NavigatablePsiElement[]{element};
    }

    private final NavigatablePsiElement getNavigatablePsiElement(Project project) {
        if (!this.isNavigatable()) {
            LOG.warn("Element is not navigatable");
            return null;
        }
        PerfSourceFileLineData perfSourceFileLineData = this.navigationMap.getNavigationData(this.library, this.methodWithClassOrFunction);
        Intrinsics.checkNotNull((Object)perfSourceFileLineData);
        PerfSourceFileLineData sourceFileLineData = perfSourceFileLineData;
        VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(sourceFileLineData.getFilePath(), new String[0]), (boolean)true);
        if (virtualFile == null) {
            LOG.warn("Can't navigate: virtual file is null");
            return null;
        }
        boolean $i$f$runReadAction = false;
        return (NavigatablePsiElement)ApplicationManager.getApplication().runReadAction(new Computable(this, virtualFile, project, sourceFileLineData){
            final /* synthetic */ NavigatableNativeCall this$0;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ PerfSourceFileLineData $sourceFileLineData$inlined;
            {
                this.this$0 = navigatableNativeCall;
                this.$virtualFile$inlined = virtualFile;
                this.$project$inlined = project;
                this.$sourceFileLineData$inlined = perfSourceFileLineData;
            }

            public final T compute() {
                NavigatablePsiElement navigatablePsiElement;
                boolean bl = false;
                Document document = FileDocumentManager.getInstance().getDocument(this.$virtualFile$inlined);
                if (document == null) {
                    NavigatableNativeCall.access$getLOG$cp().warn("Can't navigate: document is null");
                    navigatablePsiElement = null;
                } else {
                    PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.$project$inlined).getPsiFile(document);
                    if (psiFile == null) {
                        NavigatableNativeCall.access$getLOG$cp().warn("Can't navigate: psi file is null");
                        navigatablePsiElement = null;
                    } else {
                        int offset = document.getLineStartOffset(this.$sourceFileLineData$inlined.getLineNumber());
                        if (!DocumentUtil.isValidOffset((int)offset, (Document)document)) {
                            NavigatableNativeCall.access$getLOG$cp().warn("Can't navigate: offset is not valid");
                            navigatablePsiElement = null;
                        } else {
                            PsiElement elementAt = psiFile.findElementAt(offset);
                            NavigatablePsiElement function = (NavigatablePsiElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementAt, (Class[])new Class[]{NavigatableNativeCall.access$getNavigatableClass$p(this.this$0)});
                            if (function == null) {
                                NavigatableNativeCall.access$getLOG$cp().warn("Can't navigate: navigatable psi is not found");
                                navigatablePsiElement = null;
                            } else {
                                navigatablePsiElement = function;
                            }
                        }
                    }
                }
                return (T)navigatablePsiElement;
            }
        });
    }

    public NavigatableNativeCall(@NotNull String library, @NotNull String methodWithClassOrFunction, @NotNull Class<? extends NavigatablePsiElement> navigatableClass) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)methodWithClassOrFunction, (String)"methodWithClassOrFunction");
        Intrinsics.checkNotNullParameter(navigatableClass, (String)"navigatableClass");
        this.library = library;
        this.methodWithClassOrFunction = methodWithClassOrFunction;
        this.navigatableClass = navigatableClass;
        this.nativeCall = new NativeCall(this.library, this.methodWithClassOrFunction);
        this.navigationMap = new PerfNavigationMap();
    }

    public /* synthetic */ NavigatableNativeCall(String string, String string2, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            clazz = OCFunctionDeclaration.class;
        }
        this(string, string2, clazz);
    }

    public NavigatableNativeCall(@NotNull String library, @NotNull String methodWithClassOrFunction, @NotNull PerfNavigationMap navigationMap, @NotNull Class<? extends NavigatablePsiElement> navigatableClass) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)methodWithClassOrFunction, (String)"methodWithClassOrFunction");
        Intrinsics.checkNotNullParameter((Object)navigationMap, (String)"navigationMap");
        Intrinsics.checkNotNullParameter(navigatableClass, (String)"navigatableClass");
        this(library, methodWithClassOrFunction, navigatableClass);
        this.navigationMap = navigationMap;
    }

    public /* synthetic */ NavigatableNativeCall(String string, String string2, PerfNavigationMap perfNavigationMap, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            clazz = OCFunctionDeclaration.class;
        }
        this(string, string2, perfNavigationMap, clazz);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NavigatableNativeCall.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Class access$getNavigatableClass$p(NavigatableNativeCall $this) {
        return $this.navigatableClass;
    }

    private final String component1() {
        return this.library;
    }

    private final String component2() {
        return this.methodWithClassOrFunction;
    }

    private final Class<? extends NavigatablePsiElement> component3() {
        return this.navigatableClass;
    }

    @NotNull
    public final NavigatableNativeCall copy(@NotNull String library, @NotNull String methodWithClassOrFunction, @NotNull Class<? extends NavigatablePsiElement> navigatableClass) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)methodWithClassOrFunction, (String)"methodWithClassOrFunction");
        Intrinsics.checkNotNullParameter(navigatableClass, (String)"navigatableClass");
        return new NavigatableNativeCall(library, methodWithClassOrFunction, navigatableClass);
    }

    public static /* synthetic */ NavigatableNativeCall copy$default(NavigatableNativeCall navigatableNativeCall, String string, String string2, Class clazz, int n, Object object) {
        if ((n & 1) != 0) {
            string = navigatableNativeCall.library;
        }
        if ((n & 2) != 0) {
            string2 = navigatableNativeCall.methodWithClassOrFunction;
        }
        if ((n & 4) != 0) {
            clazz = navigatableNativeCall.navigatableClass;
        }
        return navigatableNativeCall.copy(string, string2, clazz);
    }

    @NotNull
    public String toString() {
        return "NavigatableNativeCall(library=" + this.library + ", methodWithClassOrFunction=" + this.methodWithClassOrFunction + ", navigatableClass=" + this.navigatableClass + ")";
    }

    public int hashCode() {
        String string = this.library;
        String string2 = this.methodWithClassOrFunction;
        Class<? extends NavigatablePsiElement> clazz = this.navigatableClass;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (clazz != null ? clazz.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof NavigatableNativeCall)) break block3;
                NavigatableNativeCall navigatableNativeCall = (NavigatableNativeCall)((Object)object);
                if (!Intrinsics.areEqual((Object)this.library, (Object)navigatableNativeCall.library) || !Intrinsics.areEqual((Object)this.methodWithClassOrFunction, (Object)navigatableNativeCall.methodWithClassOrFunction) || !Intrinsics.areEqual(this.navigatableClass, navigatableNativeCall.navigatableClass)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/clion/perf/NavigatableNativeCall$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

