/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.clion.AttachCPPProfilerProviderKt;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.perf.PerfProfilerProcess;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfUtils;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0016\u0010\n\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0016J2\u0010\u0019\u001a\u00020\u00182\u0016\u0010\u001a\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016JJ\u0010\u001b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerConfigurationExtension;", "Lcom/jetbrains/cidr/execution/CidrRunConfigurationExtensionBase;", "()V", "PERF_OUTPUT_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "attachToProcess", "", "configuration", "Lcom/jetbrains/cidr/execution/CidrRunConfiguration;", "Lcom/jetbrains/cidr/execution/CidrBuildTarget;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "runnerId", "", "context", "Lcom/jetbrains/cidr/execution/ConfigurationExtensionContext;", "isApplicableFor", "", "isEnabledFor", "applicableConfiguration", "patchCommandLine", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Companion", "intellij.profiler.clion"})
public final class PerfProfilerConfigurationExtension
extends CidrRunConfigurationExtensionBase {
    private final Key<Path> PERF_OUTPUT_FILE_KEY;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicableFor(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return true;
    }

    public boolean isEnabledFor(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> applicableConfiguration, @NotNull CidrToolEnvironment environment2, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(applicableConfiguration, (String)"applicableConfiguration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        if (SystemInfo.isMac) {
            HostMachine hostMachine = environment2.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
            if (!hostMachine.isRemote()) {
                return false;
            }
        }
        return AttachCPPProfilerProviderKt.isCLionProfilerCompatible((RunProfile)applicableConfiguration) && AttachCPPProfilerProviderKt.isPerfProfilerCanBeUsed();
    }

    public void patchCommandLine(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment2, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId) ^ true) {
            return;
        }
        if (PerfProfilerConfigurationExtension.Companion.isUnsupportedWSL(environment2)) {
            throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("perf.profiler.wsl.not.support", new Object[0]));
        }
        if (PerfProfilerConfigurationExtension.Companion.isUnsupportedToolchain(environment2)) {
            throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("perf.profiler.windows.selected.toolchain.not.support", new Object[0]));
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.getProject()");
        Project project2 = project;
        SimpleProfilerSettingsState settings = PerfProfilerSettings.Companion.getInstance().getState();
        MisConfiguredException misConfiguredException = PerfUtils.Companion.validatePerfSettings(environment2, project2);
        if (misConfiguredException != null) {
            MisConfiguredException misConfiguredException2 = misConfiguredException;
            boolean bl = false;
            boolean bl2 = false;
            MisConfiguredException it = misConfiguredException2;
            boolean bl3 = false;
            throw (Throwable)it;
        }
        KernelVariablesChangeRequiredException kernelVariablesChangeRequiredException = PerfUtils.Companion.validateKernelVariables(environment2, project2);
        if (kernelVariablesChangeRequiredException != null) {
            KernelVariablesChangeRequiredException kernelVariablesChangeRequiredException2 = kernelVariablesChangeRequiredException;
            boolean bl = false;
            boolean bl4 = false;
            KernelVariablesChangeRequiredException it = kernelVariablesChangeRequiredException2;
            boolean bl5 = false;
            throw (Throwable)it;
        }
        Path outputFilePath = PerfUtils.Companion.createOutputFilePath(environment2, StringKt.nullize$default((String)settings.getOutputDirectory(), (boolean)false, (int)1, null));
        String string = settings.getExecutablePath();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        PerfProfilerConfigurationExtension.Companion.addPerfStarter(cmdLine, string2, settings.getSamplingFrequency(), settings.getDefaultCmdArgs(), outputFilePath, environment2);
        context.putUserData(this.PERF_OUTPUT_FILE_KEY, (Object)outputFilePath);
    }

    public void attachToProcess(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> configuration, @NotNull ProcessHandler handler2, @NotNull CidrToolEnvironment environment2, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        Path outputFile;
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId) ^ true) {
            return;
        }
        if (PerfProfilerConfigurationExtension.Companion.isUnsupportedWSL(environment2) || PerfProfilerConfigurationExtension.Companion.isUnsupportedToolchain(environment2)) {
            return;
        }
        if (!(handler2 instanceof BaseProcessHandler)) {
            throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.detect.target.process", new Object[0]));
        }
        if (handler2 instanceof KillableProcessHandler) {
            ((KillableProcessHandler)handler2).setShouldKillProcessSoftly(true);
        }
        if ((outputFile = (Path)context.getUserData(this.PERF_OUTPUT_FILE_KEY)) == null) {
            throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.get.output.file", new Object[0]));
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.getProject()");
        Project project2 = project;
        BaseProcessHandler baseProcessHandler = (BaseProcessHandler)handler2;
        String string = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.getName()");
        PerfProfilerProcess profilerProcess = new PerfProfilerProcess(baseProcessHandler, false, outputFile, string, project2, System.currentTimeMillis(), environment2, null, 128, null);
        String string2 = profilerProcess.getProfilerConfiguration().getConfigurationTypeId();
        ConfigurationType configurationType = configuration.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.getType()");
        String string3 = configurationType.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"configuration.getType().id");
        ProfilerUsageTriggerCollector.Companion.reportStart(project2, string2, string3);
        ProfilerToolWindowManager.addProfilerProcessTab$default((ProfilerToolWindowManager)ProfilerToolWindowManager.Companion.getInstance(project2), (ProfilerProcess)((ProfilerProcess)profilerProcess), (boolean)false, (int)2, null);
    }

    public PerfProfilerConfigurationExtension() {
        Key key = Key.create((String)"perf.output");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Path>(\"perf.output\")");
        this.PERF_OUTPUT_FILE_KEY = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J:\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerConfigurationExtension$Companion;", "", "()V", "isUnsupportedToolchain", "", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "isUnsupportedWSL", "addPerfStarter", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "perfPath", "", "samplingFrequency", "", "defaultArgs", "", "outputPath", "Ljava/nio/file/Path;", "intellij.profiler.clion"})
    public static final class Companion {
        private final boolean isUnsupportedWSL(CidrToolEnvironment environment2) {
            return PerfUtils.Companion.isWSL(environment2) && PerfUtils.Companion.getWSLVersion(environment2) < 2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUnsupportedToolchain(CidrToolEnvironment environment2) {
            if (!SystemInfo.isWindows) return false;
            HostMachine hostMachine = environment2.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
            if (hostMachine.isRemote()) return false;
            return true;
        }

        private final GeneralCommandLine addPerfStarter(GeneralCommandLine $this$addPerfStarter, String perfPath, int samplingFrequency, List<String> defaultArgs, Path outputPath, CidrToolEnvironment environment2) {
            GeneralCommandLine generalCommandLine = $this$addPerfStarter;
            boolean bl = false;
            boolean bl2 = false;
            GeneralCommandLine $this$apply = generalCommandLine;
            boolean bl3 = false;
            ParametersList parametersList = $this$apply.getParametersList();
            SpreadBuilder spreadBuilder = new SpreadBuilder(6);
            spreadBuilder.add((Object)"record");
            spreadBuilder.add((Object)("--freq=" + samplingFrequency));
            Collection $this$toTypedArray$iv = defaultArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            spreadBuilder.addSpread((Object)stringArray);
            spreadBuilder.add((Object)"-o");
            spreadBuilder.add((Object)environment2.toEnvPath(((Object)outputPath).toString()));
            spreadBuilder.add((Object)environment2.toEnvPath($this$apply.getExePath()));
            parametersList.prependAll((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            $this$apply.setExePath(environment2.toEnvPath(perfPath));
            return generalCommandLine;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

