/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.linux.KernelVariable;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\tH\u0014J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/clion/perf/RemoteKernelVariable;", "Lcom/intellij/profiler/linux/KernelVariable;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "name", "", "requiredValue", "validator", "Lkotlin/Function1;", "", "(Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getPath", "isFileExist", "readLines", "", "intellij.profiler.clion"})
public final class RemoteKernelVariable
extends KernelVariable {
    private final CidrToolEnvironment environment;

    @NotNull
    public String getPath() {
        String string = this.environment.toEnvPath(FileUtil.join((String[])new String[]{"/proc/sys/kernel", this.getName()}));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.toEnvPath(Fi\u2026iableUtils.kernel, name))");
        return string;
    }

    protected boolean isFileExist() {
        String path = this.getPath();
        return Files.exists(this.environment.getHostMachine().getPath(path, new String[0]), new LinkOption[0]);
    }

    @NotNull
    protected List<String> readLines() {
        String path = this.getPath();
        Stream<String> stream = Files.lines(this.environment.getHostMachine().getPath(path, new String[0]));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.lines(environment.hostMachine.getPath(path))");
        return StreamsKt.toList(stream);
    }

    public RemoteKernelVariable(@NotNull CidrToolEnvironment environment2, @NotNull String name2, @NotNull String requiredValue, @NotNull Function1<? super String, Boolean> validator2) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)requiredValue, (String)"requiredValue");
        Intrinsics.checkNotNullParameter(validator2, (String)"validator");
        super(name2, requiredValue, validator2);
        this.environment = environment2;
    }
}

