/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.console;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.ErrorMatcher;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.execution.DimmableFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CMakeOutputFilter
implements Filter,
ErrorMatcher,
DumbAware,
DimmableFilter {
    @NonNls
    private static final String CMAKE_ERROR = "CMake Error";
    @NonNls
    private static final String CMAKE_WARNING = "CMake Warning";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("CMake ((?:Error|Warning)( \\(dev\\))?)(?: (?:in|at) (.+?)(?::(\\d+)( \\(.+\\))?)?)?:");
    private static final Pattern LOCATION_PATTERN = Pattern.compile("(.+?):(\\d+):?");
    @Nullable
    private final Project myProject;
    @NotNull
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final Path myBaseDir;
    @NotNull
    private final ArrayList<CMakeMessage> myCollectedMessages = new ArrayList();
    @NotNull
    private final EditorColorsScheme myColorsScheme;
    private boolean myDimHighlighting;
    private volatile boolean isFinished;
    private final StringBuilder myBuffer = new StringBuilder();
    private boolean isParseError = false;
    private boolean isGeneralError = false;
    private final List<CharSequence> parseErrorLines = new ArrayList<CharSequence>();
    private Matcher currentMatcher = null;

    public CMakeOutputFilter(@Nullable Project project, @Nullable CidrToolEnvironment env, @Nullable Path baseDir) {
        this.myProject = project;
        this.myEnvironment = env == null ? new CidrToolEnvironment() : env;
        this.myBaseDir = baseDir;
        this.myColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
    }

    public void dimHighlighting() {
        this.myDimHighlighting = true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String eachLine, int entireLength) {
        if (eachLine == null) {
            CMakeOutputFilter.$$$reportNull$$$0(0);
        }
        CPPLog.LOG.assertTrue(!this.isFinished, (Object)"finish has been already called");
        int offset = entireLength - eachLine.length();
        SmartList links = new SmartList();
        if (this.match(eachLine, offset, (List<Filter.ResultItem>)links) && !this.myDimHighlighting) {
            TextAttributes errorAttr = this.myColorsScheme.getAttributes(ConsoleViewContentType.ERROR_OUTPUT_KEY);
            links.add(new Filter.ResultItem(offset, entireLength, null, errorAttr, null){

                public int getHighlighterLayer() {
                    return 5000;
                }
            });
        }
        return links.isEmpty() ? null : new Filter.Result((List)links);
    }

    private boolean match(CharSequence eachLine, int offset, List<Filter.ResultItem> links) {
        Matcher m;
        eachLine = StringUtil.trimTrailing((CharSequence)eachLine);
        if (this.currentMatcher != null) {
            if (eachLine.length() == 0) {
                this.myBuffer.append('\n');
                return true;
            }
            if (StringUtil.startsWith((CharSequence)eachLine, (CharSequence)"  ")) {
                int length = this.myBuffer.length();
                if (length > 0 && !Character.isWhitespace(this.myBuffer.charAt(length - 1))) {
                    this.myBuffer.append(' ');
                }
                this.myBuffer.append(eachLine.subSequence("  ".length(), eachLine.length()));
                return true;
            }
            this.flushMessage(this.currentMatcher, this.myBuffer);
            this.currentMatcher = null;
            this.myBuffer.setLength(0);
        } else if (this.isParseError) {
            if (this.parseErrorLines.size() < 2) {
                this.parseErrorLines.add(eachLine);
                return true;
            }
            this.flushParsingError(this.parseErrorLines);
            this.parseErrorLines.clear();
            this.isParseError = false;
        }
        boolean startsWithError = StringUtil.startsWith((CharSequence)eachLine, (CharSequence)CMAKE_ERROR);
        Matcher matcher = m = startsWithError || StringUtil.startsWith((CharSequence)eachLine, (CharSequence)CMAKE_WARNING) ? MESSAGE_PATTERN.matcher(eachLine) : null;
        if (m != null && m.matches()) {
            if (this.isGeneralError) {
                this.flushGeneralMessage(this.myBuffer);
            }
            this.isGeneralError = false;
            this.currentMatcher = m;
            this.addErrorHyperlink(m, offset, links);
            return true;
        }
        if (startsWithError && StringUtil.startsWith((CharSequence)eachLine, (CharSequence)"CMake Error:")) {
            if (this.isGeneralError) {
                this.flushGeneralMessage(this.myBuffer);
            }
            this.isGeneralError = false;
            if (eachLine.equals("CMake Error: Error in cmake code at")) {
                this.isParseError = true;
            } else {
                this.myBuffer.append(eachLine.subSequence("CMake Error:".length(), eachLine.length())).append("\n");
                this.isGeneralError = true;
            }
            return true;
        }
        if (this.isGeneralError) {
            if (!StringUtil.startsWith((CharSequence)eachLine, (CharSequence)"-- ") && !StringUtil.equalsTrimWhitespaces((CharSequence)eachLine, (CharSequence)"")) {
                this.myBuffer.append(eachLine).append("\n");
                return true;
            }
            this.flushGeneralMessage(this.myBuffer);
            this.isGeneralError = false;
        }
        return false;
    }

    @Override
    public boolean isPotentialMatch(@NotNull CharSequence multilineFragment) {
        if (multilineFragment == null) {
            CMakeOutputFilter.$$$reportNull$$$0(1);
        }
        return StringUtil.contains((CharSequence)multilineFragment, (CharSequence)CMAKE_ERROR) || StringUtil.contains((CharSequence)multilineFragment, (CharSequence)CMAKE_WARNING);
    }

    @Override
    @Nullable
    public CMakeConsoleMessageType match(@NotNull CharSequence line) {
        Matcher m;
        if (line == null) {
            CMakeOutputFilter.$$$reportNull$$$0(2);
        }
        if ((m = MESSAGE_PATTERN.matcher(line = StringUtil.trimTrailing((CharSequence)line))).matches()) {
            return m.group(1).equals("Error") ? CMakeConsoleMessageType.ERROR : CMakeConsoleMessageType.WARNING;
        }
        if (StringUtil.startsWith((CharSequence)line, (CharSequence)"CMake Error:")) {
            return CMakeConsoleMessageType.ERROR;
        }
        return null;
    }

    private void addErrorHyperlink(@NotNull Matcher m, int offset, @NotNull List<? super Filter.ResultItem> results) {
        HyperlinkInfo info;
        if (m == null) {
            CMakeOutputFilter.$$$reportNull$$$0(3);
        }
        if (results == null) {
            CMakeOutputFilter.$$$reportNull$$$0(4);
        }
        Pair<File, Integer> fileAndLine = this.toFileAndLine(m.group(3), m.group(4));
        if (fileAndLine.first != null && (info = this.createHyperlinkInfo((File)fileAndLine.first, (Integer)fileAndLine.second)) != null) {
            results.add((Filter.ResultItem)new Filter.ResultItem(offset + m.start(3), offset + Math.max(m.end(3), m.end(4)), info, this.myDimHighlighting));
        }
    }

    @Nullable
    protected HyperlinkInfo createHyperlinkInfo(@NotNull File file, @Nullable Integer line) {
        if (file == null) {
            CMakeOutputFilter.$$$reportNull$$$0(5);
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        return this.myProject == null || vFile == null ? null : new OpenFileHyperlinkInfo(this.myProject, vFile, line == null ? 0 : line - 1, 0);
    }

    @NotNull
    @TestOnly
    public List<CMakeMessage> finishAndGetMessages() {
        CPPLog.LOG.assertTrue(!this.isFinished, (Object)"finishAndGetMessages() has been already called.\nThis might happen when something tries to write to CMake console, after generation/build has finished");
        this.isFinished = true;
        if (this.currentMatcher != null) {
            this.flushMessage(this.currentMatcher, this.myBuffer);
        }
        if (this.isParseError) {
            this.flushParsingError(this.parseErrorLines);
        }
        if (this.isGeneralError) {
            this.flushGeneralMessage(this.myBuffer);
        }
        List<CMakeMessage> list = Collections.unmodifiableList(this.myCollectedMessages);
        if (list == null) {
            CMakeOutputFilter.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void flushGeneralMessage(StringBuilder text) {
        this.myCollectedMessages.add(this.createMessage(CMakeMessage.MessageLevel.ERROR, null, null, text));
    }

    private void flushParsingError(List<CharSequence> parseErrorLines) {
        Matcher m = LOCATION_PATTERN.matcher(parseErrorLines.get(0));
        String fileText = null;
        String lineText = null;
        StringBuilder text = new StringBuilder();
        if (m.matches()) {
            fileText = m.group(1);
            lineText = m.group(2);
        } else {
            text.append(parseErrorLines.get(0)).append(' ');
        }
        text.append(parseErrorLines.get(1));
        this.myCollectedMessages.add(this.createMessage(CMakeMessage.MessageLevel.FATAL_ERROR, fileText, lineText, text));
    }

    private void flushMessage(@NotNull Matcher matcher, @NotNull StringBuilder text) {
        if (matcher == null) {
            CMakeOutputFilter.$$$reportNull$$$0(7);
        }
        if (text == null) {
            CMakeOutputFilter.$$$reportNull$$$0(8);
        }
        String levelText = matcher.group(1);
        String dev = matcher.group(2);
        String fileText = matcher.group(3);
        String lineText = matcher.group(4);
        CMakeMessage.MessageLevel level = levelText.equals("Error") ? CMakeMessage.MessageLevel.ERROR : (dev == null ? CMakeMessage.MessageLevel.WARNING : CMakeMessage.MessageLevel.AUTHOR_WARNING);
        this.myCollectedMessages.add(this.createMessage(level, fileText, lineText, text));
    }

    private CMakeMessage createMessage(@NotNull CMakeMessage.MessageLevel level, @Nullable String fileText, @Nullable String lineText, @NotNull StringBuilder text) {
        if (level == null) {
            CMakeOutputFilter.$$$reportNull$$$0(9);
        }
        if (text == null) {
            CMakeOutputFilter.$$$reportNull$$$0(10);
        }
        Pair<File, Integer> fileAndLine = this.toFileAndLine(fileText, lineText);
        CMakeMessage result = new CMakeMessage(level, (File)fileAndLine.first, (Integer)fileAndLine.second, text.toString().trim());
        text.setLength(0);
        return result;
    }

    @NotNull
    private Pair<File, Integer> toFileAndLine(@Nullable String fileText, @Nullable String lineText) {
        Integer line = null;
        try {
            line = lineText == null ? null : Integer.valueOf(Integer.parseInt(lineText));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Pair pair = Pair.create(fileText == null || this.myBaseDir == null ? null : new File(this.myEnvironment.toLocalPath(this.myBaseDir.toFile(), fileText)), (Object)line);
        if (pair == null) {
            CMakeOutputFilter.$$$reportNull$$$0(11);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multilineFragment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/console/CMakeOutputFilter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/console/CMakeOutputFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "finishAndGetMessages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileAndLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialMatch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addErrorHyperlink";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHyperlinkInfo";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "flushMessage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

