/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model.api;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\b\b\u0001\u0010\b\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u0005H\u0002J\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005J$\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00052\u000e\b\u0004\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0086\b\u00f8\u0001\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/model/api/CMakeApiFailLogger;", "", "()V", "loggingScopes", "Ljava/util/Deque;", "", "fail", "T", "reason", "(Ljava/lang/String;)Ljava/lang/Object;", "", "cause", "", "getErrorScopeString", "popScope", "pushScope", "name", "scope", "block", "Lkotlin/Function0;", "intellij.clion.cmake"})
public final class CMakeApiFailLogger {
    private final Deque<String> loggingScopes = new ArrayDeque();

    private final String getErrorScopeString() {
        return this.loggingScopes.isEmpty() ? "" : StringUtil.join((Collection)this.loggingScopes, (String)": ") + ": ";
    }

    @Contract(value="_ -> fail")
    public final <T> T fail(@NonNls @NotNull String reason) throws CMakeApiException {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        throw (Throwable)new CMakeApiException(this.getErrorScopeString() + reason);
    }

    @Contract(value="_ -> fail")
    public final void fail(@NotNull Throwable cause) throws CMakeApiException {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        throw (Throwable)new CMakeApiException(this.getErrorScopeString() + cause.getLocalizedMessage(), cause);
    }

    public final void pushScope(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.loggingScopes.addLast(name2);
    }

    public final void popScope() {
        this.loggingScopes.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scope(@NotNull String name2, @NotNull Function0<Unit> block) {
        int $i$f$scope = 0;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.pushScope(name2);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.popScope();
            InlineMarker.finallyEnd((int)1);
        }
    }
}

