/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleBuilder;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleViewImpl;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildToolWindowActivator;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildUtil;
import com.jetbrains.cidr.cpp.execution.build.CMakeBuildListener;
import com.jetbrains.cidr.cpp.toolchains.CPPBuildUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuild;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.CidrBuildTaskType;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeBuild {
    public static ExecutionResult<CidrBuildResult> build(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(0);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(1);
        }
        return CMakeBuild.build(project, configurations, null);
    }

    public static ExecutionResult<CidrBuildResult> build(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @Nullable ProcessListener listener) {
        Object providedSessionId;
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(2);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(3);
        }
        Object buildSessionId = (providedSessionId = CMakeBuild.getBuildSessionId(configurations)) == null ? UUID.randomUUID() : providedSessionId;
        String explicitTarget = CMakeBuild.getEffectiveTargetName(configurations.explicitBuildTargetName, configurations.buildConfiguration);
        String firstPreBuildMessage = CLionBuildUtil.buildDescription(null, CidrExecutionBundle.message((String)"task.execution.build", (Object[])new Object[0]), explicitTarget != null ? explicitTarget : configurations.buildConfiguration.getTarget().getName(), configurations.buildConfiguration.getProfileName());
        ExecutionResult<CidrBuildResult> firstResult = CMakeBuild.execute(project, CidrExecutionBundle.message((String)"task.execution.build", (Object[])new Object[0]), CidrExecutionBundle.message((String)"build.progress", (Object[])new Object[0]), configurations.buildConfiguration, CidrBuildTaskType.BUILD, explicitTarget, firstPreBuildMessage, listener, buildSessionId, false, false, CMakeBuild.getRunTaskConfiguration(configurations));
        if (configurations.runConfiguration == null || explicitTarget != null) {
            return firstResult;
        }
        ExecutionResult secondResult = new ExecutionResult();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                CidrBuildResult firstBuildResult = (CidrBuildResult)firstResult.get();
                String secondPreBuildMessage = CLionBuildUtil.buildDescription(null, CidrExecutionBundle.message((String)"task.execution.build", (Object[])new Object[0]), configurations.runConfiguration.getTarget().getName(), configurations.runConfiguration.getProfileName());
                CidrBuildResult secondBuildResult = (CidrBuildResult)CMakeBuild.execute(project, CidrExecutionBundle.message((String)"task.execution.build", (Object[])new Object[0]), CidrExecutionBundle.message((String)"build.progress", (Object[])new Object[0]), configurations.runConfiguration, CidrBuildTaskType.BUILD, null, secondPreBuildMessage, listener, buildSessionId, false, false, CMakeBuild.getRunTaskConfiguration(configurations)).get();
                secondResult.set((Object)firstBuildResult.merge(secondBuildResult));
            }
            catch (ExecutionException e) {
                secondResult.setException((Throwable)e);
            }
        });
        return secondResult;
    }

    @Nullable
    private static String getEffectiveTargetName(@Nullable String targetName, @NotNull CMakeConfiguration buildConfiguration) {
        if (buildConfiguration == null) {
            CMakeBuild.$$$reportNull$$$0(4);
        }
        if ("all".equals(targetName)) {
            String generator2 = buildConfiguration.getGenerator().name;
            return CMakeGenerator.getAllTargetName(generator2);
        }
        return targetName;
    }

    public static ExecutionResult<CidrBuildResult> clean(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations buildConfiguration) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(5);
        }
        if (buildConfiguration == null) {
            CMakeBuild.$$$reportNull$$$0(6);
        }
        return CMakeBuild.clean(project, buildConfiguration, null);
    }

    public static ExecutionResult<CidrBuildResult> clean(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @Nullable ProcessListener listener) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(7);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(8);
        }
        String preBuildMessage = CLionBuildUtil.buildDescription(null, CidrExecutionBundle.message((String)"build.clean", (Object[])new Object[0]), null, configurations.buildConfiguration.getProfileName());
        return CMakeBuild.execute(project, CidrExecutionBundle.message((String)"build.clean", (Object[])new Object[0]), CidrExecutionBundle.message((String)"build.clean.progress", (Object[])new Object[0]), configurations.buildConfiguration, CidrBuildTaskType.CLEAN, "clean", preBuildMessage, listener, CMakeBuild.getBuildSessionId(configurations), false, false, CMakeBuild.getRunTaskConfiguration(configurations));
    }

    public static ExecutionResult<CidrBuildResult> install(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(9);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(10);
        }
        return CMakeBuild.install(project, configurations, null);
    }

    public static ExecutionResult<CidrBuildResult> install(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @Nullable ProcessListener listener) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(11);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(12);
        }
        String preBuildMessage = CLionBuildUtil.buildDescription(null, CLionCMakeBundle.message("cmake.install.name", new Object[0]), null, configurations.buildConfiguration.getProfileName());
        return CMakeBuild.execute(project, CLionCMakeBundle.message("cmake.install.name", new Object[0]), CLionCMakeBundle.message("cmake.install.progress", new Object[0]), configurations.buildConfiguration, CidrBuildTaskType.INSTALL, "install", preBuildMessage, listener, CMakeBuild.getBuildSessionId(configurations), false, false, CMakeBuild.getRunTaskConfiguration(configurations));
    }

    public static ExecutionResult<CidrBuildResult> compileFile(@NotNull Project project, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @NotNull String targetName, @Nullable @NlsActions.ActionText String taskName, @Nullable String preBuildMessage, @Nullable ProcessListener processListener2) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(13);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(14);
        }
        if (targetName == null) {
            CMakeBuild.$$$reportNull$$$0(15);
        }
        return CMakeBuild.execute(project, taskName != null ? taskName : CLionExecutionBundle.message("action.recompile.current.file", new Object[0]), CLionExecutionBundle.message("cpp.compileFile.progress", new Object[0]), configurations.buildConfiguration, CidrBuildTaskType.COMPILE, targetName, preBuildMessage, processListener2, CMakeBuild.getBuildSessionId(configurations), true, true, CMakeBuild.getRunTaskConfiguration(configurations));
    }

    @NotNull
    public static List<CidrBuildConfiguration> getBuildableElements(@NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(16);
        }
        CidrBuildConfiguration element = configurations.explicitBuildTargetName != null ? new CMakeExplicitTargetConfiguration(configurations.buildConfiguration, configurations.explicitBuildTargetName) : configurations.buildConfiguration;
        SmartList buildableElements = new SmartList((Object)element);
        if (configurations.runConfiguration != null && configurations.explicitBuildTargetName == null) {
            buildableElements.add(configurations.runConfiguration);
        }
        SmartList smartList = buildableElements;
        if (smartList == null) {
            CMakeBuild.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @Nullable
    private static RunnerAndConfigurationSettings getRunTaskConfiguration(@NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(18);
        }
        return (RunnerAndConfigurationSettings)configurations.getUserData(CLionBuildUtil.BEFORE_RUN_TASK_CONFIGURATION);
    }

    @Nullable
    private static Object getBuildSessionId(@Nullable CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (configurations == null) {
            return null;
        }
        return configurations.getUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY);
    }

    private static ExecutionResult<CidrBuildResult> execute(@NotNull Project project, @NotNull @Nls String taskName, @NotNull @NlsContexts.ProgressText String progressTitle, @NotNull CMakeConfiguration buildConfiguration, @Nullable CidrBuildTaskType taskType, @Nullable String explicitTargetName, @Nullable String preBuildMessage, @Nullable ProcessListener processListener2, @Nullable Object buildSessionId, boolean useTargetMakefile, boolean forceRebuild, @Nullable RunnerAndConfigurationSettings runTaskConfiguration) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(19);
        }
        if (taskName == null) {
            CMakeBuild.$$$reportNull$$$0(20);
        }
        if (progressTitle == null) {
            CMakeBuild.$$$reportNull$$$0(21);
        }
        if (buildConfiguration == null) {
            CMakeBuild.$$$reportNull$$$0(22);
        }
        CidrBuild.BuildContext context = new CidrBuild.BuildContext(project, (CidrBuildConfiguration)buildConfiguration, taskType, taskName, progressTitle);
        return CidrBuild.execute((Project)project, (CidrBuild.BuildContext)context, () -> {
            CMakeWorkspace workspace = CMakeWorkspace.getInstance(project);
            workspace.lockModelDuring(() -> {
                try {
                    CMakeProfileInfo profileInfo = workspace.getProfileInfoFor(buildConfiguration);
                    CPPEnvironment environment2 = profileInfo.getEnvironmentSafe(true);
                    File buildDir = buildConfiguration.getConfigurationGenerationDir();
                    File cmakeSourceDir = workspace.getModelProjectDir();
                    SmartList toRefresh = new SmartList();
                    toRefresh.add((Object)buildDir);
                    for (CMakeTarget eachTarget : workspace.getModelTargets()) {
                        for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                            File productFile = eachConfig.getProductFile();
                            if (productFile == null || FileUtil.isAncestor((File)buildDir, (File)productFile, (boolean)true)) continue;
                            ContainerUtil.addIfNotNull((Collection)toRefresh, (Object)productFile);
                        }
                    }
                    for (String eachUrl : ProjectRootManager.getInstance((Project)project).getContentRootUrls()) {
                        ContainerUtil.addIfNotNull((Collection)toRefresh, (Object)new File(VfsUtilCore.urlToPath((String)eachUrl)));
                    }
                    try {
                        String target = explicitTargetName != null ? explicitTargetName : buildConfiguration.getTarget().getName();
                        String forcedBuildType = CMakeGenerator.isSingleConfigurationGenerator(buildConfiguration.getGenerator().name) ? null : buildConfiguration.getBuildType();
                        CMakeSettings.Profile profile = profileInfo.getProfile();
                        context.processHandler = CMakeBuild.createBuildProcess(environment2, profile.getEffectiveBuildOptionsList(environment2.getToolchain()), profile.getPassSystemEnvironment(), profile.getAdditionalEnvironment(), buildDir, target, forcedBuildType, useTargetMakefile ? buildConfiguration.getConfigurationAndTargetGenerationDir() : null, forceRebuild);
                    }
                    catch (Throwable e) {
                        throw e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(e);
                    }
                    if (processListener2 != null) {
                        context.processHandler.addProcessListener(processListener2);
                    }
                    ApplicationManager.getApplication().invokeAndWait(() -> CMakeBuild.createBuildListenerAndConsole(project, environment2, cmakeSourceDir, context, buildSessionId, runTaskConfiguration, taskName, preBuildMessage));
                    CidrBuild.startProcess((Project)project, (CidrBuild.BuildContext)context, (Collection)toRefresh);
                    context.processHandler.waitFor();
                }
                catch (ExecutionException e) {
                    context.error((Throwable)e);
                    ExecutionUtil.handleExecutionError((Project)project, (String)"Messages", (String)taskName, (Throwable)e);
                }
                catch (Throwable e) {
                    context.error(e);
                }
                return null;
            });
        });
    }

    public static void createBuildListenerAndConsole(final @NotNull Project project, @NotNull CPPEnvironment environment2, @Nullable File cmakeSourceDir, final @NotNull CidrBuild.BuildContext context, @Nullable Object buildSessionId, @Nullable RunnerAndConfigurationSettings runTaskConfiguration, @NotNull String taskName, @Nullable String preBuildMessage) {
        CMakeConsoleViewImpl consoleView;
        ToolWindow toolWindow;
        ContentManager contentManager;
        Content usedContent;
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(23);
        }
        if (environment2 == null) {
            CMakeBuild.$$$reportNull$$$0(24);
        }
        if (context == null) {
            CMakeBuild.$$$reportNull$$$0(25);
        }
        if (taskName == null) {
            CMakeBuild.$$$reportNull$$$0(26);
        }
        if ((usedContent = (Content)ContainerUtil.find((Object[])(contentManager = (toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages")).getContentManager()).getContents(), content -> content.getDisplayName().equals(CidrExecutionBundle.message((String)"build.logToolWindowName", (Object[])new Object[0])))) == null || !(usedContent.getComponent() instanceof CMakeConsoleViewImpl) || buildSessionId == null || !buildSessionId.equals(CLionBuildUtil.getBuildSessionId(usedContent))) {
            CMakeConsoleBuilder consoleBuilder = new CMakeConsoleBuilder(project, (CidrToolEnvironment)environment2, cmakeSourceDir != null ? cmakeSourceDir.toPath() : null, 0){

                @Override
                protected void addToolbarActions(@NotNull ConsoleView consoleView, @NotNull DefaultActionGroup toolbarActions) {
                    if (consoleView == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (toolbarActions == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    toolbarActions.add((AnAction)new CLionBuildUtil.StopBuildAction((CMakeConsoleViewImpl)consoleView));
                    toolbarActions.addSeparator();
                    super.addToolbarActions(consoleView, toolbarActions);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "consoleView";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "toolbarActions";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/cpp/execution/build/CMakeBuild$1";
                    objectArray[2] = "addToolbarActions";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            consoleView = (CMakeConsoleViewImpl)consoleBuilder.getConsole();
            consoleView.addMessageListener(new CMakeConsoleViewImpl.MessageListener(){

                @Override
                public void messageReported(@NotNull CMakeConsoleMessageType type) {
                    if (type == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CLionBuildToolWindowActivator activator = (CLionBuildToolWindowActivator)project.getService(CLionBuildToolWindowActivator.class);
                    activator.activateIfNeeded(new CidrBuildEvent(context.buildConfiguration, context.taskType, context.id));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/cpp/execution/build/CMakeBuild$2", "messageReported"));
                }
            });
            Content content2 = ContentFactory.SERVICE.getInstance().createContent(consoleView.getComponent(), CidrExecutionBundle.message((String)"build.logToolWindowName", (Object[])new Object[0]), true);
            ContentsUtil.addOrReplaceContent((ContentManager)contentManager, (Content)content2, (boolean)true);
            content2.setDisposer(() -> contentManager.removeContent(content2, false));
            if (buildSessionId != null) {
                content2.putUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY, buildSessionId);
            }
            Disposer.register((Disposable)content2, (Disposable)consoleView);
            contentManager.addContentManagerListener((ContentManagerListener)new CidrBuild.BuildContentRemoveListener(project, contentManager, content2, context));
        } else {
            consoleView = (CMakeConsoleViewImpl)((Object)usedContent.getComponent());
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        context.processHandler.addProcessListener((ProcessListener)new CMakeBuildListener(context.indicator));
        consoleView.putClientProperty(CidrBuild.BuildContext.class, context);
        consoleView.attachToProcess(context.processHandler);
        MessageBusConnection buildConnection = project.getMessageBus().connect();
        CidrBuildListener buildListener = CLionBuildUtil.notificationListener(buildConnection, context.id, context.processHandler, taskName, preBuildMessage);
        buildConnection.subscribe(CidrBuildListener.TOPIC, (Object)buildListener);
    }

    private static ProcessHandler createBuildProcess(@NotNull CPPEnvironment environment2, @NotNull List<String> buildOptions2, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment2, @NotNull File generatedDir, @NotNull String target, @Nullable String forcedBuildType, @Nullable File makefileDir, boolean forceRebuild) throws CMakeException, ExecutionException {
        if (environment2 == null) {
            CMakeBuild.$$$reportNull$$$0(27);
        }
        if (buildOptions2 == null) {
            CMakeBuild.$$$reportNull$$$0(28);
        }
        if (additionalEnvironment2 == null) {
            CMakeBuild.$$$reportNull$$$0(29);
        }
        if (generatedDir == null) {
            CMakeBuild.$$$reportNull$$$0(30);
        }
        if (target == null) {
            CMakeBuild.$$$reportNull$$$0(31);
        }
        CPPToolSet toolSet = environment2.getToolSet();
        boolean usePty = CPPBuildUtil.usePty((CPPEnvironment)environment2);
        String generatedDirPath = environment2.toEnvPath(generatedDir.getPath());
        ArrayList parameters = ContainerUtil.newArrayList((Object[])new String[]{"--build", generatedDirPath, "--target", target});
        if (forcedBuildType != null) {
            parameters.add("--config");
            parameters.add(forcedBuildType);
        }
        parameters.addAll(buildOptions2);
        if (makefileDir != null) {
            CMakeBuild.ensureHasToolFlagsMarker(parameters);
            File makefile = new File(makefileDir, "build.make");
            String makefilePath = environment2.toEnvPath(makefile.getPath());
            parameters.add("-f");
            parameters.add(makefilePath);
        }
        if (forceRebuild) {
            CMakeBuild.ensureHasToolFlagsMarker(parameters);
            if (toolSet.isMSVC()) {
                parameters.add("-A");
            } else {
                parameters.add("--always-make");
            }
        }
        GeneralCommandLine cmd = CMakeRunner.buildCommandLine(environment2, generatedDir.toPath(), parameters, passSystemEnvironment, additionalEnvironment2, usePty);
        CPPLog.LOG.info("Building: " + cmd.getCommandLineString());
        CPPBuildUtil.setAdditionalBuildEnvironment((GeneralCommandLine)cmd);
        return environment2.getHostMachine().createProcess(cmd, true, usePty);
    }

    private static void ensureHasToolFlagsMarker(@NotNull List<String> parameters) {
        if (parameters == null) {
            CMakeBuild.$$$reportNull$$$0(32);
        }
        if (!parameters.contains("--")) {
            parameters.add("--");
        }
    }

    public static String showBuildNotification(@NotNull Project project, @NotNull MessageType messageType, @NotNull @Nls String message) {
        if (project == null) {
            CMakeBuild.$$$reportNull$$$0(33);
        }
        if (messageType == null) {
            CMakeBuild.$$$reportNull$$$0(34);
        }
        if (message == null) {
            CMakeBuild.$$$reportNull$$$0(35);
        }
        return CidrBuild.showBuildNotification((Project)project, (MessageType)messageType, (String)message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildConfiguration";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/build/CMakeBuild";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildOptions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedDir";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/build/CMakeBuild";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildableElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveTargetName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clean";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "compileFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBuildableElements";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRunTaskConfiguration";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createBuildListenerAndConsole";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createBuildProcess";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "ensureHasToolFlagsMarker";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showBuildNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

