/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.execution.build.runners.CLionCompileTaskRunner;
import com.jetbrains.cidr.execution.CidrResolveConfigurationProvider;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 ,*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00018\u0000H$\u00a2\u0006\u0002\u0010\tJ4\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016JU\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH$\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H$J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010\u000e\u001a\u00020\"H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J(\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010(\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001bH$\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CLionCompileTaskRunner;", "BUILD_CONFIGURATION", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "()V", "acceptConfiguration", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)Z", "compile", "", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/task/ModuleFilesBuildTask;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "sessionId", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "doBuild", "currentFile", "buildFile", "taskName", "", "preBuildMessage", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;Lcom/intellij/task/ProjectTaskContext;Lorg/jetbrains/concurrency/AsyncPromise;Ljava/lang/String;Ljava/lang/String;)V", "doGetConfiguration", "Lkotlin/Pair;", "executeTask", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTask;", "expandTask", "", "findRoots", "", "getConfiguration", "showBuildNotification", "messageType", "Lcom/intellij/openapi/ui/MessageType;", "message", "Companion", "intellij.clion.execution"})
public abstract class CLionCompileTaskRunner<BUILD_CONFIGURATION>
implements CidrTaskRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract Pair<BUILD_CONFIGURATION, VirtualFile> doGetConfiguration(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean acceptConfiguration(@Nullable VirtualFile var1, @Nullable BUILD_CONFIGURATION var2);

    protected abstract void doBuild(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, BUILD_CONFIGURATION var4, @NotNull ProjectTaskContext var5, @NotNull AsyncPromise<ProjectTaskRunner.Result> var6, @NlsActions.ActionText @NotNull String var7, @NotNull String var8);

    protected abstract void showBuildNotification(@NotNull Project var1, @NotNull MessageType var2, @NotNull String var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectTask> expandTask(@NotNull ProjectTask task2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (task2 instanceof ModuleFilesBuildTask) {
            if (((ModuleFilesBuildTask)task2).getFiles().length == 1) {
                list = CollectionsKt.listOf((Object)task2);
            } else {
                void $this$mapTo$iv$iv;
                VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)task2).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"task.files");
                VirtualFile[] $this$map$iv = virtualFileArray;
                boolean $i$f$map = false;
                VirtualFile[] virtualFileArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var7_7 = $this$mapTo$iv$iv;
                int n = ((void)var7_7).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_11 = item$iv$iv = var7_7[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ModuleFilesBuildTaskImpl moduleFilesBuildTaskImpl = new ModuleFilesBuildTaskImpl(((ModuleFilesBuildTask)task2).getModule(), ((ModuleFilesBuildTask)task2).isIncrementalBuild(), new VirtualFile[]{it});
                    collection.add(moduleFilesBuildTaskImpl);
                }
                list = (List)destination$iv$iv;
            }
        } else {
            CPPLog.LOG.error("Unexpected task type: " + task2.getPresentableName());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public Promise<ProjectTaskRunner.Result> executeTask(@NotNull Project project, @NotNull ProjectTask task2, @NotNull Object sessionId, @NotNull ProjectTaskContext context) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CPPLog.LOG.assertTrue(task2 instanceof ModuleFilesBuildTask);
        AsyncPromise promise = new AsyncPromise();
        this.compile(project, (ModuleFilesBuildTask)task2, (AsyncPromise<ProjectTaskRunner.Result>)promise, sessionId, context);
        return (Promise)promise;
    }

    /*
     * WARNING - void declaration
     */
    public final void compile(@NotNull Project project, @NotNull ModuleFilesBuildTask task2, @NotNull AsyncPromise<ProjectTaskRunner.Result> promise, @NotNull Object sessionId, @NotNull ProjectTaskContext context) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = task2.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"task.files");
        VirtualFile file = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
        CPPLog.LOG.assertTrue(file != null);
        VirtualFile virtualFile = file;
        Intrinsics.checkNotNull((Object)virtualFile);
        if (virtualFile.isDirectory() || !OCFileTypeHelpers.isSourceFile((String)file.getName()) && !OCFileTypeHelpers.isHeaderFile((String)file.getName())) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, project, file){
                final /* synthetic */ CLionCompileTaskRunner this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;

                public final void run() {
                    MessageType messageType = MessageType.ERROR;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
                    String string = CLionExecutionBundle.message("cpp.compileCurrentFile.error.message", this.$file.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLionExecutionBundle.mes\u2026rror.message\", file.name)");
                    this.this$0.showBuildNotification(this.$project, messageType, string);
                }
                {
                    this.this$0 = cLionCompileTaskRunner;
                    this.$project = project;
                    this.$file = virtualFile;
                }
            });
            promise.setResult((Object)TaskRunnerResults.ABORTED);
            return;
        }
        try {
            void configuration;
            Pair<BUILD_CONFIGURATION, VirtualFile> pair = this.getConfiguration(project, file);
            Object object = pair.component1();
            VirtualFile buildFile = (VirtualFile)pair.component2();
            if (!this.acceptConfiguration(buildFile, configuration)) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, project, buildFile, file){
                    final /* synthetic */ CLionCompileTaskRunner this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ VirtualFile $buildFile;
                    final /* synthetic */ VirtualFile $file;

                    public final void run() {
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
                        Object[] objectArray = new Object[1];
                        VirtualFile virtualFile = this.$buildFile;
                        if (virtualFile == null) {
                            virtualFile = this.$file;
                        }
                        objectArray[0] = virtualFile.getName();
                        String string = CLionExecutionBundle.message("cpp.compileCurrentFile.noRulesError.message", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLionExecutionBundle.mes\u2026(buildFile ?: file).name)");
                        this.this$0.showBuildNotification(this.$project, messageType, string);
                    }
                    {
                        this.this$0 = cLionCompileTaskRunner;
                        this.$project = project;
                        this.$buildFile = virtualFile;
                        this.$file = virtualFile2;
                    }
                });
                promise.setResult((Object)TaskRunnerResults.ABORTED);
                return;
            }
            if (configuration instanceof UserDataHolder) {
                ((UserDataHolder)configuration).putUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY, sessionId);
            }
            VirtualFile virtualFile2 = buildFile;
            Intrinsics.checkNotNull((Object)virtualFile2);
            void v3 = configuration;
            Intrinsics.checkNotNull((Object)v3);
            this.doBuild(project, file, virtualFile2, v3, context, promise, CLionCompileTaskRunner.Companion.taskName(project, file), CLionCompileTaskRunner.Companion.preBuildMessage(project, file, buildFile));
        }
        catch (ExecutionException ex) {
            promise.setResult((Object)TaskRunnerResults.ABORTED);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(project, task2, ex){
                final /* synthetic */ Project $project;
                final /* synthetic */ ModuleFilesBuildTask $task;
                final /* synthetic */ ExecutionException $ex;

                public final void run() {
                    ExecutionUtil.handleExecutionError((Project)this.$project, (String)"Messages", (String)this.$task.getPresentableName(), (Throwable)this.$ex);
                }
                {
                    this.$project = project;
                    this.$task = moduleFilesBuildTask;
                    this.$ex = executionException;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Collection<VirtualFile> findRoots(@NotNull Project project, @NotNull VirtualFile file) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ExtensionPointName extensionPointName = CidrResolveConfigurationProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"CidrResolveConfigurationProvider.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CidrResolveConfiguration\u2026der.EP_NAME.extensionList");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CidrResolveConfigurationProvider provider2 = (CidrResolveConfigurationProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = provider2.findRoots(project, file);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<BUILD_CONFIGURATION, VirtualFile> getConfiguration(Project project, VirtualFile file) {
        void configurationAndFile;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new Pair(null, null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isDispatchThread()) {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable(this, (Ref.ObjectRef)configurationAndFile, project, file){
                final /* synthetic */ CLionCompileTaskRunner this$0;
                final /* synthetic */ Ref.ObjectRef $configurationAndFile$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ VirtualFile $file$inlined;
                {
                    this.this$0 = cLionCompileTaskRunner;
                    this.$configurationAndFile$inlined = objectRef;
                    this.$project$inlined = project;
                    this.$file$inlined = virtualFile;
                }

                public final T compute() {
                    boolean bl = false;
                    this.$configurationAndFile$inlined.element = this.this$0.doGetConfiguration(this.$project$inlined, this.$file$inlined);
                    return (T)Unit.INSTANCE;
                }
            });
            return (Pair)configurationAndFile.element;
        }
        boolean canceled2 = !ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, (Ref.ObjectRef)configurationAndFile, project, file){
            final /* synthetic */ CLionCompileTaskRunner this$0;
            final /* synthetic */ Ref.ObjectRef $configurationAndFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ getConfiguration.canceled.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        this.this$0.$configurationAndFile.element = this.this$0.this$0.doGetConfiguration(this.this$0.$project, this.this$0.$file);
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = cLionCompileTaskRunner;
                this.$configurationAndFile = objectRef;
                this.$project = project;
                this.$file = virtualFile;
            }
        }, CLionExecutionBundle.message("cpp.compileCurrentFile.resolveProgress.title", new Object[0]), true, project);
        return canceled2 ? new Pair(null, null) : (Pair)configurationAndFile.element;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0003\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CLionCompileTaskRunner$Companion;", "", "()V", "allBuildConfigurationsOfTargetsOfFile", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "rootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "preBuildMessage", "", "currentFile", "buildFile", "taskName", "intellij.clion.execution"})
    public static final class Companion {
        private final String preBuildMessage(Project project, VirtualFile currentFile, VirtualFile buildFile) {
            String string;
            String string2 = VfsUtil.getRelativePath((VirtualFile)buildFile, (VirtualFile)project.getBaseDir());
            if (string2 == null) {
                string2 = buildFile.getPath();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtil.getRelativePath(\u2026aseDir) ?: buildFile.path");
            String relativeBuildPath = string2;
            if (Intrinsics.areEqual((Object)currentFile, (Object)buildFile) ^ true) {
                String string3 = VfsUtil.getRelativePath((VirtualFile)currentFile, (VirtualFile)project.getBaseDir());
                if (string3 == null) {
                    string3 = currentFile.getPath();
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VfsUtil.getRelativePath(\u2026eDir) ?: currentFile.path");
                String relativeCurrentPath = string3;
                String string4 = CLionExecutionBundle.message("cpp.compileCurrentFile.preHeaderBuild.message", relativeBuildPath, relativeCurrentPath);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"CLionExecutionBundle.mes\u2026ath, relativeCurrentPath)");
            } else {
                String string5 = CLionExecutionBundle.message("cpp.compileCurrentFile.preBuild.message", relativeBuildPath);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"CLionExecutionBundle.mes\u2026sage\", relativeBuildPath)");
            }
            return string;
        }

        @NlsActions.ActionText
        private final String taskName(Project project, VirtualFile currentFile) {
            String string = VfsUtil.getRelativePath((VirtualFile)currentFile, (VirtualFile)project.getBaseDir());
            if (string == null) {
                string = currentFile.getPath();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtil.getRelativePath(\u2026eDir) ?: currentFile.path");
            String relativePath = string;
            String string2 = CLionExecutionBundle.message("cpp.compileCurrentFile.task.name", relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CLionExecutionBundle.mes\u2026task.name\", relativePath)");
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<OCResolveConfiguration> allBuildConfigurationsOfTargetsOfFile(@NotNull VirtualFile rootFile, @NotNull Project project) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExtensionPointName extensionPointName = CidrResolveConfigurationProvider.EP_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"CidrResolveConfigurationProvider.EP_NAME");
            List list = extensionPointName.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CidrResolveConfiguration\u2026der.EP_NAME.extensionList");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CidrResolveConfigurationProvider it = (CidrResolveConfigurationProvider)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getAllResolveConfigurationsOfTargetsOfFile(rootFile, project);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

