/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build.runners;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrConfigurationTask;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J4\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CMakeConfigurationTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "()V", "doExecute", "Lcom/jetbrains/cidr/execution/ExecutionResult;", "Lcom/jetbrains/cidr/execution/build/CidrBuildResult;", "project", "Lcom/intellij/openapi/project/Project;", "configurations", "Lcom/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration$BuildAndRunConfigurations;", "execute", "", "task", "Lcom/jetbrains/cidr/execution/build/tasks/CidrConfigurationTask;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "sessionId", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "executeTask", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTask;", "getConfiguration", "intellij.clion.cmake"})
public abstract class CMakeConfigurationTaskRunner
implements CidrTaskRunner {
    @NotNull
    protected abstract ExecutionResult<CidrBuildResult> doExecute(@NotNull Project var1, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations var2);

    private final CMakeAppRunConfiguration.BuildAndRunConfigurations getConfiguration(CidrConfigurationTask task2) {
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations;
        CidrBuildConfiguration cidrBuildConfiguration = task2.getBuildConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)cidrBuildConfiguration, (String)"task.buildConfiguration");
        CidrBuildConfiguration cmakeConfiguration = cidrBuildConfiguration;
        if (cmakeConfiguration instanceof CMakeConfiguration) {
            buildAndRunConfigurations = new CMakeAppRunConfiguration.BuildAndRunConfigurations((CMakeConfiguration)cmakeConfiguration);
        } else {
            CPPLog.LOG.assertTrue(cmakeConfiguration instanceof CMakeExplicitTargetConfiguration);
            CidrBuildConfiguration cidrBuildConfiguration2 = cmakeConfiguration;
            if (cidrBuildConfiguration2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration");
            }
            buildAndRunConfigurations = new CMakeAppRunConfiguration.BuildAndRunConfigurations(((CMakeExplicitTargetConfiguration)cidrBuildConfiguration2).getCmakeConfiguration(), null, null, ((CMakeExplicitTargetConfiguration)cmakeConfiguration).getExplicitBuildTargetName());
        }
        return buildAndRunConfigurations;
    }

    @NotNull
    public Promise<ProjectTaskRunner.Result> executeTask(@NotNull Project project, @NotNull ProjectTask task2, @NotNull Object sessionId, @NotNull ProjectTaskContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CPPLog.LOG.assertTrue(task2 instanceof CidrConfigurationTask);
        AsyncPromise promise = new AsyncPromise();
        this.execute(project, (CidrConfigurationTask)task2, (AsyncPromise<ProjectTaskRunner.Result>)promise, sessionId, context);
        return (Promise)promise;
    }

    public final void execute(@NotNull Project project, @NotNull CidrConfigurationTask task2, @NotNull AsyncPromise<ProjectTaskRunner.Result> promise, @NotNull Object sessionId, @NotNull ProjectTaskContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = this.getConfiguration(task2);
        configurations.putUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY, sessionId);
        ExecutionResult<CidrBuildResult> result = this.doExecute(project, configurations);
        CLionBuildUtil.handleProjectTaskResults(result, promise);
    }

    @NotNull
    public List<ProjectTask> expandTask(@NotNull ProjectTask task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        return CidrTaskRunner.DefaultImpls.expandTask((CidrTaskRunner)this, (ProjectTask)task2);
    }
}

