/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build.runners;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeBuildTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeCleanTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeCompileTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeInstallTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeProjectTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.tasks.CLionInstallTask;
import com.jetbrains.cidr.cpp.notifications.CMakeTrustedProjectsNotificationsKt;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTask;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J7\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0013\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CMakeProjectTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "canRun", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTask", "Lcom/intellij/task/ProjectTask;", "run", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "context", "Lcom/intellij/task/ProjectTaskContext;", "tasks", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/task/ProjectTaskContext;[Lcom/intellij/task/ProjectTask;)Lorg/jetbrains/concurrency/Promise;", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "task", "Companion", "intellij.clion.cmake"})
public final class CMakeProjectTaskRunner
extends CidrProjectTaskRunner {
    @NotNull
    private final String buildSystemId;
    @NotNull
    public static final String ID = "CMake";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getBuildSystemId() {
        return this.buildSystemId;
    }

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
        CMakeWorkspace cMakeWorkspace = CMakeWorkspace.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cMakeWorkspace), (String)"CMakeWorkspace.getInstance(project)");
        CMakeWorkspace workspace = cMakeWorkspace;
        return workspace.isInitialized() && this.canRun(projectTask) && (projectTask instanceof ModuleBuildTask ? Intrinsics.areEqual((Object)((ModuleBuildTask)projectTask).getModule(), (Object)workspace.getModule()) : true);
    }

    @NotNull
    public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
        Promise promise;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        if (TrustedProjects.isTrusted((Project)project)) {
            promise = super.run(project, context, Arrays.copyOf(tasks, tasks.length));
        } else {
            CMakeTrustedProjectsNotificationsKt.showUntrustedCMakeNotification(project);
            promise = Promises.rejectedPromise((String)"Project is not trusted");
        }
        return promise;
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
            Function1 isConfiguration2 = canRun.isConfiguration.1.INSTANCE;
            ProjectTask projectTask2 = projectTask;
            if (projectTask2 instanceof ModuleFilesBuildTask) {
                VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)projectTask).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"projectTask.files");
                VirtualFile[] virtualFileArray2 = virtualFileArray;
                boolean bl2 = false;
                if (virtualFileArray2.length == 0) {
                    bl = false;
                } else {
                    VirtualFile[] virtualFileArray3 = ((ModuleFilesBuildTask)projectTask).getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"projectTask.files");
                    VirtualFile[] $this$all$iv = virtualFileArray3;
                    boolean $i$f$all = false;
                    VirtualFile[] virtualFileArray4 = $this$all$iv;
                    int n = virtualFileArray4.length;
                    for (int i = 0; i < n; ++i) {
                        VirtualFile element$iv;
                        VirtualFile it = element$iv = virtualFileArray4[i];
                        boolean bl3 = false;
                        VirtualFile virtualFile = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                        if (!virtualFile.isDirectory() && (OCFileTypeHelpers.isSourceFile((String)it.getName()) || OCFileTypeHelpers.isHeaderFile((String)it.getName()))) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            } else {
                if (projectTask2 instanceof ModuleBuildTask) {
                    return true;
                }
                if (projectTask2 instanceof CLionInstallTask) {
                    CidrBuildConfiguration cidrBuildConfiguration = ((CLionInstallTask)projectTask).getBuildConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)cidrBuildConfiguration, (String)"projectTask.buildConfiguration");
                    return (Boolean)isConfiguration2.invoke((Object)cidrBuildConfiguration);
                }
                if (projectTask2 instanceof CidrCleanTask) {
                    CidrBuildConfiguration cidrBuildConfiguration = ((CidrCleanTask)projectTask).getBuildConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)cidrBuildConfiguration, (String)"projectTask.buildConfiguration");
                    return (Boolean)isConfiguration2.invoke((Object)cidrBuildConfiguration);
                }
                if (projectTask2 instanceof ProjectModelBuildTask) {
                    ProjectModelBuildableElement projectModelBuildableElement = ((ProjectModelBuildTask)projectTask).getBuildableElement();
                    Intrinsics.checkNotNullExpressionValue((Object)projectModelBuildableElement, (String)"projectTask.buildableElement");
                    return (Boolean)isConfiguration2.invoke((Object)projectModelBuildableElement);
                }
                return false;
            }
        }
        return bl;
    }

    @Nullable
    public CidrTaskRunner runnerForTask(@NotNull ProjectTask task2, @NotNull Project project) {
        CidrTaskRunner cidrTaskRunner;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectTask projectTask = task2;
        if (projectTask instanceof ModuleFilesBuildTask) {
            cidrTaskRunner = new CMakeCompileTaskRunner();
        } else if (projectTask instanceof ModuleBuildTask) {
            cidrTaskRunner = CMakeBuildTaskRunner.INSTANCE;
        } else if (projectTask instanceof ProjectModelBuildTask) {
            cidrTaskRunner = CMakeBuildTaskRunner.INSTANCE;
        } else if (projectTask instanceof CLionInstallTask) {
            cidrTaskRunner = CMakeInstallTaskRunner.INSTANCE;
        } else if (projectTask instanceof CidrCleanTask) {
            cidrTaskRunner = CMakeCleanTaskRunner.INSTANCE;
        } else {
            CPPLog.LOG.error("Unexpected project task type: " + task2.getPresentableName());
            return null;
        }
        return cidrTaskRunner;
    }

    public CMakeProjectTaskRunner() {
        this.buildSystemId = ID;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CMakeProjectTaskRunner$Companion;", "", "()V", "ID", "", "intellij.clion.cmake"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

