/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.compound.migration;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundBuildBeforeRunTaskProviderKt;
import com.jetbrains.cidr.execution.CidrBuildBeforeRunTaskProvider;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class CidrCompoundRunConfigurationConverter
extends ProjectConverter {
    public static final String EMBEDDED_GDBSERVER_TYPE_ID = "com.jetbrains.cidr.embedded.customgdbserver.type";
    static final List<String> MIGRATION_LIST = Arrays.asList("com.jetbrains.cidr.embedded.customgdbserver.type", "com.jetbrains.cidr.remote.gdbserver.type");

    @Nullable
    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new ConversionProcessor<RunManagerSettings>(){

            public boolean isConversionNeeded(RunManagerSettings settings) {
                return settings.getRunConfigurations().stream().anyMatch(x$0 -> CidrCompoundRunConfigurationConverter.isConversionNeeded(x$0));
            }

            public void process(RunManagerSettings settings) throws CannotConvertException {
                settings.getRunConfigurations().stream().filter(x$0 -> CidrCompoundRunConfigurationConverter.isConversionNeeded(x$0)).forEach(x$0 -> CidrCompoundRunConfigurationConverter.convert(x$0));
            }
        };
    }

    private static boolean isConversionNeeded(Element element) {
        return MIGRATION_LIST.contains(element.getAttributeValue("type")) && CidrCompoundRunConfigurationConverter.isConversionOfBeforeRunTaskNeeded(element);
    }

    private static void convert(Element element) {
        Element option = CidrCompoundRunConfigurationConverter.getOptionElement(element);
        if (option != null) {
            option.setAttribute("name", CidrCompoundBuildBeforeRunTaskProviderKt.ID.toString());
            option.setAttribute("enabled", Boolean.TRUE.toString());
        }
    }

    private static boolean isConversionOfBeforeRunTaskNeeded(Element element) {
        Element option = CidrCompoundRunConfigurationConverter.getOptionElement(element);
        return option != null && CidrBuildBeforeRunTaskProvider.ID.toString().equals(option.getAttributeValue("name"));
    }

    @Nullable
    private static Element getOptionElement(Element element) {
        Element method = element.getChild("method");
        return method != null ? method.getChild("option") : null;
    }
}

