/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.coverage.CoverageOptionsConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CidrExecutionUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeBuildOptionsInstaller;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageBuildOptionsInstallerFactory;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageErrorProcessor;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageUtil;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageErrorProcessor;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0003J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\u0011\u001a\u00020\u00102\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J)\u0010\u0016\u001a\u00020\u00042\u000b\u0010\u0017\u001a\u00070\n\u00a2\u0006\u0002\b\u00182\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageErrorProcessor;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageErrorProcessor;", "()V", "doRerunCoverageCallback", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "getFixMessageOnCoverageNotFound", "", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "isAvailable", "isCTestExecution", "isCTestWithLLVMCodeCoverageExecution", "onCodeCoverageNotFound", "", "onException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "rerunCoverageCallback", "tryInstallCoverageOptions", "message", "Lorg/jetbrains/annotations/Nls;", "intellij.clion.coverage"})
public final class CMakeCoverageErrorProcessor
extends CidrCoverageErrorProcessor {
    @Override
    public boolean isAvailable(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof CMakeAppRunConfiguration;
    }

    @Override
    public void onCodeCoverageNotFound(@NotNull RunConfigurationBase<?> configuration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.tryInstallCoverageOptions(this.getFixMessageOnCoverageNotFound(configuration), configuration, project)) {
            super.onCodeCoverageNotFound(configuration, project);
            return;
        }
    }

    @Override
    public void onException(@NotNull Exception exception, @NotNull RunConfigurationBase<?> configuration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (exception instanceof ExecutionException) {
            if (this.isCTestWithLLVMCodeCoverageExecution(configuration)) {
                String string = CidrCoverageBundle.message("coverage.not.found.ctest.fix", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.messa\u2026age.not.found.ctest.fix\")");
                if (this.tryInstallCoverageOptions(string, configuration, project)) {
                    return;
                }
            }
            CidrCoverageLogKt.getCidrCoverageLog().warn("Coverage failed with error", (Throwable)exception);
            String string = CidrCoverageBundle.message("coverage.message.with.configure", exception.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.messa\u2026gure\", exception.message)");
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
            CidrCoverageUtil.Companion.showBalloon(string, messageType, new HyperlinkListener(project){
                final /* synthetic */ Project $project;

                public final void hyperlinkUpdate(HyperlinkEvent event) {
                    HyperlinkEvent hyperlinkEvent = event;
                    Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"event");
                    if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, CoverageOptionsConfigurable.class);
                    }
                }
                {
                    this.$project = project;
                }
            }, project);
            return;
        }
        super.onException(exception, configuration, project);
    }

    private final boolean tryInstallCoverageOptions(String message, RunConfigurationBase<?> configuration, Project project) {
        CMakeCoverageBuildOptionsInstallerFactory buildOptionsInstallerFactory = new CMakeCoverageBuildOptionsInstallerFactory();
        CMakeBuildOptionsInstaller buildOptionsInstaller = buildOptionsInstallerFactory.getInstaller(configuration);
        if (buildOptionsInstaller == null || !buildOptionsInstaller.canInstall(configuration, project)) {
            return false;
        }
        MessageType messageType = MessageType.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
        CidrCoverageUtil.Companion.showBalloon(message, messageType, new HyperlinkListener(this, buildOptionsInstaller, configuration, project){
            final /* synthetic */ CMakeCoverageErrorProcessor this$0;
            final /* synthetic */ CMakeBuildOptionsInstaller $buildOptionsInstaller;
            final /* synthetic */ RunConfigurationBase $configuration;
            final /* synthetic */ Project $project;

            public final void hyperlinkUpdate(HyperlinkEvent event) {
                HyperlinkEvent hyperlinkEvent = event;
                Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"event");
                if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && !this.$buildOptionsInstaller.install((Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ tryInstallCoverageOptions.1 this$0;

                    public final void invoke() {
                        CMakeCoverageErrorProcessor.access$rerunCoverageCallback(this.this$0.this$0, (RunConfiguration)this.this$0.$configuration, this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }), this.$configuration, this.$project)) {
                    CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to add required flags automatically");
                    String string = CidrCoverageBundle.message("coverage.auto.fix.failed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.messa\u2026overage.auto.fix.failed\")");
                    MessageType messageType = MessageType.ERROR;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
                    CidrCoverageUtil.Companion.showBalloon(string, messageType, null, this.$project);
                }
            }
            {
                this.this$0 = cMakeCoverageErrorProcessor;
                this.$buildOptionsInstaller = cMakeBuildOptionsInstaller;
                this.$configuration = runConfigurationBase;
                this.$project = project;
            }
        }, project);
        return true;
    }

    @Nls
    private final String getFixMessageOnCoverageNotFound(RunConfigurationBase<?> configuration) {
        if (this.isCTestWithLLVMCodeCoverageExecution(configuration)) {
            String string = CidrCoverageBundle.message("coverage.not.found.ctest.fix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.messa\u2026age.not.found.ctest.fix\")");
            return string;
        }
        String string = CidrCoverageBundle.message("coverage.not.found.auto.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.messa\u2026rage.not.found.auto.fix\")");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCTestWithLLVMCodeCoverageExecution(RunConfigurationBase<?> configuration) {
        if (!CMakeCoverageUtil.Companion.isCTestConfiguration((RunConfiguration)configuration)) return false;
        RunConfigurationBase<?> runConfigurationBase = configuration;
        if (runConfigurationBase == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.execution.CidrRunConfiguration<*, *>");
        }
        if (!CidrExecutionUtil.compiledWithCompilerSwitches((CidrRunConfiguration)runConfigurationBase, ArraysKt.toList((Object[])CMakeCoverageUtil.Companion.getLLVM_COVERAGE_OPTIONS()))) return false;
        return true;
    }

    private final void rerunCoverageCallback(RunConfiguration configuration, Project project) {
        if (this.isCTestExecution(configuration) || !this.doRerunCoverageCallback(configuration, project)) {
            String string = CidrCoverageBundle.message("coverage.auto.fix.manual.execution", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.messa\u2026to.fix.manual.execution\")");
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.INFO");
            CidrCoverageUtil.Companion.showBalloon(string, messageType, null, project);
        }
    }

    private final boolean isCTestExecution(RunConfiguration configuration) {
        ConfigurationType configurationType = configuration.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.type");
        return Intrinsics.areEqual((Object)configurationType.getId(), (Object)"CTestRunConfiguration");
    }

    private final boolean doRerunCoverageCallback(RunConfiguration configuration, Project project) {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Coverage");
        if (executor == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"ExecutorRegistry.getInst\u2026CUTOR_ID) ?: return false");
        Executor executor2 = executor;
        ExecutionTargetManager executionTargetManager = ExecutionTargetManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)executionTargetManager, (String)"ExecutionTargetManager.getInstance(project)");
        ExecutionTarget executionTarget = executionTargetManager.getActiveTarget();
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"ExecutionTargetManager.g\u2026nce(project).activeTarget");
        ExecutionTarget activeTarget = executionTarget;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).findConfigurationByName(configuration.getName());
        if (runnerAndConfigurationSettings == null) {
            return false;
        }
        RunnerAndConfigurationSettings configurationSettings = runnerAndConfigurationSettings;
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = ExecutionUtil.createEnvironment((Executor)executor2, (RunnerAndConfigurationSettings)configurationSettings);
        if (executionEnvironmentBuilder == null || (executionEnvironmentBuilder = executionEnvironmentBuilder.target(activeTarget)) == null || (executionEnvironmentBuilder = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)executionEnvironmentBuilder, null, (int)1, null)) == null) {
            return false;
        }
        ExecutionEnvironmentBuilder environment2 = executionEnvironmentBuilder;
        environment2.setExecutionId(new ExecutionEnvironment().assignNewExecutionId());
        environment2.getRunner().execute((ExecutionEnvironment)environment2);
        return true;
    }

    public static final /* synthetic */ void access$rerunCoverageCallback(CMakeCoverageErrorProcessor $this, RunConfiguration configuration, Project project) {
        $this.rerunCoverageCallback(configuration, project);
    }
}

