/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CoverageToolFinder;", "", "toolName", "", "preferVersion", "Lcom/intellij/openapi/util/Version;", "userPath", "toolSetDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "(Ljava/lang/String;Lcom/intellij/openapi/util/Version;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;)V", "isPrecalculated", "", "parameters", "", "toolPath", "doFindTool", "findTool", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getToolsToSearch", "", "intellij.clion.coverage"})
public final class CoverageToolFinder {
    private boolean isPrecalculated;
    private String toolPath;
    private List<String> parameters;
    private final String toolName;
    private final Version preferVersion;
    private final String userPath;
    private final String toolSetDirectory;
    private final CidrToolEnvironment environment;

    @Nullable
    public final GeneralCommandLine getCommandLine() {
        if (!this.findTool()) {
            return null;
        }
        return new GeneralCommandLine(new String[]{this.toolPath}).withParameters(this.parameters);
    }

    private final boolean findTool() {
        if (!this.isPrecalculated) {
            this.isPrecalculated = true;
            this.toolPath = this.doFindTool();
            CidrCoverageLogKt.getCidrCoverageLog().info(this.toolName + " to use: " + this.toolPath);
        }
        CharSequence charSequence = this.toolPath;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = this.toolPath;
            Intrinsics.checkNotNull((Object)string);
            if (Intrinsics.areEqual((Object)new File(string).getName(), (Object)"xcrun")) {
                this.parameters.add(this.toolName);
            }
            return true;
        }
        return false;
    }

    private final String doFindTool() {
        block10: {
            block11: {
                File xcrun;
                CharSequence charSequence = this.userPath;
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    return this.userPath;
                }
                List<String> toolsToSearch = this.getToolsToSearch();
                bl2 = false;
                List toolSetFiles = new ArrayList();
                if (this.toolSetDirectory != null) {
                    FileUtil.processFilesRecursively((File)new File(this.toolSetDirectory), (Processor)new Processor(this, toolSetFiles){
                        final /* synthetic */ CoverageToolFinder this$0;
                        final /* synthetic */ List $toolSetFiles;

                        public final boolean process(File file) {
                            File file2 = file;
                            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                            if (file2.isFile()) {
                                String string = file.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                                if (StringsKt.startsWith$default((String)string, (String)CoverageToolFinder.access$getToolName$p(this.this$0), (boolean)false, (int)2, null)) {
                                    this.$toolSetFiles.add(file);
                                }
                            }
                            return true;
                        }
                        {
                            this.this$0 = coverageToolFinder;
                            this.$toolSetFiles = list;
                        }
                    });
                }
                for (String toolToSearch : toolsToSearch) {
                    Object v0;
                    block9: {
                        Iterable iterable = toolSetFiles;
                        boolean bl3 = false;
                        Iterable iterable2 = iterable;
                        boolean bl4 = false;
                        for (Object t : iterable2) {
                            File it = (File)t;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)FilesKt.getNameWithoutExtension((File)it), (Object)toolToSearch)) continue;
                            v0 = t;
                            break block9;
                        }
                        v0 = null;
                    }
                    File toolInToolSetDir = v0;
                    if (toolInToolSetDir != null) {
                        return toolInToolSetDir.getPath();
                    }
                    File toolInPath = PathEnvironmentVariableUtil.findInPath((String)toolToSearch);
                    if (toolInPath == null) continue;
                    return toolInPath.getPath();
                }
                if (SystemInfo.isMac && (xcrun = PathEnvironmentVariableUtil.findInPath((String)"xcrun")) != null) {
                    return xcrun.getPath();
                }
                if (!(this.environment instanceof CPPEnvironment)) break block10;
                CPPToolSet cPPToolSet = ((CPPEnvironment)this.environment).getToolSet();
                Intrinsics.checkNotNullExpressionValue((Object)cPPToolSet, (String)"environment.toolSet");
                if (cPPToolSet.isWSL()) break block11;
                HostMachine hostMachine = ((CPPEnvironment)this.environment).getHostMachine();
                Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
                if (!hostMachine.isRemote()) break block10;
            }
            return this.toolSetDirectory != null ? FileUtil.join((String[])new String[]{this.toolSetDirectory, this.toolName}) : FileUtil.join((String[])new String[]{"/usr/bin", this.toolName});
        }
        return null;
    }

    private final List<String> getToolsToSearch() {
        boolean bl = false;
        List toolsToSearch = new ArrayList();
        if (this.preferVersion != null) {
            if (SystemInfo.isMac) {
                CollectionsKt.addAll((Collection)toolsToSearch, (Object[])new String[]{this.toolName + "-mp-" + this.preferVersion.major + '.' + this.preferVersion.minor + '.' + this.preferVersion.bugfix, this.toolName + "-mp-" + this.preferVersion.major + '.' + this.preferVersion.minor, this.toolName + "-mp-" + this.preferVersion.major, this.toolName + "-mp"});
            }
            CollectionsKt.addAll((Collection)toolsToSearch, (Object[])new String[]{this.toolName + '-' + this.preferVersion.major + '.' + this.preferVersion.minor + '.' + this.preferVersion.bugfix, this.toolName + '-' + this.preferVersion.major + '.' + this.preferVersion.minor, this.toolName + '-' + this.preferVersion.major, this.toolName});
            return toolsToSearch;
        }
        return CollectionsKt.listOf((Object)this.toolName);
    }

    public CoverageToolFinder(@NotNull String toolName, @Nullable Version preferVersion, @Nullable String userPath, @Nullable String toolSetDirectory, @NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        this.toolName = toolName;
        this.preferVersion = preferVersion;
        this.userPath = userPath;
        this.toolSetDirectory = toolSetDirectory;
        this.environment = environment2;
        boolean bl = false;
        this.parameters = new ArrayList();
    }

    public static final /* synthetic */ String access$getToolName$p(CoverageToolFinder $this) {
        return $this.toolName;
    }
}

