/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.jetbrains.cidr.cpp.execution.debugger.CLionLocalAttachGroup;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionGDBDriverConfiguration;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionLLDBDriverConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUIUtils;
import com.jetbrains.cidr.execution.debugger.CidrCustomDebuggerProvider;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.toolchains.OSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLionLocalAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final Key<List<XLocalAttachDebugger>> DEBUGGERS_KEY = Key.create((String)"CLionLocalAttachDebuggerProvider.DEBUGGERS");
    private final boolean myFilterUnsupported;
    private final boolean myHasBundledLLDB;

    public CLionLocalAttachDebuggerProvider() {
        this(true, LLDBDriverConfiguration.hasBundledLLDB());
    }

    public CLionLocalAttachDebuggerProvider(boolean filterUnsupported, boolean hasBundledLLDB) {
        this.myFilterUnsupported = filterUnsupported;
        this.myHasBundledLLDB = hasBundledLLDB;
    }

    @NotNull
    public XAttachPresentationGroup<ProcessInfo> getPresentationGroup() {
        CLionLocalAttachGroup cLionLocalAttachGroup = CLionLocalAttachGroup.INSTANCE;
        if (cLionLocalAttachGroup == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return cLionLocalAttachGroup;
    }

    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        List<XLocalAttachDebugger> result;
        if (project == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        if (processInfo == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if (contextHolder == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if ((result = (List<XLocalAttachDebugger>)contextHolder.getUserData(DEBUGGERS_KEY)) != null) {
            List<XLocalAttachDebugger> list = result;
            if (list == null) {
                CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<CidrLocalAttachDebugger> debuggers = new ArrayList<CidrLocalAttachDebugger>();
        CPPToolchains.Toolchain toolchain = this.getToolchain();
        if (toolchain != null) {
            boolean isLLDBUsed = toolchain.getDebuggerKind().isLLDB();
            if (!isLLDBUsed) {
                debuggers.add(CLionLocalAttachDebuggerProvider.createGDBDebugger(project, toolchain));
            }
            if (isLLDBUsed || this.myHasBundledLLDB) {
                debuggers.add(CPPToolchainsUIUtils.showLLDBFirst((OSType)toolchain.getOSType()) ? 0 : debuggers.size(), CLionLocalAttachDebuggerProvider.createLLDBDebugger(project, toolchain));
            }
        }
        for (CidrCustomDebuggerProvider eachProvider : CidrCustomDebuggerProvider.EP_NAME.getExtensionList()) {
            for (DebuggerDriverConfiguration eachConfig : eachProvider.getDebuggerConfigurations()) {
                debuggers.add(new CidrLocalAttachDebugger(eachConfig));
            }
        }
        if (this.myFilterUnsupported) {
            debuggers = ContainerUtil.filter(debuggers, debugger -> debugger.getConfiguration().isAttachSupported());
        }
        result = Collections.unmodifiableList(debuggers);
        contextHolder.putUserData(DEBUGGERS_KEY, result);
        List<XLocalAttachDebugger> list = result;
        if (list == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    protected CPPToolchains.Toolchain getToolchain() {
        return CPPToolchains.getInstance().getDefaultToolchain();
    }

    @NotNull
    public static CidrLocalAttachDebugger createLLDBDebugger(@NotNull Project project, @NotNull CPPToolchains.Toolchain toolchain) {
        if (project == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(6);
        }
        if (toolchain == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(7);
        }
        return new CidrLocalAttachDebugger((DebuggerDriverConfiguration)new CLionLLDBDriverConfiguration(project, toolchain));
    }

    @NotNull
    public static CidrLocalAttachDebugger createGDBDebugger(@NotNull Project project, @NotNull CPPToolchains.Toolchain toolchain) {
        if (project == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(8);
        }
        if (toolchain == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(9);
        }
        return new CidrLocalAttachDebugger((DebuggerDriverConfiguration)new CLionGDBDriverConfiguration(project, toolchain));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CLionLocalAttachDebuggerProvider";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CLionLocalAttachDebuggerProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLLDBDebugger";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGDBDebugger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

