/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileDataKeys;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.actions.MemoryProfileExportAction;
import com.jetbrains.cidr.cpp.profiling.actions.MemoryProfileGroupByDirectoryAction;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileStackFrameTreeNode;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTree;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTreeNode;
import com.jetbrains.cidr.cpp.profiling.ui.MemoryProfileAutoScrollToSourceHandler;
import com.jetbrains.cidr.cpp.profiling.ui.MemoryProfileExclusionHandler;
import com.jetbrains.cidr.cpp.profiling.ui.MemoryProfileNoPreviewPanel;
import com.jetbrains.cidr.cpp.profiling.ui.MemoryProfileOccurenceNavigator;
import com.jetbrains.cidr.cpp.profiling.ui.MemoryProfileStackFramePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfileOutputPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    private final MemoryProfileTreeDataModel myTreeDataModel;
    @NotNull
    private final String myEditSettingsActionId;
    @NotNull
    private final String myTreePopupId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MemoryProfileTree myTree;
    @NotNull
    private final MemoryProfileNoPreviewPanel myNoPreviewPanel;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final MemoryProfileOccurenceNavigator myOccurenceNavigator;
    @NotNull
    private final MemoryProfileAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    @NotNull
    private final MemoryProfileExclusionHandler myExclusionHandler;
    @NotNull
    private final MemoryProfileExportAction myExportAction;
    @NotNull
    private final List<ActionToolbar> myToolbars;

    public MemoryProfileOutputPanel(@NotNull MemoryProfileTreeDataModel treeDataModel, @NonNls @NotNull String editSettingsActionId, @NonNls @NotNull String treePopupId, @NotNull Project project) {
        if (treeDataModel == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(0);
        }
        if (editSettingsActionId == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(1);
        }
        if (treePopupId == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(3);
        }
        this.myToolbars = new ArrayList<ActionToolbar>();
        this.myTreeDataModel = treeDataModel;
        this.myEditSettingsActionId = editSettingsActionId;
        this.myTreePopupId = treePopupId;
        this.myProject = project;
        this.myTree = new MemoryProfileTree(treeDataModel);
        this.myNoPreviewPanel = new MemoryProfileNoPreviewPanel();
        this.mySplitter = new OnePixelSplitter(false, 0.5f);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.setSecondComponent((JComponent)this.myNoPreviewPanel);
        this.myOccurenceNavigator = new MemoryProfileOccurenceNavigator(this.myTree);
        this.myAutoScrollToSourceHandler = new MemoryProfileAutoScrollToSourceHandler();
        this.myExclusionHandler = new MemoryProfileExclusionHandler(this.myTree);
        this.myExportAction = new MemoryProfileExportAction(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySplitter, "Center");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.addActionToolbars();
            this.configureTreeListeners();
        }
        this.updatePreviewPanel();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    private void configureTreeListeners() {
        this.myTree.getSelectionModel().addTreeSelectionListener(event -> {
            this.updatePreviewPanel();
            if (this.myAutoScrollToSourceHandler.isAutoScrollMode()) {
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)this), (boolean)false);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this.myTree));
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)this.myTreePopupId, (String)"CodeInspection");
    }

    private void updatePreviewPanel() {
        this.disposePreviewPanel();
        MemoryProfileTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode instanceof MemoryProfileStackFrameTreeNode) {
            MemoryProfileFrame frameToPreview = ((MemoryProfileStackFrameTreeNode)selectedNode).getFrame();
            this.mySplitter.setSecondComponent((JComponent)new MemoryProfileStackFramePreviewPanel(frameToPreview, this.myProject));
        } else {
            this.mySplitter.setSecondComponent((JComponent)this.myNoPreviewPanel);
        }
    }

    private void addActionToolbars() {
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.add((Component)this.createLeftActionsToolbar(), "West");
        actionPanel.add((Component)this.createRightActionsToolbar(), "East");
        this.add((Component)actionPanel, "West");
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        actionGroup.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        actionGroup.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        actionGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        actionGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        return this.createToolbar(actionGroup);
    }

    private JComponent createRightActionsToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MemoryProfileGroupByDirectoryAction(this.myTree, this.myTreeDataModel));
        actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        actionGroup.add((AnAction)this.myExportAction);
        actionGroup.add(ActionManager.getInstance().getAction(this.myEditSettingsActionId));
        return this.createToolbar(actionGroup);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(4);
        }
        if (ExclusionHandler.EXCLUSION_HANDLER.is(dataId)) {
            return this.myExclusionHandler;
        }
        if (MemoryProfileDataKeys.TREE.is(dataId)) {
            return this.myTree;
        }
        if (MemoryProfileDataKeys.TREE_MODEL.is(dataId)) {
            return this.myTreeDataModel;
        }
        MemoryProfileTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return null;
        }
        if (MemoryProfileDataKeys.SELECTED_NODE.is(dataId)) {
            return selectedNode;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return selectedNode.getNavigatable();
        }
        return null;
    }

    public void dispose() {
        this.disposePreviewPanel();
    }

    private MemoryProfileTreeNode getSelectedNode() {
        int selectionCount = this.myTree.getSelectionModel().getSelectionCount();
        if (selectionCount != 1) {
            return null;
        }
        TreePath selectionPath = this.myTree.getSelectionModel().getSelectionPath();
        return selectionPath != null ? (MemoryProfileTreeNode)selectionPath.getLastPathComponent() : null;
    }

    private JComponent createToolbar(DefaultActionGroup actionGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)actionGroup, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myTree));
        this.myToolbars.add(toolbar);
        return toolbar.getComponent();
    }

    @NotNull
    public MemoryProfileTree getTree() {
        MemoryProfileTree memoryProfileTree = this.myTree;
        if (memoryProfileTree == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(5);
        }
        return memoryProfileTree;
    }

    @NotNull
    public MemoryProfileTreeDataModel getTreeDataModel() {
        MemoryProfileTreeDataModel memoryProfileTreeDataModel = this.myTreeDataModel;
        if (memoryProfileTreeDataModel == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(6);
        }
        return memoryProfileTreeDataModel;
    }

    public void setExportContent(@NotNull String exportContent) {
        if (exportContent == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(7);
        }
        this.myExportAction.setContentToExport(exportContent);
        this.updateActionsImmediately();
    }

    private void updateActionsImmediately() {
        this.myToolbars.forEach(toolbar -> toolbar.updateActionsImmediately());
    }

    private void disposePreviewPanel() {
        JComponent component = this.mySplitter.getSecondComponent();
        if (component instanceof MemoryProfileStackFramePreviewPanel) {
            Disposer.dispose((Disposable)((Disposable)component));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeDataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editSettingsActionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePopupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/profiling/ui/MemoryProfileOutputPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/ui/MemoryProfileOutputPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setExportContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

