/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.CLionProfilingBundle;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileConsoleViewWrapper;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileFileReader;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileFileWatcher;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileUtil;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTree;
import com.jetbrains.cidr.cpp.profiling.ui.MemoryProfileOutputPanel;
import com.jetbrains.cidr.cpp.sanitizers.SanitizersUtil;
import com.jetbrains.cidr.cpp.valgrind.ValgrindCommandLineParametersBuilder;
import com.jetbrains.cidr.cpp.valgrind.ValgrindConfigurable;
import com.jetbrains.cidr.cpp.valgrind.ValgrindExecutor;
import com.jetbrains.cidr.cpp.valgrind.ValgrindHandler;
import com.jetbrains.cidr.cpp.valgrind.ValgrindOutputConsumer;
import com.jetbrains.cidr.cpp.valgrind.ValgrindSettings;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindConfigurationExtension
extends CidrRunConfigurationExtensionBase {
    public static final Key<Path> OUTPUT_DIRECTORY_KEY = Key.create((String)"valgrind.output_directory_key");
    public static final Key<Path> SUPPRESSION_FILES_REMOTE_DIR_KEY = Key.create((String)"valgrind.output.suppression.files.remote.dir");
    public static final Key<MemoryProfileTreeDataModel> DATA_MODEL_KEY = Key.create((String)"valgrind.data_model_key");
    public static final Key<MemoryProfileOutputPanel> OUTPUT_PANEL_KEY = Key.create((String)"valgrind.output_panel_key");

    public boolean isApplicableFor(@NotNull CidrRunConfiguration configuration) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(0);
        }
        return ValgrindConfigurationExtension.isApplicableForConfiguration((RunProfile)configuration);
    }

    public static boolean isApplicableForConfiguration(@NotNull RunProfile configuration) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(1);
        }
        return !configuration.getClass().getName().contains("GdbServerRunConfiguration") && !configuration.getClass().getName().contains("CidrCoreDumpRunConfiguration");
    }

    public boolean isEnabledFor(@NotNull CidrRunConfiguration applicableConfiguration, @NotNull CidrToolEnvironment environment2, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void patchCommandLine(@NotNull CidrRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment2, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) throws ExecutionException {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (cmdLine == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(8);
        }
        if (!"ValgrindRunner".equals(runnerId)) {
            return;
        }
        HostMachine host = environment2.getHostMachine();
        String programPath = environment2.toEnvPath(cmdLine.getExePath());
        String valgrindPath = environment2.toEnvPath(ValgrindSettings.getInstance().getValgrindPath());
        if (!Files.exists(host.getPath(programPath, new String[0]), new LinkOption[0])) {
            throw new ExecutionException(CLionExecutionBundle.message("run.fileNotFound", programPath));
        }
        Project project = configuration.getProject();
        if (StringUtil.isEmpty((String)valgrindPath) || !Files.exists(host.getPath(valgrindPath, new String[0]), new LinkOption[0])) {
            throw new HyperlinkException(CLionProfilingBundle.message("valgrind.fileNotFound", valgrindPath), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, ValgrindConfigurable.class));
        }
        if (SanitizersUtil.compiledWithSanitizeSwitch(configuration)) {
            MemoryProfileUtil.showNotification("Valgrind", null, CLionProfilingBundle.message("valgrind.sanitizers", new Object[0]), NotificationType.WARNING, project);
        }
        try {
            Path outputDirectory = ValgrindConfigurationExtension.generateOutputDirectory(environment2);
            String outputFile = FileUtil.join((String[])new String[]{outputDirectory.toString(), "valgrind_output_%p"});
            String outputFilePath = environment2.toEnvPath(outputFile);
            cmdLine.setExePath(valgrindPath);
            ValgrindCommandLineParametersBuilder parametersBuilder = new ValgrindCommandLineParametersBuilder();
            List<String> suppressionFiles = this.prepareSuppressionFiles(environment2, configuration, context, project);
            List<String> valgrindParameters = parametersBuilder.build(ValgrindSettings.getInstance().getAnalysisOptions(), suppressionFiles, outputFilePath);
            if (ValgrindConfigurationExtension.isCTestExecution(configuration) && !parametersBuilder.tryAppend("--trace-children", "yes", valgrindParameters)) {
                MemoryProfileUtil.showNotification("Valgrind", null, CLionProfilingBundle.message("valgrind.ctest.invalid.trace.children.parameter", new Object[0]), NotificationType.WARNING, project);
            }
            valgrindParameters.add(programPath);
            cmdLine.getParametersList().prependAll(ArrayUtilRt.toStringArray(valgrindParameters));
            ValgrindConfigurationExtension.putUserData(OUTPUT_DIRECTORY_KEY, outputDirectory, configuration, context);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    public void attachToProcess(@NotNull CidrRunConfiguration configuration, @NotNull ProcessHandler processHandler, @NotNull CidrToolEnvironment environment2, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(10);
        }
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(12);
        }
        if (context == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(13);
        }
        Path outputDirectory = ValgrindConfigurationExtension.getUserData(OUTPUT_DIRECTORY_KEY, configuration, context);
        if (!"ValgrindRunner".equals(runnerId)) {
            if (outputDirectory != null) {
                MemoryProfileUtil.deleteDirectorySilently(outputDirectory, this.LOG);
            }
            return;
        }
        this.LOG.assertTrue(outputDirectory != null, (Object)"outputDirectory is null");
        Project project = configuration.getProject();
        MemoryProfileTreeDataModel treeDataModel = ValgrindConfigurationExtension.getUserData(DATA_MODEL_KEY, configuration, context);
        this.LOG.assertTrue(treeDataModel != null, (Object)"treeDataModel is null");
        MemoryProfileOutputPanel outputPanel = ValgrindConfigurationExtension.getUserData(OUTPUT_PANEL_KEY, configuration, context);
        this.LOG.assertTrue(outputPanel != null, (Object)"outputPanel is null");
        final MemoryProfileTree tree = outputPanel.getTree();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                MemoryProfileUtil.setTreeBusy(tree, CLionProfilingBundle.message("valgrind.progress", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension$1", "startNotified"));
            }
        });
        if (environment2.getHostMachine().isRemote()) {
            Path suppressionFilesDirectory = (Path)context.getUserData(SUPPRESSION_FILES_REMOTE_DIR_KEY);
            this.processOutputFromRemote(treeDataModel, outputPanel, outputDirectory, suppressionFilesDirectory, processHandler, environment2, project);
        } else {
            this.processLocalOutput(treeDataModel, outputPanel, outputDirectory, processHandler, environment2, project);
        }
    }

    private void processOutputFromRemote(final @NotNull MemoryProfileTreeDataModel treeDataModel, final @NotNull MemoryProfileOutputPanel outputPanel, final @NotNull Path outputDirectory, final @Nullable Path suppressionFilesDirectory, @NotNull ProcessHandler processHandler, final @NotNull CidrToolEnvironment environment2, final @NotNull Project project) {
        if (treeDataModel == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (outputPanel == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(15);
        }
        if (outputDirectory == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(16);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(17);
        }
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(18);
        }
        if (project == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(19);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                MemoryProfileUtil.processOutputFromRemote("Valgrind", () -> {
                    Disposable disposableMarker = Disposer.newDisposable();
                    Disposer.register((Disposable)project, (Disposable)disposableMarker);
                    try {
                        List<Path> outputFilePaths = MemoryProfileUtil.getFiles(outputDirectory);
                        for (Path outputFilePath : outputFilePaths) {
                            ValgrindOutputConsumer consumer = new ValgrindOutputConsumer(new ValgrindHandler(treeDataModel, environment2), disposableMarker);
                            MemoryProfileFileReader reader = new MemoryProfileFileReader(outputFilePath, (Consumer<String>)consumer, "Valgrind");
                            reader.stop();
                        }
                        ValgrindConfigurationExtension.this.processExportAction(outputPanel, outputDirectory);
                    }
                    catch (Exception e) {
                        ValgrindConfigurationExtension.this.LOG.error("Cannot process Valgrind output", (Throwable)e);
                    }
                    finally {
                        MemoryProfileUtil.setTreeDataReady(outputPanel.getTree());
                        Disposer.dispose((Disposable)disposableMarker);
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            MemoryProfileUtil.deleteDirectorySilently(outputDirectory, ValgrindConfigurationExtension.this.LOG);
                            if (suppressionFilesDirectory != null) {
                                MemoryProfileUtil.deleteDirectorySilently(suppressionFilesDirectory, ValgrindConfigurationExtension.this.LOG);
                            }
                        }
                    }
                }, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension$2", "processTerminated"));
            }
        });
    }

    private void processLocalOutput(@NotNull MemoryProfileTreeDataModel treeDataModel, final @NotNull MemoryProfileOutputPanel outputPanel, final @NotNull Path outputDirectory, @NotNull ProcessHandler processHandler, @NotNull CidrToolEnvironment environment2, @NotNull Project project) {
        if (treeDataModel == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(20);
        }
        if (outputPanel == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(21);
        }
        if (outputDirectory == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(22);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(23);
        }
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(25);
        }
        final Disposable disposableMarker = Disposer.newDisposable();
        Disposer.register((Disposable)project, (Disposable)disposableMarker);
        Supplier<Consumer> consumerSupplier = () -> new ValgrindOutputConsumer(new ValgrindHandler(treeDataModel, environment2), disposableMarker);
        VirtualFile outputDirectoryVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outputDirectory.toFile());
        this.LOG.assertTrue(outputDirectoryVirtualFile != null && outputDirectoryVirtualFile.exists(), (Object)"Output virtual directory is null or not found");
        final MemoryProfileFileWatcher watcher = new MemoryProfileFileWatcher(outputDirectoryVirtualFile, consumerSupplier, "Valgrind", project, disposableMarker);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    watcher.stop();
                    ValgrindConfigurationExtension.this.processExportAction(outputPanel, outputDirectory);
                }
                finally {
                    MemoryProfileUtil.setTreeDataReady(outputPanel.getTree());
                    Disposer.dispose((Disposable)disposableMarker);
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        MemoryProfileUtil.deleteDirectorySilently(outputDirectory, ValgrindConfigurationExtension.this.LOG);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension$3", "processTerminated"));
            }
        });
    }

    public void patchCommandLineState(@NotNull CidrRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment2, @Nullable File projectBaseDir, @NotNull CommandLineState state, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(26);
        }
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(27);
        }
        if (state == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(28);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(29);
        }
        if (context == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(30);
        }
        if (!"ValgrindRunner".equals(runnerId)) {
            return;
        }
        final Project project = configuration.getProject();
        MemoryProfileTreeDataModel treeDataModel = new MemoryProfileTreeDataModel("Valgrind", project);
        final MemoryProfileOutputPanel outputPanel = new MemoryProfileOutputPanel(treeDataModel, "Valgrind.EditSettings", "ValgrindToolWindow.TreePopup", project);
        ValgrindConfigurationExtension.putUserData(DATA_MODEL_KEY, treeDataModel, configuration, context);
        ValgrindConfigurationExtension.putUserData(OUTPUT_PANEL_KEY, outputPanel, configuration, context);
        final ConsoleView console = state.getConsoleBuilder().getConsole();
        state.setConsoleBuilder((TextConsoleBuilder)new CidrConsoleBuilder(project, environment2, projectBaseDir == null ? null : projectBaseDir.toPath()){

            @NotNull
            public ConsoleView getConsole() {
                Icon icon = ValgrindExecutor.getExecutorInstance().getIcon();
                return new MemoryProfileConsoleViewWrapper("Valgrind", console, outputPanel, project, icon);
            }
        });
    }

    @NotNull
    private static Path generateOutputDirectory(@NotNull CidrToolEnvironment environment2) throws IOException {
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(31);
        }
        @NlsSafe String valgrindOutputFilePrefix = "clion-valgrind";
        String uniqueSuffix = UUID.randomUUID().toString();
        Path path = environment2.getHostMachine().createTempDirectory("clion-valgrind", uniqueSuffix);
        if (path == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(32);
        }
        return path;
    }

    private void processExportAction(@NotNull MemoryProfileOutputPanel outputPanel, @NotNull Path outputDirectory) {
        if (outputPanel == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(33);
        }
        if (outputDirectory == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(34);
        }
        String exportContent = this.getExportContent(outputDirectory);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (StringUtil.isNotEmpty((String)exportContent)) {
                outputPanel.setExportContent(exportContent);
            }
        });
    }

    private static boolean isCTestExecution(@NotNull CidrRunConfiguration configuration) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(35);
        }
        return configuration.getType().getId().equals("CTestRunConfiguration");
    }

    @Nullable
    private String getExportContent(@NotNull Path outputDirectory) {
        if (outputDirectory == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(36);
        }
        try {
            List<Path> filePaths = MemoryProfileUtil.getFiles(outputDirectory);
            StringBuilder content = new StringBuilder();
            for (Path filePath : filePaths) {
                content.append(Files.readString(filePath)).append(System.lineSeparator());
            }
            return content.toString();
        }
        catch (Exception e) {
            this.LOG.error("Cannot load Valgrind output for Export action", (Throwable)e);
            return null;
        }
    }

    private List<String> prepareSuppressionFiles(@NotNull CidrToolEnvironment environment2, @NotNull CidrRunConfiguration configuration, @NotNull ConfigurationExtensionContext context, @NotNull Project project) {
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(37);
        }
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(38);
        }
        if (context == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(39);
        }
        if (project == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(40);
        }
        return (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.doPrepareSuppressionFiles(environment2, configuration, context), CLionProfilingBundle.message("valgrind.prepare.suppression.files", new Object[0]), false, project);
    }

    @NotNull
    private List<String> doPrepareSuppressionFiles(@NotNull CidrToolEnvironment environment2, @NotNull CidrRunConfiguration configuration, @NotNull ConfigurationExtensionContext context) {
        ArrayList<String> arrayList;
        if (environment2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(41);
        }
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(42);
        }
        if (context == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(43);
        }
        List<String> localSuppressionFiles = ValgrindSettings.getInstance().getSuppressionFiles();
        if (!environment2.getHostMachine().isRemote() || localSuppressionFiles.isEmpty()) {
            List<String> list = localSuppressionFiles;
            if (list == null) {
                ValgrindConfigurationExtension.$$$reportNull$$$0(44);
            }
            return list;
        }
        try {
            ArrayList<String> envSuppressionFiles = new ArrayList<String>(localSuppressionFiles.size());
            Path envDirPath = environment2.getHostMachine().createTempDirectory("clion-valgrind-suppressions", null);
            ValgrindConfigurationExtension.putUserData(SUPPRESSION_FILES_REMOTE_DIR_KEY, envDirPath, configuration, context);
            for (String localSuppressionFile : localSuppressionFiles) {
                if (!FileUtil.exists((String)localSuppressionFile)) continue;
                Path envSuppressionFilePath = Files.createTempFile(envDirPath, "valgrind_suppression_file", null, new FileAttribute[0]);
                Files.writeString(envSuppressionFilePath, (CharSequence)FileUtil.loadFile((File)new File(localSuppressionFile)), new OpenOption[0]);
                envSuppressionFiles.add(environment2.toEnvPath(envSuppressionFilePath.toString()));
            }
            arrayList = envSuppressionFiles;
        }
        catch (Exception e) {
            this.LOG.error("Cannot create environment suppression files", (Throwable)e);
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ValgrindConfigurationExtension.$$$reportNull$$$0(46);
            }
            return list;
        }
        if (arrayList == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    private static <T> void putUserData(@NotNull Key<T> key, T value, @NotNull CidrRunConfiguration configuration, @NotNull ConfigurationExtensionContext context) {
        if (key == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(47);
        }
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(48);
        }
        if (context == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(49);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            configuration.putUserData(key, value);
        } else {
            context.putUserData(key, value);
        }
    }

    private static <T> T getUserData(@NotNull Key<T> key, @NotNull CidrRunConfiguration configuration, @NotNull ConfigurationExtensionContext context) {
        if (key == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(50);
        }
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(51);
        }
        if (context == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(52);
        }
        return (T)(ApplicationManager.getApplication().isUnitTestMode() ? configuration.getUserData(key) : context.getUserData(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 32: 
            case 44: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 32: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 18: 
            case 24: 
            case 27: 
            case 31: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 7: 
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 8: 
            case 13: 
            case 30: 
            case 39: 
            case 43: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeDataModel";
                break;
            }
            case 15: 
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPanel";
                break;
            }
            case 16: 
            case 22: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 19: 
            case 25: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "generateOutputDirectory";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "doPrepareSuppressionFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableForConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processOutputFromRemote";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processLocalOutput";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineState";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateOutputDirectory";
                break;
            }
            case 32: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processExportAction";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isCTestExecution";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExportContent";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "prepareSuppressionFiles";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "doPrepareSuppressionFiles";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 32: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HyperlinkException
    extends ExecutionException
    implements HyperlinkListener {
        @NotNull
        private final Runnable myHyperlinkEventRunnable;

        HyperlinkException(@NotNull @NlsContexts.DialogMessage String cause, @NotNull Runnable hyperlinkEventRunnable) {
            if (cause == null) {
                HyperlinkException.$$$reportNull$$$0(0);
            }
            if (hyperlinkEventRunnable == null) {
                HyperlinkException.$$$reportNull$$$0(1);
            }
            super(cause);
            this.myHyperlinkEventRunnable = hyperlinkEventRunnable;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myHyperlinkEventRunnable.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hyperlinkEventRunnable";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension$HyperlinkException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

