/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileError;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileProblemDescription;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileStack;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValgrindHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(ValgrindHandler.class);
    @NlsSafe
    private static final String ERROR_ELEMENT = "error";
    @NlsSafe
    private static final String KIND_ELEMENT = "kind";
    @NlsSafe
    private static final String WHAT_ELEMENT = "what";
    @NlsSafe
    private static final String XWHAT_ELEMENT = "xwhat";
    @NlsSafe
    private static final String STACK_ELEMENT = "stack";
    @NlsSafe
    private static final String FRAME_ELEMENT = "frame";
    @NlsSafe
    private static final String IP_ELEMENT = "ip";
    @NlsSafe
    private static final String OBJ_ELEMENT = "obj";
    @NlsSafe
    private static final String FN_ELEMENT = "fn";
    @NlsSafe
    private static final String DIR_ELEMENT = "dir";
    @NlsSafe
    private static final String FILE_ELEMENT = "file";
    @NlsSafe
    private static final String LINE_ELEMENT = "line";
    @NlsSafe
    private static final String TEXT_ELEMENT = "text";
    @NlsSafe
    private static final String AUXWHAT_ELEMENT = "auxwhat";
    @NlsSafe
    private static final String XAUXWHAT_ELEMENT = "xauxwhat";
    @NlsSafe
    private static final String SUPPRESSION_ELEMENT = "suppression";
    @NlsSafe
    private static final String RAW_TEXT_ELEMENT = "rawtext";
    @NlsSafe
    private static final String CDATA_BEGIN = "<![CDATA[";
    @NlsSafe
    private static final String CDATA_END = "]]>";
    @NotNull
    private final MemoryProfileTreeDataModel myModel;
    private final CidrToolEnvironment myEnvironment;
    private boolean myInsideErrorElement;
    private boolean myInsideXWhatElement;
    private boolean myInsideSuppression;
    private MemoryProfileError myCurrentError;
    private StringBuilder myElementText;

    public ValgrindHandler(@NotNull MemoryProfileTreeDataModel model, @NotNull CidrToolEnvironment environment2) {
        if (model == null) {
            ValgrindHandler.$$$reportNull$$$0(0);
        }
        if (environment2 == null) {
            ValgrindHandler.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myEnvironment = environment2;
        this.myInsideErrorElement = false;
        this.myInsideXWhatElement = false;
        this.myInsideSuppression = false;
        this.myCurrentError = null;
        this.myElementText = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ERROR_ELEMENT)) {
            this.myInsideErrorElement = true;
            this.startNewError();
            this.clearTextBuffer();
            return;
        }
        if (!this.myInsideErrorElement) {
            return;
        }
        if (qName.equals(XWHAT_ELEMENT) || qName.equals(XAUXWHAT_ELEMENT)) {
            this.myInsideXWhatElement = true;
        }
        if (qName.equals(WHAT_ELEMENT) || qName.equals(XWHAT_ELEMENT) || qName.equals(AUXWHAT_ELEMENT) || qName.equals(XAUXWHAT_ELEMENT)) {
            this.myCurrentError.getProblemDescriptions().add(new MemoryProfileProblemDescription(""));
        } else if (qName.equals(STACK_ELEMENT)) {
            if (this.myCurrentError.getProblemDescriptions().isEmpty() || !this.getCurrentProblemDescription().getStack().isEmpty()) {
                this.myCurrentError.getProblemDescriptions().add(new MemoryProfileProblemDescription(""));
            }
        } else if (qName.equals(FRAME_ELEMENT)) {
            this.getCurrentStack().pushFrame(new MemoryProfileFrame());
        } else if (qName.equals(SUPPRESSION_ELEMENT)) {
            this.myInsideSuppression = true;
        }
        this.clearTextBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myInsideErrorElement) {
            this.myElementText.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.myInsideErrorElement) {
            this.clearTextBuffer();
            return;
        }
        if (this.myInsideSuppression) {
            if (qName.equals(SUPPRESSION_ELEMENT)) {
                this.myInsideSuppression = false;
            } else if (qName.equals(RAW_TEXT_ELEMENT)) {
                String rawText = this.myElementText.toString();
                this.myCurrentError.setSuppression(ValgrindHandler.removeCDataFromRawText(rawText));
            }
            this.clearTextBuffer();
            return;
        }
        if (this.myInsideXWhatElement) {
            if (qName.equals(TEXT_ELEMENT)) {
                this.getCurrentProblemDescription().appendText(this.myElementText.toString());
            } else if (qName.equals(XWHAT_ELEMENT) || qName.equals(XAUXWHAT_ELEMENT)) {
                this.myInsideXWhatElement = false;
            }
        } else if (qName.equals(ERROR_ELEMENT)) {
            this.myInsideErrorElement = false;
            MemoryProfileError error = this.myCurrentError;
            LOG.debug("Adding error to model: " + error.getKind());
            ApplicationManager.getApplication().invokeLater(() -> this.myModel.addError(error));
        } else if (qName.equals(KIND_ELEMENT)) {
            this.myCurrentError.setKind(this.myElementText.toString());
        } else if (qName.equals(WHAT_ELEMENT) || qName.equals(AUXWHAT_ELEMENT)) {
            this.getCurrentProblemDescription().appendText(this.myElementText.toString());
        } else if (qName.equals(IP_ELEMENT)) {
            this.getCurrentFrame().setInstructionPointer(this.myElementText.toString());
        } else if (qName.equals(OBJ_ELEMENT)) {
            this.getCurrentFrame().setBinary(this.toLocalPath(this.myElementText.toString()));
        } else if (qName.equals(FN_ELEMENT)) {
            this.getCurrentFrame().setFunction(this.myElementText.toString());
        } else if (qName.equals(DIR_ELEMENT)) {
            this.getCurrentFrame().setDirectory(this.toLocalPath(this.myElementText.toString()));
        } else if (qName.equals(FILE_ELEMENT)) {
            this.getCurrentFrame().setFile(this.myElementText.toString());
        } else if (qName.equals(LINE_ELEMENT)) {
            this.getCurrentFrame().setLine(this.myElementText.toString());
        }
        this.clearTextBuffer();
    }

    @NotNull
    private MemoryProfileProblemDescription getCurrentProblemDescription() {
        List<MemoryProfileProblemDescription> problemDescriptions = this.myCurrentError.getProblemDescriptions();
        LOG.assertTrue(!problemDescriptions.isEmpty());
        MemoryProfileProblemDescription memoryProfileProblemDescription = problemDescriptions.get(problemDescriptions.size() - 1);
        if (memoryProfileProblemDescription == null) {
            ValgrindHandler.$$$reportNull$$$0(2);
        }
        return memoryProfileProblemDescription;
    }

    @NotNull
    private MemoryProfileStack getCurrentStack() {
        MemoryProfileStack memoryProfileStack = this.getCurrentProblemDescription().getStack();
        if (memoryProfileStack == null) {
            ValgrindHandler.$$$reportNull$$$0(3);
        }
        return memoryProfileStack;
    }

    @NotNull
    private String toLocalPath(@NotNull String path) {
        if (path == null) {
            ValgrindHandler.$$$reportNull$$$0(4);
        }
        String string = this.myEnvironment.toLocalPath(path);
        if (string == null) {
            ValgrindHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private MemoryProfileFrame getCurrentFrame() {
        MemoryProfileFrame memoryProfileFrame = this.getCurrentStack().getOutermostFrame();
        if (memoryProfileFrame == null) {
            ValgrindHandler.$$$reportNull$$$0(6);
        }
        return memoryProfileFrame;
    }

    private void startNewError() {
        this.myCurrentError = new MemoryProfileError();
    }

    private void clearTextBuffer() {
        this.myElementText = new StringBuilder();
    }

    private static String removeCDataFromRawText(@NotNull String rawText) {
        if (rawText == null) {
            ValgrindHandler.$$$reportNull$$$0(7);
        }
        StringBuilder filteredText = new StringBuilder();
        int restIndex = 0;
        int beginIndex = rawText.indexOf(CDATA_BEGIN);
        while (beginIndex != -1) {
            int endIndex = rawText.indexOf(CDATA_END, beginIndex);
            LOG.assertTrue(endIndex != -1);
            filteredText.append(rawText, beginIndex + CDATA_BEGIN.length(), endIndex);
            restIndex = endIndex + CDATA_END.length();
            beginIndex = rawText.indexOf(CDATA_BEGIN, restIndex);
        }
        if (restIndex < rawText.length()) {
            filteredText.append(rawText, restIndex, rawText.length());
        }
        return filteredText.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/ValgrindHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProblemDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStack";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toLocalPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeCDataFromRawText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

