/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.cidr.execution.coverage.CidrBranchCoverageFileData;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageEnabledConfiguration;
import com.jetbrains.cidr.execution.coverage.CidrCoverageEngine;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrProjectData;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageModel;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageParser;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J7\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010!\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "()V", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "createLineData", "Lcom/intellij/rt/coverage/data/LineData;", "line", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "fileData", "Lcom/intellij/rt/coverage/data/ClassData;", "branchCoverageData", "Lcom/jetbrains/cidr/execution/coverage/CidrBranchCoverageFileData;", "getDataFileExtension", "", "getId", "getPresentableName", "loadCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "parseModel", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "workingDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/intellij/openapi/project/Project;)[Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "Companion", "intellij.cidr.coverage"})
public final class GCovCoverageRunner
extends CoverageRunner {
    @NotNull
    public static final String ID = "gcov";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getPresentableName() {
        String string = CidrCoverageBundle.message("gcov.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.message(\"gcov.name\")");
        return string;
    }

    @NotNull
    public String getDataFileExtension() {
        return ID;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof CidrCoverageEngine;
    }

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        File file;
        Object object;
        CidrToolEnvironment environment2;
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        CoverageEnabledConfiguration configuration = CidrCoverageEnabledConfiguration.Companion.getCoverageEnabledConfiguration(baseCoverageSuite);
        CidrToolEnvironment cidrToolEnvironment = CidrCoverageUtil.Companion.getEnvironment(baseCoverageSuite);
        if (cidrToolEnvironment == null) {
            cidrToolEnvironment = environment2 = new CidrToolEnvironment();
        }
        if ((object = configuration) != null && (object = object.getCoverageFilePath()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            file = new File((String)it);
        } else {
            file = null;
        }
        File workingDirectory = file;
        CoverageSuite coverageSuite = baseCoverageSuite;
        GCovCoverageModel[] models = this.parseModel(sessionDataFile, workingDirectory, environment2, (Project)(coverageSuite != null ? coverageSuite.getProject() : null));
        CidrProjectData projectData = new CidrProjectData();
        for (GCovCoverageModel model : models) {
            LineData it;
            LineData element$iv;
            int n;
            int n2;
            LineData[] lineDataArray;
            if (model.getLines().isEmpty()) continue;
            ClassData fileData = projectData.getOrCreateClassData(model.getFilePath());
            CidrBranchCoverageFileData branchCoverageData = projectData.getOrCreateBranchCoverageData(model.getFilePath());
            LineData[] lines = new LineData[((GCovCoverageModel.GCovLineModel)CollectionsKt.last(model.getLines())).getLineIndex() + 1];
            for (GCovCoverageModel.GCovLineModel line : model.getLines()) {
                if (line.getTotalHits() == -1) continue;
                try {
                    int n3 = line.getLineIndex();
                    ClassData classData = fileData;
                    Intrinsics.checkNotNullExpressionValue((Object)classData, (String)"fileData");
                    lines[n3] = this.createLineData(line, classData, branchCoverageData);
                }
                catch (Exception e) {
                    CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to create gcov coverage line data", (Throwable)e);
                }
            }
            if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage() && branchCoverageData.getTotalBranches() == 0) {
                boolean bl;
                block11: {
                    LineData[] $this$any$iv = lines;
                    boolean $i$f$any = false;
                    lineDataArray = $this$any$iv;
                    n2 = lineDataArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = lineDataArray[n];
                        boolean bl4 = false;
                        LineData lineData = it;
                        if (!((lineData != null ? Integer.valueOf(lineData.getHits()) : null) != null && it.getHits() > 0)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
                if (bl) {
                    branchCoverageData.setTotalBranches(1);
                    branchCoverageData.setCoveredBranches(1);
                }
            }
            LineData[] $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            lineDataArray = $this$forEach$iv;
            n2 = lineDataArray.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = lineDataArray[n];
                boolean bl = false;
                LineData lineData = it;
                if (lineData == null) continue;
                lineData.fillArrays();
            }
            fileData.setLines(lines);
        }
        return projectData;
    }

    private final GCovCoverageModel[] parseModel(File sessionDataFile, File workingDirectory, CidrToolEnvironment environment2, Project project) {
        GCovCoverageParser parser = new GCovCoverageParser();
        return parser.parse(sessionDataFile, workingDirectory, environment2, project);
    }

    private final LineData createLineData(GCovCoverageModel.GCovLineModel line, ClassData fileData, CidrBranchCoverageFileData branchCoverageData) {
        LineData lineData = new LineData(line.getLineIndex(), null);
        lineData.setHits(line.getTotalHits());
        Collection collection = line.getBlocks();
        boolean bl = false;
        if (!collection.isEmpty()) {
            int jumpIndex = 0;
            for (GCovCoverageModel.GCovBlockModel block : line.getBlocks()) {
                List<GCovCoverageModel.GCovBranchModel> branches = block.getBranches();
                for (GCovCoverageModel.GCovBranchModel branch : branches) {
                    JumpData jump;
                    JumpData jumpData = jump = lineData.addJump(jumpIndex++);
                    Intrinsics.checkNotNullExpressionValue((Object)jumpData, (String)"jump");
                    jumpData.setTrueHits(branch.getTaken());
                    jump.setFalseHits(RangesKt.coerceAtLeast((int)0, (int)(block.getHits() - branch.getTaken())));
                    CidrBranchCoverageFileData cidrBranchCoverageFileData = branchCoverageData;
                    cidrBranchCoverageFileData.setTotalBranches(cidrBranchCoverageFileData.getTotalBranches() + 1);
                    if (branch.getTaken() <= 0) continue;
                    CidrBranchCoverageFileData cidrBranchCoverageFileData2 = branchCoverageData;
                    cidrBranchCoverageFileData2.setCoveredBranches(cidrBranchCoverageFileData2.getCoveredBranches() + 1);
                }
            }
        }
        if (fileData.getLines() != null) {
            Object[] objectArray = fileData.getLines();
            Intrinsics.checkNotNull((Object)objectArray);
            LineData oldLineData = (LineData)objectArray[line.getLineIndex()];
            if (oldLineData != null) {
                lineData.merge((CoverageData)oldLineData);
            }
        }
        return lineData;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageRunner$Companion;", "", "()V", "ID", "", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

