/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.llvm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageComposer;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.llvm.LLVMCoverageToolsProvider;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageComposer;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageComposer;", "()V", "afterProcessTerminated", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "event", "Lcom/intellij/execution/process/ProcessEvent;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "beforeProcessExecution", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createCovCommand", "profileFile", "", "toolsProvider", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageToolsProvider;", "createLLVMCovProcessAdapter", "Lcom/intellij/execution/process/CapturingProcessAdapter;", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "outputFile", "Ljava/nio/file/Path;", "createProfdataCommand", "profileRawFile", "exportCoverageDataToJson", "llvmCov", "getAuxiliaryFile", "extension", "getCoverageDataFile", "isBranchCoverageSupportedByExportTool", "", "Companion", "intellij.cidr.coverage"})
public class LLVMCoverageComposer
extends CidrCoverageComposer {
    @JvmField
    @NotNull
    public static final Key<String> ARCH_KEY;
    @JvmField
    @NotNull
    public static final Key<Collection<String>> EXECUTABLES_KEY;
    @JvmField
    @NotNull
    public static final Key<String> RAW_PROFILE_KEY;
    @NotNull
    public static final Companion Companion;

    @Override
    public void beforeProcessExecution(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2, @NotNull GeneralCommandLine cmdLine, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        String profileRawFile;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = (String)context.getUserData(RAW_PROFILE_KEY);
        if (string == null) {
            string = profileRawFile = this.getAuxiliaryFile(configuration, "profraw", environment2);
        }
        if (profileRawFile != null) {
            context.putUserData(RAW_PROFILE_KEY, (Object)profileRawFile);
            Files.deleteIfExists(environment2.getHostMachine().getPath(profileRawFile, new String[0]));
            Map map2 = cmdLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"cmdLine.environment");
            map2.put("LLVM_PROFILE_FILE", environment2.toEnvPath(profileRawFile.toString()));
            Map map3 = cmdLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"cmdLine.environment");
            map3.put("__XPC_LLVM_PROFILE_FILE", environment2.toEnvPath(profileRawFile.toString()));
        }
        if (context.getUserData(EXECUTABLES_KEY) == null) {
            context.putUserData(EXECUTABLES_KEY, (Object)CollectionsKt.listOf((Object)cmdLine.getExePath()));
        }
    }

    @Override
    public void afterProcessTerminated(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2, @NotNull ProcessEvent event, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Path coverageFile;
        Path path;
        String it;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        LLVMCoverageToolsProvider lLVMCoverageToolsProvider = LLVMCoverageToolsProvider.Companion.getInstance(configuration);
        if (lLVMCoverageToolsProvider == null) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("llvm.tools.missing", new Object[0]));
        }
        LLVMCoverageToolsProvider toolsProvider = lLVMCoverageToolsProvider;
        Collection executables = (Collection)EXECUTABLES_KEY.get(context);
        String profileRawFile = (String)RAW_PROFILE_KEY.get(context);
        if (profileRawFile == null || !Files.exists(environment2.getHostMachine().getPath(profileRawFile, new String[0]), new LinkOption[0])) {
            CidrCoverageLogKt.getCidrCoverageLog().debug("LLVM profile raw file is not found");
            return;
        }
        String profileFile = this.getAuxiliaryFile(configuration, "profdata", environment2);
        if (profileFile == null) {
            CidrCoverageLogKt.getCidrCoverageLog().debug("Cannot get path llvm profdata file path");
            return;
        }
        Files.deleteIfExists(environment2.getHostMachine().getPath(profileFile, new String[0]));
        GeneralCommandLine llvmProfdata = this.createProfdataCommand(profileRawFile, profileFile, toolsProvider, configuration, environment2);
        ProcessOutput processOutput = environment2.getHostMachine().runProcess(llvmProfdata, indicator, -1);
        boolean bl = false;
        boolean bl2 = false;
        ProcessOutput output = processOutput;
        boolean bl3 = false;
        ProcessOutput processOutput2 = output;
        Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"output");
        if (processOutput2.getExitCode() != 0) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("llvm.profdata.merge.failed", output.getStderr()));
        }
        Files.deleteIfExists(environment2.getHostMachine().getPath(profileRawFile, new String[0]));
        indicator.checkCanceled();
        GeneralCommandLine llvmCov = this.createCovCommand(profileFile, toolsProvider, configuration, environment2, indicator);
        String arch = (String)context.getUserData(ARCH_KEY);
        Collection collection = executables;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"executables");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path exePath;
            it = (String)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)environment2.getHostMachine().getPath(it, new String[0]), (String)"environment.hostMachine.getPath(it)");
            if (!Files.isExecutable(exePath) || Files.isDirectory(exePath, new LinkOption[0]) || StringsKt.endsWith$default((String)((Object)exePath).toString(), (String)".a", (boolean)false, (int)2, null)) continue;
            llvmCov.addParameters(new String[]{"-object", environment2.toEnvPath(it)});
            if (arch == null) continue;
            llvmCov.addParameters(new String[]{"-arch", arch});
        }
        String string = this.getCoverageDataFile(configuration);
        if (string != null) {
            String string2 = string;
            boolean bl5 = false;
            boolean bl6 = false;
            it = string2;
            boolean bl7 = false;
            path = environment2.getHostMachine().getPath(it, new String[0]);
        } else {
            path = coverageFile = null;
        }
        if (coverageFile == null) {
            CidrCoverageLogKt.getCidrCoverageLog().error("Cannot get coverage output file path");
            return;
        }
        Files.deleteIfExists(coverageFile);
        indicator.checkCanceled();
        this.exportCoverageDataToJson(llvmCov, coverageFile, environment2, indicator);
        Files.deleteIfExists(environment2.getHostMachine().getPath(profileFile, new String[0]));
    }

    private final void exportCoverageDataToJson(GeneralCommandLine llvmCov, Path outputFile, CidrToolEnvironment environment2, ProgressIndicator indicator) {
        Function1 processAdapterProducer2;
        BaseProcessHandler baseProcessHandler = environment2.getHostMachine().createProcess(llvmCov, false, false, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)baseProcessHandler, (String)"environment.hostMachine.\u2026lse, false, false, false)");
        BaseProcessHandler process = baseProcessHandler;
        Function1 function1 = processAdapterProducer2 = (Function1)new Function1<ProcessOutput, CapturingProcessAdapter>(this, outputFile){
            final /* synthetic */ LLVMCoverageComposer this$0;
            final /* synthetic */ Path $outputFile;

            @NotNull
            public final CapturingProcessAdapter invoke(@NotNull ProcessOutput processOutput) {
                Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
                return LLVMCoverageComposer.access$createLLVMCovProcessAdapter(this.this$0, processOutput, this.$outputFile);
            }
            {
                this.this$0 = lLVMCoverageComposer;
                this.$outputFile = path;
                super(1);
            }
        };
        CapturingProcessRunner processRunner = new CapturingProcessRunner(process, new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        ProcessOutput processOutput = processRunner.runProcess(indicator);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"processRunner.runProcess(indicator)");
        ProcessOutput processOutput2 = processOutput;
        if (processOutput2.getExitCode() != 0) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("llvm.cov.export.failed", processOutput2.getStderr()));
        }
    }

    private final CapturingProcessAdapter createLLVMCovProcessAdapter(ProcessOutput processOutput, Path outputFile) {
        return new CapturingProcessAdapter(outputFile, processOutput, processOutput){
            final /* synthetic */ Path $outputFile;
            final /* synthetic */ ProcessOutput $processOutput;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                    Files.writeString(this.$outputFile, (CharSequence)event.getText(), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                    return;
                }
                super.onTextAvailable(event, outputType);
            }
            {
                this.$outputFile = $captured_local_variable$0;
                this.$processOutput = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    private final GeneralCommandLine createProfdataCommand(String profileRawFile, String profileFile, LLVMCoverageToolsProvider toolsProvider, RunConfiguration configuration, CidrToolEnvironment environment2) {
        GeneralCommandLine generalCommandLine = toolsProvider.createProfdataCommand(configuration, environment2);
        if (generalCommandLine == null) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("coverage.tool.not.found", "llvm-profdata"));
        }
        GeneralCommandLine command = generalCommandLine;
        CidrCoverageLogKt.getCidrCoverageLog().debug("llvm-profdata tool to use: " + command.getExePath());
        GeneralCommandLine generalCommandLine2 = command.withParameters(new String[]{"merge", environment2.toEnvPath(profileRawFile), "-o", environment2.toEnvPath(profileFile)});
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"command.withParameters(\"\u2026t.toEnvPath(profileFile))");
        return generalCommandLine2;
    }

    private final GeneralCommandLine createCovCommand(String profileFile, LLVMCoverageToolsProvider toolsProvider, RunConfiguration configuration, CidrToolEnvironment environment2, ProgressIndicator indicator) {
        GeneralCommandLine generalCommandLine = toolsProvider.createCovCommand(configuration, environment2);
        if (generalCommandLine == null) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("coverage.tool.not.found", "llvm-cov"));
        }
        GeneralCommandLine command = generalCommandLine;
        CidrCoverageLogKt.getCidrCoverageLog().debug("llvm-cov tool to use: " + command.getExePath());
        command.withParameters(new String[]{"export", "-instr-profile", environment2.toEnvPath(profileFile)});
        if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            if (this.isBranchCoverageSupportedByExportTool(toolsProvider, configuration, environment2, indicator)) {
                Intrinsics.checkNotNullExpressionValue((Object)command.withParameters(new String[]{"--show-branch-summary"}), (String)"command.withParameters(\"--show-branch-summary\")");
            } else {
                CidrCoverageLogKt.getCidrCoverageLog().warn("Branch coverage is disabled programmatically: `llvm-cov export` doesn't provide --show-branch-summary option");
            }
        }
        return command;
    }

    private final boolean isBranchCoverageSupportedByExportTool(LLVMCoverageToolsProvider toolsProvider, RunConfiguration configuration, CidrToolEnvironment environment2, ProgressIndicator indicator) {
        GeneralCommandLine generalCommandLine = toolsProvider.createCovCommand(configuration, environment2);
        if (generalCommandLine == null) {
            return false;
        }
        GeneralCommandLine commandLine = generalCommandLine;
        commandLine.withParameters(new String[]{"export", "--help"});
        ProcessOutput processOutput = environment2.getHostMachine().runProcess(commandLine, indicator, -1);
        boolean bl = false;
        boolean bl2 = false;
        ProcessOutput it = processOutput;
        boolean bl3 = false;
        ProcessOutput processOutput2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"it");
        String string = processOutput2.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.stdout");
        String string2 = string;
        boolean bl4 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)string3)).toString(), (CharSequence)"--show-branch-summary", (boolean)false, (int)2, null);
    }

    private final String getCoverageDataFile(RunConfiguration configuration) {
        CidrCoverageDataFileProvider cidrCoverageDataFileProvider = CidrCoverageDataFileProvider.Companion.getInstance(configuration, this.getCoverageRunnerId());
        return cidrCoverageDataFileProvider != null ? cidrCoverageDataFileProvider.getLocalCoverageDataPath(configuration) : null;
    }

    private final String getAuxiliaryFile(RunConfiguration configuration, String extension, CidrToolEnvironment environment2) {
        String string = this.getCoverageDataFile(configuration);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String file = string2;
            boolean bl3 = false;
            String parentDirectory = new File(file).getParent();
            return FileUtil.join((String[])new String[]{parentDirectory, configuration.getName() + '.' + extension});
        }
        return null;
    }

    public LLVMCoverageComposer() {
        super("llvm-cov");
    }

    static {
        Companion = new Companion(null);
        ARCH_KEY = new Key("LLVM_COVERAGE_ARCH");
        EXECUTABLES_KEY = new Key("LLVM_COVERAGE_PROGRAM_EXECUTABLES");
        RAW_PROFILE_KEY = new Key("LLVM_COVERAGE_RAW_PROFILE");
    }

    public static final /* synthetic */ CapturingProcessAdapter access$createLLVMCovProcessAdapter(LLVMCoverageComposer $this, ProcessOutput processOutput, Path outputFile) {
        return $this.createLLVMCovProcessAdapter(processOutput, outputFile);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageComposer$Companion;", "", "()V", "ARCH_KEY", "Lcom/intellij/openapi/util/Key;", "", "EXECUTABLES_KEY", "", "RAW_PROFILE_KEY", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

