/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiFile;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.Case;
import icons.CMakeIcons;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCompletionUtils {
    @NotNull
    public static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList) {
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(0);
        }
        if (argumentList == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(1);
        }
        return CMakeCompletionUtils.createStandardCommandItem(command, boldCompletion, true, putCaretInsideParentheses, argumentList, null);
    }

    @NotNull
    private static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean addParentheses, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList, @Nullable Object equalsObject) {
        LookupElementBuilder lookupElementBuilder;
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(2);
        }
        if (argumentList == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(3);
        }
        if (addParentheses || putCaretInsideParentheses) {
            StringBuilder argumentsBuilder = new StringBuilder();
            argumentsBuilder.append('(');
            for (CMakeArgument argument : argumentList) {
                argumentsBuilder.append(argument.getLiteralNotNull().getText()).append(' ');
            }
            if (!argumentList.isEmpty()) {
                argumentsBuilder.deleteCharAt(argumentsBuilder.length() - 1);
            }
            argumentsBuilder.append(')');
            lookupElementBuilder = LookupElementBuilder.create((Object)new String(command + argumentsBuilder + (equalsObject != null ? equalsObject.toString() : "")), (String)command);
            lookupElementBuilder = lookupElementBuilder.withTailText(argumentsBuilder.toString());
        } else {
            lookupElementBuilder = LookupElementBuilder.create((Object)new String(command), (String)command);
        }
        if (boldCompletion) {
            lookupElementBuilder = lookupElementBuilder.bold();
        }
        if (addParentheses) {
            lookupElementBuilder = putCaretInsideParentheses || !argumentList.isEmpty() ? lookupElementBuilder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false)) : lookupElementBuilder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false));
        }
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder;
        if (lookupElementBuilder2 == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(4);
        }
        return lookupElementBuilder2;
    }

    @NotNull
    public static String convertCommandToProperCase(@NotNull PsiFile file, @NotNull String textToComplete) {
        if (file == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(5);
        }
        if (textToComplete == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(6);
        }
        CMakeCodeStyleSettings cMakeSettings = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, CMakeCodeStyleSettings.class);
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.DO_NOT_CHANGE.getValue()) {
            String string = textToComplete;
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_LOWER.getValue()) {
            String string = textToComplete.toLowerCase(Locale.getDefault());
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_UPPER.getValue()) {
            String string = textToComplete.toUpperCase(Locale.getDefault());
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(9);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static LookupElement createCommandItem(@NotNull String textToComplete, @NotNull String filename, @NotNull List<CMakeArgument> argumentsInCompletion, boolean isFunctionName, boolean addParentheses) {
        if (textToComplete == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(10);
        }
        if (filename == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(11);
        }
        if (argumentsInCompletion == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(12);
        }
        Icon icon = CMakeCompletionUtils.getRoutineIcon(isFunctionName);
        LookupElementBuilder lookupElementBuilder = CMakeCompletionUtils.createStandardCommandItem(textToComplete, false, addParentheses, false, argumentsInCompletion, filename + isFunctionName).withIcon(icon);
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.appendTailText(CMakeCompletionUtils.getStandardCMakeCompletionTailText(filename), true);
        if (lookupElementBuilder2 == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(13);
        }
        return lookupElementBuilder2;
    }

    @NonNls
    @NotNull
    @Contract(pure=true)
    private static String getStandardCMakeCompletionTailText(@NotNull String filename) {
        if (filename == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(14);
        }
        String string = " (in " + filename + ")";
        if (string == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static Icon getRoutineIcon(boolean isFunctionName) {
        return isFunctionName ? CMakeCompletionUtils.getFunctionIcon() : CMakeCompletionUtils.getMacroIcon();
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getMacroIcon() {
        Icon icon = CMakeIcons.CMake_Macro;
        if (icon == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(16);
        }
        return icon;
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getFunctionIcon() {
        Icon icon = CMakeIcons.CMake_Function;
        if (icon == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(17);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/completion/CMakeCompletionUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToComplete";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsInCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/completion/CMakeCompletionUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createStandardCommandItem";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCommandToProperCase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandItem";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardCMakeCompletionTailText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStandardCommandItem";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertCommandToProperCase";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCommandItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStandardCMakeCompletionTailText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

