/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "list", "Ljavax/swing/JList;", "(Ljavax/swing/JList;)V", "getRunnableAt", "Ljava/lang/Runnable;", "e", "Ljava/awt/event/MouseEvent;", "mouseClicked", "", "mouseMoved", "intellij.vcs.github"})
public final class GHRepositoryMouseAdapter
extends MouseAdapter {
    private final JList<?> list;

    private final Runnable getRunnableAt(MouseEvent e) {
        Point point = e.getPoint();
        Component renderer = ListUtil.getDeepestRendererChildComponentAt(this.list, (Point)point);
        if (!(renderer instanceof SimpleColoredComponent)) {
            return null;
        }
        Object tag = ((SimpleColoredComponent)renderer).getFragmentTagAt(point.x);
        return tag instanceof Runnable ? (Runnable)tag : null;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Runnable runnable = this.getRunnableAt(e);
        if (runnable != null) {
            UIUtil.setCursor((Component)this.list, (Cursor)Cursor.getPredefinedCursor(12));
        } else {
            UIUtil.setCursor((Component)this.list, (Cursor)Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Runnable runnable = this.getRunnableAt(e);
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    public GHRepositoryMouseAdapter(@NotNull JList<?> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.list = list2;
    }
}

