/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.auth.AccountsListener;
import com.intellij.collaboration.hosting.GitHostingUrlUtil;
import com.intellij.collaboration.ui.SimpleEventListener;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ObservableProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHEnterpriseServerMeta;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.util.GHEnterpriseServerMetadataLoader;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubUtil;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"J\b\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020\u001fH\u0003J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0003J\b\u0010,\u001a\u00020\u001fH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \f*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/github/util/GHProjectRepositoriesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "getAccountManager", "()Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/collaboration/ui/SimpleEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "knownRepositories", "getKnownRepositories", "()Ljava/util/Set;", "setKnownRepositories", "(Ljava/util/Set;)V", "knownRepositories$delegate", "Lkotlin/properties/ObservableProperty;", "serversFromDiscovery", "Ljava/util/HashSet;", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "Lkotlin/collections/HashSet;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "addRepositoryListChangedListener", "", "disposable", "listener", "Lkotlin/Function0;", "dispose", "doUpdateRepositories", "findKnownRepositories", "", "repository", "Lgit4idea/repo/GitRepository;", "scheduleEnterpriseServerDiscovery", "remote", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "updateRepositories", "Companion", "RemoteUrlsListener", "intellij.vcs.github"})
public final class GHProjectRepositoriesManager
implements Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final MergingUpdateQueue updateQueue;
    private final EventDispatcher<SimpleEventListener> eventDispatcher;
    @NotNull
    private final ObservableProperty knownRepositories$delegate;
    private final HashSet<GithubServerPath> serversFromDiscovery;
    private final Project project;
    private static final Logger LOG;
    private static final Object UPDATE_IDENTITY;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(GHProjectRepositoriesManager.class, "knownRepositories", "getKnownRepositories()Ljava/util/Set;", 0))};
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHProjectRepositoriesManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        UPDATE_IDENTITY = new Object();
    }

    private final GHAccountManager getAccountManager() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return (GHAccountManager)((Object)object);
    }

    @NotNull
    public final Set<GHGitRepositoryMapping> getKnownRepositories() {
        return (Set)this.knownRepositories$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setKnownRepositories(Set<GHGitRepositoryMapping> set) {
        this.knownRepositories$delegate.setValue((Object)this, $$delegatedProperties[0], set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GHGitRepositoryMapping> findKnownRepositories(@NotNull GitRepository repository) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Iterable $this$filter$iv = this.getKnownRepositories();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GHGitRepositoryMapping it = (GHGitRepositoryMapping)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getGitRemoteUrlCoordinates().getRepository(), (Object)repository)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void updateRepositories() {
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                GHProjectRepositoriesManager.access$doUpdateRepositories((GHProjectRepositoriesManager)this.receiver);
            }
        };
        this.updateQueue.queue(Update.create((Object)UPDATE_IDENTITY, (Runnable)new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void doUpdateRepositories() {
        void $this$mapTo$iv$iv2;
        void $this$flatMapTo$iv$iv;
        LOG.debug("Repository list update started");
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitRepositoryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        List list2 = ((GitRepositoryManager)object).getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"project.service<GitRepos\u2026ryManager>().repositories");
        List gitRepositories = list2;
        if (gitRepositories.isEmpty()) {
            this.setKnownRepositories(SetsKt.emptySet());
            LOG.debug("No repositories found");
            return;
        }
        Iterable $this$flatMap$iv = gitRepositories;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            GitRepository repo = (GitRepository)element$iv$iv;
            boolean bl = false;
            GitRepository gitRepository = repo;
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
            Collection collection = gitRepository.getRemotes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repo.remotes");
            Iterable $this$flatMap$iv2 = collection;
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$mapNotNullTo$iv$iv;
                GitRemote remote = (GitRemote)element$iv$iv2;
                boolean bl2 = false;
                GitRemote gitRemote = remote;
                Intrinsics.checkNotNullExpressionValue((Object)gitRemote, (String)"remote");
                List list3 = gitRemote.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"remote.urls");
                Iterable $this$mapNotNull$iv = list3;
                boolean $i$f$mapNotNull = false;
                Iterable iterable3 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv3 = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String url = (String)element$iv$iv3;
                    boolean bl4 = false;
                    String string = url;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
                    GitRemoteUrlCoordinates gitRemoteUrlCoordinates = new GitRemoteUrlCoordinates(string, remote, repo);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    GitRemoteUrlCoordinates it$iv$iv = gitRemoteUrlCoordinates;
                    boolean bl7 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List remotes = (List)destination$iv$iv;
        LOG.debug("Found remotes: " + remotes);
        Iterable $this$map$iv = this.getAccountManager().getAccounts();
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            GithubAccount bl = (GithubAccount)((Object)item$iv$iv);
            Collection collection = destination$iv$iv4;
            boolean bl8 = false;
            GithubServerPath githubServerPath = it.getServer();
            collection.add(githubServerPath);
        }
        List authenticatedServers = (List)destination$iv$iv4;
        $i$f$map22 = false;
        List $i$f$map22 = new ArrayList();
        boolean $this$mapTo$iv$iv2 = false;
        boolean bl = false;
        List $this$apply = $i$f$map22;
        boolean bl92 = false;
        GithubServerPath githubServerPath = GithubServerPath.DEFAULT_SERVER;
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"GithubServerPath.DEFAULT_SERVER");
        $this$apply.add(githubServerPath);
        $this$apply.addAll(authenticatedServers);
        $this$apply.addAll((Collection)this.serversFromDiscovery);
        List servers = $i$f$map22;
        HashSet<GHGitRepositoryMapping> repositories = new HashSet<GHGitRepositoryMapping>();
        for (GitRemoteUrlCoordinates remote : remotes) {
            GHGitRepositoryMapping repository;
            GHGitRepositoryMapping gHGitRepositoryMapping;
            Iterable iterable4;
            boolean bl10;
            Object bl92;
            block12: {
                bl92 = servers;
                bl10 = false;
                Iterable iterable5 = bl92;
                boolean bl8 = false;
                for (Iterable iterable2 : iterable5) {
                    GithubServerPath it = (GithubServerPath)((Object)iterable2);
                    boolean bl11 = false;
                    if (!it.matches(remote.getUrl())) continue;
                    iterable4 = iterable2;
                    break block12;
                }
                iterable4 = null;
            }
            GithubServerPath githubServerPath2 = (GithubServerPath)((Object)iterable4);
            if (githubServerPath2 != null) {
                bl92 = githubServerPath2;
                bl10 = false;
                boolean bl12 = false;
                Object it = bl92;
                boolean bl13 = false;
                gHGitRepositoryMapping = GHGitRepositoryMapping.Companion.create((GithubServerPath)it, remote);
            } else {
                gHGitRepositoryMapping = repository = null;
            }
            if (repository != null) {
                repositories.add(repository);
                continue;
            }
            this.scheduleEnterpriseServerDiscovery(remote);
        }
        LOG.debug("New list of known repos: " + repositories);
        this.setKnownRepositories((Set<GHGitRepositoryMapping>)repositories);
        for (GithubServerPath server : authenticatedServers) {
            if (server.isGithubDotCom()) continue;
            boolean $i$f$service2 = false;
            Class<GHEnterpriseServerMetadataLoader> serviceClass$iv = GHEnterpriseServerMetadataLoader.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, ((GHEnterpriseServerMetadataLoader)object2).loadMetadata(server), null, (Function1)((Function1)new Function1<GHEnterpriseServerMeta, Unit>(this, server){
                final /* synthetic */ GHProjectRepositoriesManager this$0;
                final /* synthetic */ GithubServerPath $server;

                public final void invoke(@NotNull GHEnterpriseServerMeta it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    GHPRStatisticsCollector.INSTANCE.logEnterpriseServerMeta(GHProjectRepositoriesManager.access$getProject$p(this.this$0), this.$server, it);
                }
                {
                    this.this$0 = gHProjectRepositoriesManager;
                    this.$server = githubServerPath;
                    super(1);
                }
            }), (int)1, null);
        }
    }

    @RequiresEdt
    private final void scheduleEnterpriseServerDiscovery(GitRemoteUrlCoordinates remote) {
        URI uri = GitHostingUrlUtil.getUriFromRemoteUrl((String)remote.getUrl());
        LOG.debug("Extracted URI " + uri + " from remote " + remote.getUrl());
        if (uri == null) {
            return;
        }
        String string = uri.getHost();
        if (string == null) {
            return;
        }
        String host = string;
        String string2 = uri.getPath();
        if (string2 == null) {
            return;
        }
        String path = string2;
        List list2 = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)path, (CharSequence)"/"), (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        List list3 = it.size() >= 2 ? list2 : null;
        if (list3 == null) {
            return;
        }
        List pathParts = list3;
        String serverSuffix = pathParts.size() == 2 ? null : CollectionsKt.joinToString$default((Iterable)pathParts.subList(0, pathParts.size() - 2), (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null);
        GithubServerPath server = new GithubServerPath(false, host, null, serverSuffix);
        GithubServerPath serverHttp = new GithubServerPath(true, host, null, serverSuffix);
        GithubServerPath server8080 = new GithubServerPath(true, host, 8080, serverSuffix);
        LOG.debug("Scheduling GHE server discovery for " + server + ", " + serverHttp + " and " + server8080);
        boolean $i$f$service = false;
        Class<GHEnterpriseServerMetadataLoader> serviceClass$iv = GHEnterpriseServerMetadataLoader.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        GHEnterpriseServerMetadataLoader serverManager = (GHEnterpriseServerMetadataLoader)object;
        CompletableFutureUtil.errorOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, serverManager.loadMetadata(server), null, (Function1)((Function1)new Function1<GHEnterpriseServerMeta, Unit>(this, server){
            final /* synthetic */ GHProjectRepositoriesManager this$0;
            final /* synthetic */ GithubServerPath $server;

            public final void invoke(@NotNull GHEnterpriseServerMeta it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHProjectRepositoriesManager.access$getLOG$cp().debug("Found GHE server at " + this.$server);
                GHProjectRepositoriesManager.access$getServersFromDiscovery$p(this.this$0).add(this.$server);
                GHProjectRepositoriesManager gHProjectRepositoriesManager = this.this$0;
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(gHProjectRepositoriesManager){
                    final /* synthetic */ GHProjectRepositoriesManager receiver$0$inlined;
                    {
                        this.receiver$0$inlined = gHProjectRepositoriesManager;
                    }

                    public final void run() {
                        boolean bl = false;
                        GHProjectRepositoriesManager.access$doUpdateRepositories(this.receiver$0$inlined);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
            }
            {
                this.this$0 = gHProjectRepositoriesManager;
                this.$server = githubServerPath;
                super(1);
            }
        }), (int)1, null), null, (Function1)((Function1)new Function1<Throwable, Unit>(this, serverManager, serverHttp, server8080){
            final /* synthetic */ GHProjectRepositoriesManager this$0;
            final /* synthetic */ GHEnterpriseServerMetadataLoader $serverManager;
            final /* synthetic */ GithubServerPath $serverHttp;
            final /* synthetic */ GithubServerPath $server8080;

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletableFutureUtil.errorOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, this.$serverManager.loadMetadata(this.$serverHttp), null, (Function1)((Function1)new Function1<GHEnterpriseServerMeta, Unit>(this){
                    final /* synthetic */ scheduleEnterpriseServerDiscovery.2 this$0;

                    public final void invoke(@NotNull GHEnterpriseServerMeta it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        GHProjectRepositoriesManager.access$getLOG$cp().debug("Found GHE server at " + this.this$0.$serverHttp);
                        GHProjectRepositoriesManager.access$getServersFromDiscovery$p(this.this$0.this$0).add(this.this$0.$serverHttp);
                        GHProjectRepositoriesManager gHProjectRepositoriesManager = this.this$0.this$0;
                        ModalityState modalityState$iv = null;
                        boolean $i$f$invokeLater = false;
                        Application application = ApplicationManager.getApplication();
                        Runnable runnable = new Runnable(gHProjectRepositoriesManager){
                            final /* synthetic */ GHProjectRepositoriesManager receiver$0$inlined;
                            {
                                this.receiver$0$inlined = gHProjectRepositoriesManager;
                            }

                            public final void run() {
                                boolean bl = false;
                                GHProjectRepositoriesManager.access$doUpdateRepositories(this.receiver$0$inlined);
                            }
                        };
                        ModalityState modalityState = ModalityState.defaultModalityState();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                        application.invokeLater(runnable, modalityState);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null), null, (Function1)((Function1)new Function1<Throwable, Unit>(this){
                    final /* synthetic */ scheduleEnterpriseServerDiscovery.2 this$0;

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, this.this$0.$serverManager.loadMetadata(this.this$0.$server8080), null, (Function1)((Function1)new Function1<GHEnterpriseServerMeta, Unit>(this){
                            final /* synthetic */ scheduleEnterpriseServerDiscovery.2 this$0;

                            public final void invoke(@NotNull GHEnterpriseServerMeta it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                GHProjectRepositoriesManager.access$getLOG$cp().debug("Found GHE server at " + this.this$0.this$0.$server8080);
                                GHProjectRepositoriesManager.access$getServersFromDiscovery$p(this.this$0.this$0.this$0).add(this.this$0.this$0.$server8080);
                                GHProjectRepositoriesManager gHProjectRepositoriesManager = this.this$0.this$0.this$0;
                                ModalityState modalityState$iv = null;
                                boolean $i$f$invokeLater = false;
                                Application application = ApplicationManager.getApplication();
                                Runnable runnable = new Runnable(gHProjectRepositoriesManager){
                                    final /* synthetic */ GHProjectRepositoriesManager receiver$0$inlined;
                                    {
                                        this.receiver$0$inlined = gHProjectRepositoriesManager;
                                    }

                                    public final void run() {
                                        boolean bl = false;
                                        GHProjectRepositoriesManager.access$doUpdateRepositories(this.receiver$0$inlined);
                                    }
                                };
                                ModalityState modalityState = ModalityState.defaultModalityState();
                                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                                application.invokeLater(runnable, modalityState);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null);
            }
            {
                this.this$0 = gHProjectRepositoriesManager;
                this.$serverManager = gHEnterpriseServerMetadataLoader;
                this.$serverHttp = githubServerPath;
                this.$server8080 = githubServerPath2;
                super(1);
            }
        }), (int)1, null);
    }

    public final void addRepositoryListChangedListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        SimpleEventListener.Companion.addDisposableListener(this.eventDispatcher, disposable, listener);
    }

    public void dispose() {
    }

    public GHProjectRepositoriesManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.updateQueue = new MergingUpdateQueue("GitHub repositories update", 50, true, null, (Disposable)this, null, true).usePassThroughInUnitTestMode();
        EventDispatcher eventDispatcher = EventDispatcher.create(SimpleEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(S\u2026ventListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.knownRepositories$delegate = GithubUtil.Delegates.INSTANCE.observableField(SetsKt.emptySet(), this.eventDispatcher);
        this.serversFromDiscovery = new HashSet();
        this.getAccountManager().addListener(this, (AccountsListener)new AccountsListener<GithubAccount>(){

            public void onAccountListChanged(@NotNull Collection<GithubAccount> old, @NotNull Collection<GithubAccount> collection) {
                Application app$iv;
                Intrinsics.checkNotNullParameter(old, (String)"old");
                Intrinsics.checkNotNullParameter(collection, (String)"new");
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application application = app$iv = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                if (application.isDispatchThread()) {
                    boolean bl = false;
                    this.updateRepositories();
                } else {
                    boolean $i$f$invokeLater = false;
                    Application application2 = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this){
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            GHProjectRepositoriesManager.access$updateRepositories(this.this$0.this);
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application2.invokeLater(runnable, modalityState);
                }
            }

            public void onAccountCredentialsChanged(@NotNull GithubAccount account) {
                Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                AccountsListener.DefaultImpls.onAccountCredentialsChanged((AccountsListener)this, (Object)((Object)account));
            }
        });
        this.updateRepositories();
    }

    public static final /* synthetic */ void access$doUpdateRepositories(GHProjectRepositoriesManager $this) {
        $this.doUpdateRepositories();
    }

    public static final /* synthetic */ Project access$getProject$p(GHProjectRepositoriesManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ HashSet access$getServersFromDiscovery$p(GHProjectRepositoriesManager $this) {
        return $this.serversFromDiscovery;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GHProjectRepositoriesManager$RemoteUrlsListener;", "Lcom/intellij/dvcs/repo/VcsRepositoryMappingListener;", "Lgit4idea/repo/GitRepositoryChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "mappingChanged", "", "repositoryChanged", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.github"})
    public static final class RemoteUrlsListener
    implements VcsRepositoryMappingListener,
    GitRepositoryChangeListener {
        private final Project project;

        public void mappingChanged() {
            Application application$iv;
            Companion companion = Companion;
            Project project$iv = this.project;
            boolean $i$f$runInEdt = false;
            Application application = application$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
            if (application.isDispatchThread()) {
                boolean bl = false;
                Companion.updateRepositories(this.project);
            } else {
                application$iv.invokeLater(new Runnable(this){
                    final /* synthetic */ RemoteUrlsListener this$0;
                    {
                        this.this$0 = remoteUrlsListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        org.jetbrains.plugins.github.util.GHProjectRepositoriesManager$Companion.access$updateRepositories(GHProjectRepositoriesManager.Companion, RemoteUrlsListener.access$getProject$p(this.this$0));
                    }
                }, new Condition(project$iv){
                    final /* synthetic */ Project $project;

                    public final boolean value(Object it) {
                        return this.$project.isDisposed();
                    }
                    {
                        this.$project = project;
                    }
                });
            }
        }

        public void repositoryChanged(@NotNull GitRepository repository) {
            Application application$iv;
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Companion companion = Companion;
            Project project$iv = this.project;
            boolean $i$f$runInEdt = false;
            Application application = application$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
            if (application.isDispatchThread()) {
                boolean bl = false;
                Companion.updateRepositories(this.project);
            } else {
                application$iv.invokeLater(new Runnable(this){
                    final /* synthetic */ RemoteUrlsListener this$0;
                    {
                        this.this$0 = remoteUrlsListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        org.jetbrains.plugins.github.util.GHProjectRepositoriesManager$Companion.access$updateRepositories(GHProjectRepositoriesManager.Companion, RemoteUrlsListener.access$getProject$p(this.this$0));
                    }
                }, new /* invalid duplicate definition of identical inner class */);
            }
        }

        public RemoteUrlsListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0004\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0082\bJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/util/GHProjectRepositoriesManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "UPDATE_IDENTITY", "runInEdt", "", "project", "Lcom/intellij/openapi/project/Project;", "runnable", "Lkotlin/Function0;", "updateRepositories", "intellij.vcs.github"})
    public static final class Companion {
        private final void runInEdt(Project project, Function0<Unit> runnable) {
            Application application;
            int $i$f$runInEdt = 0;
            Application application2 = application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
            if (application2.isDispatchThread()) {
                runnable.invoke();
            } else {
                application.invokeLater(new Runnable(runnable){
                    final /* synthetic */ Function0 $runnable;

                    public final void run() {
                        this.$runnable.invoke();
                    }
                    {
                        this.$runnable = function0;
                    }
                }, new /* invalid duplicate definition of identical inner class */);
            }
        }

        private final void updateRepositories(Project project) {
            try {
                if (!project.isDisposed()) {
                    Project $this$service$iv = project;
                    boolean $i$f$service = false;
                    Object object = $this$service$iv.getService(GHProjectRepositoriesManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                    ((GHProjectRepositoriesManager)object).updateRepositories();
                }
            }
            catch (Exception e) {
                LOG.info("Error occurred while updating repositories", (Throwable)e);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$runInEdt(Companion $this, Project project, Function0 runnable) {
            $this.runInEdt(project, (Function0<Unit>)runnable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

