/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.impldep.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ConfigurationResolveReport;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ResolveReport;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveOptions;
import org.gradle.internal.impldep.org.apache.ivy.plugins.report.ReportOutputter;
import org.gradle.internal.impldep.org.apache.ivy.plugins.report.XmlReportWriter;
import org.gradle.internal.impldep.org.apache.ivy.util.FileUtil;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class XmlReportOutputter
implements ReportOutputter {
    private XmlReportWriter writer = new XmlReportWriter();

    public String getName() {
        return "xml";
    }

    public void output(ResolveReport report, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        String[] confs = report.getConfigurations();
        for (int i = 0; i < confs.length; ++i) {
            this.output(report.getConfigurationReport(confs[i]), report.getResolveId(), confs, cacheMgr);
        }
    }

    public void output(ConfigurationResolveReport report, String resolveId, String[] confs, ResolutionCacheManager cacheMgr) throws IOException {
        File reportFile = cacheMgr.getConfigurationResolveReportInCache(resolveId, report.getConfiguration());
        File reportParentDir = reportFile.getParentFile();
        reportParentDir.mkdirs();
        FileOutputStream stream = new FileOutputStream(reportFile);
        this.writer.output(report, confs, stream);
        ((OutputStream)stream).close();
        Message.verbose("\treport for " + report.getModuleDescriptor().getModuleRevisionId() + " " + report.getConfiguration() + " produced in " + reportFile);
        File reportXsl = new File(reportParentDir, "ivy-report.xsl");
        File reportCss = new File(reportParentDir, "ivy-report.css");
        if (!reportXsl.exists()) {
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.xsl"), reportXsl, null);
        }
        if (!reportCss.exists()) {
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), reportCss, null);
        }
    }
}

