/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.ClassSelector;

@API(status=API.Status.STABLE, since="1.6")
public class NestedClassSelector
implements DiscoverySelector {
    private List<ClassSelector> enclosingClassSelectors;
    private ClassSelector nestedClassSelector;

    NestedClassSelector(List<String> enclosingClassNames, String nestedClassName) {
        this.enclosingClassSelectors = enclosingClassNames.stream().map(ClassSelector::new).collect(Collectors.toList());
        this.nestedClassSelector = new ClassSelector(nestedClassName);
    }

    NestedClassSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass) {
        this.enclosingClassSelectors = enclosingClasses.stream().map(ClassSelector::new).collect(Collectors.toList());
        this.nestedClassSelector = new ClassSelector(nestedClass);
    }

    public List<String> getEnclosingClassNames() {
        return this.enclosingClassSelectors.stream().map(ClassSelector::getClassName).collect(Collectors.toList());
    }

    public List<Class<?>> getEnclosingClasses() {
        return this.enclosingClassSelectors.stream().map(ClassSelector::getJavaClass).collect(Collectors.toList());
    }

    public String getNestedClassName() {
        return this.nestedClassSelector.getClassName();
    }

    public Class<?> getNestedClass() {
        return this.nestedClassSelector.getJavaClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedClassSelector that = (NestedClassSelector)o;
        return this.enclosingClassSelectors.equals(that.enclosingClassSelectors) && this.nestedClassSelector.equals(that.nestedClassSelector);
    }

    public int hashCode() {
        return Objects.hash(this.enclosingClassSelectors, this.nestedClassSelector);
    }

    public String toString() {
        return new ToStringBuilder(this).append("enclosingClassNames", this.getEnclosingClassNames()).append("nestedClassName", this.getNestedClassName()).toString();
    }
}

