/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.engine.TestEngine;
import org.gradle.internal.impldep.org.junit.platform.launcher.PostDiscoveryFilter;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.DefaultLauncherConfig;

@API(status=API.Status.STABLE, since="1.7")
public interface LauncherConfig {
    public boolean isTestEngineAutoRegistrationEnabled();

    public boolean isTestExecutionListenerAutoRegistrationEnabled();

    @API(status=API.Status.EXPERIMENTAL, since="1.7")
    public boolean isPostDiscoveryFilterAutoRegistrationEnabled();

    public Collection<TestEngine> getAdditionalTestEngines();

    public Collection<TestExecutionListener> getAdditionalTestExecutionListeners();

    @API(status=API.Status.EXPERIMENTAL, since="1.7")
    public Collection<PostDiscoveryFilter> getAdditionalPostDiscoveryFilters();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean listenerAutoRegistrationEnabled = true;
        private boolean engineAutoRegistrationEnabled = true;
        private boolean postDiscoveryFilterAutoRegistrationEnabled = true;
        private final Collection<TestEngine> engines = new LinkedHashSet<TestEngine>();
        private final Collection<TestExecutionListener> listeners = new LinkedHashSet<TestExecutionListener>();
        private final Collection<PostDiscoveryFilter> postDiscoveryFilters = new LinkedHashSet<PostDiscoveryFilter>();

        private Builder() {
        }

        public Builder enableTestExecutionListenerAutoRegistration(boolean enabled) {
            this.listenerAutoRegistrationEnabled = enabled;
            return this;
        }

        public Builder enableTestEngineAutoRegistration(boolean enabled) {
            this.engineAutoRegistrationEnabled = enabled;
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="1.7")
        public Builder enablePostDiscoveryFilterAutoRegistration(boolean enabled) {
            this.postDiscoveryFilterAutoRegistrationEnabled = enabled;
            return this;
        }

        public Builder addTestEngines(TestEngine ... engines) {
            Preconditions.notNull(engines, "TestEngine array must not be null");
            Preconditions.containsNoNullElements(engines, "TestEngine array must not contain null elements");
            Collections.addAll(this.engines, engines);
            return this;
        }

        public Builder addTestExecutionListeners(TestExecutionListener ... listeners) {
            Preconditions.notNull(listeners, "TestExecutionListener array must not be null");
            Preconditions.containsNoNullElements(listeners, "TestExecutionListener array must not contain null elements");
            Collections.addAll(this.listeners, listeners);
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="1.7")
        public Builder addPostDiscoveryFilters(PostDiscoveryFilter ... filters) {
            Preconditions.notNull(filters, "PostDiscoveryFilter array must not be null");
            Preconditions.containsNoNullElements(filters, "PostDiscoveryFilter array must not contain null elements");
            Collections.addAll(this.postDiscoveryFilters, filters);
            return this;
        }

        public LauncherConfig build() {
            return new DefaultLauncherConfig(this.engineAutoRegistrationEnabled, this.listenerAutoRegistrationEnabled, this.postDiscoveryFilterAutoRegistrationEnabled, this.engines, this.listeners, this.postDiscoveryFilters);
        }
    }
}

