/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.EditorTestFixture;
import com.intellij.testFramework.fixtures.InjectionAssertionData;
import com.intellij.testFramework.fixtures.InjectionTestFixture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u001a2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u001c\"\u00020!\u00a2\u0006\u0002\u0010\"J\u001c\u0010\u001f\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%J\u0010\u0010&\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010!J\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160)0%J\u0006\u0010*\u001a\u00020+J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/intellij/testFramework/fixtures/InjectionTestFixture;", "", "javaFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "injectedElement", "Lcom/intellij/psi/PsiElement;", "getInjectedElement", "()Lcom/intellij/psi/PsiElement;", "injectedLanguageManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "getInjectedLanguageManager", "()Lcom/intellij/lang/injection/InjectedLanguageManager;", "topLevelCaretPosition", "", "getTopLevelCaretPosition", "()I", "topLevelEditor", "Lcom/intellij/openapi/editor/Editor;", "getTopLevelEditor", "()Lcom/intellij/openapi/editor/Editor;", "topLevelFile", "Lcom/intellij/psi/PsiFile;", "getTopLevelFile", "()Lcom/intellij/psi/PsiFile;", "assertInjected", "", "expectedInjections", "", "Lcom/intellij/testFramework/fixtures/InjectionAssertionData;", "([Lcom/intellij/testFramework/fixtures/InjectionAssertionData;)V", "assertInjectedContent", "expectedInjectFileTexts", "", "([Ljava/lang/String;)V", "message", "expectedFilesTexts", "", "assertInjectedLangAtCaret", "lang", "getAllInjections", "Lkotlin/Pair;", "openInFragmentEditor", "Lcom/intellij/testFramework/fixtures/EditorTestFixture;", "quickEditHandler", "Lcom/intellij/codeInsight/intention/impl/QuickEditHandler;", "intellij.platform.testFramework"})
public final class InjectionTestFixture {
    private final CodeInsightTestFixture javaFixture;

    @NotNull
    public final InjectedLanguageManager getInjectedLanguageManager() {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.javaFixture.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"InjectedLanguageManager.\u2026ance(javaFixture.project)");
        return injectedLanguageManager;
    }

    @Nullable
    public final PsiElement getInjectedElement() {
        PsiFile psiFile = this.getTopLevelFile();
        if (psiFile == null) {
            return null;
        }
        return this.getInjectedLanguageManager().findInjectedElementAt(psiFile, this.getTopLevelCaretPosition());
    }

    public final void assertInjectedLangAtCaret(@Nullable String lang) {
        PsiElement injectedElement = this.getInjectedElement();
        if (lang != null) {
            TestCase.assertNotNull((String)("injection of '" + lang + "' expected"), (Object)injectedElement);
            PsiElement psiElement = injectedElement;
            Intrinsics.checkNotNull((Object)psiElement);
            Language language = psiElement.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"injectedElement!!.language");
            TestCase.assertEquals((String)lang, (String)language.getID());
        } else {
            TestCase.assertNull((Object)injectedElement);
        }
    }

    @NotNull
    public final List<Pair<PsiElement, PsiFile>> getAllInjections() {
        boolean bl = false;
        List injected = new ArrayList();
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)this.getTopLevelFile()), (Class[])new Class[]{PsiLanguageInjectionHost.class});
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"PsiTreeUtil.collectEleme\u2026njectionHost::class.java)");
        Collection hosts = collection;
        for (PsiLanguageInjectionHost host : hosts) {
            this.getInjectedLanguageManager().enumerate((PsiElement)host, new PsiLanguageInjectionHost.InjectedPsiVisitor(injected, host){
                final /* synthetic */ List $injected;
                final /* synthetic */ PsiLanguageInjectionHost $host;

                public final void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)injectedPsi, (String)"injectedPsi");
                    Intrinsics.checkNotNullParameter($noName_1, (String)"<anonymous parameter 1>");
                    this.$injected.add(TuplesKt.to((Object)this.$host, (Object)injectedPsi));
                }
                {
                    this.$injected = list;
                    this.$host = psiLanguageInjectionHost;
                }
            });
        }
        return injected;
    }

    public final void assertInjectedContent(String ... expectedInjectFileTexts) {
        Intrinsics.checkNotNullParameter((Object)expectedInjectFileTexts, (String)"expectedInjectFileTexts");
        this.assertInjectedContent("injected content expected", ArraysKt.toList((Object[])expectedInjectFileTexts));
    }

    /*
     * WARNING - void declaration
     */
    public final void assertInjectedContent(@NotNull String message, @NotNull List<String> expectedFilesTexts) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Collection<PsiFile> collection;
        void destination$iv;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(expectedFilesTexts, (String)"expectedFilesTexts");
        Iterable iterable = this.getAllInjections();
        Collection collection2 = new HashSet();
        String string = message;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Pair pair = (Pair)item$iv;
            collection = destination$iv;
            boolean bl = false;
            object = (PsiFile)it.getSecond();
            collection.add((PsiFile)object);
        }
        collection = destination$iv;
        $this$mapTo$iv = collection;
        boolean $i$f$map = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFile psiFile = (PsiFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getText();
            collection.add((PsiFile)object);
        }
        collection = (List)destination$iv$iv;
        UsefulTestCase.assertSameElements(string, (Collection)collection, (Collection)expectedFilesTexts);
    }

    /*
     * Unable to fully structure code
     */
    public final void assertInjected(InjectionAssertionData ... expectedInjections) {
        Intrinsics.checkNotNullParameter((Object)expectedInjections, (String)"expectedInjections");
        expected = (LinkedList)ArraysKt.toCollection((Object[])expectedInjections, (Collection)new LinkedList<E>());
        foundInjections = (LinkedList)CollectionsKt.toCollection((Iterable)this.getAllInjections(), (Collection)new LinkedList<E>());
        while (true) {
            block5: {
                var4_4 = expected;
                var5_6 = false;
                if (!(var4_4.isEmpty() == false)) break;
                var6_7 = (InjectionAssertionData)expected.pop();
                var4_4 = var6_7.component1();
                injectedLanguage = var6_7.component2();
                var7_8 = foundInjections;
                var8_9 = false;
                var9_10 = var7_8;
                var10_11 = false;
                for (T var12_13 : var9_10) {
                    $dstr$psi$file = (Pair)var12_13;
                    $i$a$-find-InjectionTestFixture$assertInjected$found$1 = false;
                    var15_16 = (PsiElement)$dstr$psi$file.component1();
                    file = (PsiFile)$dstr$psi$file.component2();
                    if (!Intrinsics.areEqual((Object)psi.getText(), (Object)text)) ** GOTO lbl-1000
                    v0 = file.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"file.language");
                    if (Intrinsics.areEqual((Object)v0.getID(), (Object)injectedLanguage)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = var12_13;
                    break block5;
                }
                v2 = null;
            }
            if ((Pair)v2 == null) {
                v3 = AssertionsKt.fail((String)("no injection '" + (String)text + "' -> '" + injectedLanguage + "' were found, remains: " + CollectionsKt.joinToString$default((Iterable)foundInjections, null, null, null, (int)0, null, (Function1)assertInjected.found.2.INSTANCE, (int)31, null) + "   "));
                throw new KotlinNothingValueException();
            }
            foundInjections.remove(found);
        }
    }

    @NotNull
    public final EditorTestFixture openInFragmentEditor() {
        QuickEditHandler quickEditHandler;
        QuickEditHandler quickEditHandler2 = quickEditHandler = new QuickEditAction().invokeImpl(this.javaFixture.getProject(), this.getTopLevelEditor(), this.getTopLevelFile());
        Intrinsics.checkNotNullExpressionValue((Object)quickEditHandler2, (String)"quickEditHandler");
        return this.openInFragmentEditor(quickEditHandler2);
    }

    @NotNull
    public final EditorTestFixture openInFragmentEditor(@NotNull QuickEditHandler quickEditHandler) {
        Editor fragmentEditor;
        Intrinsics.checkNotNullParameter((Object)quickEditHandler, (String)"quickEditHandler");
        PsiFile injectedFile = quickEditHandler.getNewFile();
        Project project2 = this.javaFixture.getProject();
        PsiElement psiElement = this.getInjectedElement();
        Object object = psiElement != null ? psiElement.getContainingFile() : null;
        Intrinsics.checkNotNull((Object)object);
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)((PsiElement)object));
        CaretModel caretModel = this.getTopLevelEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"topLevelEditor.caretModel");
        int offset = caretModel.getOffset();
        int unEscapedOffset = InjectedLanguageUtil.hostToInjectedUnescaped((DocumentWindow)documentWindow, (int)offset);
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project2);
        PsiFile psiFile = injectedFile;
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"injectedFile");
        Editor editor = fragmentEditor = fileEditorManagerEx.openTextEditor(new OpenFileDescriptor(project2, psiFile.getVirtualFile(), unEscapedOffset), true);
        Intrinsics.checkNotNull((Object)editor);
        return new EditorTestFixture(project2, editor, injectedFile.getVirtualFile());
    }

    @NotNull
    public final PsiFile getTopLevelFile() {
        PsiFile psiFile = this.javaFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile psiFile2 = psiFile;
        boolean bl = false;
        boolean bl2 = false;
        PsiFile it = psiFile2;
        boolean bl3 = false;
        PsiFile psiFile3 = this.getInjectedLanguageManager().getTopLevelFile((PsiElement)it);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"javaFixture.file!!.let {\u2026ger.getTopLevelFile(it) }");
        return psiFile3;
    }

    public final int getTopLevelCaretPosition() {
        CaretModel caretModel = this.getTopLevelEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"topLevelEditor.caretModel");
        return caretModel.getOffset();
    }

    @NotNull
    public final Editor getTopLevelEditor() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.javaFixture.getProject());
        PsiFile psiFile = this.getTopLevelFile();
        Intrinsics.checkNotNull((Object)psiFile);
        FileEditor fileEditor = fileEditorManager.getSelectedEditor(psiFile.getVirtualFile());
        if (fileEditor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"(FileEditorManager.getIn\u2026le) as TextEditor).editor");
        return editor;
    }

    public InjectionTestFixture(@NotNull CodeInsightTestFixture javaFixture) {
        Intrinsics.checkNotNullParameter((Object)javaFixture, (String)"javaFixture");
        this.javaFixture = javaFixture;
    }
}

