/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CompletionAutoPopupTester;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.icons.RowIcon;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrCodeInsightFixtureAdapter;
import com.jetbrains.cidr.CidrExternalAnnotationsProvider;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.TestAnnotationInfoList;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.daemon.OCBasicHighlighter;
import com.jetbrains.cidr.lang.daemon.OCHiddenNonVirtualFunctionAnnotator;
import com.jetbrains.cidr.lang.daemon.OCLegacyAnnotator;
import com.jetbrains.cidr.lang.daemon.OCObjCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.TestAnnotationHolder;
import com.jetbrains.cidr.lang.inspections.CidrInspectionToolProvider;
import com.jetbrains.cidr.lang.legacy.daemon.OCDataFlowBasedAnnotator;
import com.jetbrains.cidr.lang.legacy.daemon.OCErrorAnnotator;
import com.jetbrains.cidr.lang.legacy.daemon.OCFormatStringsAnnotator;
import com.jetbrains.cidr.lang.legacy.daemon.OCResolveAnnotator;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureProcessor;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.util.ClangdCommonUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import icons.CidrLangIcons;
import icons.CidrProjectModelIcons;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.Icon;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import kotlin.text.StringsKt;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CidrCodeInsightFixture
implements CidrProjectDependentFixture {
    public static final String FND = "#import \"foundation.h\"\n";
    public static final String SIZE_T_DEFINITION = "typedef unsigned int size_t; namespace std { typedef unsigned int size_t; }\n";
    public static final Key<Object> DISABLE_CLANG_ERRORS = Key.create((String)"DISABLE_CLANG_ERRORS");
    public static final Key<Object> ENABLE_CLANG_WARNINGS = Key.create((String)"DISABLE_CLANG_WARNINGS");
    @NotNull
    protected CidrProjectFixture myProjectFixture;
    @NotNull
    protected CidrCodeInsightFixtureAdapter myProjectAdapter;
    @Nullable
    protected CodeInsightTestFixture myFixture;
    @Nullable
    private CompletionAutoPopupTester myCompletionAutoPopupTester;
    @Nullable
    private final String myTestFilesPath;
    @Nullable
    private String myTestFilesExtension;
    private final Set<VirtualFile> myCreatedFiles;
    private final Map<VirtualFile, String> myUpdatedFiles;
    private final List<FileTracker> myFileCreationTrackers;
    private static final Map<Icon, String> ICON_TO_TEXT = new HashMap<Icon, String>();

    public CidrCodeInsightFixture(@NotNull CidrProjectFixture projectFixture, @NotNull CidrCodeInsightFixtureAdapter projectAdapter) {
        if (projectFixture == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(0);
        }
        if (projectAdapter == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(1);
        }
        this(projectFixture, projectAdapter, null, null);
    }

    public CidrCodeInsightFixture(@NotNull CidrProjectFixture projectFixture, @NotNull CidrCodeInsightFixtureAdapter projectAdapter, @Nullable String testFilesPath, @Nullable String testFilesExtension) {
        if (projectFixture == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(2);
        }
        if (projectAdapter == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(3);
        }
        this.myCreatedFiles = new HashSet<VirtualFile>();
        this.myUpdatedFiles = new HashMap<VirtualFile, String>();
        this.myFileCreationTrackers = new ArrayList<FileTracker>();
        this.myProjectFixture = projectFixture;
        this.myProjectAdapter = projectAdapter;
        this.myTestFilesPath = testFilesPath;
        this.myTestFilesExtension = testFilesExtension;
    }

    public Annotator @NotNull [] getTestAnnotators() {
        Annotator[] annotatorArray = new Annotator[]{new OCBasicHighlighter(), new OCObjCAnnotator(), new OCFormatStringsAnnotator(), new OCHiddenNonVirtualFunctionAnnotator(), new OCErrorAnnotator(), new OCResolveAnnotator(), new OCDataFlowBasedAnnotator()};
        if (annotatorArray == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(4);
        }
        return annotatorArray;
    }

    public void addFileTracker(@NotNull FileTracker tracker) {
        if (tracker == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(5);
        }
        this.myFileCreationTrackers.add(tracker);
    }

    public void removeFileTracker(@NotNull FileTracker tracker) {
        if (tracker == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(6);
        }
        this.myFileCreationTrackers.remove(tracker);
    }

    @Nullable
    public String getTestFilesPath() {
        return this.myTestFilesPath;
    }

    public void setTestFilesExtension(@Nullable String extension) {
        this.myTestFilesExtension = extension;
    }

    public void setUp() throws Exception {
        this.myProjectFixture.addProjectDependentFixture(this);
        CidrTestListUpdater.setSchedulingDisabledInTests((Boolean)true);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
        if (symbolsKind == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(7);
        }
        return symbolsKind;
    }

    public void tearDown() throws Exception {
        this.myProjectFixture.removeProjectDependentFixture(this);
        CidrTestListUpdater.setSchedulingDisabledInTests(null);
    }

    @Override
    public void afterProjectOpened() throws Exception {
        IdeaProjectTestFixture ideaProjectTestFixture = new IdeaProjectTestFixture(){

            @Override
            public Project getProject() {
                return CidrCodeInsightFixture.this.myProjectFixture.getProject();
            }

            @Override
            public Module getModule() {
                return ModuleManager.getInstance((Project)this.getProject()).getModules()[0];
            }

            @Override
            public void setUp() {
            }

            @Override
            public void tearDown() {
            }
        };
        TempDirTestFixtureImpl dirTestFixture = new TempDirTestFixtureImpl(){

            @Override
            protected Path getTempHome() {
                return CidrCodeInsightFixture.this.myProjectFixture.getProjectIODir();
            }

            @Override
            public Path createTempFile(@NotNull String path) throws IOException {
                if (path == null) {
                    2.$$$reportNull$$$0(0);
                }
                return 2.createEmptyTempFile(this.getTempHome(), path);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/CidrCodeInsightFixture$2", "createTempFile"));
            }
        };
        CodeInsightTestFixtureImpl fixture = new CodeInsightTestFixtureImpl(ideaProjectTestFixture, dirTestFixture){

            @Override
            protected boolean shouldTrackVirtualFilePointers() {
                return false;
            }

            @Override
            protected void prepareVirtualFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                CidrCodeInsightFixture.this.prepareVirtualFile(file2);
                super.prepareVirtualFile(file2);
            }

            @Override
            @NotNull
            protected Editor createEditor(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                Editor editor = super.createEditor(file2);
                editor.getCaretModel().moveToOffset(0);
                Editor editor2 = editor;
                if (editor2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return editor2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/CidrCodeInsightFixture$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepareVirtualFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createEditor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.setFixture(fixture);
        Project project2 = this.getProject();
        OCCompilerFeatures.resetFeatures((Project)project2);
        project2.putUserData(OCFile.UNUSED_CHECKS, (Object)OCFile.UnusedChecksMode.DISABLED);
        project2.putUserData(OCFile.UNUSED_EXPRESSION_CHECKS, (Object)OCFile.UnusedChecksMode.DISABLED);
        project2.putUserData(OCFile.DFA_UNUSED_CHECKS, (Object)OCFile.UnusedChecksMode.DISABLED);
        project2.putUserData(OCFile.DFA_UNREACHABLE_CODE, (Object)false);
        project2.putUserData(OCChangeSignatureProcessor.CHECK_CONFLICTS, (Object)Boolean.TRUE);
        project2.putUserData(OCNewFileActionBase.FILE_FACTORY, (Object)new OCNewFileActionBase.FileFactory(){

            public PsiFile createFileFromText(@NotNull String fileName, @Nullable FileType fileType, @NotNull String text) {
                if (fileName == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    4.$$$reportNull$$$0(1);
                }
                TestCase.assertEquals((Object)OCFileType.INSTANCE, (Object)fileType);
                try {
                    text = text.replaceAll("#import <Foundation/Foundation.h>\n", CidrCodeInsightFixture.FND);
                    return CidrCodeInsightFixture.this.configureByText(text, fileName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$4";
                objectArray[2] = "createFileFromText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        WriteAction.runAndWait(() -> {
            for (PsiFile each : PsiManagerEx.getInstanceEx((Project)project2).getFileManager().getAllCachedFiles()) {
                if (!(each instanceof PsiFileImpl)) continue;
                each.clearCaches();
            }
        });
        CodeStyle.setTemporarySettings((Project)this.getProject(), (CodeStyleSettings)CodeStyle.createTestSettings());
        this.getOCSettings().INTRODUCE_GENERATE_PROPERTY = true;
        this.myCompletionAutoPopupTester = new CompletionAutoPopupTester(this.getFixture());
    }

    private void prepareVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(8);
        }
        for (FileTracker tracker : this.myFileCreationTrackers) {
            tracker.onCreated(file2);
        }
    }

    private void setFixture(@Nullable CodeInsightTestFixtureImpl fixture) throws Exception {
        if (this.myFixture != null) {
            this.myFixture.tearDown();
        }
        this.myFixture = fixture;
        if (this.myFixture != null) {
            if (this.myTestFilesPath != null) {
                this.myFixture.setTestDataPath(this.myTestFilesPath);
            }
            this.myFixture.setUp();
        }
    }

    @Override
    public void beforeProjectClosed() throws Exception {
        WriteAction.runAndWait(() -> this.deleteCreatedFiles());
        Project project2 = this.getProject();
        project2.putUserData(OCFile.UNUSED_CHECKS, null);
        project2.putUserData(OCFile.UNUSED_EXPRESSION_CHECKS, null);
        project2.putUserData(OCFile.DFA_UNUSED_CHECKS, null);
        project2.putUserData(OCFile.DFA_UNREACHABLE_CODE, null);
        project2.putUserData(OCChangeSignatureProcessor.CHECK_CONFLICTS, null);
        project2.putUserData(OCNewFileActionBase.FILE_FACTORY, null);
        OCCompilerFeatures.resetFeatures((Project)project2);
        CodeStyle.dropTemporarySettings((Project)project2);
        this.setFixture(null);
    }

    public void deleteCreatedFiles() {
        for (Map.Entry<VirtualFile, String> entry : this.myUpdatedFiles.entrySet()) {
            if (!entry.getKey().isValid()) continue;
            this.doWriteToExistingFile(entry.getKey(), entry.getValue());
        }
        this.myUpdatedFiles.clear();
        for (VirtualFile virtualFile : this.myCreatedFiles) {
            this.deleteCreatedFile(virtualFile);
        }
        this.myCreatedFiles.clear();
    }

    private void deleteCreatedFile(@NotNull VirtualFile each) {
        if (each == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(9);
        }
        if (!each.isValid()) {
            return;
        }
        if (each instanceof VirtualFileWindow) {
            each = ((VirtualFileWindow)each).getDelegate();
        }
        this.removeFileFromProject(each, false);
        FileEditorManager.getInstance((Project)this.getProject()).closeFile(each);
        try {
            each.delete((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCMakeFindUsages(CharSequence fileText, int expectedUsagesCount, Pair<String, Class> ... usages) throws Exception {
        UsefulTestCase.assertEquals((int)expectedUsagesCount, (int)usages.length);
        File tempCMakeFile = FileUtil.createTempFile((File)new File(this.getProject().getBasePath()), (String)"test", (String)".cmake");
        try {
            Object psiFile = this.configureByText(StringGroovyMethods.stripMargin((CharSequence)fileText), tempCMakeFile.getName());
            PsiReference referenceAtCaret = this.findReferenceAtCaret((PsiFile)psiFile);
            Assert.assertNotNull((Object)referenceAtCaret);
            PsiElement resolved = referenceAtCaret.getElement();
            Assert.assertNotNull((Object)resolved);
            FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)this.getProject())).getFindUsagesManager().getFindUsagesHandler(resolved, false);
            Assert.assertNotNull((Object)handler);
            FindUsagesOptions options = handler.getFindUsagesOptions();
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            for (PsiElement element : handler.getPrimaryElements()) {
                handler.processElementUsages(element, (Processor)processor, options);
            }
            for (PsiElement element : handler.getSecondaryElements()) {
                handler.processElementUsages(element, (Processor)processor, options);
            }
            ArrayList results = new ArrayList(processor.getResults());
            UsefulTestCase.assertEquals((int)expectedUsagesCount, (int)results.size());
            for (int i = 0; i < results.size(); ++i) {
                PsiElement element;
                UsageInfo usageInfo = (UsageInfo)results.get(i);
                element = usageInfo.getElement();
                Assert.assertNotNull((Object)element);
                Pair<String, Class> expectedUsage = usages[i];
                UsefulTestCase.assertEquals((String)((String)expectedUsage.getFirst()), (String)element.getText());
                UsefulTestCase.assertInstanceOf(element, (Class)expectedUsage.getSecond());
            }
        }
        finally {
            Assert.assertTrue((boolean)tempCMakeFile.delete());
        }
    }

    public void removeFilesFromProject(PsiFile ... files) {
        for (PsiFile file2 : files) {
            this.removeFileFromProject(file2.getVirtualFile());
        }
    }

    public void addFileToProject(@NotNull VirtualFile file2, boolean forceCachesReset) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(10);
        }
        EdtTestUtil.runInEdtAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile fileToAdd = file2;
            while (true) {
                if (!(fileToAdd instanceof VirtualFileWindow)) {
                    this.myProjectAdapter.addFileToProject(fileToAdd);
                    this.resetFileCaches(fileToAdd, forceCachesReset);
                    return;
                }
                fileToAdd = ((VirtualFileWindow)fileToAdd).getDelegate();
            }
        }));
    }

    public void removeFileFromProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(11);
        }
        this.removeFileFromProject(file2, true);
    }

    public void removeFileFromProject(@NotNull VirtualFile file2, boolean forceCachesReset) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(12);
        }
        EdtTestUtil.runInEdtAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            this.myProjectAdapter.removeFileFromProject(file2);
            this.resetFileCaches(file2, forceCachesReset);
        }));
    }

    public CodeStyleSettings getCodeStyleSettings() {
        return CodeStyle.getSettings((Project)this.getProject());
    }

    public CommonCodeStyleSettings getOCCommonSettings() {
        return this.getCodeStyleSettings().getCommonSettings(OCLanguageUtils.getConfigLanguage());
    }

    public OCCodeStyleSettings getOCSettings() {
        return (OCCodeStyleSettings)this.getCodeStyleSettings().getCustomSettings(OCCodeStyleSettings.class);
    }

    public void resetFileCaches(@NotNull VirtualFile file2, boolean resetSymbols) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(13);
        }
        if (!file2.isValid()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file2);
        Assert.assertNotNull((Object)psiFile);
        psiFile.clearCaches();
        if (resetSymbols) {
            WriteAction.run(() -> FileSymbolTablesCache.getInstance((Project)this.getProject()).handleOutOfCodeBlockChange(psiFile, true));
            FileSymbolTablesCache.getInstance((Project)this.getProject()).ensurePendingFilesProcessed();
        }
    }

    @NotNull
    public CodeInsightTestFixture getFixture() {
        Assert.assertNotNull((String)"trying to access non-initialized code fixture", (Object)this.myFixture);
        CodeInsightTestFixture codeInsightTestFixture = this.myFixture;
        if (codeInsightTestFixture == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(14);
        }
        return codeInsightTestFixture;
    }

    public void setCaresAboutInjectionIfFixtureIsInitialized(boolean value) {
        CodeInsightTestFixture fixture = this.myFixture;
        if (fixture != null) {
            fixture.setCaresAboutInjection(value);
        }
    }

    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    public Editor getEditor() {
        return this.getFixture().getEditor();
    }

    public PsiFile getFile() {
        PsiFile file2 = this.getFixture().getFile();
        if (file2 == null) {
            return null;
        }
        VirtualFile mayBeInjectedVFile = file2.getViewProvider().getVirtualFile();
        while (mayBeInjectedVFile instanceof VirtualFileWindow) {
            mayBeInjectedVFile = ((VirtualFileWindow)mayBeInjectedVFile).getDelegate();
        }
        VirtualFile hostFile = mayBeInjectedVFile;
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(hostFile));
    }

    public OCFile getOCFile() {
        return (OCFile)this.getFile(OCLanguageUtils.getSlowLanguage());
    }

    @NotNull
    public PsiFile getFile(@NotNull Language language) {
        if (language == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(15);
        }
        PsiFile file2 = this.getFile().getViewProvider().getPsi(language);
        Assert.assertNotNull((Object)file2);
        PsiFile psiFile = file2;
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(16);
        }
        return psiFile;
    }

    public Document getDocument() {
        return this.getFixture().getDocument(this.getFile());
    }

    public int getCaretOffset() {
        return this.getFixture().getCaretOffset();
    }

    public TextRange getSelection() {
        SelectionModel sm = this.getEditor().getSelectionModel();
        return sm.hasSelection() ? new TextRange(sm.getSelectionStart(), sm.getSelectionEnd()) : this.getFile().getTextRange();
    }

    @Nullable
    public PsiElement resolveElementAtCaret(@NotNull PsiFile file2) {
        PsiReference reference;
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(17);
        }
        return (reference = this.findReferenceAtCaret(file2)) != null ? reference.resolve() : null;
    }

    @Nullable
    public PsiReference findReferenceAtCaret(@NotNull PsiFile file2) {
        PsiElement elementAtCaret;
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(18);
        }
        for (elementAtCaret = this.findElementAtCaret(file2); elementAtCaret != null && elementAtCaret.getReference() == null; elementAtCaret = elementAtCaret.getParent()) {
        }
        return elementAtCaret != null ? elementAtCaret.getReference() : null;
    }

    @Nullable
    public <T extends PsiElement> T findElementByText(@NotNull String text, @NotNull Language language, @NotNull Class<T> elementClass) {
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(19);
        }
        if (language == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(20);
        }
        if (elementClass == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(21);
        }
        PsiFile file2 = this.getFile(language);
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text);
        Assert.assertTrue((String)text, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(pos), elementClass);
    }

    @NotNull
    public PsiElement findElementAtCaret(PsiFile file2) {
        PsiElement result = file2.findElementAt(this.getFixture().getCaretOffset());
        Assert.assertNotNull((String)"Cannot find element at caret", (Object)result);
        PsiElement psiElement = result;
        if (psiElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @NotNull
    public <T extends PsiElement> T findElementOfClassAtCaret(PsiFile file2, Class<T> elementClass) {
        PsiElement element = this.findElementAtCaret(file2);
        PsiElement result = PsiTreeUtil.getParentOfType((PsiElement)element, elementClass);
        Assert.assertNotNull((String)("Cannot find " + elementClass.getSimpleName() + " element at caret"), (Object)result);
        PsiElement psiElement = result;
        if (psiElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(23);
        }
        return (T)psiElement;
    }

    @NotNull
    public OCExpression findExpressionAtCaret(OCFile file2) {
        OCExpression oCExpression = this.findElementOfClassAtCaret((PsiFile)file2, OCExpression.class);
        if (oCExpression == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(24);
        }
        return oCExpression;
    }

    @NotNull
    public <T extends PsiElement> T findNodeAtSelection(PsiFile file2, Class<T> nodeClass) {
        SelectionModel m = this.getFixture().getEditor().getSelectionModel();
        for (PsiElement elt = OCLanguageUtils.tryGetOCFile((PsiFile)file2).findElementAt(m.getSelectionStart()); elt != null; elt = elt.getParent()) {
            TextRange range;
            if (nodeClass.isAssignableFrom(elt.getClass()) && ((range = elt.getTextRange()).getStartOffset() == m.getSelectionStart() && range.getEndOffset() == m.getSelectionEnd() || nodeClass.equals(OCFile.class))) {
                PsiElement psiElement = elt;
                if (psiElement == null) {
                    CidrCodeInsightFixture.$$$reportNull$$$0(25);
                }
                return (T)psiElement;
            }
            if (elt instanceof PsiFile) break;
        }
        throw new AssertionFailedError("Cannot find " + nodeClass.getName() + " in exact range of selection");
    }

    @NotNull
    public OCExpression findExpressionAtSelection(OCFile file2) {
        OCExpression oCExpression = this.findNodeAtSelection((PsiFile)file2, OCExpression.class);
        if (oCExpression == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(26);
        }
        return oCExpression;
    }

    public void checkFindUsages(String expected, String errorDetails, @Nullable SearchScope scope) {
        PsiElement targetElement = this.getFindUsageTargetElement(errorDetails);
        String res = this.findUsages(targetElement, scope);
        UsefulTestCase.assertEquals((String)("Wrong usages for referenced element: " + errorDetails), (String)expected.trim(), (String)res.trim());
    }

    public void checkFindUsagesOnNonDispatchThread(String expected, String errorDetails, @Nullable SearchScope scope) {
        PsiElement targetElement = this.getFindUsageTargetElement(errorDetails);
        final FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)this.getProject())).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        String targetName = targetElement.toString();
        Assert.assertNotNull((String)("Cannot find handler for: " + targetName), (Object)handler);
        final CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        final PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements());
        Future future = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(new Task.Backgroundable(this.getProject(), "hasNull"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    FindUsagesOptions options = handler.getFindUsagesOptions(null);
                    Project project2 = ProjectCoreUtil.theProject;
                    ProjectCoreUtil.theProject = null;
                    for (PsiElement psiElement : psiElements) {
                        handler.processElementUsages(psiElement, (Processor)processor, options);
                    }
                    ProjectCoreUtil.theProject = project2;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/CidrCodeInsightFixture$5", "run"));
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            UsefulTestCase.fail((String)e.getMessage());
        }
        Collection usageInfos = processor.getResults();
        String res = this.usageInfosToString(usageInfos);
        UsefulTestCase.assertEquals((String)("Wrong usages for referenced element: " + errorDetails), (String)expected.trim(), (String)res.trim());
    }

    public String findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(27);
        }
        return this.findUsages(targetElement, null);
    }

    public String findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        if (targetElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(28);
        }
        Collection<UsageInfo> usages = ((CodeInsightTestFixtureImpl)this.getFixture()).findUsages(targetElement, scope);
        return this.usageInfosToString(usages);
    }

    private PsiElement getFindUsageTargetElement(String errorDetails) {
        PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)TargetElementUtil.getInstance().getReferenceSearchFlags());
        Assert.assertNotNull((Object)targetElement);
        Assert.assertNotNull((String)("Cannot find referenced element: " + errorDetails), (Object)targetElement);
        return targetElement;
    }

    private String usageInfosToString(Collection<UsageInfo> usages) {
        List results = ContainerUtil.map(usages, info -> {
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(info.getFile());
            int startOffset = info.getSegment().getStartOffset();
            int line = document.getLineNumber(startOffset);
            return info.getVirtualFile().getName() + ":" + (line + 1) + ":" + (startOffset - document.getLineStartOffset(line) + 1);
        });
        ContainerUtil.sort((List)results);
        return StringUtil.join((Collection)results, (String)"\n");
    }

    @Nullable
    public OCFile findOCFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(29);
        }
        return this.myProjectFixture.findProjectSubOCFile(relativePath);
    }

    @NotNull
    public OCFile getOCFile(String relativePath) {
        OCFile oCFile = this.myProjectFixture.getProjectSubOCFile(relativePath);
        if (oCFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(30);
        }
        return oCFile;
    }

    @Nullable
    public PsiFile findFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(31);
        }
        return this.myProjectFixture.findProjectSubPsiFile(relativePath);
    }

    public void processOCFiles(final @NotNull PairProcessor<OCFile, VirtualFile> processor, int expectedCount) {
        if (processor == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(32);
        }
        class CountingIterator
        implements ContentIterator {
            public int processed = 0;

            CountingIterator() {
            }

            public boolean processFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    CountingIterator.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory() || !OCFileTypeHelpers.isHeaderFile((String)file2.getName()) && !OCFileTypeHelpers.isSourceFile((String)file2.getName())) {
                    return true;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)CidrCodeInsightFixture.this.getProject()).findFile(file2);
                Assert.assertNotNull((Object)psiFile);
                PsiDocumentManager.getInstance((Project)CidrCodeInsightFixture.this.getProject()).getDocument(psiFile);
                UsefulTestCase.assertInstanceOf(psiFile, OCFile.class);
                ++this.processed;
                return processor.process((Object)((OCFile)psiFile), (Object)file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/CidrCodeInsightFixture$1CountingIterator", "processFile"));
            }
        }
        CountingIterator iterator = new CountingIterator();
        ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().iterateContent((ContentIterator)iterator);
        TestCase.assertEquals((String)"Wrong number of files processed", (int)expectedCount, (int)iterator.processed);
    }

    public OCSymbol lookup(OCFile psiFile, String symbolName, OCLanguageKind kind) {
        FileSymbolTable table = FileSymbolTable.forFile((PsiFile)psiFile, (OCInclusionContext)OCInclusionContext.empty((OCLanguageKind)kind, (PsiFile)psiFile));
        Assert.assertNotNull((Object)table);
        OCSymbol[] answer = new OCSymbol[]{null};
        FileSymbolTable.ProcessingState state = new FileSymbolTable.ProcessingState(OCInclusionContext.empty((OCLanguageKind)kind, (PsiFile)psiFile), false);
        table.processSymbols(ocSymbol -> {
            answer[0] = ocSymbol;
            return true;
        }, symbolName, state, null, null, null);
        return answer[0];
    }

    public OCType parseTypeCpp(String type) {
        return this.parseDeclTypeCpp(type + " x;");
    }

    public OCType parseDeclTypeCpp(CharSequence text) {
        CLanguageKind kind = CLanguageKind.CPP;
        OCFile psiFile = this.configureByText(text.toString(), (OCLanguageKind)kind);
        OCType type = this.lookup(psiFile, "x", (OCLanguageKind)kind).getType().resolve((PsiElement)psiFile);
        return OCTypeCloneVisitor.cloneType((OCType)type, (OCTypeCloneVisitor)new OCTypeCloneVisitor(false){

            public OCType visitReferenceType(OCReferenceType type) {
                OCSymbolReference reference = type.getReference();
                OCReferenceTypeBuilder resultBuilder = new OCReferenceTypeBuilder(reference);
                resultBuilder.setProtocolSubstitutionARCFromType(type);
                resultBuilder.setConstVolatile(this.isConstCopy((OCType)type), this.isVolatileCopy((OCType)type));
                resultBuilder.setFunctionParameterType(type.isFunctionParameterType());
                resultBuilder.setIsKindof(type.isKindof());
                resultBuilder.setNullability(type.getNullability());
                return resultBuilder.build();
            }
        });
    }

    public OCType parseTypeObjC(@NotNull CharSequence text) {
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(33);
        }
        CLanguageKind kind = CLanguageKind.OBJ_C;
        OCFile psiFile = this.configureByText("#import <Foundation/Foundation.h>\n" + text.toString() + " x;", (OCLanguageKind)kind);
        return this.lookup(psiFile, "x", (OCLanguageKind)kind).getType().resolve((PsiElement)psiFile);
    }

    @NotNull
    private static String textForExpression(@NotNull String text) {
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(34);
        }
        String string = "#import \"foundation.h\"\n@implementation -(void) foo {\n    " + text.trim() + ";\n} @end";
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(35);
        }
        return string;
    }

    public OCFile configureByExpressionOCpp(@NotNull String text) {
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(36);
        }
        return this.configureByTextOCpp(CidrCodeInsightFixture.textForExpression(text));
    }

    public OCFile configureByExpressionOC(@NotNull String text) {
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(37);
        }
        return this.configureByTextOC(CidrCodeInsightFixture.textForExpression(text));
    }

    public OCFile configureByTextC(String text) {
        return this.configureByText(text, (OCLanguageKind)CLanguageKind.C);
    }

    public OCFile configureByTextOCpp(String text) {
        return this.configureByText(text, (OCLanguageKind)CLanguageKind.OBJ_CPP);
    }

    public OCFile configureByTextCpp(String text) {
        return this.configureByText(text, (OCLanguageKind)CLanguageKind.CPP);
    }

    public OCFile configureByTextOC(String text) {
        return this.configureByText(text, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public OCFile configureByText(String text, OCLanguageKind languageKind) {
        OCPsiFile file2 = (OCPsiFile)this.configureByText(text, "test." + languageKind.getDefaultSourceExtension());
        return file2.getOCFile();
    }

    public OCFile configureByTextOC(String text, String fileName) {
        OCPsiFile file2 = (OCPsiFile)this.configureByText(text, fileName);
        return file2.getOCFile();
    }

    public <T extends PsiFile> T configureByText(String text, String fileName) {
        return this.configureByText(text, fileName, true);
    }

    @NotNull
    public <T extends PsiFile> T configureByText(String text, String fileName, String directory) {
        T t = this.configureByText(text, fileName, directory, true);
        if (t == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(38);
        }
        return t;
    }

    public <T extends PsiFile> T configureByText(String text, String fileName, boolean forceResetCaches) {
        com.jetbrains.cidr.TestAnnotationHolder.findAndSetEnabledLanguageFeatures(text, this.getProject());
        this.getProject().putUserData(ClangdCommonUtil.DISABLED_WARNINGS, com.jetbrains.cidr.TestAnnotationHolder.findDisabledClangWarnings(text, this.getProject()));
        PsiFile existing = this.tryConfigureWithExistingFile(fileName, text, forceResetCaches);
        if (existing != null) {
            return (T)existing;
        }
        VirtualFile file2 = this.getFixture().configureByText(fileName, text).getVirtualFile();
        this.postConfigureByFile(file2, forceResetCaches);
        return (T)this.getFile();
    }

    @NotNull
    public <T extends PsiFile> T configureByText(String text, String fileName, String directory, boolean forceResetCaches) {
        PsiFile existing = this.tryConfigureWithExistingFile(directory + "/" + fileName, text, forceResetCaches);
        if (existing != null) {
            PsiFile psiFile = existing;
            if (psiFile == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(39);
            }
            return (T)psiFile;
        }
        VirtualFile file2 = null;
        try {
            file2 = (VirtualFile)WriteAction.computeAndWait(() -> {
                File dir = new File(this.myProjectFixture.getProjectIODir() + "/" + directory);
                Assert.assertTrue((boolean)FileUtil.createDirectory((File)dir));
                VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir).findOrCreateChildData((Object)this, fileName);
                VfsUtil.saveText((VirtualFile)vFile, (String)text);
                com.jetbrains.cidr.TestAnnotationHolder.findAndSetEnabledLanguageFeatures(text, this.getProject());
                this.getProject().putUserData(ClangdCommonUtil.DISABLED_WARNINGS, com.jetbrains.cidr.TestAnnotationHolder.findDisabledClangWarnings(text, this.getProject()));
                this.getFixture().configureFromExistingVirtualFile(vFile);
                return vFile;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.postConfigureByFile(file2, forceResetCaches);
        PsiFile psiFile = this.getFile();
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(40);
        }
        return (T)psiFile;
    }

    @Nullable
    private PsiFile tryConfigureWithExistingFile(String fileName, String text, boolean forceResetCaches) {
        VirtualFile existing = this.findExistingFileAndSetText(fileName, text);
        if (existing == null) {
            return null;
        }
        return (PsiFile)WriteCommandAction.writeCommandAction((Project)this.getProject()).compute(() -> {
            this.myFixture.configureFromExistingVirtualFile(existing);
            this.prepareVirtualFile(existing);
            this.updateCaretOffset();
            this.resetFileCaches(existing, forceResetCaches);
            return this.getFile();
        });
    }

    private void postConfigureByFile(@NotNull VirtualFile virtualFile, boolean forceResetCaches) {
        if (virtualFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(41);
        }
        this.updateCreatedFiles(virtualFile, forceResetCaches);
        this.updateCaretOffset();
    }

    private void updateCaretOffset() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            int selectionStart = this.getEditor().getSelectionModel().getSelectionStart();
            if (selectionStart > 0 && this.getEditor().getCaretModel().getOffset() == 0) {
                this.getEditor().getCaretModel().moveToOffset(selectionStart);
            }
        });
    }

    private void updateCreatedFiles(@NotNull VirtualFile virtualFile, boolean forceResetCaches) {
        if (virtualFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(42);
        }
        this.myCreatedFiles.stream().filter(f -> f.getPath().equals(virtualFile.getPath())).forEach(this::removeFileFromProject);
        this.myCreatedFiles.add(virtualFile);
        this.addFileToProject(virtualFile, forceResetCaches);
    }

    @NotNull
    public PsiFile addFileToProject(String text, String fileName) {
        VirtualFile file2;
        VirtualFile existing = this.findExistingFileAndSetText(fileName, text);
        if (existing != null) {
            this.prepareVirtualFile(existing);
            file2 = existing;
        } else {
            file2 = this.getFixture().addFileToProject(fileName, text).getVirtualFile();
            this.updateCreatedFiles(file2, true);
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(file2));
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(43);
        }
        return psiFile;
    }

    @Nullable
    private VirtualFile findExistingFileAndSetText(@NotNull String fileName, @NotNull String text) {
        VirtualFile file2;
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(44);
        }
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(45);
        }
        if ((file2 = this.myProjectFixture.findProjectSubFile(fileName)) == null) {
            return null;
        }
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationFor((VirtualFile)file2, (Project)this.getProject());
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> this.doWriteToExistingFile(file2, text));
        return file2;
    }

    private void doWriteToExistingFile(@NotNull VirtualFile file2, @NotNull String text) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(46);
        }
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(47);
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(file2);
        this.myUpdatedFiles.putIfAbsent(file2, document.getText());
        if (documentManager.isDocumentUnsaved(document)) {
            document.setText((CharSequence)text);
            documentManager.saveDocument(document);
        } else {
            this.myFixture.saveText(file2, text);
        }
    }

    public OCFile configureByFile(String testName) throws Exception {
        return this.configureByFile(testName, "." + this.myTestFilesExtension, null);
    }

    public OCFile configureByFile(String testName, String fileNameSuffix) throws Exception {
        return this.configureByFile(testName, fileNameSuffix, null);
    }

    protected OCFile configureByFile(String testName, String fileNameSuffix, @Nullable String text) throws Exception {
        String fileName = this.getFullFileName(testName, fileNameSuffix);
        if (text == null) {
            text = this.loadFile(fileName);
        }
        OCPsiFile file2 = (OCPsiFile)this.configureByText(text, fileName);
        return file2.getOCFile();
    }

    @NotNull
    public String loadFile(@TestDataFile String name) throws IOException {
        String string = CidrCodeInsightFixture.doLoadFile(this.getFullFilePath(name));
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(48);
        }
        return string;
    }

    public String loadFile(String testName, String fileName) throws IOException {
        return this.loadFile(this.getFullFileName(testName, fileName));
    }

    public String tryLoadFile(@TestDataFile String name) throws IOException {
        String fullPath = this.getFullFilePath(name);
        return FileUtil.exists((String)fullPath) ? this.loadFile(name) : null;
    }

    private static String doLoadFile(String fullPath) throws IOException {
        String text = FileUtil.loadFile((File)new File(fullPath), (Charset)StandardCharsets.UTF_8);
        text = StringUtil.convertLineSeparators((String)text);
        return text;
    }

    @NotNull
    public String getFullFilePath(@NotNull String fileName) {
        if (fileName == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(49);
        }
        String string = this.myTestFilesPath + File.separatorChar + fileName;
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(50);
        }
        return string;
    }

    public String getFullFileName(String testName, String fileNameSuffix) {
        Object fileName = StringUtil.join((Object[])UsefulTestCase.getTestName(testName, true).split("_"), StringUtil::decapitalize, (String)"-");
        if (!fileNameSuffix.isEmpty()) {
            fileName = (String)fileName + (String)(fileNameSuffix.startsWith(".") ? fileNameSuffix : "-" + fileNameSuffix);
        }
        return fileName;
    }

    public void checkResult(@NotNull String text) {
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(51);
        }
        this.getFixture().checkResult(text);
    }

    public void checkResultWithoutFormatting(String expectedFileText) {
        this.checkResultWithoutFormatting(expectedFileText, this.getFile());
    }

    public void checkResultWithoutFormatting(String expectedFileText, PsiFile file2) {
        UsefulTestCase.assertEquals((String)CidrCodeInsightFixture.removeFormatting(expectedFileText), (String)CidrCodeInsightFixture.removeFormatting(file2.getText()));
    }

    public static String removeFormatting(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char symbol = string.charAt(i);
            if (Character.isWhitespace(symbol)) continue;
            result.append(symbol);
        }
        return result.toString();
    }

    public void typeWithPauses(String text) {
        this.myCompletionAutoPopupTester.typeWithPauses(text);
    }

    public void runWithAutoPopupEnabled(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (runnable == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(52);
        }
        this.myCompletionAutoPopupTester.runWithAutoPopupEnabled(runnable);
    }

    public void assertSearchEverywhereShowsSameItems(String name, boolean isClass, ChooseByNameContributor contributor, boolean includeNonProjectItems) {
        List<NavigationItem> items = Arrays.asList(contributor.getItemsByName(name, name, this.getProject(), includeNonProjectItems));
        UsefulTestCase.assertNotEmpty(items);
        List mismatchingSymbolNames = ContainerUtil.map((Collection)ContainerUtil.filter(items, item -> isClass ? !SearchEverywhereClassifier.EP_Manager.isClass((Object)item) : !SearchEverywhereClassifier.EP_Manager.isSymbol((Object)item)), item -> item.getPresentation().getPresentableText());
        UsefulTestCase.assertEmpty("Non " + (isClass ? "classes" : "symbols") + " were shown", mismatchingSymbolNames);
    }

    public void assertGuttersAtCaret(GutterInfo ... expectedGutters) {
        if (expectedGutters == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(53);
        }
        UsefulTestCase.assertOrderedEquals(ContainerUtil.map(this.getFixture().findGuttersAtCaret(), GutterInfo::new), expectedGutters);
    }

    public List<OCImportSymbolFix> findAutoImports(PsiElement element) {
        OCFile file2 = (OCFile)element.getContainingFile();
        TestAnnotationHolder testHolder = new TestAnnotationHolder(this, (PsiFile)file2);
        try {
            this.runCheckAndGetAnnotations((PsiFile)file2, this.getEditor(), element, testHolder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ContainerUtil.findAll(testHolder.getQuickFixes(), OCImportSymbolFix.class);
    }

    public void assertAutoImports(OCFile file2) {
        this.assertAutoImports(file2, new AutoImportFix[0]);
    }

    public void assertAutoImports(OCFile file2, AutoImportChoice ... expectedChoices) {
        this.assertAutoImportsAtSelection(file2, OCFile.class, expectedChoices);
    }

    public void assertAutoImports(OCFile file2, AutoImportFix ... expectedFixes) {
        this.assertAutoImportsAtSelection(file2, OCFile.class, expectedFixes);
    }

    public void assertAutoImportsAtSelection(OCFile file2, Class<? extends PsiElement> elementToCheck) {
        this.assertAutoImportsAtSelection(file2, elementToCheck, new AutoImportFix[0]);
    }

    public void assertAutoImportsAtSelection(OCFile file2, Class<? extends PsiElement> elementToCheck, AutoImportChoice ... expectedChoices) {
        AutoImportFix[] expectedFixes = expectedChoices.length == 0 ? new AutoImportFix[]{} : new AutoImportFix[]{new AutoImportFix("<any_auto_import_title>", "<any_auto_import_title>", expectedChoices)};
        this.assertAutoImportsAtSelection(file2, elementToCheck, expectedFixes);
    }

    public void assertAutoImportsAtSelection(OCFile file2, Class<? extends PsiElement> elementToCheck, AutoImportFix ... expectedFixes) {
        PsiElement selection = this.findNodeAtSelection((PsiFile)file2, elementToCheck);
        List<OCImportSymbolFix> fixes = this.findAutoImports(selection);
        this.assertAutoImports(file2, fixes, expectedFixes);
    }

    public void assertAutoImports(OCFile file2, List<OCImportSymbolFix> fixes, AutoImportFix ... expectedFixes) {
        ArrayList<AutoImportFix> actualFixes = new ArrayList<AutoImportFix>();
        for (OCImportSymbolFix eachFix : fixes) {
            ArrayList<AutoImportChoice> choices = new ArrayList<AutoImportChoice>();
            for (OCImportSymbolFix.AutoImportItem eachItem : eachFix.getAutoImportItems()) {
                PsiFile copy = (PsiFile)file2.copy();
                eachItem.invoke(this.getProject(), copy);
                Pair titleAndLocation = eachItem.getTitleAndLocation();
                choices.add(new AutoImportChoice((String)titleAndLocation.first + " @ " + (String)titleAndLocation.second, copy.getText()));
            }
            Pair popupText = eachFix.getText(true);
            actualFixes.add(new AutoImportFix(eachFix.getText(), (String)popupText.first + ((Boolean)popupText.second != false ? "..." : ""), choices));
        }
        UsefulTestCase.assertOrderedEquals(actualFixes, expectedFixes);
    }

    public void type(String text) {
        this.getFixture().type(text);
    }

    public void runActionInCommandAction(IntentionAction action, PsiFile file2) {
        if (action.startInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> action.invoke(file2.getProject(), this.getEditor(), file2));
        } else {
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> action.invoke(file2.getProject(), this.getEditor(), file2), null, null);
        }
    }

    public void runActionInCommandAction(CodeInsightActionHandler action, OCFile file2) {
        Runnable runnable = () -> {
            action.invoke(file2.getProject(), this.getEditor(), (PsiFile)file2);
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitAllDocuments();
        };
        if (action.startInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (Runnable)runnable);
        } else {
            CommandProcessor.getInstance().executeCommand(this.getProject(), runnable, null, null);
        }
    }

    public void checkAnnotations(String testName) throws Exception {
        this.checkAnnotations(this.configureByFile(testName));
    }

    public <T extends PsiFile> void checkAnnotations(@NotNull T file2) throws Exception {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(54);
        }
        this.checkAnnotations(file2, null, null);
    }

    public <T extends PsiFile> void checkAnnotations(@NotNull T file2, @Nullable HighlightSeverity minimalSeverityOrNull, @Nullable Function<? super T, String> extraInfoProvider) throws Exception {
        List<String> messages;
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(55);
        }
        if ((messages = this.getAnnotationMessages(file2, minimalSeverityOrNull)) == null) {
            System.out.println("Disabled");
        } else if (!messages.isEmpty()) {
            String message = "\n" + (String)(extraInfoProvider == null ? "" : (String)extraInfoProvider.fun(file2) + "\n") + StringUtil.join(messages, (String)"\n");
            UsefulTestCase.fail((String)message);
        }
    }

    public List<String> getAnnotationMessages(@NotNull PsiFile file2, @Nullable HighlightSeverity minimalSeverityOrNull) throws Exception {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(56);
        }
        return (List)ApplicationManager.getApplication().runReadAction(() -> {
            final ArrayList messages = new ArrayList();
            file2.getProject().putUserData(OCFile.DFA_UNREACHABLE_CODE, (Object)true);
            com.jetbrains.cidr.TestAnnotationHolder testHolder = new com.jetbrains.cidr.TestAnnotationHolder(minimalSeverityOrNull, file2){

                @Override
                protected void fail(String message) {
                    messages.add(message);
                }

                @Override
                protected void assertTrue(String message, boolean condition) {
                    if (!condition) {
                        messages.add(message);
                    }
                }
            };
            if (testHolder.isTestDisabled()) {
                return null;
            }
            ArrayList nodes = new ArrayList();
            OCElementUtil.fillChildrenRecursive((PsiElement)file2, nodes);
            this.runCheckAndGetAnnotations(file2, null, nodes, (PsiElement)(testHolder.isRunInspections() ? file2 : null), testHolder);
            testHolder.checkAllExpectedAnnotationsFound();
            return messages;
        });
    }

    public void runCheckAndGetAnnotations(@NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement nodeToCheck, @NotNull TestAnnotationInfoList testHolder) throws Exception {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(57);
        }
        if (nodeToCheck == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(58);
        }
        if (testHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(59);
        }
        ArrayList<PsiElement> nodes = new ArrayList<PsiElement>();
        if (nodeToCheck instanceof OCFile) {
            OCElementUtil.fillChildrenRecursive((PsiElement)nodeToCheck, nodes);
        }
        nodes.add(nodeToCheck);
        this.runCheckAndGetAnnotations(file2, editor, nodes, nodeToCheck, testHolder);
    }

    public void runCheckAndGetAnnotations(@NotNull PsiFile file2, @Nullable Editor editor, @NotNull List<? extends PsiElement> nodesForAnnotator, @Nullable PsiElement nodeForInspections, @NotNull TestAnnotationInfoList testHolder) throws Exception {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(60);
        }
        if (nodesForAnnotator == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(61);
        }
        if (testHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(62);
        }
        ProblemsHolder problemsHolder = CidrCodeInsightFixture.getTestProblemsHolder(false, file2, editor, testHolder);
        testHolder.annotationsAdded(CidrCodeInsightFixture.runAnnotators(file2, nodesForAnnotator, this.getTestAnnotators()));
        if (nodeForInspections != null) {
            CidrCodeInsightFixture.runInspections(file2, nodeForInspections, problemsHolder);
        }
        if (OCLegacyAnnotator.isEnabledFor((PsiFile)file2)) {
            return;
        }
        for (CidrExternalAnnotationsProvider provider : CidrExternalAnnotationsProvider.EP_NAME.getExtensionList()) {
            provider.addExternalAnnotations(file2, editor, nodesForAnnotator, nodeForInspections, testHolder);
        }
    }

    @NotNull
    public static List<Annotation> runAnnotators(@NotNull PsiFile file2, @NotNull List<? extends PsiElement> elements, Annotator ... annotators) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(63);
        }
        if (elements == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(64);
        }
        if (annotators == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(65);
        }
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        for (PsiElement psiElement : elements) {
            for (Annotator annotator : annotators) {
                annotationHolder.runAnnotatorWithContext(psiElement, annotator);
            }
        }
        annotationHolder.assertAllAnnotationsCreated();
        ImmutableList immutableList = ContainerUtil.immutableList((List)annotationHolder);
        if (immutableList == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(66);
        }
        return immutableList;
    }

    public static void runInspections(@NotNull PsiFile file2, @NotNull PsiElement nodeForInspections, @NotNull ProblemsHolder problemsHolder) throws InstantiationException, IllegalAccessException {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(67);
        }
        if (nodeForInspections == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(68);
        }
        if (problemsHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(69);
        }
        for (Class clazz : CidrInspectionToolProvider.getStandaloneInspectionClasses()) {
            if (!LocalInspectionTool.class.isAssignableFrom(clazz)) continue;
            LocalInspectionTool inspection = (LocalInspectionTool)clazz.newInstance();
            CidrCodeInsightFixture.runInspection(file2, nodeForInspections, inspection, problemsHolder);
        }
    }

    public static void runInspection(@NotNull PsiFile file2, @NotNull PsiElement nodeForInspections, LocalInspectionTool inspection, ProblemsHolder problemsHolder) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(70);
        }
        if (nodeForInspections == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(71);
        }
        CidrCodeInsightFixture.runInspection(file2, nodeForInspections, inspection, problemsHolder, true);
    }

    public static void runInspection(@NotNull PsiFile file2, final @NotNull PsiElement nodeForInspections, @NotNull LocalInspectionTool inspection, @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(72);
        }
        if (nodeForInspections == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(73);
        }
        if (inspection == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(74);
        }
        if (problemsHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(75);
        }
        ProgressManager.getInstance().runProcess(() -> {
            LocalInspectionToolSession session = new LocalInspectionToolSession(file2, nodeForInspections.getTextOffset(), nodeForInspections.getTextRange().getEndOffset());
            inspection.inspectionStarted(session, isOnTheFly);
            final PsiElementVisitor visitor = inspection.buildVisitor(problemsHolder, isOnTheFly, session);
            nodeForInspections.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if (element == nodeForInspections || !element.getClass().equals(nodeForInspections.getClass())) {
                        element.accept(visitor);
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/CidrCodeInsightFixture$8", "visitElement"));
                }
            });
            inspection.inspectionFinished(session, problemsHolder);
        }, (ProgressIndicator)new DaemonProgressIndicator());
    }

    @NotNull
    public static ProblemsHolder getTestProblemsHolder(final boolean checkRanges, @NotNull PsiFile file2, final @Nullable Editor editor, final @NotNull TestAnnotationInfoList testHolder) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(76);
        }
        if (testHolder == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(77);
        }
        return new ProblemsHolder(InspectionManager.getInstance((Project)file2.getProject()), file2, true){

            public void registerProblem(@NotNull ProblemDescriptor problem) {
                if (problem == null) {
                    9.$$$reportNull$$$0(0);
                }
                int offset = problem.getStartElement().getTextOffset();
                if (!checkRanges || editor.getSelectionModel().getSelectionStart() <= offset && offset < editor.getSelectionModel().getSelectionEnd()) {
                    TextRange range = new TextRange(problem.getStartElement().getTextRange().getStartOffset(), problem.getEndElement().getTextRange().getEndOffset());
                    testHolder.annotationAdded(HighlightSeverity.WARNING, range, problem.getDescriptionTemplate());
                    for (QuickFix quickFix : problem.getFixes()) {
                        if (quickFix instanceof IntentionWrapper) {
                            testHolder.createQuickFix((Segment)range, ((IntentionWrapper)quickFix).getAction());
                            continue;
                        }
                        if (!(quickFix instanceof LocalQuickFix) || !(quickFix instanceof IntentionAction)) continue;
                        testHolder.createQuickFix((Segment)range, (IntentionAction)quickFix);
                    }
                    if (problem.getProblemGroup() instanceof OCProblemGroup) {
                        for (QuickFix quickFix : ((OCProblemGroup)problem.getProblemGroup()).getSuppressActions(null)) {
                            testHolder.createQuickFix((Segment)range, (IntentionAction)quickFix);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/jetbrains/cidr/CidrCodeInsightFixture$9", "registerProblem"));
            }
        };
    }

    public void edit(@NotNull PsiFile file2, @NotNull Function<Document, Void> docFunction) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(78);
        }
        if (docFunction == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(79);
        }
        CommandProcessor.getInstance().executeCommand(file2.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
            Document document = manager.getDocument(file2);
            Assert.assertNotNull((Object)document);
            docFunction.fun((Object)document);
            manager.commitDocument(document);
            FileDocumentManager.getInstance().saveDocumentAsIs(document);
        }), "change doc", (Object)"");
    }

    public void assertIcons(@NotNull PsiElement rootElement, @Nullable Function<PsiElement, OCSymbol> symbolExtractor, String ... expectedIcons) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(80);
        }
        UsefulTestCase.assertOrderedEquals(this.getIconsAsStrings(rootElement, symbolExtractor), expectedIcons);
    }

    @NotNull
    public List<String> getIconsAsStrings(@NotNull PsiElement rootElement, final @Nullable Function<PsiElement, OCSymbol> symbolExtractor) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(81);
        }
        final ArrayList<String> actualIcons = new ArrayList<String>();
        rootElement.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (!(element instanceof ElementBase)) {
                    super.visitElement(element);
                }
                OCSymbol symbol = null;
                if (symbolExtractor != null) {
                    symbol = (OCSymbol)symbolExtractor.fun((Object)element);
                }
                if (symbol == null && element instanceof OCSymbolDeclarator) {
                    symbol = ((OCSymbolDeclarator)element).getSymbol();
                }
                Object result = null;
                try {
                    Method method = ElementBase.class.getDeclaredMethod("getBaseIcon", new Class[0]);
                    method.setAccessible(true);
                    Icon baseIcon = (Icon)method.invoke((Object)element, new Object[0]);
                    method = ElementBase.class.getDeclaredMethod("getElementIcon", Integer.TYPE);
                    method.setAccessible(true);
                    Icon fullIcon = (Icon)method.invoke((Object)element, 0);
                    if (baseIcon != null && fullIcon != null) {
                        result = CidrCodeInsightFixture.printIcon(baseIcon, fullIcon);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (result != null && symbol != null) {
                    String symbolIcons;
                    Icon baseIcon = symbol.getBaseIcon();
                    Icon fullIcon = symbol.computeFullIconNow(element, CidrCodeInsightFixture.this.getProject());
                    if (baseIcon != null && fullIcon != null && !(symbolIcons = CidrCodeInsightFixture.printIcon(baseIcon, fullIcon)).equals(result)) {
                        result = (String)result + " | " + symbolIcons;
                    }
                }
                if (result != null) {
                    boolean sameFunctionElement;
                    boolean bl = sameFunctionElement = element.getParent() instanceof OCFunctionDeclaration && ((String)actualIcons.get(actualIcons.size() - 1)).equals(result);
                    if (!sameFunctionElement) {
                        actualIcons.add(result);
                    }
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/CidrCodeInsightFixture$10", "visitElement"));
            }
        });
        ArrayList<String> arrayList = actualIcons;
        if (arrayList == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(82);
        }
        return arrayList;
    }

    public void assertLineMarkerIcons(@NotNull PsiElement rootElement, @NotNull RunLineMarkerContributor lineMarkerProvider, String ... expectedIcons) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(83);
        }
        if (lineMarkerProvider == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(84);
        }
        this.cleanTestsHistory();
        UsefulTestCase.assertOrderedEquals(this.getLineMarkerIcons(rootElement, lineMarkerProvider), expectedIcons);
    }

    private void cleanTestsHistory() {
        TestStateStorage instance2 = TestStateStorage.getInstance((Project)this.getProject());
        instance2.getKeys().forEach(key -> instance2.removeState(key));
    }

    @NotNull
    public List<String> getLineMarkerIcons(@NotNull PsiElement rootElement, final @NotNull RunLineMarkerContributor lineMarkerProvider) {
        if (rootElement == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(85);
        }
        if (lineMarkerProvider == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(86);
        }
        final ArrayList<String> actualIcons = new ArrayList<String>();
        rootElement.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                RunLineMarkerContributor.Info info;
                if (element == null) {
                    11.$$$reportNull$$$0(0);
                }
                if ((info = lineMarkerProvider.getInfo(element)) != null) {
                    actualIcons.add(CidrCodeInsightFixture.printIcon(info.icon, info.icon));
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/CidrCodeInsightFixture$11", "visitElement"));
            }
        });
        ArrayList<String> arrayList = actualIcons;
        if (arrayList == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    @NotNull
    public static String printIcon(Icon baseIcon, Icon fullIcon) {
        String fullText;
        String baseText = CidrCodeInsightFixture.printIcon(baseIcon);
        Object object = baseText.equals(fullText = CidrCodeInsightFixture.printIcon(fullIcon)) ? baseText : baseText + " - " + fullText;
        if (object == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(88);
        }
        return object;
    }

    public void assertIcon(Icon expected, Icon actual) {
        UsefulTestCase.assertEquals((String)CidrCodeInsightFixture.printIcon(expected), (String)CidrCodeInsightFixture.printIcon(actual));
    }

    @NotNull
    public static String printIcon(Icon icon) {
        String string = CidrCodeInsightFixture.printIcon(new StringBuilder(), icon).toString();
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(89);
        }
        return string;
    }

    private static StringBuilder printIcon(StringBuilder builder, Icon icon) {
        while (icon instanceof RetrievableIcon) {
            icon = ((RetrievableIcon)icon).retrieveIcon();
        }
        if (icon instanceof LayeredIcon) {
            builder.append("[");
            for (Icon subicon : ((LayeredIcon)icon).getAllLayers()) {
                CidrCodeInsightFixture.printIcon(builder, subicon);
                builder.append(",");
            }
            if (builder.charAt(builder.length() - 1) == ',') {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append("]");
            return builder;
        }
        if (icon instanceof RowIcon) {
            builder.append("<");
            for (int i = 0; i < ((RowIcon)icon).getIconCount(); ++i) {
                CidrCodeInsightFixture.printIcon(builder, ((RowIcon)icon).getIcon(i));
                builder.append(",");
            }
            if (builder.charAt(builder.length() - 1) == ',') {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append(">");
            return builder;
        }
        builder.append(CidrCodeInsightFixture.iconToText(icon));
        return builder;
    }

    private static String iconToText(Icon icon) {
        if (icon == null) {
            return null;
        }
        String result = ICON_TO_TEXT.get(icon);
        Assert.assertNotNull((String)("icon name not found for " + icon + ".\nProbably you need to register custom icons classes using CidrCodeInsightFixture.addIconsClass()"), (Object)result);
        return result;
    }

    public static void addIconsClass(Class c) {
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, c);
    }

    private static void processIconContainerClass(Map<Icon, String> map, Class clazz) {
        String ICON_PREFIX = "CodeAssistant";
        try {
            for (Field field : clazz.getDeclaredFields()) {
                Object value;
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || field.getAnnotation(Deprecated.class) != null || !((value = field.get(null)) instanceof Icon)) continue;
                if (value instanceof RetrievableIcon) {
                    value = ((RetrievableIcon)value).retrieveIcon();
                }
                Object name = field.getName();
                if (map.containsValue(name = StringUtil.trimStart((String)name, (String)ICON_PREFIX))) {
                    for (Class<?> declClass = field.getDeclaringClass(); declClass != null; declClass = declClass.getDeclaringClass()) {
                        name = declClass.getSimpleName() + "." + (String)name;
                    }
                }
                map.put((Icon)value, (String)name);
            }
            for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
                CidrCodeInsightFixture.processIconContainerClass(map, (Class)annotatedElement);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void expectCompletion(String prefix, String ... items) {
        this.expectCompletion(prefix, 1, items);
    }

    public void expectCompletion(String prefix, int time, String ... items) {
        this.doExpectCompletionContains(prefix, time, true, items);
    }

    public void expectCompletionContains(String prefix, int time, String ... items) {
        this.doExpectCompletionContains(prefix, time, false, items);
    }

    private void doExpectCompletionContains(String prefix, int time, boolean exactSet, String ... expectedItems) {
        List actualItems = ContainerUtil.map((Collection)ContainerUtil.notNullize(this.complete(time).getItems()), String::trim);
        ArrayList<LookupElement> expectedLookupElement = new ArrayList<LookupElement>();
        for (String element : expectedItems) {
            expectedLookupElement.add((LookupElement)LookupElementBuilder.create((String)element));
        }
        String expectedString = StringUtil.join(new CompletionResult(prefix, expectedLookupElement).getItems(), (String)", ");
        if (exactSet) {
            String actualString = StringUtil.join((Collection)actualItems, (String)", ");
            UsefulTestCase.assertEquals((String)expectedString, (String)actualString);
        } else {
            UsefulTestCase.assertContainsElements(actualItems, expectedItems);
        }
    }

    public void expectEmptyCompletion(int time) {
        CompletionResult result = this.complete(time);
        UsefulTestCase.assertEquals((String)new CompletionResult(null, null).toString(), (String)result.toString());
    }

    @NotNull
    public CompletionResult complete() {
        CompletionResult completionResult = this.complete(1);
        if (completionResult == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(90);
        }
        return completionResult;
    }

    public CompletionResult complete(CompletionType type) {
        return this.complete(type, 1);
    }

    @NotNull
    public CompletionResult complete(int time) {
        CompletionResult completionResult = this.complete(CompletionType.BASIC, time);
        if (completionResult == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(91);
        }
        return completionResult;
    }

    @NotNull
    public CompletionResult complete(@NotNull CompletionType type, int time) {
        if (type == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(92);
        }
        new CodeCompletionHandlerBase(type).invokeCompletion(this.getProject(), this.getEditor(), time);
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.getEditor());
        if (lookup == null) {
            return new CompletionResult(null, null);
        }
        return new CompletionResult(lookup.itemPattern((LookupElement)lookup.getItems().get(0)), lookup.getItems());
    }

    public void checkFolding(String content, String folded) {
        this.checkFolding(content, folded, "test.m");
    }

    public void checkFoldingCPP(String content, String folded) {
        this.checkFolding(content, folded, "test.cpp");
    }

    public PsiFile checkFolding(String content, String folded, String fileName) {
        return this.checkFolding(content, folded, false, fileName, true);
    }

    public <T extends PsiFile> T checkFolding(String content, String folded, boolean performCollapseBlock, String fileName, boolean waitForCodePass) {
        content = StringsKt.trimMargin((String)content, (String)"|");
        folded = StringsKt.trimMargin((String)folded, (String)"|");
        T file2 = this.configureByText(content, fileName);
        if (performCollapseBlock) {
            this.getFixture().performEditorAction("CollapseBlock");
        }
        if (waitForCodePass) {
            this.getFixture().doHighlighting();
        }
        UsefulTestCase.assertEquals((String)folded, (String)((CodeInsightTestFixtureImpl)this.getFixture()).getFoldingDescription(true));
        return file2;
    }

    public void assertLanguageStandard(@NotNull String relativeFile, OCLanguageStandard ... expected) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(93);
        }
        if (expected == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(94);
        }
        this.assertLanguageStandard((PsiFile)this.myProjectFixture.getProjectSubOCFile(relativeFile), expected);
    }

    public void assertLanguageStandard(@NotNull PsiFile file2, OCLanguageStandard ... expected) {
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(95);
        }
        if (expected == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(96);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            OCLanguageStandard std = (OCLanguageStandard)OCCompilerFeaturesHelper.getFeatureForFile((PsiFile)file2, null, (OCCompilerFeatures.Type)OCCompilerFeatures.LANGUAGE_STANDARD);
            Assert.assertTrue((String)("Wrong language standard for " + file2.getName() + "\n\texpected: " + Arrays.toString(expected) + "\n\tactual:   " + std), (boolean)ArrayUtil.contains((Object)std, (Object[])expected));
        });
    }

    public void assertClangFeature(@NotNull String relativeFile, @NotNull String feature, @Nullable String value) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(97);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(98);
        }
        this.doAssertClangFeatureOrExtension(true, null, relativeFile, feature, value);
    }

    public void assertClangFeature(@NotNull OCResolveConfiguration configuration2, @NotNull String relativeFile, @NotNull String feature, @Nullable String value) {
        if (configuration2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(99);
        }
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(100);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(101);
        }
        this.doAssertClangFeatureOrExtension(true, configuration2, relativeFile, feature, value);
    }

    public void assertClangExtension(@NotNull String relativeFile, @NotNull String feature, @Nullable String value) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(102);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(103);
        }
        this.doAssertClangFeatureOrExtension(false, null, relativeFile, feature, value);
    }

    public void assertClangExtension(@NotNull OCResolveConfiguration configuration2, @NotNull String relativeFile, @NotNull String feature, @Nullable String value) {
        if (configuration2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(104);
        }
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(105);
        }
        if (feature == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(106);
        }
        this.doAssertClangFeatureOrExtension(false, configuration2, relativeFile, feature, value);
    }

    void doAssertClangFeatureOrExtension(boolean isFeature, @Nullable OCResolveConfiguration configuration2, @NotNull String relativeFile, @NotNull String name, @Nullable String value) {
        if (relativeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(107);
        }
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(108);
        }
        String kind = isFeature ? "feature" : "extension";
        String macroCallText = "__has_" + kind + "(" + name + ")";
        OCFile file2 = this.setFileConfiguration(configuration2, this.myProjectFixture.getProjectSubOCFile(relativeFile));
        OCExpression expression = (OCExpression)WriteAction.computeAndWait(() -> OCElementFactory.expressionFromText((String)macroCallText, (PsiElement)file2, (boolean)false));
        ApplicationManager.getApplication().runReadAction(() -> {
            String expectedValue = value == null ? macroCallText : value;
            String actualValue = expression instanceof OCLiteralExpression ? ((OCLiteralExpression)expression).getUnescapedLiteralText() : expression.getText();
            UsefulTestCase.assertEquals((String)(kind + " " + name + " expected to be " + expectedValue + " in file " + relativeFile), (String)expectedValue, (String)StringUtil.nullize((String)actualValue));
        });
    }

    @NotNull
    public CompletionResult assertAutoPopup(@NotNull String text, @NotNull String typedText, @NotNull OCLanguageKind ocLanguageKind, boolean shouldPopup) {
        if (text == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(109);
        }
        if (typedText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(110);
        }
        if (ocLanguageKind == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(111);
        }
        this.configureByText(text, ocLanguageKind);
        CompletionResult completionResult = this.assertAutoPopup(typedText, shouldPopup);
        if (completionResult == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(112);
        }
        return completionResult;
    }

    @NotNull
    public CompletionResult assertAutoPopup(@NotNull String typedText, boolean shouldPopup) {
        if (typedText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(113);
        }
        this.typeWithPauses(typedText);
        LookupImpl lookup = this.getLookup();
        if (shouldPopup) {
            Assert.assertNotNull((Object)lookup);
        } else {
            UsefulTestCase.assertNull((Object)lookup);
        }
        if (lookup == null) {
            return new CompletionResult(null, null);
        }
        List items = lookup.getItems();
        return new CompletionResult(lookup.itemPattern((LookupElement)items.get(0)), items);
    }

    @Nullable
    private LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.getEditor());
    }

    @NotNull
    public <T extends PsiFile> T setFileConfiguration(OCResolveConfiguration configuration2, T file2) {
        PsiFile result = (PsiFile)WriteAction.computeAndWait(() -> {
            OCInclusionContextUtil.setUserSelectedConfiguration((PsiFile)file2, (OCResolveConfiguration)configuration2);
            FileSymbolTablesCache.getInstance((Project)this.getProject()).ensurePendingFilesProcessed();
            if (file2.isValid()) {
                return file2;
            }
            FileViewProvider provider = PsiManager.getInstance((Project)this.getProject()).findViewProvider(file2.getVirtualFile());
            return provider.getPsi(file2.getLanguage());
        });
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            application.invokeAndWait(() -> UIUtil.dispatchAllInvocationEvents());
        }
        PsiFile psiFile = result;
        if (psiFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(114);
        }
        return (T)psiFile;
    }

    public static DefineDescription resolved(@NotNull String name) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(115);
        }
        return new DefineDescription(name, DefineDescription.State.resolved, null);
    }

    public static DefineDescription resolved(@NotNull String name, @NotNull String value) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(116);
        }
        if (value == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(117);
        }
        return new DefineDescription(name, DefineDescription.State.resolved, value);
    }

    public static DefineDescription notResolved(@NotNull String name) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(118);
        }
        return new DefineDescription(name, DefineDescription.State.not_resolved, null);
    }

    public static DefineDescription declared(@NotNull String name) {
        if (name == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(119);
        }
        return new DefineDescription(name, DefineDescription.State.declared, null);
    }

    @NotNull
    public String convertToOsDependentPath(@NotNull String anyPath) {
        if (anyPath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(120);
        }
        if (SystemInfo.isWindows) {
            String string = anyPath.replace('/', '\\');
            if (string == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(121);
            }
            return string;
        }
        String string = anyPath;
        if (string == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(122);
        }
        return string;
    }

    public static void assertDefines(@NotNull OCResolveConfiguration configuration2, @NotNull OCFile ocFile, String[] @NotNull [] cmdLineDefines) {
        if (configuration2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(123);
        }
        if (ocFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(124);
        }
        OCInclusionContext context = OCInclusionContext.sourceParsingContext((OCResolveConfiguration)configuration2, (OCLanguageKind)ocFile.getKind(), (PsiFile)ocFile);
        ArrayList<CallSite> problems = new ArrayList<CallSite>();
        for (String[] macroName2Value : cmdLineDefines) {
            OCMacroSymbol def = context.getDefinition(macroName2Value[0]);
            if (def == null) {
                problems.add((CallSite)((Object)("Undefined macro " + macroName2Value[0])));
                continue;
            }
            if (macroName2Value[1].equals(def.toString())) continue;
            problems.add((CallSite)((Object)("Wrong macro from compiler flag:\nexpected: " + macroName2Value[1] + "\nactual: " + def.toString())));
        }
        UsefulTestCase.assertEmpty(problems);
    }

    public void assertDefines(@NotNull OCResolveConfiguration configuration2, @NotNull OCFile file2, DefineDescription ... expectedDefines) {
        if (configuration2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(125);
        }
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(126);
        }
        final ArrayList actual = new ArrayList();
        OCFile finalFile = this.setFileConfiguration(configuration2, file2);
        ApplicationManager.getApplication().invokeAndWait(() -> {});
        ApplicationManager.getApplication().runReadAction(() -> finalFile.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitOCElement(OCElement elem) {
                if (elem instanceof OCReferenceElement) {
                    if (elem.getParent() instanceof OCMacroCall) {
                        actual.add(CidrCodeInsightFixture.resolved(((OCReferenceElement)elem).getName(), ((OCMacroCall)elem.getParent()).getReplacementText()));
                    } else if (elem.getParent() instanceof OCReferenceExpression || elem.getParent() instanceof OCTypeElement) {
                        OCReferenceElement elem1 = (OCReferenceElement)elem;
                        actual.add(elem1.resolve() != null ? CidrCodeInsightFixture.resolved(elem1.getName()) : CidrCodeInsightFixture.notResolved(elem1.getName()));
                    }
                } else if (OCElementUtil.getElementMacroCall((PsiElement)elem) == null && elem instanceof OCDeclaration) {
                    List declarators = ((OCDeclaration)elem).getDeclarators();
                    OCTypeElement type = ((OCDeclaration)elem).getTypeElement();
                    if (declarators.isEmpty()) {
                        actual.add(CidrCodeInsightFixture.notResolved(type.getText()));
                    } else if (type.isEmpty()) {
                        actual.add(CidrCodeInsightFixture.notResolved(((OCDeclarator)declarators.get(0)).getText()));
                    } else {
                        String name = ((OCDeclarator)declarators.get(0)).getName();
                        if (!"ignore".equals(name)) {
                            actual.add(CidrCodeInsightFixture.declared(name));
                        }
                    }
                }
                super.visitOCElement(elem);
            }
        }));
        UsefulTestCase.assertOrderedEquals("Incorrect defines for file " + file2.getName() + " in config " + configuration2.getDisplayName(), actual, expectedDefines);
    }

    public static IncludeDescription unresolved(@NotNull String includeText) {
        if (includeText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(127);
        }
        return new IncludeDescription(includeText);
    }

    public static IncludeDescription inc(@NotNull String includeText, @NotNull PsiFile includeFile) {
        if (includeText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(128);
        }
        if (includeFile == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(129);
        }
        return new IncludeDescription(includeText, includeFile);
    }

    public static IncludeDescription inc(@NotNull String includeText, @NotNull String includedPath) {
        if (includeText == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(130);
        }
        if (includedPath == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(131);
        }
        return new IncludeDescription(includeText, includedPath);
    }

    public void assertIncludes(@NotNull OCResolveConfiguration configuration2, @NotNull OCFile file2, IncludeDescription ... expected) {
        if (configuration2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(132);
        }
        if (file2 == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(133);
        }
        OCFile finalFile = file2 = this.setFileConfiguration(configuration2, file2);
        ApplicationManager.getApplication().invokeAndWait(() -> {});
        ApplicationManager.getApplication().runReadAction(() -> {
            ArrayList<IncludeDescription> actual = new ArrayList<IncludeDescription>();
            for (OCIncludeDirective each : finalFile.findIncludeDirectives()) {
                boolean library = each.isAngleBrackets();
                String pref = library ? "<" : "\"";
                String suf = library ? ">" : "\"";
                String importedText = pref + each.getReferenceText() + suf;
                PsiFile importedFile = each.getIncludedFile();
                IncludeDescription desc = importedFile == null ? new IncludeDescription(importedText) : (VfsUtilCore.isAncestor((VirtualFile)this.myProjectFixture.getProjectDir(), (VirtualFile)importedFile.getVirtualFile(), (boolean)false) ? new IncludeDescription(importedText, importedFile) : new IncludeDescription(importedText, importedFile.getName()));
                actual.add(desc);
            }
            UsefulTestCase.assertOrderedEquals("incorrect imports in configuration " + configuration2.getDisplayName() + " for file " + finalFile.getName(), actual, expected);
        });
    }

    @NotNull
    public List<Crumb> getBreadcrumbsAt(int offset) {
        PsiElement element = this.getFile().findElementAt(offset);
        if (element == null) {
            List<Crumb> list = Collections.emptyList();
            if (list == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(134);
            }
            return list;
        }
        Language language = element.getContainingFile().getLanguage();
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        if (provider == null) {
            List<Crumb> list = Collections.emptyList();
            if (list == null) {
                CidrCodeInsightFixture.$$$reportNull$$$0(135);
            }
            return list;
        }
        ArrayList<Crumb.Impl> result = new ArrayList<Crumb.Impl>();
        while (element != null) {
            if (provider.acceptElement(element)) {
                result.add(new Crumb.Impl(provider, element));
            }
            element = provider.getParent(element);
        }
        List list = ContainerUtil.reverse(result);
        if (list == null) {
            CidrCodeInsightFixture.$$$reportNull$$$0(136);
        }
        return list;
    }

    static {
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, CidrLangIcons.class);
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, CidrProjectModelIcons.class);
        CidrCodeInsightFixture.processIconContainerClass(ICON_TO_TEXT, AllIcons.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 50: 
            case 66: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 112: 
            case 114: 
            case 121: 
            case 122: 
            case 134: 
            case 135: 
            case 136: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 50: 
            case 66: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 112: 
            case 114: 
            case 121: 
            case 122: 
            case 134: 
            case 135: 
            case 136: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectAdapter";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 50: 
            case 66: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 112: 
            case 114: 
            case 121: 
            case 122: 
            case 134: 
            case 135: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrCodeInsightFixture";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 63: 
            case 67: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 95: 
            case 126: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 19: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 45: 
            case 47: 
            case 51: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedGutters";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeToCheck";
                break;
            }
            case 59: 
            case 62: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testHolder";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForAnnotator";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotators";
                break;
            }
            case 68: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeForInspections";
                break;
            }
            case 69: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docFunction";
                break;
            }
            case 80: 
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineMarkerProvider";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 93: 
            case 97: 
            case 100: 
            case 102: 
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFile";
                break;
            }
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 98: 
            case 101: 
            case 103: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 99: 
            case 104: 
            case 123: 
            case 125: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 108: 
            case 115: 
            case 116: 
            case 118: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedText";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocLanguageKind";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyPath";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocFile";
                break;
            }
            case 127: 
            case 128: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeText";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFile";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrCodeInsightFixture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestAnnotators";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixture";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementAtCaret";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementOfClassAtCaret";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionAtCaret";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findNodeAtSelection";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionAtSelection";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOCFile";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "textForExpression";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByText";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "addFileToProject";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFilePath";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "runAnnotators";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconsAsStrings";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkerIcons";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "printIcon";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "complete";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "assertAutoPopup";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "setFileConfiguration";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToOsDependentPath";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 50: 
            case 66: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 112: 
            case 114: 
            case 121: 
            case 122: 
            case 134: 
            case 135: 
            case 136: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFileTracker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFileTracker";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareVirtualFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteCreatedFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeFileFromProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resetFileCaches";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementAtCaret";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceAtCaret";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findOCFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processOCFiles";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeObjC";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "textForExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "configureByExpressionOCpp";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "configureByExpressionOC";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "postConfigureByFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateCreatedFiles";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findExistingFileAndSetText";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "doWriteToExistingFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getFullFilePath";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "runWithAutoPopupEnabled";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "assertGuttersAtCaret";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotations";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMessages";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "runCheckAndGetAnnotations";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotators";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "runInspections";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getTestProblemsHolder";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "assertIcons";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getIconsAsStrings";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "assertLineMarkerIcons";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerIcons";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "assertLanguageStandard";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "assertClangFeature";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "assertClangExtension";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "doAssertClangFeatureOrExtension";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "assertAutoPopup";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "resolved";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "notResolved";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "declared";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "convertToOsDependentPath";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "assertDefines";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "unresolved";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "inc";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "assertIncludes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 48: 
            case 50: 
            case 66: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 112: 
            case 114: 
            case 121: 
            case 122: 
            case 134: 
            case 135: 
            case 136: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class IncludeDescription {
        @NotNull
        String includeText;
        String includedPath;
        PsiFile includedFile;

        private IncludeDescription(@NotNull String includeText) {
            if (includeText == null) {
                IncludeDescription.$$$reportNull$$$0(0);
            }
            this.includeText = includeText;
        }

        private IncludeDescription(@NotNull String includeText, @NotNull String includedPath) {
            if (includeText == null) {
                IncludeDescription.$$$reportNull$$$0(1);
            }
            if (includedPath == null) {
                IncludeDescription.$$$reportNull$$$0(2);
            }
            this.includeText = includeText;
            this.includedPath = includedPath;
        }

        private IncludeDescription(@NotNull String includeText, @NotNull PsiFile includedFile) {
            if (includeText == null) {
                IncludeDescription.$$$reportNull$$$0(3);
            }
            if (includedFile == null) {
                IncludeDescription.$$$reportNull$$$0(4);
            }
            this.includeText = includeText;
            this.includedFile = includedFile;
        }

        public String toString() {
            String result = this.includeText + "->";
            result = this.includedFile != null ? result + this.includedFile.getVirtualFile().getPath() : (this.includedPath != null ? result + this.includedPath : result + "<unresolved>");
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncludeDescription that = (IncludeDescription)o;
            if (!this.includeText.equals(that.includeText)) {
                return false;
            }
            if (this.includedFile != null ? !this.includedFile.equals(that.includedFile) : that.includedFile != null) {
                return false;
            }
            return !(this.includedPath != null ? !this.includedPath.equals(that.includedPath) : that.includedPath != null);
        }

        public int hashCode() {
            int result = this.includeText.hashCode();
            result = 31 * result + (this.includedPath != null ? this.includedPath.hashCode() : 0);
            result = 31 * result + (this.includedFile != null ? this.includedFile.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "includeText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "includedPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "includedFile";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$IncludeDescription";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DefineDescription {
        final String name;
        final State state;
        final String value;

        public DefineDescription(String name, State state, String value) {
            this.name = name;
            this.state = state;
            this.value = value;
        }

        public String toString() {
            return this.state + " " + this.name + (String)(this.value != null ? "=" + this.value : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefineDescription that = (DefineDescription)o;
            if (this.state != that.state) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.state.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        static enum State {
            declared,
            resolved,
            not_resolved;

        }
    }

    public static class CompletionResult {
        private final String myPrefix;
        private final List<LookupElement> myElements;

        public CompletionResult(String prefix, List<LookupElement> elements) {
            this.myPrefix = prefix;
            this.myElements = elements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletionResult other = (CompletionResult)o;
            return Objects.equals(this.myPrefix, other.myPrefix) && Comparing.equal(this.getItems(), other.getItems());
        }

        public int hashCode() {
            int result = this.myPrefix.hashCode();
            result = 31 * result + this.getItems().hashCode();
            return result;
        }

        public String toString() {
            return "CompletionResult{myPrefix='" + this.myPrefix + "', myElements=" + this.getItems() + "}";
        }

        public List<String> getItems() {
            return this.getItemImpl((Function<LookupElement, String>)((Function)LookupElement::getLookupString));
        }

        public List<String> getItems(boolean sorted, @Nullable Function<? super LookupElement, Boolean> filter) {
            return this.getItemImpl((Function<LookupElement, String>)((Function)element -> {
                if (filter != null && !((Boolean)filter.fun(element)).booleanValue()) {
                    return null;
                }
                return element.getLookupString();
            }), sorted);
        }

        public List<String> getFullRenderedItems() {
            return this.getFullRenderedItems(true, null);
        }

        public List<String> getFullRenderedItems(boolean sorted, @Nullable Function<? super LookupElement, Boolean> filter) {
            return this.getItemImpl((Function<LookupElement, String>)((Function)element -> {
                LookupElementPresentation presentation;
                if (filter != null && !((Boolean)filter.fun(element)).booleanValue()) {
                    return null;
                }
                LookupElementRenderer expensiveRenderer = element.getExpensiveRenderer();
                if (expensiveRenderer != null) {
                    presentation = new LookupElementPresentation();
                    expensiveRenderer.renderElement(element, presentation);
                } else {
                    presentation = LookupElementPresentation.renderElement((LookupElement)element);
                }
                StringBuilder buffer = new StringBuilder();
                if (presentation.getItemText() != null) {
                    buffer.append(presentation.getItemText());
                }
                if (presentation.getTailText() != null) {
                    buffer.append(presentation.getTailText());
                }
                if (presentation.getTypeText() != null) {
                    buffer.append(":").append(presentation.getTypeText());
                }
                return buffer.toString();
            }), sorted);
        }

        public List<LookupElementPresentation> getRenderedElementPresentations() {
            if (this.myElements == null) {
                return null;
            }
            return this.myElements.stream().map(element -> LookupElementPresentation.renderElement((LookupElement)element)).sorted(Comparator.comparing(LookupElementPresentation::getItemText)).collect(Collectors.toList());
        }

        @NotNull
        public List<LookupElement> getElements() {
            List<LookupElement> list = Collections.unmodifiableList(this.myElements);
            if (list == null) {
                CompletionResult.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static String renderDocumentation(LookupElement lookupElement) {
            PsiElement element = lookupElement.getPsiElement();
            return LanguageDocumentation.INSTANCE.forLanguage(element.getLanguage()).getQuickNavigateInfo(element, element);
        }

        @Nullable
        private List<String> getItemImpl(Function<LookupElement, @Nullable String> map, boolean sorted) {
            if (this.myElements == null) {
                return null;
            }
            ArrayList<String> answer = new ArrayList<String>();
            for (LookupElement element : this.myElements) {
                String mapped = (String)map.fun((Object)element);
                if (mapped == null) continue;
                answer.add((String)map.fun((Object)element));
            }
            if (sorted) {
                Collections.sort(answer);
            }
            return answer;
        }

        @Nullable
        private List<String> getItemImpl(Function<LookupElement, String> map) {
            return this.getItemImpl(map, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/CidrCodeInsightFixture$CompletionResult", "getElements"));
        }
    }

    public static class AutoImportChoice {
        public static final String ANY_RESULT = "<any_auto_import_choice>";
        @NotNull
        protected final String name;
        @NotNull
        protected final String resultWithFormatting;
        @NotNull
        protected final String resultWithoutFormatting;
        private final boolean checkWithFormat;

        public AutoImportChoice(@NotNull String name, @NotNull String result) {
            if (name == null) {
                AutoImportChoice.$$$reportNull$$$0(0);
            }
            if (result == null) {
                AutoImportChoice.$$$reportNull$$$0(1);
            }
            this(name, result, false);
        }

        public AutoImportChoice(@NotNull String name, @NotNull String result, boolean checkWithFormat) {
            if (name == null) {
                AutoImportChoice.$$$reportNull$$$0(2);
            }
            if (result == null) {
                AutoImportChoice.$$$reportNull$$$0(3);
            }
            this.name = name;
            this.resultWithFormatting = result;
            this.resultWithoutFormatting = CidrCodeInsightFixture.removeFormatting(result);
            this.checkWithFormat = checkWithFormat;
        }

        public String toString() {
            return this.name + ":\n" + this.resultWithFormatting;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoImportChoice anImport = (AutoImportChoice)o;
            if (!this.name.equals(anImport.name)) {
                return false;
            }
            if (this.resultWithFormatting != ANY_RESULT && anImport.resultWithFormatting != ANY_RESULT) {
                return this.checkWithFormat || anImport.checkWithFormat ? this.resultWithFormatting.equals(anImport.resultWithFormatting) : this.resultWithoutFormatting.equals(anImport.resultWithoutFormatting);
            }
            return true;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$AutoImportChoice";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AutoImportFix {
        public static final String ANY_TITLE = "<any_auto_import_title>";
        @NotNull
        String fixTitle;
        @NotNull
        String popupTitle;
        @NotNull
        List<AutoImportChoice> choices;

        public AutoImportFix(@NotNull String fixTitle, @NotNull String popupTitle, AutoImportChoice ... choices) {
            if (fixTitle == null) {
                AutoImportFix.$$$reportNull$$$0(0);
            }
            if (popupTitle == null) {
                AutoImportFix.$$$reportNull$$$0(1);
            }
            if (choices == null) {
                AutoImportFix.$$$reportNull$$$0(2);
            }
            this(fixTitle, popupTitle, Arrays.asList(choices));
        }

        public AutoImportFix(@NotNull String fixTitle, @NotNull String popupTitle, @NotNull List<AutoImportChoice> choices) {
            if (fixTitle == null) {
                AutoImportFix.$$$reportNull$$$0(3);
            }
            if (popupTitle == null) {
                AutoImportFix.$$$reportNull$$$0(4);
            }
            if (choices == null) {
                AutoImportFix.$$$reportNull$$$0(5);
            }
            this.fixTitle = fixTitle;
            this.popupTitle = popupTitle;
            this.choices = choices;
        }

        public String toString() {
            return this.fixTitle + "\n" + this.popupTitle + ":\n------\n" + StringUtil.join(this.choices, (String)"\n------\n") + "\n===================";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoImportFix fix = (AutoImportFix)o;
            if (this.fixTitle != ANY_TITLE && fix.fixTitle != ANY_TITLE && !this.fixTitle.equals(fix.fixTitle)) {
                return false;
            }
            if (this.popupTitle != ANY_TITLE && fix.popupTitle != ANY_TITLE && !this.popupTitle.equals(fix.popupTitle)) {
                return false;
            }
            return this.choices.equals(fix.choices);
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixTitle";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "popupTitle";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "choices";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$AutoImportFix";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GutterInfo {
        @NotNull
        public final Icon icon;
        @NotNull
        public final String tooltip;

        public GutterInfo(@NotNull Icon icon, @NotNull String tooltip) {
            if (icon == null) {
                GutterInfo.$$$reportNull$$$0(0);
            }
            if (tooltip == null) {
                GutterInfo.$$$reportNull$$$0(1);
            }
            this.icon = icon;
            this.tooltip = tooltip;
        }

        public GutterInfo(@NotNull GutterMark mark) {
            if (mark == null) {
                GutterInfo.$$$reportNull$$$0(2);
            }
            this.icon = mark.getIcon();
            this.tooltip = mark.getTooltipText();
        }

        public String toString() {
            return "GutterInfo{tooltip='" + this.tooltip + "'icon='" + this.icon + "'@" + System.identityHashCode(this.icon) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GutterInfo info = (GutterInfo)o;
            if (!this.icon.equals(info.icon)) {
                return false;
            }
            return this.tooltip.equals(info.tooltip);
        }

        public int hashCode() {
            int result = this.icon.hashCode();
            result = 31 * result + this.tooltip.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tooltip";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mark";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/CidrCodeInsightFixture$GutterInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface FileTracker {
        public void onCreated(@NotNull VirtualFile var1);
    }
}

