/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.cpp.CPPTestCase;
import com.jetbrains.cidr.cpp.execution.debugger.CLionLocalAttachDebuggerProvider;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import java.io.File;
import java.util.List;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;

public abstract class CLionDebuggingFixture<EXECUTION_FIXTURE extends CidrExecutionFixture<?>>
extends CidrDebuggingFixture<EXECUTION_FIXTURE> {
    public CLionDebuggingFixture(EXECUTION_FIXTURE fixture) {
        super(fixture);
    }

    @NotNull
    public CPPEnvironment getEnvironment() {
        CPPEnvironment cPPEnvironment = CPPTestCase.getTestCPPEnvironment();
        if (cPPEnvironment == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(0);
        }
        return cPPEnvironment;
    }

    @Override
    @NotNull
    protected ArchitectureType getArchitectureType() {
        CPPEnvironment environment = this.getEnvironment();
        if (environment.isMSVC()) {
            List options = environment.getToolchain().getToolSetOptions();
            Triple optionsTriple = MSVC.getOptions((List)options);
            String arch = ((MSVC.Arch)optionsTriple.getFirst()).getValue();
            ArchitectureType architectureType = arch.endsWith("amd64") || arch.endsWith("x64") ? ArchitectureType.X86_64 : (arch.endsWith("x86") ? ArchitectureType.I386 : ArchitectureType.UNKNOWN);
            if (architectureType == null) {
                CLionDebuggingFixture.$$$reportNull$$$0(1);
            }
            return architectureType;
        }
        ArchitectureType architectureType = ArchitectureType.UNKNOWN;
        if (architectureType == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(2);
        }
        return architectureType;
    }

    @Override
    @NotNull
    public File getGdbserverExecutable() {
        GDB gdb = this.getEnvironment().getGDB();
        CLionDebuggingFixture.assertNotNull((String)"GDB is not set for tests", (Object)gdb);
        return new File(gdb.getExecutable().getParent(), "gdbserver" + (SystemInfo.isWindows ? ".exe" : ""));
    }

    @Override
    @NotNull
    protected String toAppEnvPath(@NotNull String path) {
        if (path == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(3);
        }
        if (CPPTestCase.getTestMinGW() != null || CPPTestCase.getTestMSVC() != null) {
            String string = StringUtil.escapeBackSlashes((String)PathUtil.toSystemDependentName((String)path));
            if (string == null) {
                CLionDebuggingFixture.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.getEnvironment().toEnvPath(path);
        if (string == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean supportsOCDebugging() {
        return false;
    }

    @Override
    public boolean supportsInputOutputOnWindows() {
        return !this.getEnvironment().isCygwin();
    }

    @Override
    @NotNull
    protected CidrLocalAttachDebugger getLocalAttachDebugger(@NotNull Project project2) {
        if (project2 == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(6);
        }
        CidrLocalAttachDebugger cidrLocalAttachDebugger = CLionLocalAttachDebuggerProvider.createGDBDebugger((Project)project2, (CPPToolchains.Toolchain)CPPTestCase.getTestToolchain());
        if (cidrLocalAttachDebugger == null) {
            CLionDebuggingFixture.$$$reportNull$$$0(7);
        }
        return cidrLocalAttachDebugger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CLionDebuggingFixture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchitectureType";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CLionDebuggingFixture";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toAppEnvPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAttachDebugger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toAppEnvPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAttachDebugger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

