/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingWithDebugProjectTestCase;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public abstract class CidrDebuggingThreadsTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggingWithDebugProjectTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE> {
    public CidrDebuggingThreadsTestCase(String targetName, DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, targetName, fixtureProjectFileRelativePath);
    }

    @Test
    public void testCollectingThreads() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_STARTED);
        this.startDebugSessionAndWaitForPause("fork_2_threads");
        XSuspendContext context = this.myDebuggingFixture.getSession().getSuspendContext();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_STARTED);
        List<XExecutionStack> threads = this.myDebuggingFixture.collectThreads();
        CidrDebuggingThreadsTestCase.assertContainsElements(threads, context.getActiveExecutionStack());
        CidrDebuggingThreadsTestCase.assertTrue((String)("Not enough threads collected: " + threads), (threads.size() >= 3 ? 1 : 0) != 0);
        List<XStackFrame> frames = this.myDebuggingFixture.collectFrames(context.getActiveExecutionStack());
        CidrDebuggingFixture.assertFramePresentationMatches(frames.get(0), "fork_n_threads.*");
        XDebuggerAssertions.assertVariablesContain((List)XDebuggerTestUtil.collectChildren((XValueContainer)((XValueContainer)frames.get(0))), (String[])new String[]{"threads"});
        threads.remove(context.getActiveExecutionStack());
        CidrDebuggingThreadsTestCase.assertNotEmpty(threads);
        ArrayList forkedFrames = new ArrayList();
        for (XExecutionStack each : threads) {
            CidrDebuggingThreadsTestCase.assertNull((String)"Frames should not be loaded yet", (Object)each.getTopFrame());
            frames = this.myDebuggingFixture.collectFrames(each);
            CidrDebuggingThreadsTestCase.assertNotEmpty(frames);
            CidrDebuggingThreadsTestCase.assertNotNull((String)"Top frames should be initialized after loading frames", (Object)each.getTopFrame());
            ContainerUtil.addIfNotNull(forkedFrames, (Object)CidrDebuggingThreadsTestCase.findForkedThreadFrame(frames));
        }
        CidrDebuggingThreadsTestCase.assertEquals((String)("Forked frames not found among: " + threads), (int)2, (int)forkedFrames.size());
        for (XExecutionStack each : forkedFrames) {
            XDebuggerAssertions.assertVariablesContain((List)XDebuggerTestUtil.collectChildren((XValueContainer)each), (String[])new String[]{"thread_param"});
        }
    }

    @Test
    public void testBreakpointInThread() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        this.startDebugSessionAndWaitForPause("fork_thread");
        XSuspendContext context = this.myDebuggingFixture.getSession().getSuspendContext();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        XDebuggerAssertions.assertVariablesContain((List)XDebuggerTestUtil.collectChildren((XValueContainer)context.getActiveExecutionStack().getTopFrame()), (String[])new String[]{"thread_param", "local"});
    }

    @Test
    public void testErrorOnThreadsCollection() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("fork_thread");
        ThrowInTest.throwOn((Object)this.getSession().getDebugProcess(), (Key)CidrDebugProcess.THROW_ON_THREAD_COLLECTION, (boolean)true);
        CidrDebuggingThreadsTestCase.assertNotNull((Object)XDebuggerTestUtil.getActiveThread((XDebugSession)this.getSession()));
        Pair threadsWithErrors = XDebuggerTestUtil.collectThreadsWithErrors((XDebugSession)this.getSession());
        CidrDebuggingThreadsTestCase.assertEmpty((Collection)threadsWithErrors.first);
        CidrDebuggingThreadsTestCase.assertEquals((String)"user exception", (String)((String)threadsWithErrors.second));
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        ThrowInTest.throwOn((Object)this.getSession().getDebugProcess(), (Key)CidrDebugProcess.THROW_ON_THREAD_COLLECTION, (boolean)false);
        CidrDebuggingThreadsTestCase.assertNotNull((Object)XDebuggerTestUtil.getActiveThread((XDebugSession)this.getSession()));
        threadsWithErrors = XDebuggerTestUtil.collectThreadsWithErrors((XDebugSession)this.getSession());
        CidrDebuggingThreadsTestCase.assertEmpty((Collection)threadsWithErrors.first);
        CidrDebuggingThreadsTestCase.assertEquals((String)"Execution exception", (String)((String)threadsWithErrors.second));
    }

    @Nullable
    private static XStackFrame findForkedThreadFrame(List<XStackFrame> frames) {
        for (XStackFrame each : ContainerUtil.reverse(frames)) {
            if (!((CidrStackFrame)each).getFrame().getFunction().matches(".*forked_thread_func.*")) continue;
            return each;
        }
        return null;
    }
}

