/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.lang.CidrFileBasedChangeTestFixture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrFileBasedCompletionTestFixture
extends CidrFileBasedChangeTestFixture<CompletionData> {
    public static final Pattern ASSERTION_CONTENTS = Pattern.compile("\\s*(<(BASIC|SMART)(\\*(\\d+))?>)?(.*)?=>[ \\t]*(\\S*)");
    private boolean myAutocompletion;
    private boolean mySmartAutocompletion;
    private int myCompletionCaseSensitive;
    private static final Map<String, String> COMPLETION_KEYS = new HashMap<String, String>();
    private static final String ENTER_KEY_NAME = "ENTER";
    private static final String TYPE_KEY_NAME = "TYPE";
    public static final Function<LookupElement, String> TO_NAME;
    public static final Function<String, Item> TO_ITEM;
    public static final Function<LookupElement, String> TO_FULL_TEXT;

    public CidrFileBasedCompletionTestFixture(@NotNull CidrCodeInsightFixture codeInsightFixture, @NotNull CidrProjectFixture projectFixture, @NotNull String assertionBlockPrefix) {
        if (codeInsightFixture == null) {
            CidrFileBasedCompletionTestFixture.$$$reportNull$$$0(0);
        }
        if (projectFixture == null) {
            CidrFileBasedCompletionTestFixture.$$$reportNull$$$0(1);
        }
        if (assertionBlockPrefix == null) {
            CidrFileBasedCompletionTestFixture.$$$reportNull$$$0(2);
        }
        super(codeInsightFixture, projectFixture, assertionBlockPrefix);
    }

    @Override
    protected void performInWriteAction(CodeInsightTestFixture fixture, CompletionData data, String errorPrefix) {
        String completionKey;
        String typingSeq;
        Item selectedItem = data.myItem;
        if (data.myCompletionKey.startsWith(TYPE_KEY_NAME)) {
            typingSeq = data.myCompletionKey.substring(TYPE_KEY_NAME.length());
            completionKey = COMPLETION_KEYS.get(ENTER_KEY_NAME);
        } else {
            typingSeq = "";
            String keyName = data.myCompletionKey;
            completionKey = COMPLETION_KEYS.getOrDefault(keyName, keyName);
            TestCase.assertEquals((String)(errorPrefix + "bad completion key name: '" + keyName + "'"), (int)1, (int)completionKey.length());
        }
        char completionChar = completionKey.charAt(0);
        fixture.complete(data.myCompletionType, data.myInvocationCount);
        Object[] lookupElements = fixture.getLookupElements();
        TestCase.assertNotNull((String)errorPrefix, (Object)lookupElements);
        List<Item> expectedItems = data.myItems;
        CidrFileBasedCompletionTestFixture.assertPopupContents(errorPrefix, (LookupElement[])lookupElements, expectedItems, data.myForbiddenItems);
        if (expectedItems != null && expectedItems.isEmpty()) {
            return;
        }
        Object item = selectedItem == null ? (lookupElements.length > 0 ? lookupElements[0] : null) : (LookupElement)ContainerUtil.find((Object[])lookupElements, element -> {
            Function<LookupElement, String> f = selectedItem.isFullText() ? TO_FULL_TEXT : TO_NAME;
            return selectedItem.getText().equals(f.fun(element));
        });
        String itemsString = StringUtil.join((Object[])lookupElements, LookupElement::getLookupString, (String)", ");
        TestCase.assertNotNull((String)(errorPrefix + "can't find item '" + selectedItem + "' in {" + itemsString + "}"), (Object)item);
        LookupImpl lookup = this.getLookup();
        lookup.setCurrentItem(item);
        lookup.finishLookup(completionChar);
        if (!typingSeq.isEmpty()) {
            fixture.type(typingSeq);
        }
    }

    @Override
    @NotNull
    protected CompletionData readAssertionData(String assertionContents) {
        String completionKey;
        String variantString;
        CompletionType completionType;
        Matcher matcher = ASSERTION_CONTENTS.matcher(assertionContents);
        TestCase.assertTrue((String)assertionContents, (boolean)matcher.find());
        String typeString = matcher.group(2);
        if (typeString == null || "BASIC".equals(typeString)) {
            completionType = CompletionType.BASIC;
        } else if ("SMART".equals(typeString)) {
            completionType = CompletionType.SMART;
        } else {
            TestCase.fail((String)("unknown completion type: " + typeString));
            if (null == null) {
                CidrFileBasedCompletionTestFixture.$$$reportNull$$$0(3);
            }
            return null;
        }
        int invocationCount = 1;
        String icString = matcher.group(4);
        if (icString != null) {
            invocationCount = Integer.parseInt(icString);
        }
        ArrayList<String> variants = CidrFileBasedCompletionTestFixture.splitStrings((variantString = matcher.group(5)) == null ? "" : variantString);
        int itemsEndIdx = variants.indexOf("^");
        ArrayList<Item> items = null;
        ArrayList<Item> forbiddenItems = new ArrayList<Item>();
        boolean forbidden = false;
        if (itemsEndIdx >= 0) {
            items = new ArrayList<Item>();
            for (String variant : variants.subList(0, itemsEndIdx)) {
                if (variant.equals("<FORBID>")) {
                    forbidden = true;
                    continue;
                }
                Item fun = (Item)TO_ITEM.fun((Object)variant);
                if (forbidden) {
                    forbiddenItems.add(fun);
                    continue;
                }
                items.add(fun);
            }
        }
        Item selectedItem = null;
        int selectedItemIdx = itemsEndIdx < 0 ? 0 : itemsEndIdx + 1;
        int selectedItemCount = variants.size() - selectedItemIdx;
        TestCase.assertTrue((String)("there should be only one item to select for completion, got " + selectedItemCount + ": " + StringUtil.join(variants.subList(selectedItemIdx, variants.size()), (String)", ")), (selectedItemCount <= 1 ? 1 : 0) != 0);
        if (selectedItemCount == 1) {
            selectedItem = (Item)TO_ITEM.fun((Object)variants.get(selectedItemIdx));
        }
        if ((completionKey = matcher.group(6)).isEmpty() || completionKey.startsWith(this.myAssertionBlockPrefix)) {
            completionKey = ENTER_KEY_NAME;
        }
        return new CompletionData(completionType, invocationCount, items, forbiddenItems, selectedItem, completionKey);
    }

    protected LookupImpl getLookup() {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)this.getProject()).getActiveLookup();
        TestCase.assertNotNull((Object)lookup);
        return lookup;
    }

    private static void assertPopupContents(String errorPrefix, LookupElement[] lookupElements, List<Item> expectedItems, List<Item> forbiddenItems) {
        List actualNames = ContainerUtil.map((Object[])lookupElements, TO_NAME);
        List actualFullTexts = ContainerUtil.map((Object[])lookupElements, TO_FULL_TEXT);
        for (Item item : forbiddenItems) {
            List lookupStrings = item.isFullText() ? actualFullTexts : actualNames;
            String text = item.getText();
            TestCase.assertFalse((String)("Forbidden item found in lookup: " + text), (boolean)lookupStrings.contains(text));
        }
        if (expectedItems == null) {
            return;
        }
        int lastFoundIndex = -1;
        boolean canSkip = false;
        for (Item expectedItem : expectedItems) {
            if ("...".equals(expectedItem.myText)) {
                canSkip = true;
                continue;
            }
            List ais = expectedItem.isFullText() ? actualFullTexts : actualNames;
            int idx = lastFoundIndex >= 0 && lastFoundIndex + 1 < ais.size() ? lastFoundIndex + 1 + ais.subList(lastFoundIndex + 1, ais.size()).indexOf(expectedItem.getText()) : ais.indexOf(expectedItem.getText());
            if (idx < 0) {
                TestCase.assertEquals((String)(errorPrefix + "can't find expected item '" + expectedItem + "'"), (String)UsefulTestCase.toString(expectedItems), (String)UsefulTestCase.toString(ais));
            } else {
                int expectedIdx = lastFoundIndex + 1;
                if (!(idx == expectedIdx || canSkip && lastFoundIndex < idx)) {
                    TestCase.assertEquals((String)(errorPrefix + "wrong order of elements"), (String)UsefulTestCase.toString(expectedItems), (String)UsefulTestCase.toString(ais));
                }
            }
            lastFoundIndex = idx;
            canSkip = false;
        }
        if (!canSkip && lastFoundIndex + 1 != actualNames.size()) {
            TestCase.assertEquals((String)(errorPrefix + "unexpected elements were found"), (String)UsefulTestCase.toString(expectedItems), (String)UsefulTestCase.toString(actualNames));
        }
    }

    private static ArrayList<String> splitStrings(@NotNull String vs) {
        if (vs == null) {
            CidrFileBasedCompletionTestFixture.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean inString = false;
        boolean inQuote = false;
        StringBuilder current = new StringBuilder();
        for (char c : (vs.trim() + " ").toCharArray()) {
            if (inQuote) {
                current.append(c);
                inQuote = false;
                continue;
            }
            if (c == '\\') {
                inQuote = true;
                continue;
            }
            if (c == '\"') {
                inString = !inString;
                continue;
            }
            if (inString || !Character.isWhitespace(c)) {
                current.append(c);
                continue;
            }
            if (current.length() <= 0) continue;
            result.add(current.toString());
            current.setLength(0);
        }
        return result;
    }

    @Override
    public void setUp() {
        super.setUp();
        CodeInsightSettings settings = this.getCodeInsightSettings();
        this.myAutocompletion = settings.AUTOCOMPLETE_ON_CODE_COMPLETION;
        this.mySmartAutocompletion = settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
        this.myCompletionCaseSensitive = settings.COMPLETION_CASE_SENSITIVE;
        settings.AUTOCOMPLETE_ON_CODE_COMPLETION = false;
        settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = false;
    }

    @Override
    public void tearDown() throws Exception {
        CodeInsightSettings settings = this.getCodeInsightSettings();
        settings.AUTOCOMPLETE_ON_CODE_COMPLETION = this.myAutocompletion;
        settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = this.mySmartAutocompletion;
        settings.COMPLETION_CASE_SENSITIVE = this.myCompletionCaseSensitive;
        super.tearDown();
    }

    static {
        COMPLETION_KEYS.put(ENTER_KEY_NAME, "\n");
        COMPLETION_KEYS.put("TAB", "\t");
        COMPLETION_KEYS.put("SPACE", " ");
        TO_NAME = element -> {
            LookupElementPresentation presentation = new LookupElementPresentation();
            element.renderElement(presentation);
            String text = presentation.getItemText();
            TestCase.assertNotNull((Object)text);
            return text.trim();
        };
        TO_ITEM = s -> {
            boolean isFullText = s.contains("|");
            return new Item((String)s, isFullText);
        };
        TO_FULL_TEXT = element -> {
            LookupElementPresentation p = new LookupElementPresentation();
            element.renderElement(p);
            String text = p.getItemText();
            TestCase.assertNotNull((Object)text);
            return text.trim() + StringUtil.defaultIfEmpty((String)p.getTailText(), (String)"") + " | " + StringUtil.defaultIfEmpty((String)p.getTypeText(), (String)"");
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeInsightFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertionBlockPrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/CidrFileBasedCompletionTestFixture";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/CidrFileBasedCompletionTestFixture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readAssertionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class Item {
        @NotNull
        private final String myText;
        private final boolean myFullText;

        public Item(@NotNull String text, boolean isFullText) {
            if (text == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myFullText = isFullText;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                Item.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isFullText() {
            return this.myFullText;
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/CidrFileBasedCompletionTestFixture$Item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/CidrFileBasedCompletionTestFixture$Item";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static final class CompletionData {
        @NotNull
        private final CompletionType myCompletionType;
        private final int myInvocationCount;
        @Nullable
        private final List<Item> myItems;
        @NotNull
        private final List<Item> myForbiddenItems;
        @Nullable
        final Item myItem;
        @NotNull
        final String myCompletionKey;

        private CompletionData(@NotNull CompletionType completionType, int invocationCount, @Nullable List<Item> items, @NotNull List<Item> forbiddenItems, @Nullable Item item, @NotNull String completionKey) {
            if (completionType == null) {
                CompletionData.$$$reportNull$$$0(0);
            }
            if (forbiddenItems == null) {
                CompletionData.$$$reportNull$$$0(1);
            }
            if (completionKey == null) {
                CompletionData.$$$reportNull$$$0(2);
            }
            this.myCompletionType = completionType;
            this.myInvocationCount = invocationCount;
            this.myItems = items;
            this.myForbiddenItems = forbiddenItems;
            this.myItem = item;
            this.myCompletionKey = completionKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletionData data = (CompletionData)o;
            if (this.myInvocationCount != data.myInvocationCount) {
                return false;
            }
            if (this.myCompletionType != data.myCompletionType) {
                return false;
            }
            if (this.myItems != null ? !this.myItems.equals(data.myItems) : data.myItems != null) {
                return false;
            }
            if (!this.myForbiddenItems.equals(data.myForbiddenItems)) {
                return false;
            }
            if (this.myItem != null ? !this.myItem.equals(data.myItem) : data.myItem != null) {
                return false;
            }
            return this.myCompletionKey.equals(data.myCompletionKey);
        }

        public int hashCode() {
            int result = this.myCompletionType.hashCode();
            result = 31 * result + this.myInvocationCount;
            result = 31 * result + (this.myItems != null ? this.myItems.hashCode() : 0);
            result = 31 * result + this.myForbiddenItems.hashCode();
            result = 31 * result + (this.myItem != null ? this.myItem.hashCode() : 0);
            result = 31 * result + this.myCompletionKey.hashCode();
            return result;
        }

        public String toString() {
            return "CompletionData{myCompletionType=" + this.myCompletionType.name() + "*" + this.myInvocationCount + ", myItems=" + (this.myItems == null ? null : "{" + StringUtil.join(this.myItems, (String)", ") + "}") + ", myItem='" + this.myItem + "', myCompletionKey='" + this.myCompletionKey + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completionType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forbiddenItems";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completionKey";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/CidrFileBasedCompletionTestFixture$CompletionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

