/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.CidrTargetConfigurationHelper;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableModificationTracker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTargetConfigurationHelper
implements CidrTargetConfigurationHelper {
    protected static final Key<Pair<Boolean, Long>> ourIsEntryPoint = Key.create((String)"Is entry point");

    public boolean isInEntryPointBody(@NotNull Location location) {
        if (location == null) {
            OCTargetConfigurationHelper.$$$reportNull$$$0(0);
        }
        return OCTargetConfigurationHelper.isInEntryPointBody(location.getPsiElement());
    }

    @Contract(value="null -> false")
    public static boolean isEntryPoint(@Nullable PsiElement maybeMainDecl) {
        if (maybeMainDecl instanceof OCFunctionDefinition) {
            OCFunctionSymbol symbol;
            Pair entryVersion = (Pair)ourIsEntryPoint.get((UserDataHolder)maybeMainDecl);
            long version = OCFileSymbolTableModificationTracker.getInstance(maybeMainDecl.getProject()).getModificationCount();
            if (entryVersion != null && ((Long)entryVersion.second).equals(version)) {
                return entryVersion.first == Boolean.TRUE;
            }
            if (OCTestExecution.canWaitInThisThread() && (symbol = ((OCFunctionDefinition)maybeMainDecl).getSymbol()) != null && symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION) {
                entryVersion = Pair.pair((Object)symbol.isMainFunction(), (Object)version);
                ourIsEntryPoint.set((UserDataHolder)maybeMainDecl, (Object)entryVersion);
            }
            if (entryVersion != null && ((Long)entryVersion.second).equals(version)) {
                return entryVersion.first == Boolean.TRUE;
            }
        }
        return false;
    }

    public static boolean isInEntryPointBody(@NotNull PsiElement element) {
        if (element == null) {
            OCTargetConfigurationHelper.$$$reportNull$$$0(1);
        }
        return OCTargetConfigurationHelper.isInEntryPointBody(element, null);
    }

    private static boolean isInEntryPointBody(@NotNull PsiElement element, @Nullable PsiElement topParent) {
        if (element == null) {
            OCTargetConfigurationHelper.$$$reportNull$$$0(2);
        }
        for (PsiElement current = element; current != null; current = current.getParent()) {
            if (current instanceof PsiFile || current == topParent) {
                return false;
            }
            if (current instanceof OCMacroCall && topParent == null) {
                Ref ref = new Ref();
                PsiElement macroAsParent = current;
                ((OCMacroCall)current).processExpansionLeaves((Processor<? super PsiElement>)((Processor)leaf -> {
                    boolean inEP = OCTargetConfigurationHelper.isInEntryPointBody(leaf, macroAsParent);
                    if (inEP) {
                        ref.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }));
                if (ref.get() != Boolean.TRUE) continue;
                return true;
            }
            if (!OCTargetConfigurationHelper.isEntryPoint(current)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/OCTargetConfigurationHelper";
        objectArray[2] = "isInEntryPointBody";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

