/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class CidrTestListUpdaterWithFileVersion
extends CidrTestListUpdater {
    private final HashMap<VirtualFile, Long> myTestFileVersionMap;

    public CidrTestListUpdaterWithFileVersion(final @NotNull CidrTestFrameworkBase<?> framework, @NotNull Project project) {
        if (framework == null) {
            CidrTestListUpdaterWithFileVersion.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CidrTestListUpdaterWithFileVersion.$$$reportNull$$$0(1);
        }
        super(framework, project);
        this.myTestFileVersionMap = new HashMap();
        project.getMessageBus().connect((Disposable)this).subscribe(OCFileSymbolTableListener.TOPIC, (Object)new OCFileSymbolTableListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFileHasNewSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<VirtualFile, Long> hashMap = CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap;
                synchronized (hashMap) {
                    this.incTracker();
                    long version = CidrTestListUpdaterWithFileVersion.this.getFileVersion(virtualFile);
                    CidrTestListUpdater.log(framework.getFrameworkId(), " TU add ", virtualFile, " v=", version);
                    CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap.put(virtualFile, CidrTestListUpdaterWithFileVersion.this.getModificationCount());
                }
                CidrTestListUpdaterWithFileVersion.this.scheduleUpdate(virtualFile);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFileHasInvalidSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                HashMap<VirtualFile, Long> hashMap = CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap;
                synchronized (hashMap) {
                    this.incTracker();
                    CidrTestListUpdater.log(framework.getFrameworkId(), " TU remove ", virtualFile);
                    CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap.remove(virtualFile);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAllSymbolTablesDropped() {
                HashMap<VirtualFile, Long> hashMap = CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap;
                synchronized (hashMap) {
                    this.incTracker();
                    CidrTestListUpdater.log(framework.getFrameworkId(), " TU clear all");
                    CidrTestListUpdaterWithFileVersion.this.myTestFileVersionMap.clear();
                }
            }

            private void incTracker() {
                CidrTestListUpdaterWithFileVersion.this.incTestInfoVersion();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "virtualFile";
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestListUpdaterWithFileVersion$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileHasNewSymbolTableInPack";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileHasInvalidSymbolTableInPack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileVersion(@NotNull VirtualFile vf) {
        if (vf == null) {
            CidrTestListUpdaterWithFileVersion.$$$reportNull$$$0(2);
        }
        HashMap<VirtualFile, Long> hashMap = this.myTestFileVersionMap;
        synchronized (hashMap) {
            Long version = this.myTestFileVersionMap.get(vf);
            if (version == null) {
                version = this.getModificationCount();
                this.myTestFileVersionMap.put(vf, version);
            }
            return version;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestListUpdaterWithFileVersion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

