/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    public static final Set<String> LOOK_LIKE_OC_FILE_BUT_ARE_NOT = new THashSet(Arrays.asList("y", "yy", "ypp", "y++", "yxx", "l", "ll", "lpp", "l++", "lxx"), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);

    public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        IElementType tt;
        if (file == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(0);
        }
        if (firstBytes == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(1);
        }
        if (firstCharsIfText == null) {
            return null;
        }
        for (OCFileTypeHelper each : OCHeaderFileTypeDetector.getHelpers()) {
            FileType type = each.getFileType(file);
            if (type == null) {
                return null;
            }
            if (type == FileTypes.UNKNOWN) continue;
            return type;
        }
        String extension = file.getExtension();
        if (extension != null && LOOK_LIKE_OC_FILE_BUT_ARE_NOT.contains(extension)) {
            return null;
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        int endOffset = Math.min(this.getDesiredContentPrefixLength(), firstCharsIfText.length());
        lexer.start(firstCharsIfText, 0, endOffset, 0);
        boolean atNewLine = true;
        boolean wasDirective = false;
        int identsInSequence = 0;
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.UNKNOWN_DIRECTIVE || tt == TokenType.BAD_CHARACTER) {
                lexer.advance();
                if (lexer.getTokenType() == null) break;
                return null;
            }
            if (OCTokenTypes.COMMENTS.contains(tt)) {
                identsInSequence = 0;
            } else if (OCTokenTypes.WHITESPACES.contains(tt)) {
                if (lexer.getTokenText().contains("\n")) {
                    atNewLine = true;
                }
            } else if (tt == OCTokenTypes.IDENTIFIER) {
                if (++identsInSequence > 7) {
                    return null;
                }
                atNewLine = false;
            } else {
                if (OCTokenTypes.DIRECTIVES.contains(tt) && atNewLine) {
                    wasDirective = true;
                    break;
                }
                atNewLine = false;
                identsInSequence = 0;
            }
            lexer.advance();
        }
        return wasDirective ? OCLanguageUtils.getBaseFileType() : null;
    }

    public int getDesiredContentPrefixLength() {
        return 8192;
    }

    @NotNull
    private static List<OCFileTypeHelper> getHelpers() {
        List list = (List)ProgressManager.getInstance().computeInNonCancelableSection(() -> OCFileTypeHelper.EP_NAME.getExtensionsIfPointIsRegistered());
        if (list == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstBytes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCHeaderFileTypeDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCHeaderFileTypeDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

