/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandler;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandlerImpl;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSListener;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSRecentCache;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSUtilKt;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\tH\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0002J\u000e\u0010\"\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u001e\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010)H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandlerImpl;", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandler;", "source", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "future", "Ljava/util/concurrent/CompletableFuture;", "", "indicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "items", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSource", "()Lcom/intellij/openapi/vfs/VirtualFile;", "addIfNeeded", "listener", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSListener;", "target", "canBeTarget", "", "cancel", "getRecentCache", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSRecentCache;", "kotlin.jvm.PlatformType", "handleCached", "handleFileBased", "handleSameDefinitions", "includedInSource", "", "includersForSource", "invoke", "notifyTargetChosen", "process", "psiSource", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "shouldConsiderThisSymbol", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "sourceSymbol", "intellij.c"})
public final class OCSwitchHSHandlerImpl
implements OCSwitchHSHandler {
    private final Set<VirtualFile> items;
    private final EmptyProgressIndicator indicator;
    private final CompletableFuture<Unit> future;
    @NotNull
    private final VirtualFile source;
    @NotNull
    private final Project project;

    public final void invoke(@NotNull OCSwitchHSListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ReadAction.nonBlocking((Runnable)new Runnable(this, listener){
            final /* synthetic */ OCSwitchHSHandlerImpl this$0;
            final /* synthetic */ OCSwitchHSListener $listener;

            public final void run() {
                OCSwitchHSHandlerImpl.access$process(this.this$0, this.$listener);
            }
            {
                this.this$0 = oCSwitchHSHandlerImpl;
                this.$listener = oCSwitchHSListener;
            }
        }).inSmartMode(this.project).wrapProgress((ProgressIndicator)this.indicator).finishOnUiThread(ModalityState.defaultModalityState(), new Consumer(this){
            final /* synthetic */ OCSwitchHSHandlerImpl this$0;

            public final void accept(Void it) {
                OCSwitchHSHandlerImpl.access$getFuture$p(this.this$0).complete(Unit.INSTANCE);
            }
            {
                this.this$0 = oCSwitchHSHandlerImpl;
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> future() {
        return this.future;
    }

    @Override
    public void cancel() {
        this.indicator.cancel();
    }

    @Override
    public void notifyTargetChosen(@NotNull VirtualFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.getRecentCache().putTarget(this.source, target);
    }

    private final void process(OCSwitchHSListener listener) {
        listener.onComputationStarted();
        this.handleCached(listener);
        ProgressManager.checkCanceled();
        this.handleFileBased(listener);
        ProgressManager.checkCanceled();
        this.handleSameDefinitions(listener);
        ProgressManager.checkCanceled();
        this.future.complete(Unit.INSTANCE);
        listener.onComputationFinished();
    }

    private final void handleCached(OCSwitchHSListener listener) {
        this.addIfNeeded(listener, this.getRecentCache().getLastUsedTargetIfExists(this.source));
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFileBased(OCSwitchHSListener listener) {
        VirtualFile[] virtualFileArray = this.source.getParent();
        if (virtualFileArray != null && (virtualFileArray = virtualFileArray.getChildren()) != null) {
            void $this$filterTo$iv$iv;
            VirtualFile[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            VirtualFile[] virtualFileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var7_8 = $this$filterTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = var7_8[j];
                boolean bl = false;
                CharSequence charSequence = this.source.getNameWithoutExtension();
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                if (!(StringUtil.equalsIgnoreCase((CharSequence)charSequence, (CharSequence)v2.getNameWithoutExtension()) && this.canBeTarget(this.source, (VirtualFile)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                this.addIfNeeded(listener, it);
            }
        }
    }

    private final boolean canBeTarget(VirtualFile source, VirtualFile target) {
        return Intrinsics.areEqual((Object)source, (Object)target) ? false : (OCSwitchHSUtilKt.isSourceFile(target) ? OCSwitchHSUtilKt.isHeaderFile(source) : OCSwitchHSUtilKt.isHeaderFile(target));
    }

    private final void handleSameDefinitions(OCSwitchHSListener listener) {
        block0: {
            Set possibleFiles = SetsKt.plus(this.includedInSource(), (Iterable)this.includersForSource());
            OCFile oCFile = this.psiSource();
            if (oCFile == null) break block0;
            oCFile.accept(new OCRecursiveVisitor(this, possibleFiles, listener){
                final /* synthetic */ OCSwitchHSHandlerImpl this$0;
                final /* synthetic */ Set $possibleFiles;
                final /* synthetic */ OCSwitchHSListener $listener;

                public void visitFunctionDeclaration(@NotNull OCFunctionDeclaration declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    this.processSymbol(declaration.getSymbol());
                    super.visitFunctionDeclaration(declaration);
                }

                public void visitFunctionDefinition(@NotNull OCFunctionDefinition definition) {
                    Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
                    this.processSymbol(definition.getSymbol());
                    super.visitFunctionDefinition(definition);
                }

                public void visitClassDeclaration(@NotNull OCClassDeclaration<?> dcl) {
                    Intrinsics.checkNotNullParameter(dcl, (String)"dcl");
                    this.processSymbol(dcl.getSymbol());
                    super.visitClassDeclaration(dcl);
                }

                private final void processSymbol(OCSymbol symbol) {
                    block1: {
                        if (!OCSwitchHSHandlerImpl.shouldConsiderThisSymbol$default(this.this$0, symbol, null, 2, null)) break block1;
                        OCSymbol oCSymbol = symbol;
                        if (oCSymbol != null) {
                            oCSymbol.processSameSymbols((Processor<OCSymbol>)new Processor(this, symbol){
                                final /* synthetic */ handleSameDefinitions.1 this$0;
                                final /* synthetic */ OCSymbol $symbol;

                                public final boolean process(OCSymbol it) {
                                    OCSymbol oCSymbol = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)oCSymbol, (String)"it");
                                    return handleSameDefinitions.1.access$sameSymbolsProcessor(this.this$0, oCSymbol, this.$symbol);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$symbol = oCSymbol;
                                }
                            }, this.this$0.getProject());
                        }
                    }
                }

                private final boolean sameSymbolsProcessor(OCSymbol symbol, OCSymbol sourceSymbol) {
                    VirtualFile file;
                    if (OCSwitchHSHandlerImpl.access$shouldConsiderThisSymbol(this.this$0, symbol, sourceSymbol) && (file = symbol.getContainingFile()) != null && this.$possibleFiles.contains(file) && OCSwitchHSHandlerImpl.access$canBeTarget(this.this$0, this.this$0.getSource(), file)) {
                        OCSwitchHSHandlerImpl.access$addIfNeeded(this.this$0, this.$listener, file);
                    }
                    return true;
                }
                {
                    this.this$0 = this$0;
                    this.$possibleFiles = $captured_local_variable$1;
                    this.$listener = $captured_local_variable$2;
                }

                public static final /* synthetic */ boolean access$sameSymbolsProcessor(handleSameDefinitions.1 $this, OCSymbol symbol, OCSymbol sourceSymbol) {
                    return $this.sameSymbolsProcessor(symbol, sourceSymbol);
                }
            });
        }
    }

    private final boolean shouldConsiderThisSymbol(OCSymbol symbol, OCSymbol sourceSymbol) {
        if (Intrinsics.areEqual((Object)symbol, (Object)sourceSymbol)) {
            return false;
        }
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isPredeclaration()) {
            return false;
        }
        if (symbol != null && sourceSymbol != null && symbol.isPredeclaration() == sourceSymbol.isPredeclaration()) {
            return false;
        }
        if (symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isSpecialization() || sourceSymbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)sourceSymbol).isSpecialization()) {
            return false;
        }
        if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).isStatic() || sourceSymbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)sourceSymbol).isStatic()) {
            return false;
        }
        if (symbol instanceof OCSymbolWithQualifiedName && sourceSymbol instanceof OCSymbolWithQualifiedName) {
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName = ((OCSymbolWithQualifiedName)symbol).getParent();
            if (!(oCSymbolWithQualifiedName instanceof OCTemplateSymbol)) {
                oCSymbolWithQualifiedName = null;
            }
            OCTemplateSymbol parent = (OCTemplateSymbol)((Object)oCSymbolWithQualifiedName);
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName2 = ((OCSymbolWithQualifiedName)sourceSymbol).getParent();
            if (!(oCSymbolWithQualifiedName2 instanceof OCTemplateSymbol)) {
                oCSymbolWithQualifiedName2 = null;
            }
            OCTemplateSymbol sourceParent = (OCTemplateSymbol)((Object)oCSymbolWithQualifiedName2);
            if (parent != null && sourceParent != null && (parent.isSpecialization() || sourceParent.isSpecialization())) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ boolean shouldConsiderThisSymbol$default(OCSwitchHSHandlerImpl oCSwitchHSHandlerImpl, OCSymbol oCSymbol, OCSymbol oCSymbol2, int n, Object object) {
        if ((n & 2) != 0) {
            oCSymbol2 = null;
        }
        return oCSwitchHSHandlerImpl.shouldConsiderThisSymbol(oCSymbol, oCSymbol2);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> includedInSource() {
        void $this$mapNotNullTo$iv$iv;
        JBIterable jBIterable = SyntaxTraverser.psiTraverser().children((Object)this.psiSource()).filter(OCIncludeDirective.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u2026udeDirective::class.java)");
        Iterable $this$mapNotNull$iv = (Iterable)jBIterable;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            OCIncludeDirective it = (OCIncludeDirective)element$iv$iv;
            boolean bl2 = false;
            OCIncludeDirective oCIncludeDirective = it;
            Intrinsics.checkNotNullExpressionValue((Object)oCIncludeDirective, (String)"it");
            PsiFile psiFile = oCIncludeDirective.getIncludedFile();
            if ((psiFile != null ? psiFile.getVirtualFile() : null) == null) continue;
            virtualFile = virtualFile;
            boolean bl3 = false;
            boolean bl4 = false;
            VirtualFile it$iv$iv = virtualFile;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    private final Set<VirtualFile> includersForSource() {
        Collection<VirtualFile> collection = OCImportGraph.getInstance(this.project).findImmediateIncludingFiles(this.source, true);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"OCImportGraph.getInstanc\u2026ludingFiles(source, true)");
        return CollectionsKt.toHashSet((Iterable)collection);
    }

    private final OCFile psiSource() {
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(this.source);
        if (!(psiFile instanceof OCFile)) {
            psiFile = null;
        }
        return (OCFile)psiFile;
    }

    private final void addIfNeeded(OCSwitchHSListener listener, VirtualFile target) {
        ProgressManager.checkCanceled();
        if (target != null && !this.items.contains(target)) {
            this.items.add(target);
            listener.onItemAdded(target);
        }
    }

    private final OCSwitchHSRecentCache getRecentCache() {
        return (OCSwitchHSRecentCache)this.project.getService(OCSwitchHSRecentCache.class);
    }

    @NotNull
    public final VirtualFile getSource() {
        return this.source;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public OCSwitchHSHandlerImpl(@NotNull VirtualFile source, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.source = source;
        this.project = project;
        boolean bl = false;
        this.items = new LinkedHashSet();
        this.indicator = new EmptyProgressIndicator();
        this.future = new CompletableFuture();
    }

    public static final /* synthetic */ void access$process(OCSwitchHSHandlerImpl $this, OCSwitchHSListener listener) {
        $this.process(listener);
    }

    public static final /* synthetic */ CompletableFuture access$getFuture$p(OCSwitchHSHandlerImpl $this) {
        return $this.future;
    }

    public static final /* synthetic */ boolean access$shouldConsiderThisSymbol(OCSwitchHSHandlerImpl $this, OCSymbol symbol, OCSymbol sourceSymbol) {
        return $this.shouldConsiderThisSymbol(symbol, sourceSymbol);
    }

    public static final /* synthetic */ boolean access$canBeTarget(OCSwitchHSHandlerImpl $this, VirtualFile source, VirtualFile target) {
        return $this.canBeTarget(source, target);
    }

    public static final /* synthetic */ void access$addIfNeeded(OCSwitchHSHandlerImpl $this, OCSwitchHSListener listener, VirtualFile target) {
        $this.addIfNeeded(listener, target);
    }
}

