/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotReleasedVariablesChecker
extends OCSingleSymbolAlgorithm {
    private Set<Pair<OCInstanceVariableSymbol, PsiElement>> myAssignedIvars;
    private boolean myWasRetained;
    private boolean myStartFromReturns;

    public OCNotReleasedVariablesChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        if (cfg == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(1);
        }
        super(cfg, false, symbol);
        this.myAssignedIvars = new HashSet<Pair<OCInstanceVariableSymbol, PsiElement>>();
    }

    public void setStartFromReturns(boolean startFromReturns) {
        this.myStartFromReturns = startFromReturns;
    }

    private boolean isAssignmentToOuterScopeVariable(@NotNull OCInstruction instruction) {
        PsiElement element;
        if (instruction == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(2);
        }
        if ((element = instruction.getRValue()) instanceof OCReferenceExpression && element.getParent() instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignment = (OCAssignmentExpression)element.getParent();
            OCExpression receiver = assignment.getReceiverExpression();
            if (assignment.getSourceExpression() == element) {
                OCSymbol symbol = OCNotReleasedIvarInspection.getReceiverSymbol(receiver, true);
                OCInstanceVariableSymbol ivar = OCNotReleasedIvarInspection.getReceiverIvar(receiver);
                if (ivar != null) {
                    this.myAssignedIvars.add((Pair<OCInstanceVariableSymbol, PsiElement>)new Pair((Object)ivar, (Object)receiver));
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
                    return true;
                }
            }
        } else if (element instanceof OCReferenceExpression && element.getParent() instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element.getParent();
            OCSymbol symbol = declarator.getSymbol();
            if (declarator.getInitializer() == element && symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(3);
        }
        if (instruction.getKind() != OCInstruction.InstructionKind.READ && instruction.getKind() != OCInstruction.InstructionKind.READ_IN_BLOCK) {
            return false;
        }
        PsiElement element = instruction.getRValue();
        if (element instanceof OCReferenceExpression && (OCElementUtil.isReleaseCall(element.getParent()) || this.myStartFromReturns && element.getParent() instanceof OCReturnStatement)) {
            return true;
        }
        return this.isAssignmentToOuterScopeVariable(instruction);
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(4);
        }
        PsiElement rValue = instruction.getRValue();
        if (instruction.getKind() == OCInstruction.InstructionKind.WRITE) {
            if (OCElementUtil.isRetainCall(rValue, true)) {
                this.myWasRetained = true;
                return true;
            }
            return false;
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            PsiElement call;
            PsiElement psiElement = call = rValue != null ? rValue.getParent() : null;
            if (call instanceof OCSendMessageExpression && ((OCSendMessageExpression)call).getMessageSelector().equals("retain") && OCNotReleasedVariablesChecker.getLastUnreleasedCall((OCSendMessageExpression)call) != null) {
                this.myWasRetained = true;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(5);
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            PsiElement rValue = instruction.getRValue();
            return rValue != null ? rValue.getParent() : null;
        }
        return super.getElementFromInstruction(instruction);
    }

    @NotNull
    public List<PsiElement> getNotReleasedElements() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null || !instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                OCNotReleasedVariablesChecker.$$$reportNull$$$0(6);
            }
            return list;
        }
        this.myWasRetained = false;
        List<PsiElement> result = this.getNonReachableElements();
        if (this.myWasRetained) {
            for (Pair<OCInstanceVariableSymbol, PsiElement> pair : this.myAssignedIvars) {
                this.handleAssignedIvar(pair);
            }
        }
        List<PsiElement> list = result;
        if (list == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected void handleAssignedIvar(@NotNull Pair<OCInstanceVariableSymbol, PsiElement> pair) {
        if (pair == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    public static List<Pair<OCSendMessageExpression, PsiElement>> getUnreleasedObjects(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(9);
        }
        final ArrayList<Pair<OCSendMessageExpression, PsiElement>> result = new ArrayList<Pair<OCSendMessageExpression, PsiElement>>();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                OCSymbol symbol;
                super.visitSendMessageExpression(expression);
                if (!OCElementUtil.isRetainCall(expression, false)) {
                    return;
                }
                List<OCMethodSymbol> responders = expression.getProbableResponders().getAllResponders();
                if (responders.isEmpty()) {
                    return;
                }
                for (OCMethodSymbol responder : responders) {
                    if (responder.getReturnType(expression.getProject()).resolve(expression).isPointerToObjectCompatible()) continue;
                    return;
                }
                OCExpression receiver = expression.getReceiverExpression();
                if ("retain".equals(expression.getMessageSelector()) && (receiver instanceof OCReferenceExpression ? (symbol = ((OCReferenceExpression)receiver).resolveToSymbol()) != null && symbol.getKind().isVariable() : OCNotReleasedIvarInspection.getReceiverIvar(receiver) != null)) {
                    return;
                }
                PsiElement call = OCNotReleasedVariablesChecker.getLastUnreleasedCall(expression);
                if (call != null) {
                    if (call.getParent() instanceof OCReturnStatement && OCElementUtil.isRetainMethod((OCCallable)PsiTreeUtil.getParentOfType((PsiElement)call, OCCallable.class))) {
                        return;
                    }
                    result.add(Pair.create((Object)expression, (Object)call));
                }
            }
        });
        ArrayList<Pair<OCSendMessageExpression, PsiElement>> arrayList = result;
        if (arrayList == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement getLastUnreleasedCall(@NotNull OCSendMessageExpression expression) {
        if (expression == null) {
            OCNotReleasedVariablesChecker.$$$reportNull$$$0(11);
        }
        PsiElement parent = expression.getParent();
        OCSendMessageExpression kid = expression;
        OCResolveContext context = OCResolveContext.forPsi(expression);
        OCType type = expression.getResolvedType(context);
        while (parent != null) {
            if (parent instanceof OCParenthesizedExpression || parent instanceof OCCastExpression || parent instanceof OCConditionalExpression) {
                kid = parent;
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof OCAssignmentExpression) {
                OCSymbol symbol;
                OCExpression receiver = ((OCAssignmentExpression)parent).getReceiverExpression();
                if (receiver instanceof OCQualifiedExpression && (symbol = ((OCQualifiedExpression)receiver).resolveToSymbol()) instanceof OCPropertySymbol && ((OCPropertySymbol)symbol).isRetained()) break;
                return null;
            }
            if (parent instanceof OCDeclarator) {
                return null;
            }
            if (parent instanceof OCMessageArgument || !(parent instanceof OCSendMessageExpression)) break;
            OCSendMessageExpression parentCall = (OCSendMessageExpression)parent;
            String selector = parentCall.getMessageSelector();
            if (OCElementUtil.isReleaseSelector(selector)) {
                return null;
            }
            if (OCElementUtil.isRetainCall(parentCall, false) || !parentCall.getResolvedType().isCompatible(type, context)) break;
            kid = parent;
            parent = parent.getParent();
        }
        return kid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotReleasedElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnreleasedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentToOuterScopeVariable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStartInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEndInstruction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromInstruction";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleAssignedIvar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnreleasedObjects";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLastUnreleasedCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

