/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCTemplatesUtil {
    private static final Logger LOG = Logger.getInstance(OCTemplatesUtil.class);

    private OCTemplatesUtil() {
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesVisibleAt(PsiElement place, boolean withFields) {
        HashSet names = new HashSet();
        ArrayList<OCDeclaratorSymbol> answer = new ArrayList<OCDeclaratorSymbol>();
        Processor processor = symbol -> {
            OCSymbolKind kind;
            if (symbol instanceof OCDeclaratorSymbol && names.add(symbol.getName()) && ((kind = symbol.getKind()).isLocal() || kind == OCSymbolKind.STRUCT_FIELD)) {
                answer.add((OCDeclaratorSymbol)symbol);
            }
            return true;
        };
        if (withFields) {
            OCResolveUtil.processSymbols(null, place, (Processor<OCSymbol>)processor);
        } else {
            OCResolveUtil.processLocalSymbols(null, place, (Processor<OCSymbol>)processor, false);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = answer;
        if (arrayList == null) {
            OCTemplatesUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public static Collection<String> getNames(ExpressionContext context) {
        Project project = context.getProject();
        int offset = context.getStartOffset();
        Collection<String> names = null;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file.findElementAt(offset);
        if (element.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
            names = OCTemplatesUtil.getNamesForIdentifier(project, element);
        } else {
            PsiFile fileCopy = (PsiFile)file.copy();
            ApplicationManager.getApplication().runWriteAction(() -> {
                BlockSupport blockSupport = BlockSupport.getInstance((Project)project);
                try {
                    blockSupport.reparseRange(fileCopy, offset, offset, (CharSequence)"xxx");
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            PsiElement identifierCopy = fileCopy.findElementAt(offset);
            if (identifierCopy.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
                names = OCTemplatesUtil.getNamesForIdentifier(project, identifierCopy);
            }
        }
        return names;
    }

    @Nullable
    private static Collection<String> getNamesForIdentifier(Project project, PsiElement identifier) {
        OCDeclarator var;
        if (identifier.getParent() instanceof OCDeclarator && identifier.equals((var = (OCDeclarator)identifier.getParent()).getNameIdentifier())) {
            return OCNameSuggester.suggestForDeclaration(var, false, Collections.emptyList());
        }
        return null;
    }

    @NotNull
    public static PsiElement getInsertionPlace(@NotNull ExpressionContext context) {
        Editor editor;
        if (context == null) {
            OCTemplatesUtil.$$$reportNull$$$0(1);
        }
        OCLog.LOG.assertTrue((editor = context.getEditor()) != null && editor.getProject() != null, (Object)"Template call in undefined editor");
        PsiFile file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        OCLog.LOG.assertTrue(file != null, (Object)"Template call in undefined file");
        PsiElement place = file.findElementAt(context.getStartOffset());
        OCLog.LOG.assertTrue(place != null, (Object)"Template call in undefined context");
        PsiElement psiElement = place;
        if (psiElement == null) {
            OCTemplatesUtil.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithBeginEnd(@NotNull ExpressionContext context) {
        if (context == null) {
            OCTemplatesUtil.$$$reportNull$$$0(3);
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type = var.getResolvedType(OCResolveContext.forPsi(place));
            if (type.isUnresolved(place) || type.isUnknown() || var.isUnnamed()) continue;
            if (type instanceof OCCppReferenceType) {
                type = ((OCCppReferenceType)type).getRefType();
            }
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file = expr.getContainingOCFile();
            if (!(type instanceof OCStructType) || OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type, file).getFirst() != OCCodeInsightUtil.MemberBeginEndSearchResult.OK) continue;
            results.add(var);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = results;
        if (arrayList == null) {
            OCTemplatesUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithMethods(@NotNull ExpressionContext context, @NotNull List<String> requiredMethods) {
        if (context == null) {
            OCTemplatesUtil.$$$reportNull$$$0(5);
        }
        if (requiredMethods == null) {
            OCTemplatesUtil.$$$reportNull$$$0(6);
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type = var.getResolvedType(OCResolveContext.forPsi(place));
            if (type.isUnresolved(place) || type.isUnknown()) continue;
            if (type instanceof OCCppReferenceType) {
                type = ((OCCppReferenceType)type).getRefType();
            }
            if (!(type instanceof OCStructType)) continue;
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file = expr.getContainingOCFile();
            OCStructType structType = (OCStructType)type;
            boolean shouldAdd = true;
            for (String method : requiredMethods) {
                if (OCTemplatesUtil.hasMemberFunction(structType, file, method)) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            results.add(var);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = results;
        if (arrayList == null) {
            OCTemplatesUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean hasMemberFunction(@NotNull OCStructType type, @NotNull OCFile file, @NotNull String name) {
        OCResolveContext context;
        if (type == null) {
            OCTemplatesUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            OCTemplatesUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            OCTemplatesUtil.$$$reportNull$$$0(10);
        }
        return !type.collectMethods(name, context = OCResolveContext.forPsi(file)).isEmpty();
    }

    @NotNull
    public static List<String> getStringsList(Expression @NotNull [] params, ExpressionContext context) {
        if (params == null) {
            OCTemplatesUtil.$$$reportNull$$$0(11);
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (Expression param : params) {
            Result result = param.calculateResult(context);
            if (result == null) continue;
            namesList.add(result.toString());
        }
        ArrayList<String> arrayList = namesList;
        if (arrayList == null) {
            OCTemplatesUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredMethods";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesVisibleAt";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertionPlace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesWithBeginEnd";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesWithMethods";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionPlace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariablesWithBeginEnd";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariablesWithMethods";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasMemberFunction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStringsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

